/*
 * Interface to hwdep device
 *
 * Copyright (C) 2007 Takashi Iwai
 * 
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 */

#include "config.h"
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include "local.h"

static int fd;

struct hda_codec_info codec_info; /* exported */

int hda_open_devfile(const char *filename)
{
	int version;

	fd = open(filename, O_RDWR);
	if (fd < 0) {
		log_error("cannot open '%s'\n", filename);
		return 0;
	}
	if (hda_do_ioctl(HDA_IOCTL_PVERSION, &version) < 0) {
		log_error("ioctl PVERSION error\n");
		hda_close_devfile();
		return 0;
	}
	if (version != HDA_HWDEP_VERSION) {
		log_error("invalid pversion 0x%x\n", version);
		hda_close_devfile();
		return 0;
	}
	if (hda_do_ioctl(HDA_IOCTL_GET_CODEC_INFO, &codec_info) < 0) {
		log_error("cannot get CODEC info\n");
		hda_close_devfile();
		return 0;
	}
	return 1;
}

void hda_close_devfile(void)
{
	close(fd);
	fd = -1;
}

int hda_do_ioctl(unsigned int cmd, void *data)
{
	return ioctl(fd, cmd, data);
}

int hda_update_codec_info(void)
{
	return hda_do_ioctl(HDA_IOCTL_SET_CODEC_INFO, &codec_info);
}
