/*
 * Run post-install commands
 *
 * Copyright (C) 2007 Takashi Iwai
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "local.h"

int hda_save_env_vars(const char *devfile, const char **args)
{
	const char *dev;
	int card, devnum = -1;
	char vals[128];

	dev = strrchr(devfile, '/');
	if (dev)
		dev++;
	else
		dev = devfile;
	if (sscanf(dev, "hwC%dD%d", &card, &devnum) <= 0)
		return -EINVAL;

	sprintf(vals, "%d", card);
	setenv("ALSA_CARD", vals, 1);
	sprintf(vals, "%d", devnum);
	setenv("ALSA_DEVICE", vals, 1);

	sprintf(vals, "%04x:%04x",
		(codec_info.vendor_id >> 16) & 0xffff,
		codec_info.vendor_id & 0xffff);
	setenv("ALSA_VENDOR_ID", vals, 1);
	sprintf(vals, "%04x:%04x",
		(codec_info.subsystem_id >> 16) & 0xffff,
		codec_info.subsystem_id & 0xffff);
	setenv("ALSA_SUBSYSTEM_ID", vals, 1);
	sprintf(vals, "%08x", codec_info.revision_id);
	setenv("ALSA_REVISION_ID", vals, 1);
	sprintf(vals, "%04x:%04x",
		codec_info.pci_vendor, codec_info.pci_device);
	setenv("ALSA_PCI_ID", vals, 1);
	sprintf(vals, "%04x:%04x",
		codec_info.pci_subvendor, codec_info.pci_subdevice);
	setenv("ALSA_PCI_SSID", vals, 1);
	sprintf(vals, "%d", codec_info.codec_addr);
	setenv("ALSA_CODEC_ADDR", vals, 1);

	setenv("ALSA_CODEC_NAME", codec_info.name, 1);

	return 0;
}

#define HDA_CONFIG_POST_INSTALL		HDA_SCRIPT_DIR "/post-install"

/* Execute post-install commands */
int hda_post_install(void)
{
	if (!access(HDA_CONFIG_POST_INSTALL, X_OK))
		system(HDA_CONFIG_POST_INSTALL);
	return 0;
}
