/*
 * I/O routines for HD-Audio codec hwdep interface
 *
 * Copyright (C) 2007 Takashi Iwai
 * 
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 */

#ifndef __HDA_IO_H_INC
#define __HDA_IO_H_INC

#include "defs.h"

/*
 * direct OOB access
 */
unsigned int hda_codec_read(hda_nid_t nid, unsigned int verb,
				unsigned int value);
#define hda_codec_write		hda_codec_read
#define hda_param_read(nid, param) \
	hda_codec_read(nid, AC_VERB_PARAMETERS, param)

int hda_get_sub_nodes(hda_nid_t nid, hda_nid_t *start_id);
int hda_get_connections(hda_nid_t nid, hda_nid_t *conn_list, int max_conns);

u32 hda_get_wcaps(hda_nid_t nid);
int hda_pin_available(hda_nid_t nid);

/*
 * I/O handle
 */
int hda_open_devfile(const char *filename);
int hda_do_ioctl(unsigned int cmd, void *data);
void hda_close_devfile(void);

/*
 * codec information from the driver
 */
extern struct hda_codec_info codec_info;
int hda_update_codec_info(void);

/*
 * Registration of init verbs, unsol handlers and PCMs
 */
struct hda_verb;
struct hda_cmds;
struct hda_usr_pcm_info;

int hda_register_init_verbs(struct hda_verb *verbs);
int hda_register_init_cmds(struct hda_cmds *cmds);
int hda_register_resume_verbs(struct hda_verb *verbs);
int hda_register_resume_cmds(struct hda_cmds *cmds);

int hda_register_unsol_cmds(hda_nid_t nid, int tag, int shift,
			    struct hda_cmds *cmds);

int hda_register_pcm(struct hda_usr_pcm_info *pcm);

int hda_is_running(void);
int hda_set_status(int status);

int hda_reset(void);

#endif /* __HDA_IO_H_INC */
