/*
 * Lowlevel TLV interface
 *
 * Copyright (C) 2007 Takashi Iwai
 * 
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 */

#ifndef __HDA_TLV_H_INC
#define __HDA_TLV_H_INC

#include <stdlib.h>
#include "types.h"
#ifndef HDA_BUILD
#include "struct.h"
#endif

#define MAX_TLV_ARGS	1024

static inline int hda_tlv_len(const struct hda_tlv *tlv)
{
	return tlv->len + sizeof(struct hda_tlv);
};

struct hda_tlv *hda_alloc_tlv(int type, int len);
struct hda_tlv *hda_make_tlv(int type, struct hda_tlv *arg, ...);
struct hda_tlv *hda_make_tlv_args(int type, int nargs, struct hda_tlv *args[]);
struct hda_tlv *hda_make_int_tlv(int type, int val);
struct hda_tlv *hda_make_str_tlv(int type, const char *str);

#define hda_free_tlv(tlv) free(tlv)

int hda_tlv_dump(const struct hda_tlv *tlv, FILE *fp);

#endif /* __HDA_TLV_H_INC */
