#ifndef IRQTEST_H_INCLUDE

#define MAX_PROC_CNTS	4
#define MAX_STACK	256

#ifndef __KERNEL__
#include <stdint.h>
#include <sys/ioctl.h>
typedef uint64_t u64;
#endif

struct latency_test_info {
	int processed;
	// u64 irq_time[MAX_PROC_CNTS];
	// u64 read_time;
	unsigned long stacks[MAX_PROC_CNTS][MAX_STACK];
	unsigned short stack_pos[MAX_PROC_CNTS][MAX_STACK];
	unsigned char comm[MAX_PROC_CNTS][16];
};

struct ksym_lookup_info {
	unsigned long addr;	/* addr to look up */
	char name[128];
	unsigned long offset;
	unsigned long size;
};

#define LAT_TEST_FREQ	_IOW('t', 0x01, unsigned long)
#define LAT_TEST_COUNT	_IOW('t', 0x02, unsigned long)
#define LAT_TEST_START	_IO('t', 0x03)
#define LAT_TEST_STOP	_IO('t', 0x04)
#define LAT_TEST_READ	_IOR('t', 0x05, struct latency_test_info)
#define LAT_TEST_GETSYMBOL	_IOWR('t', 0x06, struct ksym_lookup_info)

#endif
