#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>

/* busy loop */
static void mydelay(int loops)
{
	int k=0;
	int u;
	for(u=0;u<loops;u++) k+=1;
}
		
int main(int argc, char **argv)
{
	int numprocs, loops, c;
	int mem;

	if (argc < 2)
		return 1;

	numprocs = atoi(argv[1]);
	if (argc >= 3)
		loops = atoi(argv[2]);
	else
		loops = 1000000;
	if (argc >= 4)
		mem = atoi(argv[3]);
	else
		mem = 0;

	fprintf(stderr, "num proc = %d, loop = %d, mem = %d\n", numprocs, loops, mem);
	close(0);
	close(1);
	close(2);

	c = 0;
	while (! fork()) {
		c++;
		if (c >= numprocs)
			return 0;
	}
//	nice(10);
	if (mem) {
		int *p;
		p = malloc(mem);
		if (p) {
#if 1
			memset(p, 0, mem);
#else
			int i;
			for (i = 0; i < mem/4; i++)
				*p++ = rand();
#endif
		}
	}
	mydelay(loops);
	wait(NULL);
	return 0;
}
