__inline__ unsigned long long int rdtsc()
                    {
                      unsigned long long int x;
                      __asm__ volatile (".byte 0x0f, 0x31" : "=A" (x));     return x;
                    }

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include <fcntl.h>
#include <sched.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/time.h>
#include <signal.h>

#include "gfx.h"

#define DEBUG 0

#define MAX_TIME_SAMPLES 250000



#define mygettime() (rdtsc() / cpu_hz)

int set_realtime_priority(void);
void *my_exithandler(void);
void mydelay(int loops);


int overruns;
int i_test;

int num_time_samples=0;


int NUM_TESTS;

double mytimediff;
double max_timediff=0.0;
double buffer_latency=0.032;

double mean_sum=0.0;


float time_arr[MAX_TIME_SAMPLES+1];
float latency_arr[MAX_TIME_SAMPLES+1];

main(int argc,char **argv)
{

  double cpu_hz=0.0;
  double mytime1,mytime2;
  double loops_per_sec;
  int loops_per_grain;
  int usleep_len;
  double sleep_len;
  double grain_len;

  int i,u;
  int res2;
  int run_nr;

  FILE *f;
  char *res;
  char s1[100];

  grain_len=10.0;
  if(argc>1)
  {
    grain_len=atof(argv[1]);
  }

  grain_len=grain_len/1000.0;
  printf("grain_len=%f\n",grain_len);

  sleep_len=5.0;
  if(argc>2)
  {
    sleep_len=atof(argv[2]);
  }
  usleep_len=sleep_len*1000;
  printf("usleep_len=%d\n",usleep_len);




  signal(SIGTERM,my_exithandler);
  signal(SIGINT,my_exithandler);

  overruns=0;

  f=fopen("/proc/cpuinfo","r");
  if(f==NULL)
  {
    perror("can't open /proc/cpuinfo, exiting. open");
    exit(1);
  }

  for(;;)
  {
    res=fgets(s1,100,f);
    if(res==NULL) break;
    if(!memcmp(s1,"cpu MHz",7))
    {
      cpu_hz=atof(&s1[10])*1000000.0;
      break;
    }
  }
  fclose(f);
  if(cpu_hz < 1.0)
  {
    fprintf(stderr,"can't determine CPU clock frequency, exiting.\n");
  }

  res2=set_realtime_priority();
  if(res2 == -1)
  {
    fprintf(stderr,"can't get realtime priority, run the program as root.\n");
    exit(1);
  }

printf("calibrating loop ....\n");

#define CALIB_LOOPS 100000000

mytime1=mygettime();
mydelay(CALIB_LOOPS);
mytime2=mygettime();


printf("time diff= %f \n",mytime2-mytime1);

printf("loops/sec = %f\n",CALIB_LOOPS/(mytime2-mytime1));
loops_per_sec=CALIB_LOOPS/(mytime2-mytime1);

loops_per_grain=loops_per_sec*grain_len;
printf("loops per grain = %d\n",loops_per_grain);
printf("GRAIN_LEN=%f ms \n",grain_len*1000.0);

NUM_TESTS=10.0/grain_len;

printf("running loops ....\n");

sleep(1);
mean_sum=0.0;


  run_nr=-1;

  for(i_test=0;i_test<NUM_TESTS*100;i_test++)
  {
    mytime1=mygettime();
    mydelay(loops_per_grain);
usleep(usleep_len);
    mytime2=mygettime();
    mytimediff=mytime2-mytime1;

    latency_arr[num_time_samples]=mytimediff;
    time_arr[num_time_samples]=mytime1;
    if(num_time_samples < MAX_TIME_SAMPLES) num_time_samples++;

    if(mytimediff>max_timediff)
    {
      max_timediff=mytimediff;
      run_nr=i_test;
    }

if(mytimediff >= buffer_latency )
{
  overruns++;
}

    mean_sum+=mytimediff;
  }



exit(0);

for(;;)
{


//printf("rdtsc=%lld \n",cycles);
//printf("cpu hz=%f\n",cpu_hz);


for(u=0;u<100000;u++);

if(mytimediff > max_timediff) max_timediff=mytimediff;

}





}

void mydelay(int loops)
{
  int k=0;
  int u;
  for(u=0;u<loops;u++) k+=1;
}


int set_realtime_priority(void)
{
struct sched_param schp;
	/*
	 * set the process to realtime privs
	 */
        memset(&schp, 0, sizeof(schp));
	schp.sched_priority = sched_get_priority_max(SCHED_FIFO);

	if (sched_setscheduler(0, SCHED_FIFO, &schp) != 0) {
		perror("sched_setscheduler");
		return -1;
	}

	return 0;

}

void *my_exithandler(void)
{

  if (overruns>999) overruns=999;

  if(DEBUG)  printf("\nNUMBER of OVERRUNS = %d  , max latency=%.1f ms  factor=%.1f %% of buffer\n",overruns,max_timediff*1000.0,(max_timediff/buffer_latency)*100.0);

//printf("% 5.1fms (% 3d)%5.1f%%|",max_timediff*1000.0,overruns,(max_timediff/buffer_latency)*100.0);
  printf("%5.1fms (%3d)|",max_timediff*1000.0,overruns);

//printf("time diff= %f \n",mytime2-mytime1);
printf("MAX time diff= %f \n",max_timediff);
printf("MEAN time diff= %f \n",mean_sum/NUM_TESTS);
printf("overruns = %d\n",overruns);
//printf("run nr = %d\n",run_nr);
  draw_chart(time_arr,latency_arr,num_time_samples,buffer_latency,overruns,max_timediff,0,0);

  if(DEBUG) fprintf(stderr,"\nexiting.\n");

  exit(0);
}



/*


---------------------------


if(mytimediff >= (buffer_latency*0.99) )
{
  overruns++;

  if(DEBUG)
  {
    printf("OVERRUN nr=%d :",overruns);
    printf("time diff=%.1f buffer_latency=%.1f factor=%.1f %%\n",mytimediff,buffer_latency,(mytimediff/buffer_latency)*100.0);
  }

}
//  res=ioctl(audio_fd,SNDCTL_DSP_GETOSPACE,&abinfo);
//  if(res == -1)
//  {
//    perror("ERROR: ioctl: SNDCTL_DSP_GETOSPACE");
//exit(0);
// //    return(-1);
//  }


  }

  return(0);
}


int init_audio(void)
{
  int res;
  int apar=0;

  audio_fd=open("/dev/dsp",O_WRONLY,0);
  if(audio_fd<0)
  {
    perror("ERROR: open /dev/dsp");
    exit(0);
    return(-1);
  }

  res=ioctl(audio_fd,SNDCTL_DSP_RESET,&apar);

  apar=AFMT_S16_LE;
  res=ioctl(audio_fd,SNDCTL_DSP_SETFMT,&apar);
  if(res == -1)
  {
    perror("ERROR: ioctl: SNDCTL_DSP_SETFMT");
    return(-1);
  }

  if( apar != AFMT_S16_LE)
  {
    fprintf(stderr,"ERROR: 16 bit format not supported\n");
    return(-1);
  }

  apar=1;
  res=ioctl(audio_fd,SNDCTL_DSP_STEREO,&apar);
  if(res == -1)
  {
    perror("ERROR: ioctl: SNDCTL_DSP_STEREO");
    return(-1);
  }

  if( apar != 1)
  {
    fprintf(stderr,"ERROR: stereo not supported\n");
    return(-1);
  }

  apar=44100;
  res=ioctl(audio_fd,SNDCTL_DSP_SPEED,&apar);
  if(res == -1)
  {
    perror("ERROR: ioctl: SNDCTL_DSP_SPEED");
    return(-1);
  }

if(DEBUG)  printf("SAMPLINGRATE=%d\n",apar);
 
  //apar=0x0004000b;
//  apar=0x0003000d;
//  apar=0x0002000c;
//printf("mynumfragments=%d myfragmentsize=%d\n",mynumfragments,myfragmentsize);

  apar=((mynumfragments-1) << 16) | myfragmentsize;
if(DEBUG) printf("fragment parameter = %x\n",apar);
  res=ioctl(audio_fd,SNDCTL_DSP_SETFRAGMENT,&apar);
  if(res == -1)
  {
    perror("ERROR: ioctl: SNDCTL_DSP_SETFRAGMENT");
    exit(1);
    return(-1);
  }

  
  res=ioctl(audio_fd,SNDCTL_DSP_GETOSPACE,&abinfo);
  if(res == -1)
  {
    perror("ERROR: ioctl: SNDCTL_DSP_GETOSPACE");
    return(-1);
  }

  aubuf_size=abinfo.fragstotal * abinfo.fragsize;

buffer_latency=(aubuf_size/176400.0)*1000000.0;
if(DEBUG) printf("OSS BUFFERS: fragments=%d  fragment size=%d  total buffer size=%d\n  buffer latency=%f ms\n",\
abinfo.fragstotal,abinfo.fragsize,aubuf_size,buffer_latency/1000.0);
  return(0);

}


close(audio_fd);
*/

