/*
 * zioP.h	Internal header for libzio, including required
 *		standard glibc header, zlib.h, and bzlib.h.
 *		Making the used libz and bzlib functions weak symbols.
 *
 * Copyright 2004 Werner Fink, 2004 SuSE LINUX AG, Germany.
 * Copyright 2006 Werner Fink, 2006 SuSE Products GmbH, Germany.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Author:      Werner Fink <werner@suse.de>
 */

#ifndef _ZIO_P_H
#define _ZIO_P_H

#ifndef _GNU_SOURCE
#  define _GNU_SOURCE
#endif
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <libio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

#if defined __GLIBC__ && __GLIBC__ > 1
#  undef  LIBIO_IS_FIXED
#  if __GLIBC__ > 2 || (__GLIBC__ >= 2 && __GLIBC_MINOR__ > 0)
#    define LIBIO_IS_FIXED
#  endif
#else
#  error The libzio requires the GLIBC
#endif

#if defined __GNUC__
#  if defined __USE_ISOC99
#    define _cat_pragma(exp)	_Pragma(#exp)
#    define _weak_pragma(exp)	_cat_pragma(weak name)
#  else
#    define _weak_pragma(exp)
#  endif
#  define _declare(name)	__extension__ extern __typeof__(name) name
#  define weak_symbol(name)	_weak_pragma(name) _declare(name) __attribute__((weak))
#else
#  error The libzio requires the GCC
#endif

#include <zlib.h>

weak_symbol(gzopen);
weak_symbol(gzdopen);
weak_symbol(gzread);
weak_symbol(gzwrite);
weak_symbol(gzseek);
weak_symbol(gzclose);

#include <bzlib.h>

weak_symbol(BZ2_bzopen);
weak_symbol(BZ2_bzdopen);
weak_symbol(BZ2_bzread);
weak_symbol(BZ2_bzwrite);
weak_symbol(BZ2_bzflush);
weak_symbol(BZ2_bzclose);

#ifndef LIBIO_IS_FIXED
__extension__ typedef _IO_cookie_io_functions_t cookie_io_functions_t;
__extension__ typedef ssize_t cookie_read_function_t  __P ((void *, char *, size_t));
__extension__ typedef ssize_t cookie_write_function_t __P ((void *, const char *, size_t));
__extension__ typedef int     cookie_seek_function_t  __P ((void *, off_t, int));
__extension__ typedef int     cookie_close_function_t __P ((void *));
#endif

#endif /* _ZIO_P_H */
