#ifndef _BRL_H
#define MYLiB "/usr/lib/suse-blinux/lib/libsbl-fhp.so.1"
#define _BRL_H

#define MAXNAMELEN 20
#define MAXPATHLEN 100
#define MAXSCRIPTS 200
#define NAMELEN 7

/* orca key-bindings */
#define ORCA_LNUP     0x01
#define ORCA_LNDN     0x02
#define ORCA_LNLFT    0x17
#define ORCA_LNRGT    0x18
#define ORCA_TOPLEFT   0x0b
#define ORCA_BOTLEFT   0x0c
#define ORCA_CSRTRK   0x1d
typedef struct
{
  int brl, kbd;
} brlkbd;

/* entries of $SBLDIR/keymap/ */
typedef struct
{
  brlkbd resetbrl, line01, topleft, botleft;
  brlkbd winup, windn, lnlft, lnrgt;
  brlkbd lnup, lndn, csrtrk, syscsr, softcsr;
  brlkbd chrlft, chrrgt, hwinlft, hwinrgt, fwinlft;
  brlkbd fwinrgt, csrjump, csrjmpvert, keyup;
  brlkbd keydn, keyrgt, keylft, keyenter, keyesc, csrvisoff;
  brlkbd jmpmark1, jmpmark2, jmpmark3, jmpmark4;
  brlkbd attr1, attr2, attr3, attr4;
  brlkbd csrtrkoff, prof1, prof2, prof3, prof4;
  brlkbd attroff, attrmodonoff, sixdotsonoff, csrblinkonoff;
  brlkbd csrblockonoff, cutbegin, cutend, paste;
  brlkbd spktocsr, spkfromcsr;
  brlkbd spkmod, spkoff;
  brlkbd spkcurln, spkscrtocsr, spkscrfromcsr;
  brlkbd nextlang, prevlang;
  brlkbd nextfrq, prevfrq;
  brlkbd nextspd, prevspd;
  brlkbd nextvol, prevvol;
  brlkbd nextvoice, prevvoice;
  brlkbd nextspec, prevspec;
  brlkbd spkcharmod;
  brlkbd kbdsniffon1, kbdsniffon2, kbdsniffoff;
  brlkbd soundonoff, loadkeymap, autoprofonoff;
  brlkbd setmark, jmptomark;
  int lineroutend, lineroutbeg, csrroutend, csrroutbeg;
  brlkbd scripts[MAXSCRIPTS];
  char scriptnames[MAXSCRIPTS][MAXNAMELEN];
}
keymap_file;

/* entries of /etc/suse-blinux.conf */
typedef struct
{
  char brlname[MAXNAMELEN];
  char brld_auth_key[MAXNAMELEN];
  char brld_host[MAXNAMELEN];
  int brld_port;
  char brlport[MAXNAMELEN];
  char spkname[MAXNAMELEN];
  char spkport[MAXNAMELEN];
  int keydelay, repeatdelay, profdelay, sleep;
  int debug;
  char brltbl[MAXNAMELEN];
  char profile1[MAXNAMELEN];
  char profile2[MAXNAMELEN];
  char profile3[MAXNAMELEN];
  char profile4[MAXNAMELEN];
  char progpath[MAXPATHLEN];
} sbl_config;

/* info structure for brailledisplays */
struct brlinfo
{
  char name[50];
  char fullname[80];
  int cols;
  int st_cells;
  int offvert;
  int offhor;
  int baud;
};

/* Braille information structure */
typedef struct
{
  int brl_fd;
  unsigned char *disp;		/* display contents - allocted by the driver */
  int x, y;			/* size of display */
}
brldim;				/* used for writing to a braille display */

/* only for libs */
typedef struct
{
  char *identifier;		/* name of driver */
/* Routines provided by the braille driver library: */
  void (*setxtty) (int tty);
  void (*setlock) (int lock);
  int (*getxtty) ();
  int (*getlock) ();
  struct brlinfo (*identify) (const char *, const char *);	/* print start-up messages */
  void (*debug) (unsigned int dbg);	/* set driver debuging */
  void (*initialize) (brldim *, const char *);	/* initialise Braille display */
  void (*close) (brldim *);	/* close braille display */
  void (*write) (brldim *);	/* write to braille display */
  int (*read) (int *);		/* get key press from braille display */
  void (*setstatus) (const unsigned char *);	/* set status cells */

}
braille_driver;

/* function to load the sbl configuartion files */
void getsblconf (sbl_config * sblconf, char *conf);
brlkbd keytrans (char *);
void getkeymap (sbl_config sblconf, char *profname, char *homedir);

/* helper function to parse the config files */
int confread (char *realname);
char *confsearch (char *serchstring);
#endif
