#include <stdio.h>
#include "sbllog.h"
#include "festival.h"

static FILE *fest_p = NULL;
static int fest_busy = 0;

void festival_close ()
{
  if (fest_p == NULL)
    return;

  fputs ("(quit)\n", fest_p);
  fflush (fest_p);
  pclose (fest_p);
  fest_p = NULL;
}

void festival_init (char *cmd)
{
  if (!(fest_p = popen (cmd, "w")))
   {
     sbl_log ("can't open festival: %s\n", cmd);
     return;
   }

  fputs ("(audio_mode 'async)\n", fest_p);
  fputs ("(Parameter.set 'Audio_Method 'netaudio)\n", fest_p);
  fflush (fest_p);
  sbl_log ("festival init OK\n");
}

void festival_start ()
{
}

void festival_say (char *spkstr)
{
  if (fest_p == NULL)
    return;
  fest_busy = 1;
  fprintf (fest_p, "(SayText \"%s\")\n", spkstr);
  fflush (fest_p);
}

void festival_param (char *param)
{
/* dummy */
  if (param)
    return;
}
void festival_vol (char *vol)
{
/* dummy */
  if (vol)
    return;
}

void festival_frq (char *frq)
{
/* dummy */
  if (frq)
    return;
}

void festival_spd (char *spd)
{
  if (fest_p == NULL || spd[0] == 0)
    return;
  fprintf (fest_p, "(Parameter.set 'Duration_Stretch %s)\n", spd);
  fflush (fest_p);
}

void festival_voice (char *voice)
{
  if (fest_p == NULL || voice[0] == 0)
    return;

  fprintf (fest_p, "%s\n", voice);
  fflush (fest_p);
}
void festival_lang (int lang)
{
/* dummy */
  if (lang)
    return;
}

void festival_spec (char *spec)
{
/* dummy */
  if (spec)
    return;
}

void festival_stop ()
{

  if (fest_p == NULL)
    return;

  if (!fest_busy)
    return;
  fputs ("(audio_mode 'shutup)\n", fest_p);
  fflush (fest_p);
  fest_busy = 0;
}

void festival_punctuation (int on)
{
/* dummy */
  if (on)
    return;

}
