#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ldconf.h"
#include "trans.h"
#include "keydef.h"
#include "sbllog.h"

spk_file spkctrl;
keymap_file keymap;

void getldconf (sbl_config * sblconf, char *conf)
{
  char str[100];

  if (!conf)
    iniread ("/etc/suse-blinux.conf");
  else
    iniread (conf);
  vecsearch (strcpy (sblconf->brlname, "brlname"));
  vecsearch (strcpy (sblconf->brlport, "brlport"));
  vecsearch (strcpy (sblconf->spkname, "spkname"));
  vecsearch (strcpy (sblconf->spkport, "spkport"));
  sblconf->repeatdelay = atoi (vecsearch (strcpy (str, "repeatdelay")));
  sblconf->debug = atoi (vecsearch (strcpy (str, "debug")));
  vecsearch (strcpy (sblconf->brld_host, "brld_host"));
  vecsearch (strcpy (sblconf->brld_auth_key, "brld_auth_key"));
  vecsearch (strcpy (str, "brld_auth_key"));
  if (!strlen (str))
    strcpy (sblconf->brld_auth_key, "default");
  else
    strcpy (sblconf->brld_auth_key, str);

  vecsearch (strcpy (str, "brld_port"));
  if (atoi (str))
    sblconf->brld_port = atoi (str);

  sblconf->sleep = atoi (vecsearch (strcpy (str, "sleep")));
  sblconf->profdelay = atoi (vecsearch (strcpy (str, "PROFDELAY")));
  vecsearch (strcpy (sblconf->profile1, "profile1"));
  vecsearch (strcpy (sblconf->profile2, "profile2"));
  vecsearch (strcpy (sblconf->profile3, "profile3"));
  vecsearch (strcpy (sblconf->profile4, "profile4"));
  vecsearch (strcpy (sblconf->progpath, "progpath"));
}

void getprofile (param_file * profile, char *progpath, char *homedir, char *s)
{
  char path[1200], str[1200];

  profile->csroncnt = 10;
  profile->csroffcnt = 10;
  sprintf (path, "%s/.suse-blinux/profile/%s", homedir, s);
  if (!iniread (path))
   {
     sprintf (path, "%s/profile/%s", progpath, s);
     if (!iniread (path))
      {
	sprintf (path, "%s/profile/%s", progpath, "default");
	iniread (path);
      }

   }
  strcpy (profile->profname, s);

/* vecsearch(strcpy(env.profname,"name")); */
  profile->csrsize = atoi (vecsearch (strcpy (str, "blockcsr")));
  profile->csrblink = atoi (vecsearch (strcpy (str, "csrblink")));
  profile->attrvis = atoi (vecsearch (strcpy (str, "attron")));
  profile->sixdots = atoi (vecsearch (strcpy (str, "sixdots")));
  profile->attrnr = atoi (vecsearch (strcpy (str, "attractnum")));
  profile->attr1.mask = str2mask (vecsearch (strcpy (str, "attr1")));
  profile->attr1.val = str2val (str);
  profile->attr2.mask = str2mask (vecsearch (strcpy (str, "attr2")));
  profile->attr2.val = str2val (str);
  profile->attr3.mask = str2mask (vecsearch (strcpy (str, "attr3")));
  profile->attr3.val = str2val (str);
  profile->attr4.mask = str2mask (vecsearch (strcpy (str, "attr4")));
  profile->attr4.val = str2val (str);
  profile->softcsr1.mask = str2mask (vecsearch (strcpy (str, "attrcsr1")));
  profile->softcsr1.val = str2val (str);
  profile->softcsr2.mask = str2mask (vecsearch (strcpy (str, "attrcsr2")));
  profile->softcsr2.val = str2val (str);
  profile->softcsr3.mask = str2mask (vecsearch (strcpy (str, "attrcsr3")));
  profile->softcsr3.val = str2val (str);
  profile->softcsr4.mask = str2mask (vecsearch (strcpy (str, "attrcsr4")));
  profile->softcsr4.val = str2val (str);
  profile->csrmode = atoi (vecsearch (strcpy (str, "csrmode")));
  profile->sound = atoi (vecsearch (strcpy (str, "sound")));
  profile->limitcsr1 = valxy (vecsearch (strcpy (str, "attrcsr1xy")));
  profile->limitcsr2 = valxy (vecsearch (strcpy (str, "attrcsr2xy")));
  profile->syscsrlimit = valxy (vecsearch (strcpy (str, "syscsrlimit")));
  profile->vertdispmode = atoi (vecsearch (strcpy (str, "vertmode")));
  profile->mark1 = atoi (vecsearch (strcpy (str, "mark1")));
  profile->mark2 = atoi (vecsearch (strcpy (str, "mark2")));
  profile->mark3 = atoi (vecsearch (strcpy (str, "mark3")));
  profile->mark4 = atoi (vecsearch (strcpy (str, "mark4")));
  profile->csrvis = 1;
  profile->spkvolume = atoi (vecsearch (strcpy (str, "spkvolume")));
  profile->spkfrq = atoi (vecsearch (strcpy (str, "spkfrq")));
  profile->spkspd = atoi (vecsearch (strcpy (str, "spkspd")));
  profile->spkvoice = atoi (vecsearch (strcpy (str, "spkvoice")));
  profile->spklang = atoi (vecsearch (strcpy (str, "spklang")));
  profile->spkspec = atoi (vecsearch (strcpy (str, "spkspec")));
  profile->spkmod = atoi (vecsearch (strcpy (str, "spkmod")));
  profile->spkcharmod = atoi (vecsearch (strcpy (str, "spkcharmod")));

}

/* This is now reentrant, i.e. it only changes the values in keymap
 * which are present in the config file, with the default values in
 * default.map -KK */
void getkeymap (sbl_config sblconf, char *profname, char *homedir)
{
  char *brlname[2] = { "keyboard", sblconf.brlname };
  int i;

  for (i = 0; i < 2; i++)
   {
     int cnt = 0, pos = 0, num;
     char str[120];

     sprintf (str, "%s/.suse-blinux/keymap/%s.map.%s", homedir, brlname[i],
	      profname);
     if (!iniread (str))
      {
	sprintf (str, "%s/.suse-blinux/keymap/%s.map", homedir, brlname[i]);
	if (!iniread (str))
	 {
	   sprintf (str, "%s/keymap/%s.map.%s", sblconf.progpath,
		    brlname[i], profname);
	   if (!iniread (str))
	    {
	      sprintf (str, "%s/keymap/%s.map", sblconf.progpath, brlname[i]);
	      if (!iniread (str))
		continue;
	    }
	 }
      }

     keytrans (&keymap.kbdsniffon1, vecsearch (strcpy (str, "kbdsniffon1")));
     keytrans (&keymap.kbdsniffon2, vecsearch (strcpy (str, "kbdsniffon2")));
     keytrans (&keymap.kbdsniffoff, vecsearch (strcpy (str, "kbdsniffoff")));
     keytrans (&keymap.resetbrl, vecsearch (strcpy (str, "resetbrl")));
     keytrans (&keymap.line01, vecsearch (strcpy (str, "line01")));
     keytrans (&keymap.topleft, vecsearch (strcpy (str, "topleft")));
     keytrans (&keymap.botleft, vecsearch (strcpy (str, "botleft")));
     keytrans (&keymap.winup, vecsearch (strcpy (str, "winup")));
     keytrans (&keymap.windn, vecsearch (strcpy (str, "windn")));
     keytrans (&keymap.lnlft, vecsearch (strcpy (str, "lnlft")));
     keytrans (&keymap.lnrgt, vecsearch (strcpy (str, "lnrgt")));
     keytrans (&keymap.lnup, vecsearch (strcpy (str, "lnup")));
     keytrans (&keymap.lndn, vecsearch (strcpy (str, "lndn")));
     keytrans (&keymap.csrtrk, vecsearch (strcpy (str, "csrtrk")));
     keytrans (&keymap.syscsr, vecsearch (strcpy (str, "syscsr")));
     keytrans (&keymap.softcsr, vecsearch (strcpy (str, "softcsr")));
     keytrans (&keymap.chrlft, vecsearch (strcpy (str, "chrlft")));
     keytrans (&keymap.chrrgt, vecsearch (strcpy (str, "chrrgt")));
     keytrans (&keymap.hwinlft, vecsearch (strcpy (str, "hwinlft")));
     keytrans (&keymap.hwinrgt, vecsearch (strcpy (str, "hwinrgt")));
     keytrans (&keymap.fwinlft, vecsearch (strcpy (str, "fwinlft")));
     keytrans (&keymap.fwinrgt, vecsearch (strcpy (str, "fwinrgt")));
     keytrans (&keymap.csrjump, vecsearch (strcpy (str, "csrjump")));
     keytrans (&keymap.csrjmpvert, vecsearch (strcpy (str, "csrjmpvert")));
     keytrans (&keymap.keyup, vecsearch (strcpy (str, "keyup")));
     keytrans (&keymap.keydn, vecsearch (strcpy (str, "keydn")));
     keytrans (&keymap.keylft, vecsearch (strcpy (str, "keylft")));
     keytrans (&keymap.keyrgt, vecsearch (strcpy (str, "keyrgt")));
     keytrans (&keymap.keyenter, vecsearch (strcpy (str, "keyenter")));
     keytrans (&keymap.keyesc, vecsearch (strcpy (str, "keyesc")));
     keytrans (&keymap.csrvisoff, vecsearch (strcpy (str, "csrvisoff")));
     keytrans (&keymap.jmpmark1, vecsearch (strcpy (str, "jmpmark1")));
     keytrans (&keymap.jmpmark2, vecsearch (strcpy (str, "jmpmark2")));
     keytrans (&keymap.jmpmark3, vecsearch (strcpy (str, "jmpmark3")));
     keytrans (&keymap.jmpmark4, vecsearch (strcpy (str, "jmpmark4")));
     keytrans (&keymap.setmark, vecsearch (strcpy (str, "setmark")));
     keytrans (&keymap.jmptomark, vecsearch (strcpy (str, "jmptomark")));
     keytrans (&keymap.attr1, vecsearch (strcpy (str, "attr1")));
     keytrans (&keymap.attr2, vecsearch (strcpy (str, "attr2")));
     keytrans (&keymap.attr3, vecsearch (strcpy (str, "attr3")));
     keytrans (&keymap.attr4, vecsearch (strcpy (str, "attr4")));
     keytrans (&keymap.csrtrkoff, vecsearch (strcpy (str, "csrtrkoff")));
     keytrans (&keymap.prof1, vecsearch (strcpy (str, "prof1")));
     keytrans (&keymap.prof2, vecsearch (strcpy (str, "prof2")));
     keytrans (&keymap.prof3, vecsearch (strcpy (str, "prof3")));
     keytrans (&keymap.prof4, vecsearch (strcpy (str, "prof4")));
     keytrans (&keymap.attroff, vecsearch (strcpy (str, "attroff")));
     keytrans (&keymap.attrmodonoff,
	       vecsearch (strcpy (str, "attrmodonoff")));
     keytrans (&keymap.sixdotsonoff,
	       vecsearch (strcpy (str, "sixdotsonoff")));
     keytrans (&keymap.csrblinkonoff,
	       vecsearch (strcpy (str, "csrblinkonoff")));
     keytrans (&keymap.csrblockonoff,
	       vecsearch (strcpy (str, "csrblockonoff")));
     keytrans (&keymap.cutbegin, vecsearch (strcpy (str, "cutbegin")));
     keytrans (&keymap.cutend, vecsearch (strcpy (str, "cutend")));
     keytrans (&keymap.loadkeymap, vecsearch (strcpy (str, "loadkeymap")));
     keytrans (&keymap.paste, vecsearch (strcpy (str, "paste")));
     keytrans (&keymap.soundonoff, vecsearch (strcpy (str, "soundonoff")));
     keytrans (&keymap.autoprofonoff,
	       vecsearch (strcpy (str, "autoprofonoff")));
     keytrans (&keymap.spktocsr, vecsearch (strcpy (str, "spktocsr")));
     keytrans (&keymap.spkcurln, vecsearch (strcpy (str, "spkcurln")));
     keytrans (&keymap.spkscrtocsr, vecsearch (strcpy (str, "spkscrtocsr")));
     keytrans (&keymap.spkscrfromcsr,
	       vecsearch (strcpy (str, "spkscrfromcsr")));
     keytrans (&keymap.spkfromcsr, vecsearch (strcpy (str, "spkfromcsr")));
     keytrans (&keymap.spkmod, vecsearch (strcpy (str, "spkmod")));
     keytrans (&keymap.spkoff, vecsearch (strcpy (str, "spkoff")));
     keytrans (&keymap.nextlang, vecsearch (strcpy (str, "nextlang")));
     keytrans (&keymap.nextvol, vecsearch (strcpy (str, "nextvol")));
     keytrans (&keymap.nextvoice, vecsearch (strcpy (str, "nextvoice")));
     keytrans (&keymap.nextspec, vecsearch (strcpy (str, "nextspec")));
     keytrans (&keymap.nextfrq, vecsearch (strcpy (str, "nextfrq")));
     keytrans (&keymap.nextspd, vecsearch (strcpy (str, "nextspd")));
     keytrans (&keymap.prevlang, vecsearch (strcpy (str, "prevlang")));
     keytrans (&keymap.prevvol, vecsearch (strcpy (str, "prevvol")));
     keytrans (&keymap.prevvoice, vecsearch (strcpy (str, "prevvoice")));
     keytrans (&keymap.prevspec, vecsearch (strcpy (str, "prevspec")));
     keytrans (&keymap.prevfrq, vecsearch (strcpy (str, "prevfrq")));
     keytrans (&keymap.prevspd, vecsearch (strcpy (str, "prevspd")));
     keytrans (&keymap.spkcharmod, vecsearch (strcpy (str, "spkcharmod")));

     do
      {
	char name[80] = "", key[80] = "";
	brlkbd keystruct = { 0, 0 };

	keytrans (&keystruct, script_search (name, key, cnt));
	if (keystruct.kbd || keystruct.brl)
	 {
	   keymap.scripts[pos] = keystruct;
	   strcpy (keymap.scriptnames[pos], name);
	   pos++;
	 }

	cnt++;
	sbl_log ("script: %s (%d), key: %s", name, strlen (name), key);
	if ((pos >= MAXSCRIPTS) || (!strlen (name)))
	  break;
      }
     while (1);

     num = atoi (vecsearch (strcpy (str, "csrroutbeg")) + 1);
     if (num > 0)
       keymap.csrroutbeg = num;
     num = atoi (vecsearch (strcpy (str, "csrroutend")) + 1);
     if (num > 0)
       keymap.csrroutend = num;
     num = atoi (vecsearch (strcpy (str, "lineroutbeg")) + 1);
     if (num > 0)
       keymap.lineroutbeg = num;
     num = atoi (vecsearch (strcpy (str, "lineroutend")) + 1);
     if (num > 0)
       keymap.lineroutend = num;
   }				/* end for */

}

/* Add new keys to keymap */
#define CKEYS 37
void keytrans (brlkbd * bk, char *str)
{
  const char kbdvec[][20] = {
    "csrup", "csrdn", "csrlft", "csrrgt", "pgup", "pgdn", "home", "end",
    "insert", "del",
    "num_lock", "num_div", "num_mul", "num_sub", "num_plus", "num_ent",
    "num_comma", "num_0", "num_1", "num_2", "num_3", "num_4",
    "num_5", "num_6", "num_7", "num_8", "num_9",
    "ping1", "ping2", "ping3", "caps_lock",
    "lft_ctrl", "rgt_ctrl", "alt", "alt_gr",
    "lft_shft", "rgt_shft",
    "enter", "bs", "tab", "esc",
    "f01", "f02", "f03", "f04", "f05", "f06", "f07", "f08", "f09", "f10",
    "f11", "f12",
    "space",
    "\0"
  };

  const short valkbd[] = {
    CSRUP, CSRDN, CSRLFT, CSRRGT, PGUP, PGDN, HOME, END, INSERT,
    DEL, NUM_LOCK, NUM_DIV, NUM_MUL, NUM_SUB, NUM_PLUS, NUM_ENT,
    NUM_COMMA, NUM_0, NUM_1, NUM_2, NUM_3, NUM_4,
    NUM_5, NUM_6, NUM_7, NUM_8, NUM_9,
    PING1, PING2, PING3, CAPS_LOCK,
    LFT_CTRL, RGT_CTRL, ALT, ALT_GR,
    LFT_SHFT, RGT_SHFT,
    ENTER, BS,
    TAB, ESC,
    F01, F02, F03, F04, F05, F06, F07, F08, F09, F10,
    F11, F12,
    SPACE,
    0
  };
  unsigned int i = 0;
  int code = 0, kbdcode = 0;
  char key1[10] = "", key2[10] = "", kbdstr[30] = "";
  brlkbd keys = { 0, 0 };

  if (!str)
    return;
  for (i = 0; i < strlen (str); i++)
    if (str[i] == ',')
      kbdcode = i;
  if (strlen (str) < 2)
    return;
  if (str[kbdcode] == ',')
   {
     strcpy (kbdstr, str + kbdcode + 1);
     str[kbdcode] = 0;
   }
  else
    kbdstr[0] = 0;

  if (strlen (str) > 3)
   {
     strncpy (key1, str, 4);
     key1[4] = 0;
     if (strlen (str) > 4)
       strcpy (key2, str + 5);
     key2[4] = 0;
     code = 0;
     code = (atoi (key1 + 1));
     if (strlen (key2))
       code = (code * 1000) + atoi (key2 + 1);
     keys.brl = code;
   }				/* if */
  else
    keys.brl = 0;

  memset (key1, 0, sizeof (key1));
  code = 0;
  if (strlen (kbdstr) == 1)
    keys.kbd = kbdstr[0];
  else
    for (i = 0; valkbd[i] != 0; i++)
     {
       if (!strncasecmp (kbdstr, kbdvec[i], strlen (kbdvec[i])))
	 keys.kbd = valkbd[i];
     }

  if (keys.brl)
    bk->brl = keys.brl;
  if (keys.kbd)
    bk->kbd = keys.kbd;
}

#define SPKCTRL(DEST,SRC); strtrans(DEST,vecsearch(strcpy(str,SRC)));
void getspkctrl (char *progpath, char *spkname)
{
  char path[100];
  char str[100];

  if (!strncmp (spkname, "none", 4))
    return;
  sprintf (path, "%s/spk/%s", progpath, spkname);
  if (!iniread (path))
   {
     strcpy (spkname, "none");
     return;
   }

  spkctrl.baud = atoi (vecsearch (strcpy (str, "baud")));
  SPKCTRL (spkctrl.start, "start");
  SPKCTRL (spkctrl.stop, "stop");

  SPKCTRL (spkctrl.init, "init");
  SPKCTRL (spkctrl.indexstart, "indexstart");
  SPKCTRL (spkctrl.indexsend, "indexsend");
  SPKCTRL (spkctrl.indexaltsend, "indexaltsend");
  SPKCTRL (spkctrl.indexreceive, "indexreceive");
  SPKCTRL (spkctrl.language[0], "language1");
  SPKCTRL (spkctrl.language[1], "language2");
  SPKCTRL (spkctrl.language[2], "language3");
  SPKCTRL (spkctrl.language[3], "language4");
  SPKCTRL (spkctrl.language[4], "language5");
  SPKCTRL (spkctrl.language[5], "language6");
  SPKCTRL (spkctrl.language[6], "language7");
  SPKCTRL (spkctrl.language[7], "language8");
  SPKCTRL (spkctrl.language[8], "language9");
  SPKCTRL (spkctrl.voice[0], "voice1");
  SPKCTRL (spkctrl.voice[1], "voice2");
  SPKCTRL (spkctrl.voice[2], "voice3");
  SPKCTRL (spkctrl.voice[3], "voice4");
  SPKCTRL (spkctrl.voice[4], "voice5");
  SPKCTRL (spkctrl.voice[5], "voice6");
  SPKCTRL (spkctrl.voice[6], "voice7");
  SPKCTRL (spkctrl.voice[7], "voice8");
  SPKCTRL (spkctrl.voice[8], "voice9");
  SPKCTRL (spkctrl.special[0], "special1");
  SPKCTRL (spkctrl.special[1], "special2");
  SPKCTRL (spkctrl.special[2], "special3");
  SPKCTRL (spkctrl.special[3], "special4");
  SPKCTRL (spkctrl.special[4], "special5");
  SPKCTRL (spkctrl.special[5], "special6");
  SPKCTRL (spkctrl.special[6], "special7");
  SPKCTRL (spkctrl.special[7], "special8");
  SPKCTRL (spkctrl.special[8], "special9");
  SPKCTRL (spkctrl.frequency[0], "frequency1");
  SPKCTRL (spkctrl.frequency[1], "frequency2");
  SPKCTRL (spkctrl.frequency[2], "frequency3");
  SPKCTRL (spkctrl.frequency[3], "frequency4");
  SPKCTRL (spkctrl.frequency[4], "frequency5");
  SPKCTRL (spkctrl.frequency[5], "frequency6");
  SPKCTRL (spkctrl.frequency[6], "frequency7");
  SPKCTRL (spkctrl.frequency[7], "frequency8");
  SPKCTRL (spkctrl.frequency[8], "frequency9");
  SPKCTRL (spkctrl.volume[0], "volume1");
  SPKCTRL (spkctrl.volume[1], "volume2");
  SPKCTRL (spkctrl.volume[2], "volume3");
  SPKCTRL (spkctrl.volume[3], "volume4");
  SPKCTRL (spkctrl.volume[4], "volume5");
  SPKCTRL (spkctrl.volume[5], "volume6");
  SPKCTRL (spkctrl.volume[6], "volume7");
  SPKCTRL (spkctrl.volume[7], "volume8");
  SPKCTRL (spkctrl.volume[8], "volume9");
  SPKCTRL (spkctrl.speed[0], "speed1");
  SPKCTRL (spkctrl.speed[1], "speed2");
  SPKCTRL (spkctrl.speed[2], "speed3");
  SPKCTRL (spkctrl.speed[3], "speed4");
  SPKCTRL (spkctrl.speed[4], "speed5");
  SPKCTRL (spkctrl.speed[5], "speed6");
  SPKCTRL (spkctrl.speed[6], "speed7");
  SPKCTRL (spkctrl.speed[7], "speed8");
  SPKCTRL (spkctrl.speed[8], "speed9");
  SPKCTRL (spkctrl.filter[0], "filter1");
  SPKCTRL (spkctrl.filter[1], "filter2");
  SPKCTRL (spkctrl.filter[2], "filter3");
  SPKCTRL (spkctrl.filter[3], "filter4");
  SPKCTRL (spkctrl.filter[4], "filter5");
  SPKCTRL (spkctrl.filter[5], "filter6");
  SPKCTRL (spkctrl.filter[6], "filter7");
  SPKCTRL (spkctrl.filter[7], "filter8");
  SPKCTRL (spkctrl.filter[8], "filter9");

}

char *strtrans (char *realstr, char *s)
{

  unsigned int i;
  int j = -1;
  char str[50] = "";

  memset (realstr, 0, 50);
  memset (str, 0, 50);
  for (i = 0; i < strlen (s); i++)
   {
     j++;
     if (s[i] == '^')
      {
	strncpy (str, s + i + 1, 3);
	realstr[j] = atoi (str);
	i += 3;
      }
     else
       realstr[j] = s[i];

   }

  return (char *) realstr;

}

void getspkfilter (char *progpath, char *profname, char *homedir, int filter)
{

  FILE *spkfile;
  char str[80];
  unsigned int cnt = 0, i;
  char path[120];

  sbl_log ("ldconfig: filter %d\n", filter);
  sprintf (path, "%s/.suse-blinux/spkfilter/%s%s", homedir, profname,
	   spkctrl.filter[filter]);
  if (!(spkfile = fopen (path, "r")))
   {
     sprintf (path, "%s/spkfilter/%s%s", progpath, profname,
	      spkctrl.filter[filter]);
     if (!(spkfile = fopen (path, "r")))
      {
	sprintf (path, "%s/spkfilter/%s%s", progpath, "default",
		 spkctrl.filter[filter]);
	if (!(spkfile = fopen (path, "r")))
	  return;
      }
   }

  do
   {
     fgets (str, 80, spkfile);

     for (i = 0; i < strlen (str) && !feof (spkfile); i++)
       if (str[i] == '=')
	{
	  strncpy (spkfrom[cnt], str, i);
	  spkfrom[cnt][i] = 0;
	  //strcpy (spkto[cnt],str + i + 1);
	  strtrans (spkto[cnt], str + i + 1);
	  spkto[cnt][strlen (spkto[cnt]) - 1] = 0;
	  cnt++;
	}

   }
  while (!feof (spkfile));

  fclose (spkfile);
  spkcnt = cnt;
}
