#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include<iconv.h>

#include "sbllog.h"
#include "speechdlib.h"
#include <unistd.h>

iconv_t cd;

static void *speechd_lib = NULL;

//static int cur_voice_tmp = 1;

static SPDConnection *speechd_ptr = NULL;
void speechd_close ()
{
  iconv_close (cd);
  if (!speechd_ptr)
    return;
  spd_close (speechd_ptr);
  if (speechd_lib != NULL)
    dlclose (speechd_lib);
}

int speechd_init (char *cmd)
{
  sbl_log ("speechd_init\n");

  int cmd_val = atoi (cmd);

  cmd_val++;
  cd = iconv_open ("utf8", "iso8859-1");

  if (speechd_ptr)
   {
     sbl_log ("speechd is already initialized\n");
     return 0;
   }

  speechd_ptr = spd_open ("sbl", NULL, NULL, 1);
  if (speechd_ptr)
   {
     sbl_log ("spd init param set \n");
   }
  else
   {
     sbl_log ("cannot connect to speech-dispatcher server\n");
     return 1;
   }

  return 0;
}

void speechd_start ()
{
}

void speechd_say (char *spkstr)
{
  static char tmpbuf[4096];
  unsigned int i = 0, cnt = 0;

  if (speechd_ptr == NULL)
    return;
  memset (tmpbuf, 0, sizeof (tmpbuf));
  for (i = 0; i < strlen (spkstr); i++)
   {
     if (spkstr[i] == ' ' && spkstr[i + 1] == ' ')
       continue;
     tmpbuf[cnt] = spkstr[i];
     cnt++;
   }

  tmpbuf[cnt] = '\0';
/*

  switch (spkstr[0]) {
  case 0:
    return;
  case '\n':
  case '\r':
  case ' ':
    if (spkstr[1] == 0)
      return;
    break;
  }
*/

  static char buffer[8192];	// it's enough 

  memset (buffer, 0, sizeof (buffer));
  char *inbuf = (char *) tmpbuf;
  char *outbuf = (char *) buffer;
  size_t inbytes = strlen (tmpbuf) + 1, outbytes = sizeof (buffer);

  iconv (cd, &inbuf, &inbytes, &outbuf, &outbytes);
  sbl_log ("ttsay ");

  spd_say (speechd_ptr, SPD_TEXT, (char *) buffer);
}

void speechd_param (char *param)
{
  sbl_log ("%s\n", param);
}
void speechd_vol (char *vol)
{
  int vol_val = atoi (vol);

  spd_set_volume (speechd_ptr, vol_val);
  sbl_log ("volume: %d ", vol_val);
}

void speechd_frq (char *frq)
{
  int frq_val = atoi (frq);

  if (!speechd_ptr)
    return;
  spd_set_voice_pitch (speechd_ptr, frq_val);
}

void speechd_spd (char *spd)
{
  int spd_val = atoi (spd);

  spd_set_voice_rate (speechd_ptr, spd_val);
}

void speechd_voice (char *voice)
{
  if (!speechd_ptr)
    return;

  spd_set_voice_type (speechd_ptr, atoi (voice));
}

void speechd_lang (char *lang)
{
  spd_set_language (speechd_ptr, lang);
}

void speechd_spec (char *spec)
{
  if (spec)
    return;
}

void speechd_stop ()
{
  if (!speechd_ptr)
    return;
  spd_cancel (speechd_ptr);
  usleep (500);
}

void speechd_punctuation (int on)
{
  if (on == 1)
    on--;
  if (spd_set_punctuation (speechd_ptr, on))
    sbl_log ("set punctuation level failed\n");
  else
    sbl_log ("punctuation set ok\n");
}
