#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <termio.h>

#include "mbrola.h"
#include "festival.h"
#include "ttsynth.h"
#include "speechd.h"

#include "spk.h"
#include "spkfilter.h"
#include "sbllog.h"

extern spk_file spkctrl;
extern int spkupdate;
extern sbl_config sblconf;

#define SPKNAME sblconf.spkname
static int spk_model = 0;
int spkfd = 0;
char spkparam[200] = "";
extern int spkmode;
char spkfrom[1000][80], spkto[1000][80];
char *from[] = {
  "#", "~"
};
char *to[] = {
  " gatter ", " tilde "
};
int spkcnt;
void spkinit (char *dev)
{
  struct termios newtio;	/* new terminal settings */

  ISNONE
  {
    spk_model = SPK_NONE;
    return;
  }

  ISFESTIVAL
  {
    spk_model = SPK_FESTIVAL;
    sbl_log ("try to init festival\n");
    festival_init (spkctrl.init);
    return;
  }
  ISTTSYNTH
  {
    char libpath[80] = "";

    sprintf (libpath, "%s/lib/ttsynthlib.so", PROGPATH);
    spk_model = SPK_TTSYNTH;

    if (ttsynth_load_lib (libpath))
     {
       sbl_log ("ttsynth_load: failed\n");
       spk_model = SPK_NONE;
       return;
     }
    sbl_log ("try to init ttsynth");
    ttsynth_init (spkctrl.init);
    return;
  }

  ISSPEECHD
  {
    char libpath[80] = "";

    sprintf (libpath, "%s/lib/speechdlib.so", PROGPATH);
    spk_model = SPK_SPEECHD;

    if (speechd_load_lib (libpath))
     {
       sbl_log ("speechd_load: failed\n");
       spk_model = SPK_NONE;
       return;
     }
    sbl_log ("try to init speechd");
    if (speechd_init (spkctrl.init))
     {
       spk_model = SPK_NONE;
       return;
     }
    return;
  }

  ISMBROLA
  {
    spk_model = SPK_MBROLA;
    mbrola_init ();
    return;
  }

  spk_model = SPK_HW;

  if (!dev)
   {
     printf ("ERROR: must give dev name\n");
     spk_model = SPK_NONE;
     return;
   }

  spkfd = open (dev, O_RDWR | O_NOCTTY);
  if (spkfd < 0)
   {
     printf ("ERROR: fd=%d\n", spkfd);
     spk_model = SPK_NONE;
     return;
   }

  /* Set bps, flow control and 8n1, enable reading */
  newtio.c_cflag = B9600 | CRTSCTS | CS8 | CLOCAL | CREAD;

  /* Ignore bytes with parity errors and make terminal raw and dumb */
  newtio.c_iflag = IGNPAR;
  newtio.c_oflag = 0;		/* raw output */
  newtio.c_lflag = 0;		/* don't echo or generate signals */
  newtio.c_cc[VMIN] = 0;	/* set nonblocking read */
  newtio.c_cc[VTIME] = 0;
  tcflush (spkfd, TCIFLUSH);	/* clean line */
  tcsetattr (spkfd, TCSANOW, &newtio);	/* activate new setting */

  write (spkfd, spkctrl.init, strlen (spkctrl.init));

  return;
}

void setinit ()
{

  switch (spk_model)
   {
   case SPK_NONE:
     return;
   case SPK_MBROLA:
     mbrola_start ();
     return;
   case SPK_TTSYNTH:
     ttsynth_start ();
     return;
   case SPK_SPEECHD:
     speechd_start ();
     return;

   case SPK_FESTIVAL:
     festival_start ();
     return;
   case SPK_HW:
     write (spkfd, spkctrl.start, strlen (spkctrl.start));
   }

}

void spkwrite (char *spkstr)
{
  char *str = NULL;

  if (spk_model == SPK_NONE)
    return;

  switch (spkmode)
   {
   case SPKNORM:
     spkstr = prefilt (spkstr);
     str = spkfilter (spkfrom, spkto, spkcnt, spkstr);
     break;
   case SPKOFF:
     return;
   case SPKSPELL:
    {
      char spellstr[MAXSPELLSTR] = "";

      spellfilter (spellstr, spkstr);
      str = spkfilter (spkfrom, spkto, spkcnt, spellstr);
    }
     break;
   }

  if (spkupdate)
   {
     setinit ();
     spkupdate = 0;
   }
  else
    switch (spk_model)
     {
     case SPK_MBROLA:
       mbrola_stop ();
       break;
     case SPK_TTSYNTH:
       ttsynth_stop ();
       break;
     case SPK_SPEECHD:
       speechd_stop ();
       break;
     case SPK_FESTIVAL:
       festival_stop ();
       break;
     case SPK_HW:
       write (spkfd, spkctrl.stop, strlen (spkctrl.stop));
       break;
     }				// switch

  if (strlen (spkparam))
   {
     switch (spk_model)
      {
      case SPK_MBROLA:
	mbrola_param (spkparam);
	break;
      case SPK_TTSYNTH:
	ttsynth_param (spkparam);
	break;
      case SPK_SPEECHD:
	speechd_param (spkparam);

      case SPK_FESTIVAL:
	festival_param (spkparam);
	break;
      case SPK_HW:
	write (spkfd, spkparam, strlen (spkparam));
	break;
      }				// switch
     spkparam[0] = 0;
   }

  switch (spk_model)
   {
   case SPK_MBROLA:
     mbrola_say (str);
     break;
   case SPK_TTSYNTH:
     ttsynth_say (str);
     break;

   case SPK_SPEECHD:
     speechd_say (str);
     break;

   case SPK_FESTIVAL:
     festival_say (str);
     break;
   case SPK_HW:
     write (spkfd, str, strlen (str));
     write (spkfd, spkctrl.start, strlen (spkctrl.start));
     break;
   }				// switch
}

int volume (int vol)
{

  if (spk_model == SPK_NONE)
    return 0;

  if (strlen (spkctrl.volume[vol]) < 1 || !(vol >= 0 && vol <= 8))
    return 0;

  switch (spk_model)
   {
   case SPK_MBROLA:
     mbrola_vol (spkctrl.volume[vol]);
     break;
   case SPK_TTSYNTH:
     ttsynth_vol (spkctrl.volume[vol]);
     break;
   case SPK_SPEECHD:
     speechd_vol (spkctrl.volume[vol]);
     break;
   case SPK_FESTIVAL:
     festival_vol (spkctrl.volume[vol]);
     break;
   case SPK_HW:
     sprintf (spkparam, "%s%s", spkparam, spkctrl.volume[vol]);
   }				// switch 
  return 1;
}

int frq (int frq)
{

  if (spk_model == SPK_NONE)
    return 0;

  if (strlen (spkctrl.frequency[frq]) < 1 || !(frq >= 0 && frq <= 8))
    return 0;

  switch (spk_model)
   {
   case SPK_MBROLA:
     mbrola_frq (spkctrl.frequency[frq]);
     break;
   case SPK_TTSYNTH:
     ttsynth_frq (spkctrl.frequency[frq]);
     break;
   case SPK_SPEECHD:
     speechd_frq (spkctrl.frequency[frq]);
     break;
   case SPK_FESTIVAL:
     festival_frq (spkctrl.frequency[frq]);
     break;
   case SPK_HW:
     sprintf (spkparam, "%s%s", spkparam, spkctrl.frequency[frq]);
     break;
   }				// switch 
  return 1;
}
int speed (int spd)
{

  if (spk_model == SPK_NONE)
    return 0;

  if (strlen (spkctrl.speed[spd]) < 1 || !(spd >= 0 && spd <= 8))
    return 0;

  switch (spk_model)
   {
   case SPK_MBROLA:
     mbrola_spd (spkctrl.speed[spd]);
     break;
   case SPK_TTSYNTH:
     ttsynth_spd (spkctrl.speed[spd]);
     break;
   case SPK_SPEECHD:
     speechd_spd (spkctrl.speed[spd]);
     break;
   case SPK_FESTIVAL:
     festival_spd (spkctrl.speed[spd]);
     break;
   case SPK_HW:
     sprintf (spkparam, "%s%s", spkparam, spkctrl.speed[spd]);

     break;
   }				// switch 
  return 1;
}

int voice (int v)
{

  if (spk_model == SPK_NONE)
    return 0;

  if (strlen (spkctrl.voice[v]) < 1 || !(v >= 0 && v <= 8))
    return 0;

  switch (spk_model)
   {
   case SPK_MBROLA:
     mbrola_voice (spkctrl.voice[v]);
     break;
   case SPK_TTSYNTH:
     ttsynth_voice (spkctrl.voice[v]);
     break;
   case SPK_SPEECHD:
     speechd_voice (spkctrl.voice[v]);
     break;
   case SPK_FESTIVAL:
     festival_voice (spkctrl.voice[v]);
     break;
   case SPK_HW:
     sprintf (spkparam, "%s%s", spkparam, spkctrl.voice[v]);
     break;
   }				// switch 
  return 1;
}

int lang (int lang)
{

  if (spk_model == SPK_NONE)
    return 0;
  if (strlen (spkctrl.language[lang]) < 1 || !(lang >= 0 && lang <= 8))
    return 0;
  switch (spk_model)
   {
   case SPK_MBROLA:
     mbrola_lang (lang);
     break;
   case SPK_TTSYNTH:
     ttsynth_lang (spkctrl.language[lang]);
     break;
   case SPK_SPEECHD:
     speechd_lang (spkctrl.language[lang]);
   case SPK_FESTIVAL:
     festival_lang (lang);
     break;
   case SPK_HW:
     sprintf (spkparam, "%s,", spkctrl.language[lang]);
     write (spkfd, spkparam, strlen (spkparam));
     usleep (500);
     spkparam[0] = 0;
     break;

   }				// switch 
  return 1;

}

int special (int s)
{

  if (spk_model == SPK_NONE)
    return 0;

  if (strlen (spkctrl.special[s]) < 1 || !(s >= 0 && s <= 8))
    return 0;

  switch (spk_model)
   {
   case SPK_MBROLA:
     mbrola_spec (spkctrl.special[s]);
     break;
   case SPK_TTSYNTH:
     ttsynth_spec (spkctrl.special[s]);
     break;
   case SPK_SPEECHD:
     speechd_spec (spkctrl.special[s]);
     break;

   case SPK_FESTIVAL:
     festival_spec (spkctrl.special[s]);
     break;
   case SPK_HW:
     sprintf (spkparam, "%s%s", spkparam, spkctrl.special[s]);
     break;
   }				// switch
  return 1;
}

void test123 ()
{

  spkwrite ("1 2 3 4");
}

void spellfilter (char *spell, char *str)
{

  unsigned int i;

  memset (spell, ' ', strlen (str) * 2);
  spell[strlen (str) * 2] = 0;
  for (i = 0; i < strlen (str); i++)
    spell[2 * i] = str[i];
  spell[2 * i] = 0;
  sbl_log ("%s ", spell);
}
char *prefilt (char *str)
{
  unsigned int i, first = 0, last = 0, cnt = 0;
  char ch = '\0';
  char *tmpstr = NULL;

  if (strlen (str) < 10)
    return str;
  tmpstr = (char *) malloc (sizeof (char) * (strlen (str) + 1));
  memset (tmpstr, 0, strlen (str));
  for (i = 0; i < strlen (str); i++)
   {
     if (str[i] != ch || (ch >= '0' && ch <= '9'))
      {
	if (cnt > 10)
	 {
	   strncat (tmpstr, str + first, last - first - cnt + 3);
	   first = last + 1;
	 }
	cnt = 0;
      }
     else
      {
	last = i;
	cnt++;
      }

     ch = str[i];

   }				/* for */

  strcat (tmpstr, str + first);
  memset (str, 0, strlen (tmpstr));
  strcpy (str, tmpstr);
  free (tmpstr);
  return str;

}
void spkpunctuation (int on)
{
  switch (spk_model)
   {
   case SPK_MBROLA:
     mbrola_punctuation (on);
     break;
   case SPK_FESTIVAL:
     festival_punctuation (on);
     break;
   case SPK_TTSYNTH:
     ttsynth_punctuation (on);
     break;
   case SPK_SPEECHD:
     speechd_punctuation (on);
   }
}

void spkclose ()
{

  switch (spk_model)
   {
   case SPK_MBROLA:
     mbrola_close ();
     break;
   case SPK_TTSYNTH:
     ttsynth_close ();
     ttsynth_close_lib ();
     break;

   case SPK_SPEECHD:
     speechd_close ();
     speechd_close_lib ();
     break;
   case SPK_FESTIVAL:
     festival_close ();
     break;
   }

}
