#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "brld.h"
#include "load_config.h"

static int confread (char *realname);
static char *confsearch (char *searchstring);

static char varvec[MAX_CONF_ENTRIES][MAX_ENTRY_LEN];

int getconf (brld_config * brldconf, char *filename)
{
  char str[MAX_ENTRY_LEN];

  if (!filename)
   {
     if (confread ("/etc/suse-blinux.conf"))
       return 1;
   }
  else if (confread (filename))
    return 1;

  confsearch (strcpy (brldconf->brlalias, "brlname"));

  confsearch (strcpy (brldconf->brlport, "brlport"));
  confsearch (strcpy (str, "brld_port"));
  if (atoi (str) > 0)
    brldconf->brld_port = atoi (str);
  else
    brldconf->brld_port = DEFAULT_BRLD_PORT;
  confsearch (strcpy (brldconf->brltbl, "brltbl"));
  confsearch (strcpy (brldconf->auth_key, "brld_auth_key"));
  if (!strlen (brldconf->auth_key)
      || strlen (brldconf->auth_key) > MAX_AUTH_KEY)
    strcpy (brldconf->auth_key, DEFAULT_AUTH_KEY);

  confsearch (strcpy (brldconf->progpath, "progpath"));

  return 0;
}

int confread (char *realname)
{
  FILE *pname;
  int i = 0;
  char row[MAX_ENTRY_LEN] = "";

  pname = fopen (realname, "r");
  if (pname == NULL)
    return 1;

  memset (varvec, 0, sizeof (varvec));
  while (!feof (pname))
   {
     fgets (row, 80, pname);
     if (row[0] != '#' && strlen (row) > 5)
      {
	strcpy (varvec[i], row);
	i++;
      }
     if (feof (pname))
       break;
   }
  fclose (pname);
  varvec[i][0] = 0;
  return 0;
}

char *confsearch (char *searchstring)
{
  int i = 0, end = 0;

  strcat (searchstring, "=\0");
  do
   {
     if (strncmp (varvec[i], searchstring, strlen (searchstring)) == 0)
      {
	strcpy (searchstring, varvec[i] + strlen (searchstring));
	end = 1;
      }
     i++;
   }
  while (varvec[i][0] != 0 && !end);

  if (!end)
   {
     searchstring[0] = 0;
     return searchstring;
   }

  if (strlen (searchstring))
    searchstring[strlen (searchstring) - 1] = 0;
  return searchstring;
}
