/*
 *  suse-blinux - Braille-display support for linux
 *  Author: Marco Skambraks <marco@suse.de>
 *  SuSE GmbH Nuernberg
 *
 *
 * suse-blinux based on brltty
 * special thanks to the Brltty-Team
 * Nicolas Pitre <nico@cam.org>
 * Stphane Doyon <s.doyon@videotron.ca>
 * Nikhil Nair <nn201@cus.cam.ac.uk>
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>

#define PATHLEN 200
char *getfdproc (char *sproc, int fgcon);

char *getfgproc (char *sproc, int fgcon)
{
  int i = 0;
  char str[100] = "", dev[50] = "";
  DIR *dirp;
  struct dirent *entry;
  int entvec[2000];

  dirp = opendir ("/proc");

  while ((entry = readdir (dirp)))
    if (atoi (entry->d_name))
     {
       entvec[i] = atoi (entry->d_name);
       i++;
     }

  closedir (dirp);

  sprintf (dev, "/dev/tty%i", fgcon);
  for (i -= 1; i > 1; i--)
   {
     char path[PATHLEN] = "";
     int cnt = 0;

     sprintf (path, "/proc/%i/fd/0", entvec[i]);
     cnt = readlink (path, str, 100);
     if (cnt < 0)
       str[0] = 0;
     else
       str[cnt] = 0;
     if (!strcmp (str, dev))
      {
	FILE *status;
	char name[50] = "", state[80] = "";

	sprintf (path, "/proc/%i/status", entvec[i]);
	if ((status = fopen (path, "r")) == NULL)
	 {
	   strcpy (sproc, "default");
	   return sproc;
	 }

	if (NULL == fgets (name, 50, status))
	  return strcpy (sproc, "default");
	if (NULL == fgets (state, 60, status))
	  return strcpy (sproc, "default");
	fclose (status);
	if (state[7] != 'T')
	 {
	   strcpy (sproc, name + 6);
	   sproc[strlen (sproc) - 1] = 0;
	   return sproc;
	 }
      }
     str[0] = 0;
   }
  strcpy (sproc, "default");
  return sproc;			/* normaly unreached */
}
