#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include "sbllog.h"
#include "ttsynthlib.h"
#include <unistd.h>

static void *ttsynth_lib = NULL;
static int cur_voice_tmp = 1;
static struct
{
  char name[TTSYNTH_MAX_LENGTH];
  int lang_val;
} ttsynth_languages[] =
{
  {
  "german", eciStandardGerman},
  {
  "us", eciGeneralAmericanEnglish},
  {
  "british", eciBritishEnglish},
  {
  "", 0}
};

static ECIHand ttsynth_eci = NULL;
void ttsynth_close ()
{
  if (!ttsynth_eci)
    return;
  eciStop (ttsynth_eci);
  eciDelete (ttsynth_eci);
  if (ttsynth_lib != NULL)
    dlclose (ttsynth_lib);
}
int ttsynth_init (char *cmd)
{
  int cmd_val = atoi (cmd);

  if (ttsynth_eci)
   {
     sbl_log ("ttysynth is already running\n");
     return 0;
   }

/*
ttsynth_lib=dlopen(IBMECI,RTLD_NOW | RTLD_GLOBAL);
if(ttsynth_lib==NULL)
{
sbl_log("ttsynth_init: ",dlerror());
return 1;
}
*/

  ttsynth_eci = eciNew ();
  if (ttsynth_eci)
   {
/* set output to dsp */
     eciSetOutputDevice (ttsynth_eci, 0);
     if (cmd_val > 1)
      {
	eciSetParam (ttsynth_eci, eciSizeDeviceBlocks, cmd_val);
	eciSetParam (ttsynth_eci, eciNumDeviceBlocks, 10);
	sbl_log ("ttsynth set blocksize=%d ", cmd_val);
      }

     eciSetParam (ttsynth_eci, eciSampleRate, 2);
     sbl_log ("ttsynth init param set ");
   }
  else
   {
     sbl_log ("cannot open ttsynth\n");
     return 1;
   }

  return 0;
}

void ttsynth_start ()
{
}

void ttsynth_say (char *spkstr)
{
  static char tmpbuf[4096];
  unsigned int i = 0, cnt = 0;

  if (ttsynth_eci == NULL)
    return;
  memset (tmpbuf, 0, sizeof (tmpbuf));
  for (i = 0; i < strlen (spkstr); i++)
   {
     if (spkstr[i] == ' ' && spkstr[i + 1] == ' ')
       continue;
     tmpbuf[cnt] = spkstr[i];
     cnt++;
   }

  tmpbuf[cnt] = '\n';

  switch (spkstr[0])
   {
   case 0:
     return;
   case '\n':
   case '\r':
   case ' ':
     if (spkstr[1] == 0)
       return;
     break;
   }
  sbl_log ("ttsay ");
  eciAddText (ttsynth_eci, tmpbuf);
  eciSynthesize (ttsynth_eci);
}

void ttsynth_param (char *param)
{
/* dummy */
  if (param)
    return;
}
void ttsynth_vol (char *vol)
{
  int vol_val = atoi (vol);

  if (vol_val < 1)
    return;

  eciSetVoiceParam (ttsynth_eci, 0, eciVolume, vol_val);
  sbl_log ("volume: %d ", vol_val);

}

void ttsynth_frq (char *frq)
{
  int frq_val = atoi (frq), cur_val;

  if (!ttsynth_eci)
    return;

  cur_val = eciGetVoiceParam (ttsynth_eci, cur_voice_tmp, eciPitchBaseline);

/* calculate new base from default base  and check range */
  frq_val += cur_val;
  if (frq_val < 1)
    frq_val = 1;
  else if (frq_val > 99)
    frq_val = 99;

  eciSetVoiceParam (ttsynth_eci, 0, eciPitchBaseline, frq_val);

}

void ttsynth_spd (char *spd)
{
  int spd_val = atoi (spd);

  if (spd_val < 1)
    return;
  eciSetVoiceParam (ttsynth_eci, 0, eciSpeed, spd_val);
}

void ttsynth_voice (char *voice)
{
  int voice_num = atoi (voice);

  if (!ttsynth_eci)
    return;

  if (voice_num < 1 || voice_num > ECI_PRESET_VOICES)
    return;

  eciCopyVoice (ttsynth_eci, voice_num, 0);
  cur_voice_tmp = voice_num;
}

void ttsynth_lang (char *lang)
{
  int i = 0;

  if (!ttsynth_eci)
    return;
  while (ttsynth_languages[i].name)
   {
     if (!strcmp (lang, ttsynth_languages[i].name))
      {
	int ret = 0;

	ret =
	  eciSetParam (ttsynth_eci, eciLanguageDialect,
		       ttsynth_languages[i].lang_val);
	sbl_log ("set lang %s %d\n", lang, ret);
	return;
      }
     i++;
   }

}

void ttsynth_spec (char *spec)
{
/* dummy */
  if (spec)
    return;

  if (!ttsynth_eci)
    return;
}

void ttsynth_stop ()
{

  if (!ttsynth_eci)
    return;
  if (eciSpeaking (ttsynth_eci))
    eciStop (ttsynth_eci);
}

void ttsynth_punctuation (int on)
{
  if (!ttsynth_eci)
    return;
//eciSetParam(ttsynth_eci,eciTextMode,on);
  if (on)
    return;
}
