<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: Hidden Service Configuration Instructions</title>
  <meta name="Author" content="The Tor Project, Inc.">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.ru">Главная</a>
<a href="../overview.html.ru">Обзор</a>
<a href="../easy-download.html.ru">Скачать</a>
<a href="../documentation.html.ru">Документация</a>
<a href="../volunteer.html">Добровольцы</a>
<a href="../people.html.ru">Люди</a>
<a href="https://blog.torproject.org/">Блог</a>
<a href="../donate.html.ru">Donate!</a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Настройка скрытых сервисов <a href="../index.html.ru">Tor</a></h1>
<hr>
<p>Tor позволяет клиентам и узлам предоставлять скрытые сервисы. Таким образом
Вы можете предоставлять доступ к веб-серверам, SSH-серверам, итд., без
разглашения своего IP-адреса пользователям. Также, так как Вы не используете
какие-либо внешние адреса, Вы можете запустить скрытый сервис за
брандмауэром (не имея внешнего IP-адреса).
</p>
<p>If you have Tor installed, you can see hidden services in action by visiting
<a href="http://duskgytldkxiuqc6.onion/">our example hidden service</a>.
</p>
<p>Данное руководство описывает порядок настройки вашего собственного скрытого
сервиса. Технические детали работы протокола скрытых сервисов описаны на
странице <a href="../hidden-services.html.ru">описания протокола скрытых
сервисов</a>.
</p>
<hr> <a id="zero"></a>
<h2><a class="anchor" href="#zero">Прежде всего: запуск Tor</a></h2>
<br>
<p>Перед началом убедитесь в следующем:</p>
<ol>
<li>Что Tor запущен,</li>
<li>Что Вы на самом деле настроили его корректно,</li>
</ol>
<p>Пользователи ОС Windows должны воспользоваться <a href="../docs/tor-doc-windows.html.ru">руководством для пользователей Windows</a>,
пользователи OS X должны воспользоваться <a href="../docs/tor-doc-osx.html.ru">руководством для OS X</a>, и пользователи Linux/BSD/Unix
должны воспользоваться <a href="../docs/tor-doc-unix.html.ru">руководством для
пользователей Unix</a>.
</p>
<p>Когда Вы уже установили и настроили Tor, вы сможете ознакомиться с
действующими скрытыми сервисами, доступными по адресам: <a
href="http://duskgytldkxiuqc6.onion/">пример скрытого сервиса</a> или <a
href="http://gaddbiwdftapglkq.onion/">скрытый сервер Wikileaks</a>. Загрузка
занимает обычно 10-60 секунд (или решение о недоступности сервера). Если
браузер немедленно выдаёт ошибку "www.duskgytldkxiuqc6.onion could not be
found, please check the name and try again", то значит, что у Вас
некорректно настроен Tor, ознакомьтесь с <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ItDoesntWork">частыми
вопросами</a> - возможно, это поможет.
</p>
<hr> <a id="one"></a>
<h2><a class="anchor" href="#one">Шаг 1: установка локального веб-сервера</a></h2>
<br>
<p>Прежде всего Вам следует установить локальный веб-сервер. Это может
оказаться сложной задачей, поэтому в данном руководстве будут рассмотрены
лишь базовые моменты. Если Вы запутались или хотите большего, попросите
кого-нибудь о помощи. Рекомендуется установить отдельный сервер для скрытого
сервиса, даже если у Вас уже есть один сервер, используемый для настоящего
сайта.
</p>
<p>Если Вы работаете из-под UNIX или OS X и работа с командной строкой не
доставляет Вам неудобств, лучшим началом будет установка <a
href="http://www.acme.com/software/thttpd/">thttpd</a>. Просто скачайте
самый свежий архив, распакуйте его (будет создана папка с файлами), и
запустите <kbd>./configure &amp;&amp; make</kbd>. Затем <kbd>mkdir hidserv;
cd hidserv</kbd>, и выполните <kbd>../thttpd -p 5222 -h
localhost</kbd>. Сервер вернёт ввод в командную строку, будет запущен сервер
на порту 5222. Вы можете поместить размещаемые файлы в каталог hidserv.
</p>
<p>Если Вы под Windows, Вы можете ознакомиться с <a
href="http://savant.sourceforge.net/">Savant</a> или <a
href="http://httpd.apache.org/">Apache</a>, проверьте, что сервер
прослушивает только localhost. Также Вам потребуется узнать, какой порт
прослушиает сервер - это Вам понадобится в дальнейшем.
</p>
<p>(причина для прослушивания только localhost - убедиться, что сервер не
является общедоступным. Если пользователи смогут получить доступ к серверу
напрямую, они смогут убедиться, что именно этот компьютер предоставляет
скрытый сервис.
</p>
<p>После запуска сервера убедитесь, что он работает корректно: откройте адрес
<a href="http://localhost:5222/">http://localhost:5222/</a> в Вашем
браузере, где 5222 - порт, на который настроен сервер. После этого
попробуйте запросить главную страницу, убедитесь, что она отображается
корректно.
</p>
<hr> <a id="two"></a>
<h2><a class="anchor" href="#two">Шаг 2: настройка скрытого сервиса</a></h2>
<br>
<p>Далее Вам потребуется настроить Ваш скрытый сервис на ваш локальный
веб-сервер.
</p>
<p>Откройте файл torrc в текстовом редакторе (см. <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#torrc">частые
вопросы о torrc</a>). Перейдите на среднюю секцию и найдите строчку</p>
<pre>
############### This section is just for location-hidden services ###
</pre>
<p>
Эта секция состоит из набора сгруппированных строк, каждая группа
соответствует одному скрытому сервису. На данный момент они все
закомментированы (строки, начинающиеся с #), соответственно, скрытые сервисы
неактивны. Каждая группа строк содержит строку <var>HiddenServiceDir</var> и
одну (или более) строку <var>HiddenServicePort</var>:</p>
<ul>
<li><var>HiddenServiceDir</var> - каталог, в котором Tor сохранит информацию о
скрытом сервисе. В частности, в данном каталоге Tor создаст файл с названием
<var>имя_сервера</var>, которое будет равно URL для Tor. Вручную добавлять
файлы в этот каталог не стоит.</li>
<li><var>HiddenServicePort</var> отвечает за назначение виртуального порта
(т.е. какой порт будет доступен для пользователей) IP-адресу и порту для
перенаправления соединений к запрошенному виртуальному порту.</li>
</ul>
<p>Добавьте следующие строки в torrc:
</p>
<pre>
HiddenServiceDir /Library/Tor/var/lib/tor/hidden_service/
HiddenServicePort 80 127.0.0.1:5222
</pre>
<p>Вам, возможно, понадобится изменить значение в строке
<var>HiddenServiceDir</var>, чтобы она указывала на реально существующую
папку, в которую разрешено чтение и запись для пользователя, от чьего имени
запускается Tor. Строку выше можно оставить, если Вы работаете на OS X. На
UNIX попробуйте "/home/имя_пользователя/hidserv/", где вместо
"имя_пользователя" наберите имя Вашего пользователя. В Windows Вы можете
использовать следующую строку:</p>
<pre>
HiddenServiceDir C:\Documents and Settings\username\Application Data\hidden_service\
HiddenServicePort 80 127.0.0.1:5222
</pre>
<p>Сохраните torrc и перезапустите Tor.
</p>
<p>Если Tor запустится - отлично. Если же нет - значит, где-то была ошибка. В
первую очередь просмотрите отчёты в лог-файлах. Там должны быть какие-то
предупреждения или сообщения об ошибках. Они должны Вам подсказать, в чём
проблема. Обычно это опечатки в torrc или некорректно настроенные разрешения
(см. <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">частые
вопросы об отчётах</a>, если Вы не знаете, где включить протоколирование
ошибок или найти отчёты).
</p>
<p>Tor при запуске автоматически (при необходимости) создаст каталог
<var>HiddenServiceDir</var> и создаст там два файла.</p>
<dl>
<dt><var>private_key</var></dt>
<dd>Сначала Tor создаст пару ключей (общий и личный) для вашего скрытого
сервиса. Ключ записывается в файл с названием "private_key". Не давайте этот
ключ никому и не публикуйте его нигде, иначе Вас смогут опознать и найти.</dd>
<dt><var>имя_узла</var></dt>
<dd>Следующий файл, который создаёт Tor, называется "hostname". Он содержит
отпечаток Вашего общего ключа, и имя будет у файла похоже на нечто вроде
<tt>duskgytldkxiuqc6.onion</tt>. Это общедоступное имя для Вашего узла, Вы
можете его сообщать другим, публиковать на вебсайтах, печатать на визитках
итд.</dd>
</dl>
<p>Если Tor запускается не от Вашего имени, например, на OS X, Debian или Red
hat, Вам возможно потребуются привилегии суперпользователя root для
просмотра этих файлов.</p>
<p>После перезапуска Tor сохраняет точки доступа в сеть и создаёт
<em>дескриптор скрытого сервиса</em>. Это подписанный список точек доступа,
объединённый с общим ключом Вашего сервиса. Tor анонимно публикует
дескриптор на сервера каталогов, и другие пользователи анонимно получают Ваш
дескриптор при попытке зайти на Ваш сервис.
</p>
<p>Попробуйте: вставьте содержимое файла hostname в адресную строку Вашего
браузера. Если сервис настроен корректно, Вы увидите html-страницу,
настроенную изначально. Если же Вы не увидите html-страницу, просмотрите
файлы отчётов, информация в них поможет Вам установить причину некорректной
работы сервиса.
</p>
<hr> <a id="three"></a>
<h2><a class="anchor" href="#three">Шаг 3: полезные советы</a></h2>
<br>
<p>Если Вы собираетесь поддерживать скрытый сервис в течение долгого времени,
возможно, Вам стоило бы где-нибудь сохранить резервную копию файла
<var>private_key</var>.
</p>
<p>Установка сервера Apache не была рекомендована в связи с тем, что: а) во
многих случая пользователи уже используют этот сервер как публичный, б)
сервер очень объёмный и в нём есть немало способов получить IP-адрес сервера
или другую конфиденциальную информацию, например, на страницах ошибок
наподобие генерируемой ошибки 404. Несмотря на это, пользователям с высокими
требованиями к функциональности веб-серер Apache может быть правильным
решением. Проект был бы благодарен за руководство по безопасности
использования сервера Apache в качестве сервера для скрытого
сервиса. Возможно, такие же проблемы есть у сервера Savant.
</p>
<p>Если Вы хотите направить несколько виртуальных портов на один скрытый
сервис, просто добавьте строку <var>HiddenServicePort</var> на каждый
виртуальный порт. Если же Вы хотите поддерживать несколько скрытых сервисов
на одном клиенте Tor, просто добавьте ещё одну строку
<var>HiddenServiceDir</var> на каждый сервис. Все строки
<var>HiddenServicePort</var> соответствуют строке
<var>HiddenServiceDir</var> выше, группа оканчивается на новой строке
<var>HiddenServiceDir</var>:
</p>
<pre>
HiddenServiceDir /usr/local/etc/tor/hidden_service/
HiddenServicePort 80 127.0.0.1:8080

HiddenServiceDir /usr/local/etc/tor/other_hidden_service/
HiddenServicePort 6667 127.0.0.1:6667
HiddenServicePort 22 127.0.0.1:22
</pre>
<p>Несколько моментов, о которых Вам стоит помнить в интересах Вашей
конфиденциальности:
</p>
<ul>
<li>Как было отмечено выше, будьте осторожны с возможностями сервера по
предоставлению информации о Вас, Вашем компьютере или о Вашем
местонахождении. Например, пользователи могут с некой вероятностью
установить, какое ПО используется в качестве веб-сервера (Apache, thttpd,
итд) и сделать какие-то выводы о Вашей операционной системе.</li>
<li>Если Ваш компьютер функционирует не круглосуточно, скрытый сервис также
функционировать не будет без компьютера. На этой информации можно также
сделать некие выводы, например, предположить часовой пояс.</li>
<!-- increased risks over time -->
</ul>
<hr>
<p>Если у Вас есть предложения по улучшению этого документа, пожалуйста, <a
href="../contact.html.ru">присылайте их нам</a>. Спасибо!</p>
  </div>
<!-- #main -->
</div>
<hr>
</div>
  <div class="bottom" id="bottom">
     <p>"Tor" и "Onion Logo" &mdash; <a href="../trademark-faq.html">зарегистрированные торговые
     марки</a> Tor Project, Inc.
     <br>
     Содержимое сайта защищенo по условиям лицензии
     <a href="http://creativecommons.org/licenses/by/3.0/us/">Creative Commons Attribution 3.0 United States License
 	   <!--img alt="Creative Commons Attribution 3.0 United States License" style="border-width:0" src="../images/cc-by-us-80x15.png"--></a>, если явно не указано другое.
     </p>
     <p>
      Внимание! Этот перевод устарел. Английский оригинал имеет ревизию
      22222 тогда как этот перевод основан на ревизии
      (unknown).
     </p>
     <p>
       Эта страница также переведена на следующие языки:
       <a href="tor-hidden-service.html.de">Deutsch</a>, <a href="tor-hidden-service.html.en">English</a>, <a href="tor-hidden-service.html.es">espa&ntilde;ol</a>, <a href="tor-hidden-service.html.fr">fran&ccedil;ais</a>, <a href="tor-hidden-service.html.it">Italiano</a>, <a href="tor-hidden-service.html.pl">polski</a>, <a href="tor-hidden-service.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Как установить <a href="http://www.debian.org/intro/cn#howtoset">язык документов по умолчанию</a>.
     </p>
   <p>Разработчики Tor не проверяли этот перевод на точность и корректность.
   Перевод может быть устаревшим или просто неправильным. Официальный веб-сайт
   Tor на английском языке доступен по адресу
   <a href="https://www.torproject.org/">https://www.torproject.org/</a>.
   </p>
   <p>
   <i><a href="../contact.html.ru" class="smalllink">Webmaster</a></i> -
    Последние изменения: Sun May 2 18:08:58 2010
    -
    Последняя компиляция: Sun May 2 18:44:04 2010
   </p>
  </div>
</body>
</html>
