/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 20:04:27 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.StringWriter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.System;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.GCSDWindowAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class GCSDWindowAlgorithm_ESTest extends GCSDWindowAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      float[] floatArray0 = new float[3];
      floatArray0[1] = (float) (-1442);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("}");
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getBases();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      gCSDWindowAlgorithm0.getDefaultStepSize(8262);
      gCSDWindowAlgorithm0.getDefaultWindowSize();
      gCSDWindowAlgorithm0.getMaximumInternal();
      FileSystemHandling.shouldAllThrowIOExceptions();
      gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getValues((-2077), 100, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      float[] floatArray0 = new float[4];
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Invalid IOCase name: ");
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      Bases bases1 = strand0.getBases();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases1);
      
      Strand strand1 = bases1.getReverseStrand();
      assertSame(bases0, bases1);
      assertSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertSame(strand1, strand0);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand1);
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand1);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(gCSDWindowAlgorithm0);
      
      Integer integer0 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertSame(strand1, strand0);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(5000, (int)integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer0);
      
      Integer integer1 = gCSDWindowAlgorithm0.getDefaultStepSize(8262);
      assertSame(bases0, bases1);
      assertSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertSame(strand1, strand0);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, (int)integer1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      Integer integer2 = gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertSame(bases0, bases1);
      assertSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertSame(strand1, strand0);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1000, (int)integer2);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer2);
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      
      bases0.clearCodonCache();
      assertSame(bases0, bases1);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      
      Float float0 = gCSDWindowAlgorithm0.getAverage();
      assertSame(bases0, bases1);
      assertSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertSame(strand1, strand0);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(float0);
      
      Float float1 = gCSDWindowAlgorithm0.getMaximumInternal();
      assertSame(bases0, bases1);
      assertSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertSame(strand1, strand0);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(100.0F, (float)float1, 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(float1);
      assertNotEquals((float)float1, (float)float0, 0.01F);
      
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      Integer integer3 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertSame(strand1, strand0);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(5000, (int)integer3);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer3);
      assertTrue(integer3.equals((Object)integer0));
      assertFalse(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)integer1));
      
      gCSDWindowAlgorithm0.getValues((-2077), 2, floatArray0);
      assertSame(bases0, bases1);
      assertSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertSame(strand1, strand0);
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(18, fastaStreamSequence0.getOtherCount());
      assertEquals(21, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getValues(2, (-5), floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -7
         //
         verifyException("uk.ac.sanger.artemis.plot.GCSDWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      float[] floatArray0 = new float[4];
      floatArray0[3] = (float) (-1464);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "");
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      Bases bases1 = strand0.getBases();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases1);
      
      Strand strand1 = bases1.getReverseStrand();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand1);
      assertFalse(strand1.equals((Object)strand0));
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand1);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(gCSDWindowAlgorithm0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer0 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(5000, (int)integer0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer1 = gCSDWindowAlgorithm0.getDefaultStepSize(0);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, (int)integer1);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer1);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer1.equals((Object)integer0));
      
      Integer integer2 = gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1000, (int)integer2);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer2);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      
      Float float0 = gCSDWindowAlgorithm0.getMaximumInternal();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(100.0F, (float)float0, 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(float0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      Integer integer3 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(5000, (int)integer3);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer3);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer3.equals((Object)integer2));
      assertTrue(integer3.equals((Object)integer0));
      assertFalse(integer3.equals((Object)integer1));
      
      gCSDWindowAlgorithm0.getValues(1, 100, floatArray0);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, (-1464.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Float float1 = gCSDWindowAlgorithm0.getAverage();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(Float.NaN, (float)float1, 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(float1);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertNotEquals((float)float1, (float)float0, 0.01F);
      
      Integer integer4 = gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1000, (int)integer4);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer4);
      assertFalse(integer4.equals((Object)integer3));
      assertFalse(integer4.equals((Object)integer0));
      assertTrue(integer4.equals((Object)integer2));
      assertFalse(integer4.equals((Object)integer1));
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      gCSDWindowAlgorithm0.getValues(2, 8929, floatArray0);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, (-1464.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer5 = gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1000, (int)integer5);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer5);
      assertTrue(integer5.equals((Object)integer2));
      assertFalse(integer5.equals((Object)integer3));
      assertFalse(integer5.equals((Object)integer0));
      assertTrue(integer5.equals((Object)integer4));
      assertFalse(integer5.equals((Object)integer1));
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      float[] floatArray0 = new float[4];
      floatArray0[3] = (float) (-1464);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "");
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      Bases bases1 = strand0.getBases();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases1);
      
      Strand strand1 = bases1.getReverseStrand();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand1);
      assertFalse(strand1.equals((Object)strand0));
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand1);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(gCSDWindowAlgorithm0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      StringWriter stringWriter0 = new StringWriter();
      assertEquals("", stringWriter0.toString());
      assertNotNull(stringWriter0);
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm1 = new GCSDWindowAlgorithm(strand1);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED;
      assertEquals(1, (int)integer0);
      assertNotNull(integer0);
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(gCSDWindowAlgorithm0);
      
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      float[] floatArray0 = new float[4];
      floatArray0[3] = (float) (-1464);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7;|B^f");
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      Bases bases1 = strand0.getBases();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases1);
      
      Strand strand1 = bases1.getReverseStrand();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand1);
      assertFalse(strand1.equals((Object)strand0));
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand1);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(gCSDWindowAlgorithm0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer0 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(5000, (int)integer0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer1 = gCSDWindowAlgorithm0.getDefaultStepSize(8262);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(1, (int)integer1);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer1);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer1.equals((Object)integer0));
      
      Integer integer2 = gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(1000, (int)integer2);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer2);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      
      Float float0 = gCSDWindowAlgorithm0.getMaximumInternal();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(100.0F, (float)float0, 0.01F);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(float0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      Integer integer3 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(5000, (int)integer3);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer3);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)integer1));
      assertTrue(integer3.equals((Object)integer0));
      
      gCSDWindowAlgorithm0.getValues((-2077), 100, floatArray0);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, (-1464.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getValues(2, (-5), floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gsslib");
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(5, genbankStreamSequence0.getOtherCount());
      assertNotNull(genbankStreamSequence0);
      
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(genbankStreamSequence0);
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(5, genbankStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(6, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getOtherCount());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(5, genbankStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(6, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getOtherCount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)115;
      byteArray0[1] = (byte) (-75);
      byteArray0[2] = (byte)67;
      byteArray0[3] = (byte)19;
      byteArray0[4] = (byte) (-54);
      byteArray0[5] = (byte) (-37);
      byteArray0[6] = (byte) (-77);
      byteArray0[7] = (byte)103;
      boolean boolean1 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertArrayEquals(new byte[] {(byte)115, (byte) (-75), (byte)67, (byte)19, (byte) (-54), (byte) (-37), (byte) (-77), (byte)103}, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(5, genbankStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(6, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand0);
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(5, genbankStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(6, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(gCSDWindowAlgorithm0);
      
      Float float0 = gCSDWindowAlgorithm0.getAverage();
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(5, genbankStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(6, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(16.666668F, (float)float0, 0.01F);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(float0);
      
      Float float1 = gCSDWindowAlgorithm0.getMaximumInternal();
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(5, genbankStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(6, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(100.0F, (float)float1, 0.01F);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(float1);
      assertNotEquals((float)float1, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      float[] floatArray0 = new float[4];
      floatArray0[3] = (float) (-1464);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand0);
      
      Bases bases1 = strand0.getBases();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases1);
      
      Strand strand1 = bases1.getReverseStrand();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand1);
      assertFalse(strand1.equals((Object)strand0));
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand1);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(gCSDWindowAlgorithm0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer0 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(5000, (int)integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer1 = gCSDWindowAlgorithm0.getDefaultStepSize(8262);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(1, (int)integer1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer1);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer1.equals((Object)integer0));
      
      Integer integer2 = gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(1000, (int)integer2);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer2);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      
      Float float0 = gCSDWindowAlgorithm0.getMaximumInternal();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(100.0F, (float)float0, 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(float0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      Integer integer3 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(5000, (int)integer3);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer3);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer3.equals((Object)integer1));
      assertTrue(integer3.equals((Object)integer0));
      assertFalse(integer3.equals((Object)integer2));
      
      gCSDWindowAlgorithm0.getValues((-2077), 100, floatArray0);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, (-1464.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getValues(2, (-5), floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      float[] floatArray0 = new float[4];
      floatArray0[3] = (float) (-1464);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      Bases bases1 = strand0.getBases();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases1);
      
      Strand strand1 = bases1.getReverseStrand();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand1);
      assertFalse(strand1.equals((Object)strand0));
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand1);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(gCSDWindowAlgorithm0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer0 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(5000, (int)integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer1 = gCSDWindowAlgorithm0.getDefaultStepSize((-5));
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, (int)integer1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer1);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer1.equals((Object)integer0));
      
      Integer integer2 = gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1000, (int)integer2);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer2);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      
      Float float0 = gCSDWindowAlgorithm0.getAverage();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(Float.NaN, (float)float0, 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(float0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      float[] floatArray0 = new float[4];
      floatArray0[3] = (float) (-1464);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      Bases bases1 = strand0.getBases();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases1);
      
      Strand strand1 = bases1.getReverseStrand();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand1);
      assertFalse(strand1.equals((Object)strand0));
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand1);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(gCSDWindowAlgorithm0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      int int0 = bases0.getRawPosition(8905, 24117248);
      assertSame(bases0, bases1);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals((-8904), int0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Integer integer0 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(5000, (int)integer0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer0.equals((Object)int0));
      
      Integer integer1 = gCSDWindowAlgorithm0.getDefaultStepSize(8262);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1, (int)integer1);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer1);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer1.equals((Object)int0));
      assertFalse(integer1.equals((Object)integer0));
      
      Integer integer2 = gCSDWindowAlgorithm0.getDefaultMinWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(100, (int)integer2);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer2);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)int0));
      assertFalse(integer2.equals((Object)integer0));
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      char[] charArray0 = new char[6];
      charArray0[0] = '-';
      charArray0[1] = '!';
      charArray0[2] = '9';
      charArray0[3] = 'd';
      charArray0[4] = 'T';
      charArray0[5] = ' ';
      PartialSequence partialSequence0 = new PartialSequence(charArray0, (-2003), (-2003), (Short) null, (Integer) null);
      assertArrayEquals(new char[] {'-', '!', '9', 'd', 'T', ' '}, charArray0);
      assertEquals(6, charArray0.length);
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertNull(partialSequence0.getPhase());
      assertNull(partialSequence0.getStrand());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((-2003), partialSequence0.length());
      assertNotNull(partialSequence0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertArrayEquals(new char[] {'-', '!', '9', 'd', 'T', ' '}, charArray0);
      assertEquals(6, charArray0.length);
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertNull(partialSequence0.getPhase());
      assertNull(partialSequence0.getStrand());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((-2003), partialSequence0.length());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertArrayEquals(new char[] {'-', '!', '9', 'd', 'T', ' '}, charArray0);
      assertEquals(6, charArray0.length);
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertNull(partialSequence0.getPhase());
      assertNull(partialSequence0.getStrand());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((-2003), partialSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand0);
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      assertArrayEquals(new char[] {'-', '!', '9', 'd', 'T', ' '}, charArray0);
      assertEquals(6, charArray0.length);
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertNull(partialSequence0.getPhase());
      assertNull(partialSequence0.getStrand());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((-2003), partialSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(gCSDWindowAlgorithm0);
      
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions((-564), 4986);
      assertArrayEquals(new char[] {'-', '!', '9', 'd', 'T', ' '}, charArray0);
      assertEquals(6, charArray0.length);
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertNull(partialSequence0.getPhase());
      assertNull(partialSequence0.getStrand());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((-2003), partialSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(markerRange0);
      
      Integer integer0 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertArrayEquals(new char[] {'-', '!', '9', 'd', 'T', ' '}, charArray0);
      assertEquals(6, charArray0.length);
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertNull(partialSequence0.getPhase());
      assertNull(partialSequence0.getStrand());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((-2003), partialSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(5000, (int)integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer0);
      
      Float float0 = gCSDWindowAlgorithm0.getMinimumInternal();
      assertArrayEquals(new char[] {'-', '!', '9', 'd', 'T', ' '}, charArray0);
      assertEquals(6, charArray0.length);
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertNull(partialSequence0.getPhase());
      assertNull(partialSequence0.getStrand());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((-2003), partialSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(float0);
      
      System.setCurrentTimeMillis(5);
      Float float1 = gCSDWindowAlgorithm0.getAverage();
      assertArrayEquals(new char[] {'-', '!', '9', 'd', 'T', ' '}, charArray0);
      assertEquals(6, charArray0.length);
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertNull(partialSequence0.getPhase());
      assertNull(partialSequence0.getStrand());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((-2003), partialSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(-0.0F, (float)float1, 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(float1);
      assertEquals((float)float1, (float)float0, 0.01F);
      
      Integer integer1 = gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertArrayEquals(new char[] {'-', '!', '9', 'd', 'T', ' '}, charArray0);
      assertEquals(6, charArray0.length);
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertNull(partialSequence0.getPhase());
      assertNull(partialSequence0.getStrand());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((-2003), partialSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1000, (int)integer1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(gCSDWindowAlgorithm0);
      
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED;
      assertEquals(1, (int)integer0);
      assertNotNull(integer0);
      
      Integer integer1 = gCSDWindowAlgorithm0.getDefaultStepSize(2);
      assertEquals(1, (int)integer1);
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer1);
      assertTrue(integer1.equals((Object)integer0));
      
      Integer integer2 = gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer2);
      assertEquals(1000, (int)integer2);
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      
      int int0 = gCSDWindowAlgorithm0.getValueCount();
      assertEquals(1, int0);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      float[] floatArray0 = new float[4];
      floatArray0[3] = (float) (-1464);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      Bases bases1 = strand0.getBases();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases1);
      
      Strand strand1 = bases1.getReverseStrand();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand1);
      assertFalse(strand1.equals((Object)strand0));
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand1);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(gCSDWindowAlgorithm0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer0 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(5000, (int)integer0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer1 = gCSDWindowAlgorithm0.getDefaultStepSize(8262);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, (int)integer1);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer1);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer1.equals((Object)integer0));
      
      Float float0 = gCSDWindowAlgorithm0.getMaximumInternal();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(100.0F, (float)float0, 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(float0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer2 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(5000, (int)integer2);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer2);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertTrue(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getValues(2, (-5), floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand0);
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(gCSDWindowAlgorithm0);
      
      Float float0 = gCSDWindowAlgorithm0.getMaximumInternal();
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(100.0F, (float)float0, 0.01F);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(float0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(bases0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(simpleEntryGroup0);
      
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(filteredEntryGroup0.hasUnsavedChanges());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(filteredEntryGroup0);
      
      Bases bases1 = filteredEntryGroup0.getBases();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(filteredEntryGroup0.hasUnsavedChanges());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases1);
      
      Strand strand0 = bases1.getForwardStrand();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(filteredEntryGroup0.hasUnsavedChanges());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(filteredEntryGroup0.hasUnsavedChanges());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(gCSDWindowAlgorithm0);
      
      int int0 = gCSDWindowAlgorithm0.getValueCount();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(filteredEntryGroup0.hasUnsavedChanges());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1, int0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand0);
      
      Bases bases1 = strand0.getBases();
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases1);
      
      Strand strand1 = bases1.getForwardStrand();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand1);
      assertFalse(strand1.equals((Object)strand0));
      
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand1);
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(gCSDWindowAlgorithm0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      int int0 = gCSDWindowAlgorithm0.getValueCount();
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, int0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      Integer integer0 = gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(5000, (int)integer0);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = null;
      try {
        gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      float[] floatArray0 = new float[4];
      floatArray0[3] = (float) (-1464);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("bBsZUoT=^N0\",V/q;j2");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Bases bases1 = strand0.getBases();
      Strand strand1 = bases1.getReverseStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand1);
      gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      gCSDWindowAlgorithm0.getDefaultStepSize(1);
      gCSDWindowAlgorithm0.getDefaultWindowSize();
      gCSDWindowAlgorithm0.getAverage();
      gCSDWindowAlgorithm0.getMaximumInternal();
      FileSystemHandling.shouldAllThrowIOExceptions();
      gCSDWindowAlgorithm0.getDefaultMaxWindowSize();
      gCSDWindowAlgorithm0.getValues((-5), 2, floatArray0);
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getValues(2, (-5), floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }
}
