(require "asdf")

(let ((asdf:*user-cache* (uiop:getenv "AUTOPKGTEST_TMP"))) ; Store FASL in some temporary dir
  #+(or ecl clisp) ; On those, it it necessary to manually load usocket
  (asdf:load-system "usocket")

  (asdf:load-system "cl-postgres")
  (asdf:load-system "s-sql")
  (asdf:load-system "postmodern")
  (asdf:load-system "simple-date")
  (asdf:load-system "simple-date/tests"))

;; Can't use ASDF:TEST-SYSTEM, its return value is meaningless
(let ((results (5am:run :simple-date)))
  (5am:explain! results)
  (unless (5am:results-status results)
    (uiop:quit 1)))

;; Can't run tests for other systems, they require a postgresql server running
