/*
 * Copyright (C) 2010 Ixonos Plc.
 * Copyright (C) 2011-2024 Philipp Spitzer, gregor herrmann, Stefan Stahl
 *
 * This file is part of ConfClerk.
 *
 * ConfClerk is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 2 of the License, or (at your option)
 * any later version.
 *
 * ConfClerk is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * ConfClerk.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef APPLICATION_H
#define APPLICATION_H

#include <QApplication>
#include "conference.h"

class Application : public QApplication
{
    Q_OBJECT

public:
    Application(int& argc, char** argv): QApplication(argc, argv) {}
    virtual ~Application() {}

    virtual bool notify(QObject* receiver, QEvent* event);

    void setActiveConference(Conference& conference) {mActiveConference = conference; mHasActiveConference = true;}
    void unsetActiveConference() {mHasActiveConference = false;}
    Conference& activeConference() {return mActiveConference;}
    bool hasActiveConference() const {return mHasActiveConference;}

private:
    bool mHasActiveConference = false;
    Conference mActiveConference;
};

#endif
