# Copyright 2017 Huawei Technologies Co.,LTD.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import os

import fixtures
from oslo_config import cfg
from oslo_policy import opts as policy_opts

from cyborg.common import authorize_wsgi as cyborg_policy


CONF = cfg.CONF

policy_data = """
{

}
"""


class PolicyFixture(fixtures.Fixture):
    def setUp(self):
        super(PolicyFixture, self).setUp()
        self.policy_dir = self.useFixture(fixtures.TempDir())
        self.policy_file_name = os.path.join(self.policy_dir.path,
                                             'policy.yaml')
        with open(self.policy_file_name, 'w') as policy_file:
            policy_file.write(policy_data)
        policy_opts.set_defaults(CONF)
        CONF.set_override('policy_file', self.policy_file_name, 'oslo_policy')
        cyborg_policy._ENFORCER = None
        # NOTE(yumeng): Logging all the deprecation warning for every unit
        # test will overflow the log files and leads to error. Suppress
        # the deprecation warning for tests only.
        cyborg_policy.init_enforcer(suppress_deprecation_warnings=True)
        self.addCleanup(cyborg_policy.get_enforcer().clear)
