// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package tests

import (
	"testing"

	"code.forgejo.org/f3/gof3/v3/kind"
	"code.forgejo.org/f3/gof3/v3/options"
	f3_tree "code.forgejo.org/f3/gof3/v3/tree/f3"
	tests_forge "code.forgejo.org/f3/gof3/v3/tree/tests/f3/forge"
)

type forgeTest struct {
	tests_forge.Base
}

func (o *forgeTest) NewOptions(t *testing.T) options.Interface {
	return newTestOptions(t, o.GetName())
}

func (o *forgeTest) GetNameExceptions() []string {
	return []string{
		tests_forge.ComplianceNameForkedPullRequest,
		tests_forge.ComplianceNameNoBranchPullRequest,
	}
}

func (o *forgeTest) GetKindExceptions() []kind.Kind {
	return []kind.Kind{
		f3_tree.KindAttachments,
		f3_tree.KindComments,
		f3_tree.KindIssues,
		f3_tree.KindLabels,
		f3_tree.KindMilestones,
		f3_tree.KindProjects,
		f3_tree.KindPullRequests,
		f3_tree.KindReactions,
		f3_tree.KindReleases,
		f3_tree.KindRepositories,
		f3_tree.KindReviews,
		f3_tree.KindReviewComments,
		f3_tree.KindTopics,
	}
}

func (o *forgeTest) GetNonTestUsers() []string {
	return []string{
		GetFixtureUsername(),
		"ghost",
	}
}

func newForgeTest(name string) tests_forge.Interface {
	t := &forgeTest{}
	t.SetName(name)
	return t
}
