// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"context"
	"database/sql"
	"fmt"
	"net"
	"net/http"
	"sync"
	"time"

	"github.com/facebook/ent/entc/integration/ent/role"
	"github.com/facebook/ent/entc/integration/ent/schema"
	"github.com/facebook/ent/entc/integration/gremlin/ent/card"
	"github.com/facebook/ent/entc/integration/gremlin/ent/comment"
	"github.com/facebook/ent/entc/integration/gremlin/ent/fieldtype"
	"github.com/facebook/ent/entc/integration/gremlin/ent/file"
	"github.com/facebook/ent/entc/integration/gremlin/ent/filetype"
	"github.com/facebook/ent/entc/integration/gremlin/ent/group"
	"github.com/facebook/ent/entc/integration/gremlin/ent/groupinfo"
	"github.com/facebook/ent/entc/integration/gremlin/ent/node"
	"github.com/facebook/ent/entc/integration/gremlin/ent/pet"
	"github.com/facebook/ent/entc/integration/gremlin/ent/predicate"
	"github.com/facebook/ent/entc/integration/gremlin/ent/spec"
	"github.com/facebook/ent/entc/integration/gremlin/ent/task"
	"github.com/facebook/ent/entc/integration/gremlin/ent/user"
	"github.com/google/uuid"

	"github.com/facebook/ent"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeCard      = "Card"
	TypeComment   = "Comment"
	TypeFieldType = "FieldType"
	TypeFile      = "File"
	TypeFileType  = "FileType"
	TypeGoods     = "Goods"
	TypeGroup     = "Group"
	TypeGroupInfo = "GroupInfo"
	TypeItem      = "Item"
	TypeNode      = "Node"
	TypePet       = "Pet"
	TypeSpec      = "Spec"
	TypeTask      = "Task"
	TypeUser      = "User"
)

// CardMutation represents an operation that mutates the Card nodes in the graph.
type CardMutation struct {
	config
	op            Op
	typ           string
	id            *string
	create_time   *time.Time
	update_time   *time.Time
	number        *string
	name          *string
	clearedFields map[string]struct{}
	owner         *string
	clearedowner  bool
	spec          map[string]struct{}
	removedspec   map[string]struct{}
	clearedspec   bool
	done          bool
	oldValue      func(context.Context) (*Card, error)
	predicates    []predicate.Card
}

var _ ent.Mutation = (*CardMutation)(nil)

// cardOption allows management of the mutation configuration using functional options.
type cardOption func(*CardMutation)

// newCardMutation creates new mutation for the Card entity.
func newCardMutation(c config, op Op, opts ...cardOption) *CardMutation {
	m := &CardMutation{
		config:        c,
		op:            op,
		typ:           TypeCard,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withCardID sets the ID field of the mutation.
func withCardID(id string) cardOption {
	return func(m *CardMutation) {
		var (
			err   error
			once  sync.Once
			value *Card
		)
		m.oldValue = func(ctx context.Context) (*Card, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Card.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withCard sets the old Card of the mutation.
func withCard(node *Card) cardOption {
	return func(m *CardMutation) {
		m.oldValue = func(context.Context) (*Card, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m CardMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m CardMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *CardMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetCreateTime sets the "create_time" field.
func (m *CardMutation) SetCreateTime(t time.Time) {
	m.create_time = &t
}

// CreateTime returns the value of the "create_time" field in the mutation.
func (m *CardMutation) CreateTime() (r time.Time, exists bool) {
	v := m.create_time
	if v == nil {
		return
	}
	return *v, true
}

// OldCreateTime returns the old "create_time" field's value of the Card entity.
// If the Card object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CardMutation) OldCreateTime(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldCreateTime is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldCreateTime requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreateTime: %w", err)
	}
	return oldValue.CreateTime, nil
}

// ResetCreateTime resets all changes to the "create_time" field.
func (m *CardMutation) ResetCreateTime() {
	m.create_time = nil
}

// SetUpdateTime sets the "update_time" field.
func (m *CardMutation) SetUpdateTime(t time.Time) {
	m.update_time = &t
}

// UpdateTime returns the value of the "update_time" field in the mutation.
func (m *CardMutation) UpdateTime() (r time.Time, exists bool) {
	v := m.update_time
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdateTime returns the old "update_time" field's value of the Card entity.
// If the Card object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CardMutation) OldUpdateTime(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUpdateTime is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUpdateTime requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdateTime: %w", err)
	}
	return oldValue.UpdateTime, nil
}

// ResetUpdateTime resets all changes to the "update_time" field.
func (m *CardMutation) ResetUpdateTime() {
	m.update_time = nil
}

// SetNumber sets the "number" field.
func (m *CardMutation) SetNumber(s string) {
	m.number = &s
}

// Number returns the value of the "number" field in the mutation.
func (m *CardMutation) Number() (r string, exists bool) {
	v := m.number
	if v == nil {
		return
	}
	return *v, true
}

// OldNumber returns the old "number" field's value of the Card entity.
// If the Card object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CardMutation) OldNumber(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNumber is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNumber requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNumber: %w", err)
	}
	return oldValue.Number, nil
}

// ResetNumber resets all changes to the "number" field.
func (m *CardMutation) ResetNumber() {
	m.number = nil
}

// SetName sets the "name" field.
func (m *CardMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *CardMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Card entity.
// If the Card object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CardMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ClearName clears the value of the "name" field.
func (m *CardMutation) ClearName() {
	m.name = nil
	m.clearedFields[card.FieldName] = struct{}{}
}

// NameCleared returns if the "name" field was cleared in this mutation.
func (m *CardMutation) NameCleared() bool {
	_, ok := m.clearedFields[card.FieldName]
	return ok
}

// ResetName resets all changes to the "name" field.
func (m *CardMutation) ResetName() {
	m.name = nil
	delete(m.clearedFields, card.FieldName)
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *CardMutation) SetOwnerID(id string) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *CardMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared returns if the "owner" edge to the User entity was cleared.
func (m *CardMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *CardMutation) OwnerID() (id string, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *CardMutation) OwnerIDs() (ids []string) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *CardMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// AddSpecIDs adds the "spec" edge to the Spec entity by ids.
func (m *CardMutation) AddSpecIDs(ids ...string) {
	if m.spec == nil {
		m.spec = make(map[string]struct{})
	}
	for i := range ids {
		m.spec[ids[i]] = struct{}{}
	}
}

// ClearSpec clears the "spec" edge to the Spec entity.
func (m *CardMutation) ClearSpec() {
	m.clearedspec = true
}

// SpecCleared returns if the "spec" edge to the Spec entity was cleared.
func (m *CardMutation) SpecCleared() bool {
	return m.clearedspec
}

// RemoveSpecIDs removes the "spec" edge to the Spec entity by IDs.
func (m *CardMutation) RemoveSpecIDs(ids ...string) {
	if m.removedspec == nil {
		m.removedspec = make(map[string]struct{})
	}
	for i := range ids {
		m.removedspec[ids[i]] = struct{}{}
	}
}

// RemovedSpec returns the removed IDs of the "spec" edge to the Spec entity.
func (m *CardMutation) RemovedSpecIDs() (ids []string) {
	for id := range m.removedspec {
		ids = append(ids, id)
	}
	return
}

// SpecIDs returns the "spec" edge IDs in the mutation.
func (m *CardMutation) SpecIDs() (ids []string) {
	for id := range m.spec {
		ids = append(ids, id)
	}
	return
}

// ResetSpec resets all changes to the "spec" edge.
func (m *CardMutation) ResetSpec() {
	m.spec = nil
	m.clearedspec = false
	m.removedspec = nil
}

// Op returns the operation name.
func (m *CardMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Card).
func (m *CardMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *CardMutation) Fields() []string {
	fields := make([]string, 0, 4)
	if m.create_time != nil {
		fields = append(fields, card.FieldCreateTime)
	}
	if m.update_time != nil {
		fields = append(fields, card.FieldUpdateTime)
	}
	if m.number != nil {
		fields = append(fields, card.FieldNumber)
	}
	if m.name != nil {
		fields = append(fields, card.FieldName)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *CardMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case card.FieldCreateTime:
		return m.CreateTime()
	case card.FieldUpdateTime:
		return m.UpdateTime()
	case card.FieldNumber:
		return m.Number()
	case card.FieldName:
		return m.Name()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *CardMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case card.FieldCreateTime:
		return m.OldCreateTime(ctx)
	case card.FieldUpdateTime:
		return m.OldUpdateTime(ctx)
	case card.FieldNumber:
		return m.OldNumber(ctx)
	case card.FieldName:
		return m.OldName(ctx)
	}
	return nil, fmt.Errorf("unknown Card field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CardMutation) SetField(name string, value ent.Value) error {
	switch name {
	case card.FieldCreateTime:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreateTime(v)
		return nil
	case card.FieldUpdateTime:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdateTime(v)
		return nil
	case card.FieldNumber:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNumber(v)
		return nil
	case card.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	}
	return fmt.Errorf("unknown Card field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *CardMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *CardMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CardMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Card numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *CardMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(card.FieldName) {
		fields = append(fields, card.FieldName)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *CardMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *CardMutation) ClearField(name string) error {
	switch name {
	case card.FieldName:
		m.ClearName()
		return nil
	}
	return fmt.Errorf("unknown Card nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *CardMutation) ResetField(name string) error {
	switch name {
	case card.FieldCreateTime:
		m.ResetCreateTime()
		return nil
	case card.FieldUpdateTime:
		m.ResetUpdateTime()
		return nil
	case card.FieldNumber:
		m.ResetNumber()
		return nil
	case card.FieldName:
		m.ResetName()
		return nil
	}
	return fmt.Errorf("unknown Card field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *CardMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.owner != nil {
		edges = append(edges, card.EdgeOwner)
	}
	if m.spec != nil {
		edges = append(edges, card.EdgeSpec)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *CardMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case card.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	case card.EdgeSpec:
		ids := make([]ent.Value, 0, len(m.spec))
		for id := range m.spec {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *CardMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedspec != nil {
		edges = append(edges, card.EdgeSpec)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *CardMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case card.EdgeSpec:
		ids := make([]ent.Value, 0, len(m.removedspec))
		for id := range m.removedspec {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *CardMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedowner {
		edges = append(edges, card.EdgeOwner)
	}
	if m.clearedspec {
		edges = append(edges, card.EdgeSpec)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *CardMutation) EdgeCleared(name string) bool {
	switch name {
	case card.EdgeOwner:
		return m.clearedowner
	case card.EdgeSpec:
		return m.clearedspec
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *CardMutation) ClearEdge(name string) error {
	switch name {
	case card.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Card unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *CardMutation) ResetEdge(name string) error {
	switch name {
	case card.EdgeOwner:
		m.ResetOwner()
		return nil
	case card.EdgeSpec:
		m.ResetSpec()
		return nil
	}
	return fmt.Errorf("unknown Card edge %s", name)
}

// CommentMutation represents an operation that mutates the Comment nodes in the graph.
type CommentMutation struct {
	config
	op              Op
	typ             string
	id              *string
	unique_int      *int
	addunique_int   *int
	unique_float    *float64
	addunique_float *float64
	nillable_int    *int
	addnillable_int *int
	clearedFields   map[string]struct{}
	done            bool
	oldValue        func(context.Context) (*Comment, error)
	predicates      []predicate.Comment
}

var _ ent.Mutation = (*CommentMutation)(nil)

// commentOption allows management of the mutation configuration using functional options.
type commentOption func(*CommentMutation)

// newCommentMutation creates new mutation for the Comment entity.
func newCommentMutation(c config, op Op, opts ...commentOption) *CommentMutation {
	m := &CommentMutation{
		config:        c,
		op:            op,
		typ:           TypeComment,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withCommentID sets the ID field of the mutation.
func withCommentID(id string) commentOption {
	return func(m *CommentMutation) {
		var (
			err   error
			once  sync.Once
			value *Comment
		)
		m.oldValue = func(ctx context.Context) (*Comment, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Comment.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withComment sets the old Comment of the mutation.
func withComment(node *Comment) commentOption {
	return func(m *CommentMutation) {
		m.oldValue = func(context.Context) (*Comment, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m CommentMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m CommentMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *CommentMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetUniqueInt sets the "unique_int" field.
func (m *CommentMutation) SetUniqueInt(i int) {
	m.unique_int = &i
	m.addunique_int = nil
}

// UniqueInt returns the value of the "unique_int" field in the mutation.
func (m *CommentMutation) UniqueInt() (r int, exists bool) {
	v := m.unique_int
	if v == nil {
		return
	}
	return *v, true
}

// OldUniqueInt returns the old "unique_int" field's value of the Comment entity.
// If the Comment object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CommentMutation) OldUniqueInt(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUniqueInt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUniqueInt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUniqueInt: %w", err)
	}
	return oldValue.UniqueInt, nil
}

// AddUniqueInt adds i to the "unique_int" field.
func (m *CommentMutation) AddUniqueInt(i int) {
	if m.addunique_int != nil {
		*m.addunique_int += i
	} else {
		m.addunique_int = &i
	}
}

// AddedUniqueInt returns the value that was added to the "unique_int" field in this mutation.
func (m *CommentMutation) AddedUniqueInt() (r int, exists bool) {
	v := m.addunique_int
	if v == nil {
		return
	}
	return *v, true
}

// ResetUniqueInt resets all changes to the "unique_int" field.
func (m *CommentMutation) ResetUniqueInt() {
	m.unique_int = nil
	m.addunique_int = nil
}

// SetUniqueFloat sets the "unique_float" field.
func (m *CommentMutation) SetUniqueFloat(f float64) {
	m.unique_float = &f
	m.addunique_float = nil
}

// UniqueFloat returns the value of the "unique_float" field in the mutation.
func (m *CommentMutation) UniqueFloat() (r float64, exists bool) {
	v := m.unique_float
	if v == nil {
		return
	}
	return *v, true
}

// OldUniqueFloat returns the old "unique_float" field's value of the Comment entity.
// If the Comment object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CommentMutation) OldUniqueFloat(ctx context.Context) (v float64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUniqueFloat is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUniqueFloat requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUniqueFloat: %w", err)
	}
	return oldValue.UniqueFloat, nil
}

// AddUniqueFloat adds f to the "unique_float" field.
func (m *CommentMutation) AddUniqueFloat(f float64) {
	if m.addunique_float != nil {
		*m.addunique_float += f
	} else {
		m.addunique_float = &f
	}
}

// AddedUniqueFloat returns the value that was added to the "unique_float" field in this mutation.
func (m *CommentMutation) AddedUniqueFloat() (r float64, exists bool) {
	v := m.addunique_float
	if v == nil {
		return
	}
	return *v, true
}

// ResetUniqueFloat resets all changes to the "unique_float" field.
func (m *CommentMutation) ResetUniqueFloat() {
	m.unique_float = nil
	m.addunique_float = nil
}

// SetNillableInt sets the "nillable_int" field.
func (m *CommentMutation) SetNillableInt(i int) {
	m.nillable_int = &i
	m.addnillable_int = nil
}

// NillableInt returns the value of the "nillable_int" field in the mutation.
func (m *CommentMutation) NillableInt() (r int, exists bool) {
	v := m.nillable_int
	if v == nil {
		return
	}
	return *v, true
}

// OldNillableInt returns the old "nillable_int" field's value of the Comment entity.
// If the Comment object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CommentMutation) OldNillableInt(ctx context.Context) (v *int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNillableInt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNillableInt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNillableInt: %w", err)
	}
	return oldValue.NillableInt, nil
}

// AddNillableInt adds i to the "nillable_int" field.
func (m *CommentMutation) AddNillableInt(i int) {
	if m.addnillable_int != nil {
		*m.addnillable_int += i
	} else {
		m.addnillable_int = &i
	}
}

// AddedNillableInt returns the value that was added to the "nillable_int" field in this mutation.
func (m *CommentMutation) AddedNillableInt() (r int, exists bool) {
	v := m.addnillable_int
	if v == nil {
		return
	}
	return *v, true
}

// ClearNillableInt clears the value of the "nillable_int" field.
func (m *CommentMutation) ClearNillableInt() {
	m.nillable_int = nil
	m.addnillable_int = nil
	m.clearedFields[comment.FieldNillableInt] = struct{}{}
}

// NillableIntCleared returns if the "nillable_int" field was cleared in this mutation.
func (m *CommentMutation) NillableIntCleared() bool {
	_, ok := m.clearedFields[comment.FieldNillableInt]
	return ok
}

// ResetNillableInt resets all changes to the "nillable_int" field.
func (m *CommentMutation) ResetNillableInt() {
	m.nillable_int = nil
	m.addnillable_int = nil
	delete(m.clearedFields, comment.FieldNillableInt)
}

// Op returns the operation name.
func (m *CommentMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Comment).
func (m *CommentMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *CommentMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m.unique_int != nil {
		fields = append(fields, comment.FieldUniqueInt)
	}
	if m.unique_float != nil {
		fields = append(fields, comment.FieldUniqueFloat)
	}
	if m.nillable_int != nil {
		fields = append(fields, comment.FieldNillableInt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *CommentMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case comment.FieldUniqueInt:
		return m.UniqueInt()
	case comment.FieldUniqueFloat:
		return m.UniqueFloat()
	case comment.FieldNillableInt:
		return m.NillableInt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *CommentMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case comment.FieldUniqueInt:
		return m.OldUniqueInt(ctx)
	case comment.FieldUniqueFloat:
		return m.OldUniqueFloat(ctx)
	case comment.FieldNillableInt:
		return m.OldNillableInt(ctx)
	}
	return nil, fmt.Errorf("unknown Comment field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CommentMutation) SetField(name string, value ent.Value) error {
	switch name {
	case comment.FieldUniqueInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUniqueInt(v)
		return nil
	case comment.FieldUniqueFloat:
		v, ok := value.(float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUniqueFloat(v)
		return nil
	case comment.FieldNillableInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNillableInt(v)
		return nil
	}
	return fmt.Errorf("unknown Comment field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *CommentMutation) AddedFields() []string {
	var fields []string
	if m.addunique_int != nil {
		fields = append(fields, comment.FieldUniqueInt)
	}
	if m.addunique_float != nil {
		fields = append(fields, comment.FieldUniqueFloat)
	}
	if m.addnillable_int != nil {
		fields = append(fields, comment.FieldNillableInt)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *CommentMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case comment.FieldUniqueInt:
		return m.AddedUniqueInt()
	case comment.FieldUniqueFloat:
		return m.AddedUniqueFloat()
	case comment.FieldNillableInt:
		return m.AddedNillableInt()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CommentMutation) AddField(name string, value ent.Value) error {
	switch name {
	case comment.FieldUniqueInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddUniqueInt(v)
		return nil
	case comment.FieldUniqueFloat:
		v, ok := value.(float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddUniqueFloat(v)
		return nil
	case comment.FieldNillableInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddNillableInt(v)
		return nil
	}
	return fmt.Errorf("unknown Comment numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *CommentMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(comment.FieldNillableInt) {
		fields = append(fields, comment.FieldNillableInt)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *CommentMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *CommentMutation) ClearField(name string) error {
	switch name {
	case comment.FieldNillableInt:
		m.ClearNillableInt()
		return nil
	}
	return fmt.Errorf("unknown Comment nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *CommentMutation) ResetField(name string) error {
	switch name {
	case comment.FieldUniqueInt:
		m.ResetUniqueInt()
		return nil
	case comment.FieldUniqueFloat:
		m.ResetUniqueFloat()
		return nil
	case comment.FieldNillableInt:
		m.ResetNillableInt()
		return nil
	}
	return fmt.Errorf("unknown Comment field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *CommentMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *CommentMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *CommentMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *CommentMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *CommentMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *CommentMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *CommentMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Comment unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *CommentMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Comment edge %s", name)
}

// FieldTypeMutation represents an operation that mutates the FieldType nodes in the graph.
type FieldTypeMutation struct {
	config
	op                         Op
	typ                        string
	id                         *string
	int                        *int
	addint                     *int
	int8                       *int8
	addint8                    *int8
	int16                      *int16
	addint16                   *int16
	int32                      *int32
	addint32                   *int32
	int64                      *int64
	addint64                   *int64
	optional_int               *int
	addoptional_int            *int
	optional_int8              *int8
	addoptional_int8           *int8
	optional_int16             *int16
	addoptional_int16          *int16
	optional_int32             *int32
	addoptional_int32          *int32
	optional_int64             *int64
	addoptional_int64          *int64
	nillable_int               *int
	addnillable_int            *int
	nillable_int8              *int8
	addnillable_int8           *int8
	nillable_int16             *int16
	addnillable_int16          *int16
	nillable_int32             *int32
	addnillable_int32          *int32
	nillable_int64             *int64
	addnillable_int64          *int64
	validate_optional_int32    *int32
	addvalidate_optional_int32 *int32
	optional_uint              *uint
	addoptional_uint           *uint
	optional_uint8             *uint8
	addoptional_uint8          *uint8
	optional_uint16            *uint16
	addoptional_uint16         *uint16
	optional_uint32            *uint32
	addoptional_uint32         *uint32
	optional_uint64            *uint64
	addoptional_uint64         *uint64
	state                      *fieldtype.State
	optional_float             *float64
	addoptional_float          *float64
	optional_float32           *float32
	addoptional_float32        *float32
	datetime                   *time.Time
	decimal                    *float64
	adddecimal                 *float64
	dir                        *http.Dir
	ndir                       *http.Dir
	str                        *sql.NullString
	null_str                   *sql.NullString
	link                       *schema.Link
	null_link                  *schema.Link
	active                     *schema.Status
	null_active                *schema.Status
	deleted                    *sql.NullBool
	deleted_at                 *sql.NullTime
	ip                         *net.IP
	null_int64                 *sql.NullInt64
	schema_int                 *schema.Int
	addschema_int              *schema.Int
	schema_int8                *schema.Int8
	addschema_int8             *schema.Int8
	schema_int64               *schema.Int64
	addschema_int64            *schema.Int64
	schema_float               *schema.Float64
	addschema_float            *schema.Float64
	schema_float32             *schema.Float32
	addschema_float32          *schema.Float32
	null_float                 *sql.NullFloat64
	role                       *role.Role
	mac                        *schema.MAC
	uuid                       *uuid.UUID
	clearedFields              map[string]struct{}
	done                       bool
	oldValue                   func(context.Context) (*FieldType, error)
	predicates                 []predicate.FieldType
}

var _ ent.Mutation = (*FieldTypeMutation)(nil)

// fieldtypeOption allows management of the mutation configuration using functional options.
type fieldtypeOption func(*FieldTypeMutation)

// newFieldTypeMutation creates new mutation for the FieldType entity.
func newFieldTypeMutation(c config, op Op, opts ...fieldtypeOption) *FieldTypeMutation {
	m := &FieldTypeMutation{
		config:        c,
		op:            op,
		typ:           TypeFieldType,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withFieldTypeID sets the ID field of the mutation.
func withFieldTypeID(id string) fieldtypeOption {
	return func(m *FieldTypeMutation) {
		var (
			err   error
			once  sync.Once
			value *FieldType
		)
		m.oldValue = func(ctx context.Context) (*FieldType, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().FieldType.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withFieldType sets the old FieldType of the mutation.
func withFieldType(node *FieldType) fieldtypeOption {
	return func(m *FieldTypeMutation) {
		m.oldValue = func(context.Context) (*FieldType, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m FieldTypeMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m FieldTypeMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *FieldTypeMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetInt sets the "int" field.
func (m *FieldTypeMutation) SetInt(i int) {
	m.int = &i
	m.addint = nil
}

// Int returns the value of the "int" field in the mutation.
func (m *FieldTypeMutation) Int() (r int, exists bool) {
	v := m.int
	if v == nil {
		return
	}
	return *v, true
}

// OldInt returns the old "int" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldInt(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldInt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldInt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInt: %w", err)
	}
	return oldValue.Int, nil
}

// AddInt adds i to the "int" field.
func (m *FieldTypeMutation) AddInt(i int) {
	if m.addint != nil {
		*m.addint += i
	} else {
		m.addint = &i
	}
}

// AddedInt returns the value that was added to the "int" field in this mutation.
func (m *FieldTypeMutation) AddedInt() (r int, exists bool) {
	v := m.addint
	if v == nil {
		return
	}
	return *v, true
}

// ResetInt resets all changes to the "int" field.
func (m *FieldTypeMutation) ResetInt() {
	m.int = nil
	m.addint = nil
}

// SetInt8 sets the "int8" field.
func (m *FieldTypeMutation) SetInt8(i int8) {
	m.int8 = &i
	m.addint8 = nil
}

// Int8 returns the value of the "int8" field in the mutation.
func (m *FieldTypeMutation) Int8() (r int8, exists bool) {
	v := m.int8
	if v == nil {
		return
	}
	return *v, true
}

// OldInt8 returns the old "int8" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldInt8(ctx context.Context) (v int8, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldInt8 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldInt8 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInt8: %w", err)
	}
	return oldValue.Int8, nil
}

// AddInt8 adds i to the "int8" field.
func (m *FieldTypeMutation) AddInt8(i int8) {
	if m.addint8 != nil {
		*m.addint8 += i
	} else {
		m.addint8 = &i
	}
}

// AddedInt8 returns the value that was added to the "int8" field in this mutation.
func (m *FieldTypeMutation) AddedInt8() (r int8, exists bool) {
	v := m.addint8
	if v == nil {
		return
	}
	return *v, true
}

// ResetInt8 resets all changes to the "int8" field.
func (m *FieldTypeMutation) ResetInt8() {
	m.int8 = nil
	m.addint8 = nil
}

// SetInt16 sets the "int16" field.
func (m *FieldTypeMutation) SetInt16(i int16) {
	m.int16 = &i
	m.addint16 = nil
}

// Int16 returns the value of the "int16" field in the mutation.
func (m *FieldTypeMutation) Int16() (r int16, exists bool) {
	v := m.int16
	if v == nil {
		return
	}
	return *v, true
}

// OldInt16 returns the old "int16" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldInt16(ctx context.Context) (v int16, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldInt16 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldInt16 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInt16: %w", err)
	}
	return oldValue.Int16, nil
}

// AddInt16 adds i to the "int16" field.
func (m *FieldTypeMutation) AddInt16(i int16) {
	if m.addint16 != nil {
		*m.addint16 += i
	} else {
		m.addint16 = &i
	}
}

// AddedInt16 returns the value that was added to the "int16" field in this mutation.
func (m *FieldTypeMutation) AddedInt16() (r int16, exists bool) {
	v := m.addint16
	if v == nil {
		return
	}
	return *v, true
}

// ResetInt16 resets all changes to the "int16" field.
func (m *FieldTypeMutation) ResetInt16() {
	m.int16 = nil
	m.addint16 = nil
}

// SetInt32 sets the "int32" field.
func (m *FieldTypeMutation) SetInt32(i int32) {
	m.int32 = &i
	m.addint32 = nil
}

// Int32 returns the value of the "int32" field in the mutation.
func (m *FieldTypeMutation) Int32() (r int32, exists bool) {
	v := m.int32
	if v == nil {
		return
	}
	return *v, true
}

// OldInt32 returns the old "int32" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldInt32(ctx context.Context) (v int32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldInt32 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldInt32 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInt32: %w", err)
	}
	return oldValue.Int32, nil
}

// AddInt32 adds i to the "int32" field.
func (m *FieldTypeMutation) AddInt32(i int32) {
	if m.addint32 != nil {
		*m.addint32 += i
	} else {
		m.addint32 = &i
	}
}

// AddedInt32 returns the value that was added to the "int32" field in this mutation.
func (m *FieldTypeMutation) AddedInt32() (r int32, exists bool) {
	v := m.addint32
	if v == nil {
		return
	}
	return *v, true
}

// ResetInt32 resets all changes to the "int32" field.
func (m *FieldTypeMutation) ResetInt32() {
	m.int32 = nil
	m.addint32 = nil
}

// SetInt64 sets the "int64" field.
func (m *FieldTypeMutation) SetInt64(i int64) {
	m.int64 = &i
	m.addint64 = nil
}

// Int64 returns the value of the "int64" field in the mutation.
func (m *FieldTypeMutation) Int64() (r int64, exists bool) {
	v := m.int64
	if v == nil {
		return
	}
	return *v, true
}

// OldInt64 returns the old "int64" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldInt64(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldInt64 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldInt64 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInt64: %w", err)
	}
	return oldValue.Int64, nil
}

// AddInt64 adds i to the "int64" field.
func (m *FieldTypeMutation) AddInt64(i int64) {
	if m.addint64 != nil {
		*m.addint64 += i
	} else {
		m.addint64 = &i
	}
}

// AddedInt64 returns the value that was added to the "int64" field in this mutation.
func (m *FieldTypeMutation) AddedInt64() (r int64, exists bool) {
	v := m.addint64
	if v == nil {
		return
	}
	return *v, true
}

// ResetInt64 resets all changes to the "int64" field.
func (m *FieldTypeMutation) ResetInt64() {
	m.int64 = nil
	m.addint64 = nil
}

// SetOptionalInt sets the "optional_int" field.
func (m *FieldTypeMutation) SetOptionalInt(i int) {
	m.optional_int = &i
	m.addoptional_int = nil
}

// OptionalInt returns the value of the "optional_int" field in the mutation.
func (m *FieldTypeMutation) OptionalInt() (r int, exists bool) {
	v := m.optional_int
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalInt returns the old "optional_int" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalInt(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalInt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalInt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalInt: %w", err)
	}
	return oldValue.OptionalInt, nil
}

// AddOptionalInt adds i to the "optional_int" field.
func (m *FieldTypeMutation) AddOptionalInt(i int) {
	if m.addoptional_int != nil {
		*m.addoptional_int += i
	} else {
		m.addoptional_int = &i
	}
}

// AddedOptionalInt returns the value that was added to the "optional_int" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalInt() (r int, exists bool) {
	v := m.addoptional_int
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalInt clears the value of the "optional_int" field.
func (m *FieldTypeMutation) ClearOptionalInt() {
	m.optional_int = nil
	m.addoptional_int = nil
	m.clearedFields[fieldtype.FieldOptionalInt] = struct{}{}
}

// OptionalIntCleared returns if the "optional_int" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalIntCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalInt]
	return ok
}

// ResetOptionalInt resets all changes to the "optional_int" field.
func (m *FieldTypeMutation) ResetOptionalInt() {
	m.optional_int = nil
	m.addoptional_int = nil
	delete(m.clearedFields, fieldtype.FieldOptionalInt)
}

// SetOptionalInt8 sets the "optional_int8" field.
func (m *FieldTypeMutation) SetOptionalInt8(i int8) {
	m.optional_int8 = &i
	m.addoptional_int8 = nil
}

// OptionalInt8 returns the value of the "optional_int8" field in the mutation.
func (m *FieldTypeMutation) OptionalInt8() (r int8, exists bool) {
	v := m.optional_int8
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalInt8 returns the old "optional_int8" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalInt8(ctx context.Context) (v int8, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalInt8 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalInt8 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalInt8: %w", err)
	}
	return oldValue.OptionalInt8, nil
}

// AddOptionalInt8 adds i to the "optional_int8" field.
func (m *FieldTypeMutation) AddOptionalInt8(i int8) {
	if m.addoptional_int8 != nil {
		*m.addoptional_int8 += i
	} else {
		m.addoptional_int8 = &i
	}
}

// AddedOptionalInt8 returns the value that was added to the "optional_int8" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalInt8() (r int8, exists bool) {
	v := m.addoptional_int8
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalInt8 clears the value of the "optional_int8" field.
func (m *FieldTypeMutation) ClearOptionalInt8() {
	m.optional_int8 = nil
	m.addoptional_int8 = nil
	m.clearedFields[fieldtype.FieldOptionalInt8] = struct{}{}
}

// OptionalInt8Cleared returns if the "optional_int8" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalInt8Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalInt8]
	return ok
}

// ResetOptionalInt8 resets all changes to the "optional_int8" field.
func (m *FieldTypeMutation) ResetOptionalInt8() {
	m.optional_int8 = nil
	m.addoptional_int8 = nil
	delete(m.clearedFields, fieldtype.FieldOptionalInt8)
}

// SetOptionalInt16 sets the "optional_int16" field.
func (m *FieldTypeMutation) SetOptionalInt16(i int16) {
	m.optional_int16 = &i
	m.addoptional_int16 = nil
}

// OptionalInt16 returns the value of the "optional_int16" field in the mutation.
func (m *FieldTypeMutation) OptionalInt16() (r int16, exists bool) {
	v := m.optional_int16
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalInt16 returns the old "optional_int16" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalInt16(ctx context.Context) (v int16, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalInt16 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalInt16 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalInt16: %w", err)
	}
	return oldValue.OptionalInt16, nil
}

// AddOptionalInt16 adds i to the "optional_int16" field.
func (m *FieldTypeMutation) AddOptionalInt16(i int16) {
	if m.addoptional_int16 != nil {
		*m.addoptional_int16 += i
	} else {
		m.addoptional_int16 = &i
	}
}

// AddedOptionalInt16 returns the value that was added to the "optional_int16" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalInt16() (r int16, exists bool) {
	v := m.addoptional_int16
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalInt16 clears the value of the "optional_int16" field.
func (m *FieldTypeMutation) ClearOptionalInt16() {
	m.optional_int16 = nil
	m.addoptional_int16 = nil
	m.clearedFields[fieldtype.FieldOptionalInt16] = struct{}{}
}

// OptionalInt16Cleared returns if the "optional_int16" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalInt16Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalInt16]
	return ok
}

// ResetOptionalInt16 resets all changes to the "optional_int16" field.
func (m *FieldTypeMutation) ResetOptionalInt16() {
	m.optional_int16 = nil
	m.addoptional_int16 = nil
	delete(m.clearedFields, fieldtype.FieldOptionalInt16)
}

// SetOptionalInt32 sets the "optional_int32" field.
func (m *FieldTypeMutation) SetOptionalInt32(i int32) {
	m.optional_int32 = &i
	m.addoptional_int32 = nil
}

// OptionalInt32 returns the value of the "optional_int32" field in the mutation.
func (m *FieldTypeMutation) OptionalInt32() (r int32, exists bool) {
	v := m.optional_int32
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalInt32 returns the old "optional_int32" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalInt32(ctx context.Context) (v int32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalInt32 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalInt32 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalInt32: %w", err)
	}
	return oldValue.OptionalInt32, nil
}

// AddOptionalInt32 adds i to the "optional_int32" field.
func (m *FieldTypeMutation) AddOptionalInt32(i int32) {
	if m.addoptional_int32 != nil {
		*m.addoptional_int32 += i
	} else {
		m.addoptional_int32 = &i
	}
}

// AddedOptionalInt32 returns the value that was added to the "optional_int32" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalInt32() (r int32, exists bool) {
	v := m.addoptional_int32
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalInt32 clears the value of the "optional_int32" field.
func (m *FieldTypeMutation) ClearOptionalInt32() {
	m.optional_int32 = nil
	m.addoptional_int32 = nil
	m.clearedFields[fieldtype.FieldOptionalInt32] = struct{}{}
}

// OptionalInt32Cleared returns if the "optional_int32" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalInt32Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalInt32]
	return ok
}

// ResetOptionalInt32 resets all changes to the "optional_int32" field.
func (m *FieldTypeMutation) ResetOptionalInt32() {
	m.optional_int32 = nil
	m.addoptional_int32 = nil
	delete(m.clearedFields, fieldtype.FieldOptionalInt32)
}

// SetOptionalInt64 sets the "optional_int64" field.
func (m *FieldTypeMutation) SetOptionalInt64(i int64) {
	m.optional_int64 = &i
	m.addoptional_int64 = nil
}

// OptionalInt64 returns the value of the "optional_int64" field in the mutation.
func (m *FieldTypeMutation) OptionalInt64() (r int64, exists bool) {
	v := m.optional_int64
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalInt64 returns the old "optional_int64" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalInt64(ctx context.Context) (v int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalInt64 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalInt64 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalInt64: %w", err)
	}
	return oldValue.OptionalInt64, nil
}

// AddOptionalInt64 adds i to the "optional_int64" field.
func (m *FieldTypeMutation) AddOptionalInt64(i int64) {
	if m.addoptional_int64 != nil {
		*m.addoptional_int64 += i
	} else {
		m.addoptional_int64 = &i
	}
}

// AddedOptionalInt64 returns the value that was added to the "optional_int64" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalInt64() (r int64, exists bool) {
	v := m.addoptional_int64
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalInt64 clears the value of the "optional_int64" field.
func (m *FieldTypeMutation) ClearOptionalInt64() {
	m.optional_int64 = nil
	m.addoptional_int64 = nil
	m.clearedFields[fieldtype.FieldOptionalInt64] = struct{}{}
}

// OptionalInt64Cleared returns if the "optional_int64" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalInt64Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalInt64]
	return ok
}

// ResetOptionalInt64 resets all changes to the "optional_int64" field.
func (m *FieldTypeMutation) ResetOptionalInt64() {
	m.optional_int64 = nil
	m.addoptional_int64 = nil
	delete(m.clearedFields, fieldtype.FieldOptionalInt64)
}

// SetNillableInt sets the "nillable_int" field.
func (m *FieldTypeMutation) SetNillableInt(i int) {
	m.nillable_int = &i
	m.addnillable_int = nil
}

// NillableInt returns the value of the "nillable_int" field in the mutation.
func (m *FieldTypeMutation) NillableInt() (r int, exists bool) {
	v := m.nillable_int
	if v == nil {
		return
	}
	return *v, true
}

// OldNillableInt returns the old "nillable_int" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNillableInt(ctx context.Context) (v *int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNillableInt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNillableInt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNillableInt: %w", err)
	}
	return oldValue.NillableInt, nil
}

// AddNillableInt adds i to the "nillable_int" field.
func (m *FieldTypeMutation) AddNillableInt(i int) {
	if m.addnillable_int != nil {
		*m.addnillable_int += i
	} else {
		m.addnillable_int = &i
	}
}

// AddedNillableInt returns the value that was added to the "nillable_int" field in this mutation.
func (m *FieldTypeMutation) AddedNillableInt() (r int, exists bool) {
	v := m.addnillable_int
	if v == nil {
		return
	}
	return *v, true
}

// ClearNillableInt clears the value of the "nillable_int" field.
func (m *FieldTypeMutation) ClearNillableInt() {
	m.nillable_int = nil
	m.addnillable_int = nil
	m.clearedFields[fieldtype.FieldNillableInt] = struct{}{}
}

// NillableIntCleared returns if the "nillable_int" field was cleared in this mutation.
func (m *FieldTypeMutation) NillableIntCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNillableInt]
	return ok
}

// ResetNillableInt resets all changes to the "nillable_int" field.
func (m *FieldTypeMutation) ResetNillableInt() {
	m.nillable_int = nil
	m.addnillable_int = nil
	delete(m.clearedFields, fieldtype.FieldNillableInt)
}

// SetNillableInt8 sets the "nillable_int8" field.
func (m *FieldTypeMutation) SetNillableInt8(i int8) {
	m.nillable_int8 = &i
	m.addnillable_int8 = nil
}

// NillableInt8 returns the value of the "nillable_int8" field in the mutation.
func (m *FieldTypeMutation) NillableInt8() (r int8, exists bool) {
	v := m.nillable_int8
	if v == nil {
		return
	}
	return *v, true
}

// OldNillableInt8 returns the old "nillable_int8" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNillableInt8(ctx context.Context) (v *int8, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNillableInt8 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNillableInt8 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNillableInt8: %w", err)
	}
	return oldValue.NillableInt8, nil
}

// AddNillableInt8 adds i to the "nillable_int8" field.
func (m *FieldTypeMutation) AddNillableInt8(i int8) {
	if m.addnillable_int8 != nil {
		*m.addnillable_int8 += i
	} else {
		m.addnillable_int8 = &i
	}
}

// AddedNillableInt8 returns the value that was added to the "nillable_int8" field in this mutation.
func (m *FieldTypeMutation) AddedNillableInt8() (r int8, exists bool) {
	v := m.addnillable_int8
	if v == nil {
		return
	}
	return *v, true
}

// ClearNillableInt8 clears the value of the "nillable_int8" field.
func (m *FieldTypeMutation) ClearNillableInt8() {
	m.nillable_int8 = nil
	m.addnillable_int8 = nil
	m.clearedFields[fieldtype.FieldNillableInt8] = struct{}{}
}

// NillableInt8Cleared returns if the "nillable_int8" field was cleared in this mutation.
func (m *FieldTypeMutation) NillableInt8Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNillableInt8]
	return ok
}

// ResetNillableInt8 resets all changes to the "nillable_int8" field.
func (m *FieldTypeMutation) ResetNillableInt8() {
	m.nillable_int8 = nil
	m.addnillable_int8 = nil
	delete(m.clearedFields, fieldtype.FieldNillableInt8)
}

// SetNillableInt16 sets the "nillable_int16" field.
func (m *FieldTypeMutation) SetNillableInt16(i int16) {
	m.nillable_int16 = &i
	m.addnillable_int16 = nil
}

// NillableInt16 returns the value of the "nillable_int16" field in the mutation.
func (m *FieldTypeMutation) NillableInt16() (r int16, exists bool) {
	v := m.nillable_int16
	if v == nil {
		return
	}
	return *v, true
}

// OldNillableInt16 returns the old "nillable_int16" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNillableInt16(ctx context.Context) (v *int16, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNillableInt16 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNillableInt16 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNillableInt16: %w", err)
	}
	return oldValue.NillableInt16, nil
}

// AddNillableInt16 adds i to the "nillable_int16" field.
func (m *FieldTypeMutation) AddNillableInt16(i int16) {
	if m.addnillable_int16 != nil {
		*m.addnillable_int16 += i
	} else {
		m.addnillable_int16 = &i
	}
}

// AddedNillableInt16 returns the value that was added to the "nillable_int16" field in this mutation.
func (m *FieldTypeMutation) AddedNillableInt16() (r int16, exists bool) {
	v := m.addnillable_int16
	if v == nil {
		return
	}
	return *v, true
}

// ClearNillableInt16 clears the value of the "nillable_int16" field.
func (m *FieldTypeMutation) ClearNillableInt16() {
	m.nillable_int16 = nil
	m.addnillable_int16 = nil
	m.clearedFields[fieldtype.FieldNillableInt16] = struct{}{}
}

// NillableInt16Cleared returns if the "nillable_int16" field was cleared in this mutation.
func (m *FieldTypeMutation) NillableInt16Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNillableInt16]
	return ok
}

// ResetNillableInt16 resets all changes to the "nillable_int16" field.
func (m *FieldTypeMutation) ResetNillableInt16() {
	m.nillable_int16 = nil
	m.addnillable_int16 = nil
	delete(m.clearedFields, fieldtype.FieldNillableInt16)
}

// SetNillableInt32 sets the "nillable_int32" field.
func (m *FieldTypeMutation) SetNillableInt32(i int32) {
	m.nillable_int32 = &i
	m.addnillable_int32 = nil
}

// NillableInt32 returns the value of the "nillable_int32" field in the mutation.
func (m *FieldTypeMutation) NillableInt32() (r int32, exists bool) {
	v := m.nillable_int32
	if v == nil {
		return
	}
	return *v, true
}

// OldNillableInt32 returns the old "nillable_int32" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNillableInt32(ctx context.Context) (v *int32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNillableInt32 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNillableInt32 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNillableInt32: %w", err)
	}
	return oldValue.NillableInt32, nil
}

// AddNillableInt32 adds i to the "nillable_int32" field.
func (m *FieldTypeMutation) AddNillableInt32(i int32) {
	if m.addnillable_int32 != nil {
		*m.addnillable_int32 += i
	} else {
		m.addnillable_int32 = &i
	}
}

// AddedNillableInt32 returns the value that was added to the "nillable_int32" field in this mutation.
func (m *FieldTypeMutation) AddedNillableInt32() (r int32, exists bool) {
	v := m.addnillable_int32
	if v == nil {
		return
	}
	return *v, true
}

// ClearNillableInt32 clears the value of the "nillable_int32" field.
func (m *FieldTypeMutation) ClearNillableInt32() {
	m.nillable_int32 = nil
	m.addnillable_int32 = nil
	m.clearedFields[fieldtype.FieldNillableInt32] = struct{}{}
}

// NillableInt32Cleared returns if the "nillable_int32" field was cleared in this mutation.
func (m *FieldTypeMutation) NillableInt32Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNillableInt32]
	return ok
}

// ResetNillableInt32 resets all changes to the "nillable_int32" field.
func (m *FieldTypeMutation) ResetNillableInt32() {
	m.nillable_int32 = nil
	m.addnillable_int32 = nil
	delete(m.clearedFields, fieldtype.FieldNillableInt32)
}

// SetNillableInt64 sets the "nillable_int64" field.
func (m *FieldTypeMutation) SetNillableInt64(i int64) {
	m.nillable_int64 = &i
	m.addnillable_int64 = nil
}

// NillableInt64 returns the value of the "nillable_int64" field in the mutation.
func (m *FieldTypeMutation) NillableInt64() (r int64, exists bool) {
	v := m.nillable_int64
	if v == nil {
		return
	}
	return *v, true
}

// OldNillableInt64 returns the old "nillable_int64" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNillableInt64(ctx context.Context) (v *int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNillableInt64 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNillableInt64 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNillableInt64: %w", err)
	}
	return oldValue.NillableInt64, nil
}

// AddNillableInt64 adds i to the "nillable_int64" field.
func (m *FieldTypeMutation) AddNillableInt64(i int64) {
	if m.addnillable_int64 != nil {
		*m.addnillable_int64 += i
	} else {
		m.addnillable_int64 = &i
	}
}

// AddedNillableInt64 returns the value that was added to the "nillable_int64" field in this mutation.
func (m *FieldTypeMutation) AddedNillableInt64() (r int64, exists bool) {
	v := m.addnillable_int64
	if v == nil {
		return
	}
	return *v, true
}

// ClearNillableInt64 clears the value of the "nillable_int64" field.
func (m *FieldTypeMutation) ClearNillableInt64() {
	m.nillable_int64 = nil
	m.addnillable_int64 = nil
	m.clearedFields[fieldtype.FieldNillableInt64] = struct{}{}
}

// NillableInt64Cleared returns if the "nillable_int64" field was cleared in this mutation.
func (m *FieldTypeMutation) NillableInt64Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNillableInt64]
	return ok
}

// ResetNillableInt64 resets all changes to the "nillable_int64" field.
func (m *FieldTypeMutation) ResetNillableInt64() {
	m.nillable_int64 = nil
	m.addnillable_int64 = nil
	delete(m.clearedFields, fieldtype.FieldNillableInt64)
}

// SetValidateOptionalInt32 sets the "validate_optional_int32" field.
func (m *FieldTypeMutation) SetValidateOptionalInt32(i int32) {
	m.validate_optional_int32 = &i
	m.addvalidate_optional_int32 = nil
}

// ValidateOptionalInt32 returns the value of the "validate_optional_int32" field in the mutation.
func (m *FieldTypeMutation) ValidateOptionalInt32() (r int32, exists bool) {
	v := m.validate_optional_int32
	if v == nil {
		return
	}
	return *v, true
}

// OldValidateOptionalInt32 returns the old "validate_optional_int32" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldValidateOptionalInt32(ctx context.Context) (v int32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldValidateOptionalInt32 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldValidateOptionalInt32 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldValidateOptionalInt32: %w", err)
	}
	return oldValue.ValidateOptionalInt32, nil
}

// AddValidateOptionalInt32 adds i to the "validate_optional_int32" field.
func (m *FieldTypeMutation) AddValidateOptionalInt32(i int32) {
	if m.addvalidate_optional_int32 != nil {
		*m.addvalidate_optional_int32 += i
	} else {
		m.addvalidate_optional_int32 = &i
	}
}

// AddedValidateOptionalInt32 returns the value that was added to the "validate_optional_int32" field in this mutation.
func (m *FieldTypeMutation) AddedValidateOptionalInt32() (r int32, exists bool) {
	v := m.addvalidate_optional_int32
	if v == nil {
		return
	}
	return *v, true
}

// ClearValidateOptionalInt32 clears the value of the "validate_optional_int32" field.
func (m *FieldTypeMutation) ClearValidateOptionalInt32() {
	m.validate_optional_int32 = nil
	m.addvalidate_optional_int32 = nil
	m.clearedFields[fieldtype.FieldValidateOptionalInt32] = struct{}{}
}

// ValidateOptionalInt32Cleared returns if the "validate_optional_int32" field was cleared in this mutation.
func (m *FieldTypeMutation) ValidateOptionalInt32Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldValidateOptionalInt32]
	return ok
}

// ResetValidateOptionalInt32 resets all changes to the "validate_optional_int32" field.
func (m *FieldTypeMutation) ResetValidateOptionalInt32() {
	m.validate_optional_int32 = nil
	m.addvalidate_optional_int32 = nil
	delete(m.clearedFields, fieldtype.FieldValidateOptionalInt32)
}

// SetOptionalUint sets the "optional_uint" field.
func (m *FieldTypeMutation) SetOptionalUint(u uint) {
	m.optional_uint = &u
	m.addoptional_uint = nil
}

// OptionalUint returns the value of the "optional_uint" field in the mutation.
func (m *FieldTypeMutation) OptionalUint() (r uint, exists bool) {
	v := m.optional_uint
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalUint returns the old "optional_uint" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalUint(ctx context.Context) (v uint, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalUint is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalUint requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalUint: %w", err)
	}
	return oldValue.OptionalUint, nil
}

// AddOptionalUint adds u to the "optional_uint" field.
func (m *FieldTypeMutation) AddOptionalUint(u uint) {
	if m.addoptional_uint != nil {
		*m.addoptional_uint += u
	} else {
		m.addoptional_uint = &u
	}
}

// AddedOptionalUint returns the value that was added to the "optional_uint" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalUint() (r uint, exists bool) {
	v := m.addoptional_uint
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalUint clears the value of the "optional_uint" field.
func (m *FieldTypeMutation) ClearOptionalUint() {
	m.optional_uint = nil
	m.addoptional_uint = nil
	m.clearedFields[fieldtype.FieldOptionalUint] = struct{}{}
}

// OptionalUintCleared returns if the "optional_uint" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalUintCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalUint]
	return ok
}

// ResetOptionalUint resets all changes to the "optional_uint" field.
func (m *FieldTypeMutation) ResetOptionalUint() {
	m.optional_uint = nil
	m.addoptional_uint = nil
	delete(m.clearedFields, fieldtype.FieldOptionalUint)
}

// SetOptionalUint8 sets the "optional_uint8" field.
func (m *FieldTypeMutation) SetOptionalUint8(u uint8) {
	m.optional_uint8 = &u
	m.addoptional_uint8 = nil
}

// OptionalUint8 returns the value of the "optional_uint8" field in the mutation.
func (m *FieldTypeMutation) OptionalUint8() (r uint8, exists bool) {
	v := m.optional_uint8
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalUint8 returns the old "optional_uint8" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalUint8(ctx context.Context) (v uint8, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalUint8 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalUint8 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalUint8: %w", err)
	}
	return oldValue.OptionalUint8, nil
}

// AddOptionalUint8 adds u to the "optional_uint8" field.
func (m *FieldTypeMutation) AddOptionalUint8(u uint8) {
	if m.addoptional_uint8 != nil {
		*m.addoptional_uint8 += u
	} else {
		m.addoptional_uint8 = &u
	}
}

// AddedOptionalUint8 returns the value that was added to the "optional_uint8" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalUint8() (r uint8, exists bool) {
	v := m.addoptional_uint8
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalUint8 clears the value of the "optional_uint8" field.
func (m *FieldTypeMutation) ClearOptionalUint8() {
	m.optional_uint8 = nil
	m.addoptional_uint8 = nil
	m.clearedFields[fieldtype.FieldOptionalUint8] = struct{}{}
}

// OptionalUint8Cleared returns if the "optional_uint8" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalUint8Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalUint8]
	return ok
}

// ResetOptionalUint8 resets all changes to the "optional_uint8" field.
func (m *FieldTypeMutation) ResetOptionalUint8() {
	m.optional_uint8 = nil
	m.addoptional_uint8 = nil
	delete(m.clearedFields, fieldtype.FieldOptionalUint8)
}

// SetOptionalUint16 sets the "optional_uint16" field.
func (m *FieldTypeMutation) SetOptionalUint16(u uint16) {
	m.optional_uint16 = &u
	m.addoptional_uint16 = nil
}

// OptionalUint16 returns the value of the "optional_uint16" field in the mutation.
func (m *FieldTypeMutation) OptionalUint16() (r uint16, exists bool) {
	v := m.optional_uint16
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalUint16 returns the old "optional_uint16" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalUint16(ctx context.Context) (v uint16, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalUint16 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalUint16 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalUint16: %w", err)
	}
	return oldValue.OptionalUint16, nil
}

// AddOptionalUint16 adds u to the "optional_uint16" field.
func (m *FieldTypeMutation) AddOptionalUint16(u uint16) {
	if m.addoptional_uint16 != nil {
		*m.addoptional_uint16 += u
	} else {
		m.addoptional_uint16 = &u
	}
}

// AddedOptionalUint16 returns the value that was added to the "optional_uint16" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalUint16() (r uint16, exists bool) {
	v := m.addoptional_uint16
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalUint16 clears the value of the "optional_uint16" field.
func (m *FieldTypeMutation) ClearOptionalUint16() {
	m.optional_uint16 = nil
	m.addoptional_uint16 = nil
	m.clearedFields[fieldtype.FieldOptionalUint16] = struct{}{}
}

// OptionalUint16Cleared returns if the "optional_uint16" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalUint16Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalUint16]
	return ok
}

// ResetOptionalUint16 resets all changes to the "optional_uint16" field.
func (m *FieldTypeMutation) ResetOptionalUint16() {
	m.optional_uint16 = nil
	m.addoptional_uint16 = nil
	delete(m.clearedFields, fieldtype.FieldOptionalUint16)
}

// SetOptionalUint32 sets the "optional_uint32" field.
func (m *FieldTypeMutation) SetOptionalUint32(u uint32) {
	m.optional_uint32 = &u
	m.addoptional_uint32 = nil
}

// OptionalUint32 returns the value of the "optional_uint32" field in the mutation.
func (m *FieldTypeMutation) OptionalUint32() (r uint32, exists bool) {
	v := m.optional_uint32
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalUint32 returns the old "optional_uint32" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalUint32(ctx context.Context) (v uint32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalUint32 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalUint32 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalUint32: %w", err)
	}
	return oldValue.OptionalUint32, nil
}

// AddOptionalUint32 adds u to the "optional_uint32" field.
func (m *FieldTypeMutation) AddOptionalUint32(u uint32) {
	if m.addoptional_uint32 != nil {
		*m.addoptional_uint32 += u
	} else {
		m.addoptional_uint32 = &u
	}
}

// AddedOptionalUint32 returns the value that was added to the "optional_uint32" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalUint32() (r uint32, exists bool) {
	v := m.addoptional_uint32
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalUint32 clears the value of the "optional_uint32" field.
func (m *FieldTypeMutation) ClearOptionalUint32() {
	m.optional_uint32 = nil
	m.addoptional_uint32 = nil
	m.clearedFields[fieldtype.FieldOptionalUint32] = struct{}{}
}

// OptionalUint32Cleared returns if the "optional_uint32" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalUint32Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalUint32]
	return ok
}

// ResetOptionalUint32 resets all changes to the "optional_uint32" field.
func (m *FieldTypeMutation) ResetOptionalUint32() {
	m.optional_uint32 = nil
	m.addoptional_uint32 = nil
	delete(m.clearedFields, fieldtype.FieldOptionalUint32)
}

// SetOptionalUint64 sets the "optional_uint64" field.
func (m *FieldTypeMutation) SetOptionalUint64(u uint64) {
	m.optional_uint64 = &u
	m.addoptional_uint64 = nil
}

// OptionalUint64 returns the value of the "optional_uint64" field in the mutation.
func (m *FieldTypeMutation) OptionalUint64() (r uint64, exists bool) {
	v := m.optional_uint64
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalUint64 returns the old "optional_uint64" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalUint64(ctx context.Context) (v uint64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalUint64 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalUint64 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalUint64: %w", err)
	}
	return oldValue.OptionalUint64, nil
}

// AddOptionalUint64 adds u to the "optional_uint64" field.
func (m *FieldTypeMutation) AddOptionalUint64(u uint64) {
	if m.addoptional_uint64 != nil {
		*m.addoptional_uint64 += u
	} else {
		m.addoptional_uint64 = &u
	}
}

// AddedOptionalUint64 returns the value that was added to the "optional_uint64" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalUint64() (r uint64, exists bool) {
	v := m.addoptional_uint64
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalUint64 clears the value of the "optional_uint64" field.
func (m *FieldTypeMutation) ClearOptionalUint64() {
	m.optional_uint64 = nil
	m.addoptional_uint64 = nil
	m.clearedFields[fieldtype.FieldOptionalUint64] = struct{}{}
}

// OptionalUint64Cleared returns if the "optional_uint64" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalUint64Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalUint64]
	return ok
}

// ResetOptionalUint64 resets all changes to the "optional_uint64" field.
func (m *FieldTypeMutation) ResetOptionalUint64() {
	m.optional_uint64 = nil
	m.addoptional_uint64 = nil
	delete(m.clearedFields, fieldtype.FieldOptionalUint64)
}

// SetState sets the "state" field.
func (m *FieldTypeMutation) SetState(f fieldtype.State) {
	m.state = &f
}

// State returns the value of the "state" field in the mutation.
func (m *FieldTypeMutation) State() (r fieldtype.State, exists bool) {
	v := m.state
	if v == nil {
		return
	}
	return *v, true
}

// OldState returns the old "state" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldState(ctx context.Context) (v fieldtype.State, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldState is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldState requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldState: %w", err)
	}
	return oldValue.State, nil
}

// ClearState clears the value of the "state" field.
func (m *FieldTypeMutation) ClearState() {
	m.state = nil
	m.clearedFields[fieldtype.FieldState] = struct{}{}
}

// StateCleared returns if the "state" field was cleared in this mutation.
func (m *FieldTypeMutation) StateCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldState]
	return ok
}

// ResetState resets all changes to the "state" field.
func (m *FieldTypeMutation) ResetState() {
	m.state = nil
	delete(m.clearedFields, fieldtype.FieldState)
}

// SetOptionalFloat sets the "optional_float" field.
func (m *FieldTypeMutation) SetOptionalFloat(f float64) {
	m.optional_float = &f
	m.addoptional_float = nil
}

// OptionalFloat returns the value of the "optional_float" field in the mutation.
func (m *FieldTypeMutation) OptionalFloat() (r float64, exists bool) {
	v := m.optional_float
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalFloat returns the old "optional_float" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalFloat(ctx context.Context) (v float64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalFloat is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalFloat requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalFloat: %w", err)
	}
	return oldValue.OptionalFloat, nil
}

// AddOptionalFloat adds f to the "optional_float" field.
func (m *FieldTypeMutation) AddOptionalFloat(f float64) {
	if m.addoptional_float != nil {
		*m.addoptional_float += f
	} else {
		m.addoptional_float = &f
	}
}

// AddedOptionalFloat returns the value that was added to the "optional_float" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalFloat() (r float64, exists bool) {
	v := m.addoptional_float
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalFloat clears the value of the "optional_float" field.
func (m *FieldTypeMutation) ClearOptionalFloat() {
	m.optional_float = nil
	m.addoptional_float = nil
	m.clearedFields[fieldtype.FieldOptionalFloat] = struct{}{}
}

// OptionalFloatCleared returns if the "optional_float" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalFloatCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalFloat]
	return ok
}

// ResetOptionalFloat resets all changes to the "optional_float" field.
func (m *FieldTypeMutation) ResetOptionalFloat() {
	m.optional_float = nil
	m.addoptional_float = nil
	delete(m.clearedFields, fieldtype.FieldOptionalFloat)
}

// SetOptionalFloat32 sets the "optional_float32" field.
func (m *FieldTypeMutation) SetOptionalFloat32(f float32) {
	m.optional_float32 = &f
	m.addoptional_float32 = nil
}

// OptionalFloat32 returns the value of the "optional_float32" field in the mutation.
func (m *FieldTypeMutation) OptionalFloat32() (r float32, exists bool) {
	v := m.optional_float32
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalFloat32 returns the old "optional_float32" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldOptionalFloat32(ctx context.Context) (v float32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalFloat32 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalFloat32 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalFloat32: %w", err)
	}
	return oldValue.OptionalFloat32, nil
}

// AddOptionalFloat32 adds f to the "optional_float32" field.
func (m *FieldTypeMutation) AddOptionalFloat32(f float32) {
	if m.addoptional_float32 != nil {
		*m.addoptional_float32 += f
	} else {
		m.addoptional_float32 = &f
	}
}

// AddedOptionalFloat32 returns the value that was added to the "optional_float32" field in this mutation.
func (m *FieldTypeMutation) AddedOptionalFloat32() (r float32, exists bool) {
	v := m.addoptional_float32
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalFloat32 clears the value of the "optional_float32" field.
func (m *FieldTypeMutation) ClearOptionalFloat32() {
	m.optional_float32 = nil
	m.addoptional_float32 = nil
	m.clearedFields[fieldtype.FieldOptionalFloat32] = struct{}{}
}

// OptionalFloat32Cleared returns if the "optional_float32" field was cleared in this mutation.
func (m *FieldTypeMutation) OptionalFloat32Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldOptionalFloat32]
	return ok
}

// ResetOptionalFloat32 resets all changes to the "optional_float32" field.
func (m *FieldTypeMutation) ResetOptionalFloat32() {
	m.optional_float32 = nil
	m.addoptional_float32 = nil
	delete(m.clearedFields, fieldtype.FieldOptionalFloat32)
}

// SetDatetime sets the "datetime" field.
func (m *FieldTypeMutation) SetDatetime(t time.Time) {
	m.datetime = &t
}

// Datetime returns the value of the "datetime" field in the mutation.
func (m *FieldTypeMutation) Datetime() (r time.Time, exists bool) {
	v := m.datetime
	if v == nil {
		return
	}
	return *v, true
}

// OldDatetime returns the old "datetime" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldDatetime(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDatetime is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDatetime requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDatetime: %w", err)
	}
	return oldValue.Datetime, nil
}

// ClearDatetime clears the value of the "datetime" field.
func (m *FieldTypeMutation) ClearDatetime() {
	m.datetime = nil
	m.clearedFields[fieldtype.FieldDatetime] = struct{}{}
}

// DatetimeCleared returns if the "datetime" field was cleared in this mutation.
func (m *FieldTypeMutation) DatetimeCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldDatetime]
	return ok
}

// ResetDatetime resets all changes to the "datetime" field.
func (m *FieldTypeMutation) ResetDatetime() {
	m.datetime = nil
	delete(m.clearedFields, fieldtype.FieldDatetime)
}

// SetDecimal sets the "decimal" field.
func (m *FieldTypeMutation) SetDecimal(f float64) {
	m.decimal = &f
	m.adddecimal = nil
}

// Decimal returns the value of the "decimal" field in the mutation.
func (m *FieldTypeMutation) Decimal() (r float64, exists bool) {
	v := m.decimal
	if v == nil {
		return
	}
	return *v, true
}

// OldDecimal returns the old "decimal" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldDecimal(ctx context.Context) (v float64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDecimal is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDecimal requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDecimal: %w", err)
	}
	return oldValue.Decimal, nil
}

// AddDecimal adds f to the "decimal" field.
func (m *FieldTypeMutation) AddDecimal(f float64) {
	if m.adddecimal != nil {
		*m.adddecimal += f
	} else {
		m.adddecimal = &f
	}
}

// AddedDecimal returns the value that was added to the "decimal" field in this mutation.
func (m *FieldTypeMutation) AddedDecimal() (r float64, exists bool) {
	v := m.adddecimal
	if v == nil {
		return
	}
	return *v, true
}

// ClearDecimal clears the value of the "decimal" field.
func (m *FieldTypeMutation) ClearDecimal() {
	m.decimal = nil
	m.adddecimal = nil
	m.clearedFields[fieldtype.FieldDecimal] = struct{}{}
}

// DecimalCleared returns if the "decimal" field was cleared in this mutation.
func (m *FieldTypeMutation) DecimalCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldDecimal]
	return ok
}

// ResetDecimal resets all changes to the "decimal" field.
func (m *FieldTypeMutation) ResetDecimal() {
	m.decimal = nil
	m.adddecimal = nil
	delete(m.clearedFields, fieldtype.FieldDecimal)
}

// SetDir sets the "dir" field.
func (m *FieldTypeMutation) SetDir(h http.Dir) {
	m.dir = &h
}

// Dir returns the value of the "dir" field in the mutation.
func (m *FieldTypeMutation) Dir() (r http.Dir, exists bool) {
	v := m.dir
	if v == nil {
		return
	}
	return *v, true
}

// OldDir returns the old "dir" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldDir(ctx context.Context) (v http.Dir, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDir is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDir requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDir: %w", err)
	}
	return oldValue.Dir, nil
}

// ClearDir clears the value of the "dir" field.
func (m *FieldTypeMutation) ClearDir() {
	m.dir = nil
	m.clearedFields[fieldtype.FieldDir] = struct{}{}
}

// DirCleared returns if the "dir" field was cleared in this mutation.
func (m *FieldTypeMutation) DirCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldDir]
	return ok
}

// ResetDir resets all changes to the "dir" field.
func (m *FieldTypeMutation) ResetDir() {
	m.dir = nil
	delete(m.clearedFields, fieldtype.FieldDir)
}

// SetNdir sets the "ndir" field.
func (m *FieldTypeMutation) SetNdir(h http.Dir) {
	m.ndir = &h
}

// Ndir returns the value of the "ndir" field in the mutation.
func (m *FieldTypeMutation) Ndir() (r http.Dir, exists bool) {
	v := m.ndir
	if v == nil {
		return
	}
	return *v, true
}

// OldNdir returns the old "ndir" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNdir(ctx context.Context) (v *http.Dir, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNdir is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNdir requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNdir: %w", err)
	}
	return oldValue.Ndir, nil
}

// ClearNdir clears the value of the "ndir" field.
func (m *FieldTypeMutation) ClearNdir() {
	m.ndir = nil
	m.clearedFields[fieldtype.FieldNdir] = struct{}{}
}

// NdirCleared returns if the "ndir" field was cleared in this mutation.
func (m *FieldTypeMutation) NdirCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNdir]
	return ok
}

// ResetNdir resets all changes to the "ndir" field.
func (m *FieldTypeMutation) ResetNdir() {
	m.ndir = nil
	delete(m.clearedFields, fieldtype.FieldNdir)
}

// SetStr sets the "str" field.
func (m *FieldTypeMutation) SetStr(ss sql.NullString) {
	m.str = &ss
}

// Str returns the value of the "str" field in the mutation.
func (m *FieldTypeMutation) Str() (r sql.NullString, exists bool) {
	v := m.str
	if v == nil {
		return
	}
	return *v, true
}

// OldStr returns the old "str" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldStr(ctx context.Context) (v sql.NullString, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldStr is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldStr requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStr: %w", err)
	}
	return oldValue.Str, nil
}

// ClearStr clears the value of the "str" field.
func (m *FieldTypeMutation) ClearStr() {
	m.str = nil
	m.clearedFields[fieldtype.FieldStr] = struct{}{}
}

// StrCleared returns if the "str" field was cleared in this mutation.
func (m *FieldTypeMutation) StrCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldStr]
	return ok
}

// ResetStr resets all changes to the "str" field.
func (m *FieldTypeMutation) ResetStr() {
	m.str = nil
	delete(m.clearedFields, fieldtype.FieldStr)
}

// SetNullStr sets the "null_str" field.
func (m *FieldTypeMutation) SetNullStr(ss sql.NullString) {
	m.null_str = &ss
}

// NullStr returns the value of the "null_str" field in the mutation.
func (m *FieldTypeMutation) NullStr() (r sql.NullString, exists bool) {
	v := m.null_str
	if v == nil {
		return
	}
	return *v, true
}

// OldNullStr returns the old "null_str" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNullStr(ctx context.Context) (v *sql.NullString, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNullStr is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNullStr requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNullStr: %w", err)
	}
	return oldValue.NullStr, nil
}

// ClearNullStr clears the value of the "null_str" field.
func (m *FieldTypeMutation) ClearNullStr() {
	m.null_str = nil
	m.clearedFields[fieldtype.FieldNullStr] = struct{}{}
}

// NullStrCleared returns if the "null_str" field was cleared in this mutation.
func (m *FieldTypeMutation) NullStrCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNullStr]
	return ok
}

// ResetNullStr resets all changes to the "null_str" field.
func (m *FieldTypeMutation) ResetNullStr() {
	m.null_str = nil
	delete(m.clearedFields, fieldtype.FieldNullStr)
}

// SetLink sets the "link" field.
func (m *FieldTypeMutation) SetLink(s schema.Link) {
	m.link = &s
}

// Link returns the value of the "link" field in the mutation.
func (m *FieldTypeMutation) Link() (r schema.Link, exists bool) {
	v := m.link
	if v == nil {
		return
	}
	return *v, true
}

// OldLink returns the old "link" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldLink(ctx context.Context) (v schema.Link, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldLink is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldLink requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLink: %w", err)
	}
	return oldValue.Link, nil
}

// ClearLink clears the value of the "link" field.
func (m *FieldTypeMutation) ClearLink() {
	m.link = nil
	m.clearedFields[fieldtype.FieldLink] = struct{}{}
}

// LinkCleared returns if the "link" field was cleared in this mutation.
func (m *FieldTypeMutation) LinkCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldLink]
	return ok
}

// ResetLink resets all changes to the "link" field.
func (m *FieldTypeMutation) ResetLink() {
	m.link = nil
	delete(m.clearedFields, fieldtype.FieldLink)
}

// SetNullLink sets the "null_link" field.
func (m *FieldTypeMutation) SetNullLink(s schema.Link) {
	m.null_link = &s
}

// NullLink returns the value of the "null_link" field in the mutation.
func (m *FieldTypeMutation) NullLink() (r schema.Link, exists bool) {
	v := m.null_link
	if v == nil {
		return
	}
	return *v, true
}

// OldNullLink returns the old "null_link" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNullLink(ctx context.Context) (v *schema.Link, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNullLink is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNullLink requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNullLink: %w", err)
	}
	return oldValue.NullLink, nil
}

// ClearNullLink clears the value of the "null_link" field.
func (m *FieldTypeMutation) ClearNullLink() {
	m.null_link = nil
	m.clearedFields[fieldtype.FieldNullLink] = struct{}{}
}

// NullLinkCleared returns if the "null_link" field was cleared in this mutation.
func (m *FieldTypeMutation) NullLinkCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNullLink]
	return ok
}

// ResetNullLink resets all changes to the "null_link" field.
func (m *FieldTypeMutation) ResetNullLink() {
	m.null_link = nil
	delete(m.clearedFields, fieldtype.FieldNullLink)
}

// SetActive sets the "active" field.
func (m *FieldTypeMutation) SetActive(s schema.Status) {
	m.active = &s
}

// Active returns the value of the "active" field in the mutation.
func (m *FieldTypeMutation) Active() (r schema.Status, exists bool) {
	v := m.active
	if v == nil {
		return
	}
	return *v, true
}

// OldActive returns the old "active" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldActive(ctx context.Context) (v schema.Status, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldActive is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldActive requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldActive: %w", err)
	}
	return oldValue.Active, nil
}

// ClearActive clears the value of the "active" field.
func (m *FieldTypeMutation) ClearActive() {
	m.active = nil
	m.clearedFields[fieldtype.FieldActive] = struct{}{}
}

// ActiveCleared returns if the "active" field was cleared in this mutation.
func (m *FieldTypeMutation) ActiveCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldActive]
	return ok
}

// ResetActive resets all changes to the "active" field.
func (m *FieldTypeMutation) ResetActive() {
	m.active = nil
	delete(m.clearedFields, fieldtype.FieldActive)
}

// SetNullActive sets the "null_active" field.
func (m *FieldTypeMutation) SetNullActive(s schema.Status) {
	m.null_active = &s
}

// NullActive returns the value of the "null_active" field in the mutation.
func (m *FieldTypeMutation) NullActive() (r schema.Status, exists bool) {
	v := m.null_active
	if v == nil {
		return
	}
	return *v, true
}

// OldNullActive returns the old "null_active" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNullActive(ctx context.Context) (v *schema.Status, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNullActive is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNullActive requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNullActive: %w", err)
	}
	return oldValue.NullActive, nil
}

// ClearNullActive clears the value of the "null_active" field.
func (m *FieldTypeMutation) ClearNullActive() {
	m.null_active = nil
	m.clearedFields[fieldtype.FieldNullActive] = struct{}{}
}

// NullActiveCleared returns if the "null_active" field was cleared in this mutation.
func (m *FieldTypeMutation) NullActiveCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNullActive]
	return ok
}

// ResetNullActive resets all changes to the "null_active" field.
func (m *FieldTypeMutation) ResetNullActive() {
	m.null_active = nil
	delete(m.clearedFields, fieldtype.FieldNullActive)
}

// SetDeleted sets the "deleted" field.
func (m *FieldTypeMutation) SetDeleted(sb sql.NullBool) {
	m.deleted = &sb
}

// Deleted returns the value of the "deleted" field in the mutation.
func (m *FieldTypeMutation) Deleted() (r sql.NullBool, exists bool) {
	v := m.deleted
	if v == nil {
		return
	}
	return *v, true
}

// OldDeleted returns the old "deleted" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldDeleted(ctx context.Context) (v sql.NullBool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDeleted is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDeleted requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeleted: %w", err)
	}
	return oldValue.Deleted, nil
}

// ClearDeleted clears the value of the "deleted" field.
func (m *FieldTypeMutation) ClearDeleted() {
	m.deleted = nil
	m.clearedFields[fieldtype.FieldDeleted] = struct{}{}
}

// DeletedCleared returns if the "deleted" field was cleared in this mutation.
func (m *FieldTypeMutation) DeletedCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldDeleted]
	return ok
}

// ResetDeleted resets all changes to the "deleted" field.
func (m *FieldTypeMutation) ResetDeleted() {
	m.deleted = nil
	delete(m.clearedFields, fieldtype.FieldDeleted)
}

// SetDeletedAt sets the "deleted_at" field.
func (m *FieldTypeMutation) SetDeletedAt(st sql.NullTime) {
	m.deleted_at = &st
}

// DeletedAt returns the value of the "deleted_at" field in the mutation.
func (m *FieldTypeMutation) DeletedAt() (r sql.NullTime, exists bool) {
	v := m.deleted_at
	if v == nil {
		return
	}
	return *v, true
}

// OldDeletedAt returns the old "deleted_at" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldDeletedAt(ctx context.Context) (v sql.NullTime, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDeletedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDeletedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeletedAt: %w", err)
	}
	return oldValue.DeletedAt, nil
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (m *FieldTypeMutation) ClearDeletedAt() {
	m.deleted_at = nil
	m.clearedFields[fieldtype.FieldDeletedAt] = struct{}{}
}

// DeletedAtCleared returns if the "deleted_at" field was cleared in this mutation.
func (m *FieldTypeMutation) DeletedAtCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldDeletedAt]
	return ok
}

// ResetDeletedAt resets all changes to the "deleted_at" field.
func (m *FieldTypeMutation) ResetDeletedAt() {
	m.deleted_at = nil
	delete(m.clearedFields, fieldtype.FieldDeletedAt)
}

// SetIP sets the "ip" field.
func (m *FieldTypeMutation) SetIP(n net.IP) {
	m.ip = &n
}

// IP returns the value of the "ip" field in the mutation.
func (m *FieldTypeMutation) IP() (r net.IP, exists bool) {
	v := m.ip
	if v == nil {
		return
	}
	return *v, true
}

// OldIP returns the old "ip" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldIP(ctx context.Context) (v net.IP, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldIP is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldIP requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldIP: %w", err)
	}
	return oldValue.IP, nil
}

// ClearIP clears the value of the "ip" field.
func (m *FieldTypeMutation) ClearIP() {
	m.ip = nil
	m.clearedFields[fieldtype.FieldIP] = struct{}{}
}

// IPCleared returns if the "ip" field was cleared in this mutation.
func (m *FieldTypeMutation) IPCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldIP]
	return ok
}

// ResetIP resets all changes to the "ip" field.
func (m *FieldTypeMutation) ResetIP() {
	m.ip = nil
	delete(m.clearedFields, fieldtype.FieldIP)
}

// SetNullInt64 sets the "null_int64" field.
func (m *FieldTypeMutation) SetNullInt64(si sql.NullInt64) {
	m.null_int64 = &si
}

// NullInt64 returns the value of the "null_int64" field in the mutation.
func (m *FieldTypeMutation) NullInt64() (r sql.NullInt64, exists bool) {
	v := m.null_int64
	if v == nil {
		return
	}
	return *v, true
}

// OldNullInt64 returns the old "null_int64" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNullInt64(ctx context.Context) (v sql.NullInt64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNullInt64 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNullInt64 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNullInt64: %w", err)
	}
	return oldValue.NullInt64, nil
}

// ClearNullInt64 clears the value of the "null_int64" field.
func (m *FieldTypeMutation) ClearNullInt64() {
	m.null_int64 = nil
	m.clearedFields[fieldtype.FieldNullInt64] = struct{}{}
}

// NullInt64Cleared returns if the "null_int64" field was cleared in this mutation.
func (m *FieldTypeMutation) NullInt64Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNullInt64]
	return ok
}

// ResetNullInt64 resets all changes to the "null_int64" field.
func (m *FieldTypeMutation) ResetNullInt64() {
	m.null_int64 = nil
	delete(m.clearedFields, fieldtype.FieldNullInt64)
}

// SetSchemaInt sets the "schema_int" field.
func (m *FieldTypeMutation) SetSchemaInt(s schema.Int) {
	m.schema_int = &s
	m.addschema_int = nil
}

// SchemaInt returns the value of the "schema_int" field in the mutation.
func (m *FieldTypeMutation) SchemaInt() (r schema.Int, exists bool) {
	v := m.schema_int
	if v == nil {
		return
	}
	return *v, true
}

// OldSchemaInt returns the old "schema_int" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldSchemaInt(ctx context.Context) (v schema.Int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSchemaInt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSchemaInt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSchemaInt: %w", err)
	}
	return oldValue.SchemaInt, nil
}

// AddSchemaInt adds s to the "schema_int" field.
func (m *FieldTypeMutation) AddSchemaInt(s schema.Int) {
	if m.addschema_int != nil {
		*m.addschema_int += s
	} else {
		m.addschema_int = &s
	}
}

// AddedSchemaInt returns the value that was added to the "schema_int" field in this mutation.
func (m *FieldTypeMutation) AddedSchemaInt() (r schema.Int, exists bool) {
	v := m.addschema_int
	if v == nil {
		return
	}
	return *v, true
}

// ClearSchemaInt clears the value of the "schema_int" field.
func (m *FieldTypeMutation) ClearSchemaInt() {
	m.schema_int = nil
	m.addschema_int = nil
	m.clearedFields[fieldtype.FieldSchemaInt] = struct{}{}
}

// SchemaIntCleared returns if the "schema_int" field was cleared in this mutation.
func (m *FieldTypeMutation) SchemaIntCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldSchemaInt]
	return ok
}

// ResetSchemaInt resets all changes to the "schema_int" field.
func (m *FieldTypeMutation) ResetSchemaInt() {
	m.schema_int = nil
	m.addschema_int = nil
	delete(m.clearedFields, fieldtype.FieldSchemaInt)
}

// SetSchemaInt8 sets the "schema_int8" field.
func (m *FieldTypeMutation) SetSchemaInt8(s schema.Int8) {
	m.schema_int8 = &s
	m.addschema_int8 = nil
}

// SchemaInt8 returns the value of the "schema_int8" field in the mutation.
func (m *FieldTypeMutation) SchemaInt8() (r schema.Int8, exists bool) {
	v := m.schema_int8
	if v == nil {
		return
	}
	return *v, true
}

// OldSchemaInt8 returns the old "schema_int8" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldSchemaInt8(ctx context.Context) (v schema.Int8, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSchemaInt8 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSchemaInt8 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSchemaInt8: %w", err)
	}
	return oldValue.SchemaInt8, nil
}

// AddSchemaInt8 adds s to the "schema_int8" field.
func (m *FieldTypeMutation) AddSchemaInt8(s schema.Int8) {
	if m.addschema_int8 != nil {
		*m.addschema_int8 += s
	} else {
		m.addschema_int8 = &s
	}
}

// AddedSchemaInt8 returns the value that was added to the "schema_int8" field in this mutation.
func (m *FieldTypeMutation) AddedSchemaInt8() (r schema.Int8, exists bool) {
	v := m.addschema_int8
	if v == nil {
		return
	}
	return *v, true
}

// ClearSchemaInt8 clears the value of the "schema_int8" field.
func (m *FieldTypeMutation) ClearSchemaInt8() {
	m.schema_int8 = nil
	m.addschema_int8 = nil
	m.clearedFields[fieldtype.FieldSchemaInt8] = struct{}{}
}

// SchemaInt8Cleared returns if the "schema_int8" field was cleared in this mutation.
func (m *FieldTypeMutation) SchemaInt8Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldSchemaInt8]
	return ok
}

// ResetSchemaInt8 resets all changes to the "schema_int8" field.
func (m *FieldTypeMutation) ResetSchemaInt8() {
	m.schema_int8 = nil
	m.addschema_int8 = nil
	delete(m.clearedFields, fieldtype.FieldSchemaInt8)
}

// SetSchemaInt64 sets the "schema_int64" field.
func (m *FieldTypeMutation) SetSchemaInt64(s schema.Int64) {
	m.schema_int64 = &s
	m.addschema_int64 = nil
}

// SchemaInt64 returns the value of the "schema_int64" field in the mutation.
func (m *FieldTypeMutation) SchemaInt64() (r schema.Int64, exists bool) {
	v := m.schema_int64
	if v == nil {
		return
	}
	return *v, true
}

// OldSchemaInt64 returns the old "schema_int64" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldSchemaInt64(ctx context.Context) (v schema.Int64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSchemaInt64 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSchemaInt64 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSchemaInt64: %w", err)
	}
	return oldValue.SchemaInt64, nil
}

// AddSchemaInt64 adds s to the "schema_int64" field.
func (m *FieldTypeMutation) AddSchemaInt64(s schema.Int64) {
	if m.addschema_int64 != nil {
		*m.addschema_int64 += s
	} else {
		m.addschema_int64 = &s
	}
}

// AddedSchemaInt64 returns the value that was added to the "schema_int64" field in this mutation.
func (m *FieldTypeMutation) AddedSchemaInt64() (r schema.Int64, exists bool) {
	v := m.addschema_int64
	if v == nil {
		return
	}
	return *v, true
}

// ClearSchemaInt64 clears the value of the "schema_int64" field.
func (m *FieldTypeMutation) ClearSchemaInt64() {
	m.schema_int64 = nil
	m.addschema_int64 = nil
	m.clearedFields[fieldtype.FieldSchemaInt64] = struct{}{}
}

// SchemaInt64Cleared returns if the "schema_int64" field was cleared in this mutation.
func (m *FieldTypeMutation) SchemaInt64Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldSchemaInt64]
	return ok
}

// ResetSchemaInt64 resets all changes to the "schema_int64" field.
func (m *FieldTypeMutation) ResetSchemaInt64() {
	m.schema_int64 = nil
	m.addschema_int64 = nil
	delete(m.clearedFields, fieldtype.FieldSchemaInt64)
}

// SetSchemaFloat sets the "schema_float" field.
func (m *FieldTypeMutation) SetSchemaFloat(s schema.Float64) {
	m.schema_float = &s
	m.addschema_float = nil
}

// SchemaFloat returns the value of the "schema_float" field in the mutation.
func (m *FieldTypeMutation) SchemaFloat() (r schema.Float64, exists bool) {
	v := m.schema_float
	if v == nil {
		return
	}
	return *v, true
}

// OldSchemaFloat returns the old "schema_float" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldSchemaFloat(ctx context.Context) (v schema.Float64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSchemaFloat is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSchemaFloat requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSchemaFloat: %w", err)
	}
	return oldValue.SchemaFloat, nil
}

// AddSchemaFloat adds s to the "schema_float" field.
func (m *FieldTypeMutation) AddSchemaFloat(s schema.Float64) {
	if m.addschema_float != nil {
		*m.addschema_float += s
	} else {
		m.addschema_float = &s
	}
}

// AddedSchemaFloat returns the value that was added to the "schema_float" field in this mutation.
func (m *FieldTypeMutation) AddedSchemaFloat() (r schema.Float64, exists bool) {
	v := m.addschema_float
	if v == nil {
		return
	}
	return *v, true
}

// ClearSchemaFloat clears the value of the "schema_float" field.
func (m *FieldTypeMutation) ClearSchemaFloat() {
	m.schema_float = nil
	m.addschema_float = nil
	m.clearedFields[fieldtype.FieldSchemaFloat] = struct{}{}
}

// SchemaFloatCleared returns if the "schema_float" field was cleared in this mutation.
func (m *FieldTypeMutation) SchemaFloatCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldSchemaFloat]
	return ok
}

// ResetSchemaFloat resets all changes to the "schema_float" field.
func (m *FieldTypeMutation) ResetSchemaFloat() {
	m.schema_float = nil
	m.addschema_float = nil
	delete(m.clearedFields, fieldtype.FieldSchemaFloat)
}

// SetSchemaFloat32 sets the "schema_float32" field.
func (m *FieldTypeMutation) SetSchemaFloat32(s schema.Float32) {
	m.schema_float32 = &s
	m.addschema_float32 = nil
}

// SchemaFloat32 returns the value of the "schema_float32" field in the mutation.
func (m *FieldTypeMutation) SchemaFloat32() (r schema.Float32, exists bool) {
	v := m.schema_float32
	if v == nil {
		return
	}
	return *v, true
}

// OldSchemaFloat32 returns the old "schema_float32" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldSchemaFloat32(ctx context.Context) (v schema.Float32, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSchemaFloat32 is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSchemaFloat32 requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSchemaFloat32: %w", err)
	}
	return oldValue.SchemaFloat32, nil
}

// AddSchemaFloat32 adds s to the "schema_float32" field.
func (m *FieldTypeMutation) AddSchemaFloat32(s schema.Float32) {
	if m.addschema_float32 != nil {
		*m.addschema_float32 += s
	} else {
		m.addschema_float32 = &s
	}
}

// AddedSchemaFloat32 returns the value that was added to the "schema_float32" field in this mutation.
func (m *FieldTypeMutation) AddedSchemaFloat32() (r schema.Float32, exists bool) {
	v := m.addschema_float32
	if v == nil {
		return
	}
	return *v, true
}

// ClearSchemaFloat32 clears the value of the "schema_float32" field.
func (m *FieldTypeMutation) ClearSchemaFloat32() {
	m.schema_float32 = nil
	m.addschema_float32 = nil
	m.clearedFields[fieldtype.FieldSchemaFloat32] = struct{}{}
}

// SchemaFloat32Cleared returns if the "schema_float32" field was cleared in this mutation.
func (m *FieldTypeMutation) SchemaFloat32Cleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldSchemaFloat32]
	return ok
}

// ResetSchemaFloat32 resets all changes to the "schema_float32" field.
func (m *FieldTypeMutation) ResetSchemaFloat32() {
	m.schema_float32 = nil
	m.addschema_float32 = nil
	delete(m.clearedFields, fieldtype.FieldSchemaFloat32)
}

// SetNullFloat sets the "null_float" field.
func (m *FieldTypeMutation) SetNullFloat(sf sql.NullFloat64) {
	m.null_float = &sf
}

// NullFloat returns the value of the "null_float" field in the mutation.
func (m *FieldTypeMutation) NullFloat() (r sql.NullFloat64, exists bool) {
	v := m.null_float
	if v == nil {
		return
	}
	return *v, true
}

// OldNullFloat returns the old "null_float" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldNullFloat(ctx context.Context) (v sql.NullFloat64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNullFloat is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNullFloat requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNullFloat: %w", err)
	}
	return oldValue.NullFloat, nil
}

// ClearNullFloat clears the value of the "null_float" field.
func (m *FieldTypeMutation) ClearNullFloat() {
	m.null_float = nil
	m.clearedFields[fieldtype.FieldNullFloat] = struct{}{}
}

// NullFloatCleared returns if the "null_float" field was cleared in this mutation.
func (m *FieldTypeMutation) NullFloatCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldNullFloat]
	return ok
}

// ResetNullFloat resets all changes to the "null_float" field.
func (m *FieldTypeMutation) ResetNullFloat() {
	m.null_float = nil
	delete(m.clearedFields, fieldtype.FieldNullFloat)
}

// SetRole sets the "role" field.
func (m *FieldTypeMutation) SetRole(r role.Role) {
	m.role = &r
}

// Role returns the value of the "role" field in the mutation.
func (m *FieldTypeMutation) Role() (r role.Role, exists bool) {
	v := m.role
	if v == nil {
		return
	}
	return *v, true
}

// OldRole returns the old "role" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldRole(ctx context.Context) (v role.Role, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldRole is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldRole requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRole: %w", err)
	}
	return oldValue.Role, nil
}

// ResetRole resets all changes to the "role" field.
func (m *FieldTypeMutation) ResetRole() {
	m.role = nil
}

// SetMAC sets the "mac" field.
func (m *FieldTypeMutation) SetMAC(s schema.MAC) {
	m.mac = &s
}

// MAC returns the value of the "mac" field in the mutation.
func (m *FieldTypeMutation) MAC() (r schema.MAC, exists bool) {
	v := m.mac
	if v == nil {
		return
	}
	return *v, true
}

// OldMAC returns the old "mac" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldMAC(ctx context.Context) (v schema.MAC, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldMAC is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldMAC requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMAC: %w", err)
	}
	return oldValue.MAC, nil
}

// ClearMAC clears the value of the "mac" field.
func (m *FieldTypeMutation) ClearMAC() {
	m.mac = nil
	m.clearedFields[fieldtype.FieldMAC] = struct{}{}
}

// MACCleared returns if the "mac" field was cleared in this mutation.
func (m *FieldTypeMutation) MACCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldMAC]
	return ok
}

// ResetMAC resets all changes to the "mac" field.
func (m *FieldTypeMutation) ResetMAC() {
	m.mac = nil
	delete(m.clearedFields, fieldtype.FieldMAC)
}

// SetUUID sets the "uuid" field.
func (m *FieldTypeMutation) SetUUID(u uuid.UUID) {
	m.uuid = &u
}

// UUID returns the value of the "uuid" field in the mutation.
func (m *FieldTypeMutation) UUID() (r uuid.UUID, exists bool) {
	v := m.uuid
	if v == nil {
		return
	}
	return *v, true
}

// OldUUID returns the old "uuid" field's value of the FieldType entity.
// If the FieldType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FieldTypeMutation) OldUUID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUUID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUUID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUUID: %w", err)
	}
	return oldValue.UUID, nil
}

// ClearUUID clears the value of the "uuid" field.
func (m *FieldTypeMutation) ClearUUID() {
	m.uuid = nil
	m.clearedFields[fieldtype.FieldUUID] = struct{}{}
}

// UUIDCleared returns if the "uuid" field was cleared in this mutation.
func (m *FieldTypeMutation) UUIDCleared() bool {
	_, ok := m.clearedFields[fieldtype.FieldUUID]
	return ok
}

// ResetUUID resets all changes to the "uuid" field.
func (m *FieldTypeMutation) ResetUUID() {
	m.uuid = nil
	delete(m.clearedFields, fieldtype.FieldUUID)
}

// Op returns the operation name.
func (m *FieldTypeMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (FieldType).
func (m *FieldTypeMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *FieldTypeMutation) Fields() []string {
	fields := make([]string, 0, 47)
	if m.int != nil {
		fields = append(fields, fieldtype.FieldInt)
	}
	if m.int8 != nil {
		fields = append(fields, fieldtype.FieldInt8)
	}
	if m.int16 != nil {
		fields = append(fields, fieldtype.FieldInt16)
	}
	if m.int32 != nil {
		fields = append(fields, fieldtype.FieldInt32)
	}
	if m.int64 != nil {
		fields = append(fields, fieldtype.FieldInt64)
	}
	if m.optional_int != nil {
		fields = append(fields, fieldtype.FieldOptionalInt)
	}
	if m.optional_int8 != nil {
		fields = append(fields, fieldtype.FieldOptionalInt8)
	}
	if m.optional_int16 != nil {
		fields = append(fields, fieldtype.FieldOptionalInt16)
	}
	if m.optional_int32 != nil {
		fields = append(fields, fieldtype.FieldOptionalInt32)
	}
	if m.optional_int64 != nil {
		fields = append(fields, fieldtype.FieldOptionalInt64)
	}
	if m.nillable_int != nil {
		fields = append(fields, fieldtype.FieldNillableInt)
	}
	if m.nillable_int8 != nil {
		fields = append(fields, fieldtype.FieldNillableInt8)
	}
	if m.nillable_int16 != nil {
		fields = append(fields, fieldtype.FieldNillableInt16)
	}
	if m.nillable_int32 != nil {
		fields = append(fields, fieldtype.FieldNillableInt32)
	}
	if m.nillable_int64 != nil {
		fields = append(fields, fieldtype.FieldNillableInt64)
	}
	if m.validate_optional_int32 != nil {
		fields = append(fields, fieldtype.FieldValidateOptionalInt32)
	}
	if m.optional_uint != nil {
		fields = append(fields, fieldtype.FieldOptionalUint)
	}
	if m.optional_uint8 != nil {
		fields = append(fields, fieldtype.FieldOptionalUint8)
	}
	if m.optional_uint16 != nil {
		fields = append(fields, fieldtype.FieldOptionalUint16)
	}
	if m.optional_uint32 != nil {
		fields = append(fields, fieldtype.FieldOptionalUint32)
	}
	if m.optional_uint64 != nil {
		fields = append(fields, fieldtype.FieldOptionalUint64)
	}
	if m.state != nil {
		fields = append(fields, fieldtype.FieldState)
	}
	if m.optional_float != nil {
		fields = append(fields, fieldtype.FieldOptionalFloat)
	}
	if m.optional_float32 != nil {
		fields = append(fields, fieldtype.FieldOptionalFloat32)
	}
	if m.datetime != nil {
		fields = append(fields, fieldtype.FieldDatetime)
	}
	if m.decimal != nil {
		fields = append(fields, fieldtype.FieldDecimal)
	}
	if m.dir != nil {
		fields = append(fields, fieldtype.FieldDir)
	}
	if m.ndir != nil {
		fields = append(fields, fieldtype.FieldNdir)
	}
	if m.str != nil {
		fields = append(fields, fieldtype.FieldStr)
	}
	if m.null_str != nil {
		fields = append(fields, fieldtype.FieldNullStr)
	}
	if m.link != nil {
		fields = append(fields, fieldtype.FieldLink)
	}
	if m.null_link != nil {
		fields = append(fields, fieldtype.FieldNullLink)
	}
	if m.active != nil {
		fields = append(fields, fieldtype.FieldActive)
	}
	if m.null_active != nil {
		fields = append(fields, fieldtype.FieldNullActive)
	}
	if m.deleted != nil {
		fields = append(fields, fieldtype.FieldDeleted)
	}
	if m.deleted_at != nil {
		fields = append(fields, fieldtype.FieldDeletedAt)
	}
	if m.ip != nil {
		fields = append(fields, fieldtype.FieldIP)
	}
	if m.null_int64 != nil {
		fields = append(fields, fieldtype.FieldNullInt64)
	}
	if m.schema_int != nil {
		fields = append(fields, fieldtype.FieldSchemaInt)
	}
	if m.schema_int8 != nil {
		fields = append(fields, fieldtype.FieldSchemaInt8)
	}
	if m.schema_int64 != nil {
		fields = append(fields, fieldtype.FieldSchemaInt64)
	}
	if m.schema_float != nil {
		fields = append(fields, fieldtype.FieldSchemaFloat)
	}
	if m.schema_float32 != nil {
		fields = append(fields, fieldtype.FieldSchemaFloat32)
	}
	if m.null_float != nil {
		fields = append(fields, fieldtype.FieldNullFloat)
	}
	if m.role != nil {
		fields = append(fields, fieldtype.FieldRole)
	}
	if m.mac != nil {
		fields = append(fields, fieldtype.FieldMAC)
	}
	if m.uuid != nil {
		fields = append(fields, fieldtype.FieldUUID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *FieldTypeMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case fieldtype.FieldInt:
		return m.Int()
	case fieldtype.FieldInt8:
		return m.Int8()
	case fieldtype.FieldInt16:
		return m.Int16()
	case fieldtype.FieldInt32:
		return m.Int32()
	case fieldtype.FieldInt64:
		return m.Int64()
	case fieldtype.FieldOptionalInt:
		return m.OptionalInt()
	case fieldtype.FieldOptionalInt8:
		return m.OptionalInt8()
	case fieldtype.FieldOptionalInt16:
		return m.OptionalInt16()
	case fieldtype.FieldOptionalInt32:
		return m.OptionalInt32()
	case fieldtype.FieldOptionalInt64:
		return m.OptionalInt64()
	case fieldtype.FieldNillableInt:
		return m.NillableInt()
	case fieldtype.FieldNillableInt8:
		return m.NillableInt8()
	case fieldtype.FieldNillableInt16:
		return m.NillableInt16()
	case fieldtype.FieldNillableInt32:
		return m.NillableInt32()
	case fieldtype.FieldNillableInt64:
		return m.NillableInt64()
	case fieldtype.FieldValidateOptionalInt32:
		return m.ValidateOptionalInt32()
	case fieldtype.FieldOptionalUint:
		return m.OptionalUint()
	case fieldtype.FieldOptionalUint8:
		return m.OptionalUint8()
	case fieldtype.FieldOptionalUint16:
		return m.OptionalUint16()
	case fieldtype.FieldOptionalUint32:
		return m.OptionalUint32()
	case fieldtype.FieldOptionalUint64:
		return m.OptionalUint64()
	case fieldtype.FieldState:
		return m.State()
	case fieldtype.FieldOptionalFloat:
		return m.OptionalFloat()
	case fieldtype.FieldOptionalFloat32:
		return m.OptionalFloat32()
	case fieldtype.FieldDatetime:
		return m.Datetime()
	case fieldtype.FieldDecimal:
		return m.Decimal()
	case fieldtype.FieldDir:
		return m.Dir()
	case fieldtype.FieldNdir:
		return m.Ndir()
	case fieldtype.FieldStr:
		return m.Str()
	case fieldtype.FieldNullStr:
		return m.NullStr()
	case fieldtype.FieldLink:
		return m.Link()
	case fieldtype.FieldNullLink:
		return m.NullLink()
	case fieldtype.FieldActive:
		return m.Active()
	case fieldtype.FieldNullActive:
		return m.NullActive()
	case fieldtype.FieldDeleted:
		return m.Deleted()
	case fieldtype.FieldDeletedAt:
		return m.DeletedAt()
	case fieldtype.FieldIP:
		return m.IP()
	case fieldtype.FieldNullInt64:
		return m.NullInt64()
	case fieldtype.FieldSchemaInt:
		return m.SchemaInt()
	case fieldtype.FieldSchemaInt8:
		return m.SchemaInt8()
	case fieldtype.FieldSchemaInt64:
		return m.SchemaInt64()
	case fieldtype.FieldSchemaFloat:
		return m.SchemaFloat()
	case fieldtype.FieldSchemaFloat32:
		return m.SchemaFloat32()
	case fieldtype.FieldNullFloat:
		return m.NullFloat()
	case fieldtype.FieldRole:
		return m.Role()
	case fieldtype.FieldMAC:
		return m.MAC()
	case fieldtype.FieldUUID:
		return m.UUID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *FieldTypeMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case fieldtype.FieldInt:
		return m.OldInt(ctx)
	case fieldtype.FieldInt8:
		return m.OldInt8(ctx)
	case fieldtype.FieldInt16:
		return m.OldInt16(ctx)
	case fieldtype.FieldInt32:
		return m.OldInt32(ctx)
	case fieldtype.FieldInt64:
		return m.OldInt64(ctx)
	case fieldtype.FieldOptionalInt:
		return m.OldOptionalInt(ctx)
	case fieldtype.FieldOptionalInt8:
		return m.OldOptionalInt8(ctx)
	case fieldtype.FieldOptionalInt16:
		return m.OldOptionalInt16(ctx)
	case fieldtype.FieldOptionalInt32:
		return m.OldOptionalInt32(ctx)
	case fieldtype.FieldOptionalInt64:
		return m.OldOptionalInt64(ctx)
	case fieldtype.FieldNillableInt:
		return m.OldNillableInt(ctx)
	case fieldtype.FieldNillableInt8:
		return m.OldNillableInt8(ctx)
	case fieldtype.FieldNillableInt16:
		return m.OldNillableInt16(ctx)
	case fieldtype.FieldNillableInt32:
		return m.OldNillableInt32(ctx)
	case fieldtype.FieldNillableInt64:
		return m.OldNillableInt64(ctx)
	case fieldtype.FieldValidateOptionalInt32:
		return m.OldValidateOptionalInt32(ctx)
	case fieldtype.FieldOptionalUint:
		return m.OldOptionalUint(ctx)
	case fieldtype.FieldOptionalUint8:
		return m.OldOptionalUint8(ctx)
	case fieldtype.FieldOptionalUint16:
		return m.OldOptionalUint16(ctx)
	case fieldtype.FieldOptionalUint32:
		return m.OldOptionalUint32(ctx)
	case fieldtype.FieldOptionalUint64:
		return m.OldOptionalUint64(ctx)
	case fieldtype.FieldState:
		return m.OldState(ctx)
	case fieldtype.FieldOptionalFloat:
		return m.OldOptionalFloat(ctx)
	case fieldtype.FieldOptionalFloat32:
		return m.OldOptionalFloat32(ctx)
	case fieldtype.FieldDatetime:
		return m.OldDatetime(ctx)
	case fieldtype.FieldDecimal:
		return m.OldDecimal(ctx)
	case fieldtype.FieldDir:
		return m.OldDir(ctx)
	case fieldtype.FieldNdir:
		return m.OldNdir(ctx)
	case fieldtype.FieldStr:
		return m.OldStr(ctx)
	case fieldtype.FieldNullStr:
		return m.OldNullStr(ctx)
	case fieldtype.FieldLink:
		return m.OldLink(ctx)
	case fieldtype.FieldNullLink:
		return m.OldNullLink(ctx)
	case fieldtype.FieldActive:
		return m.OldActive(ctx)
	case fieldtype.FieldNullActive:
		return m.OldNullActive(ctx)
	case fieldtype.FieldDeleted:
		return m.OldDeleted(ctx)
	case fieldtype.FieldDeletedAt:
		return m.OldDeletedAt(ctx)
	case fieldtype.FieldIP:
		return m.OldIP(ctx)
	case fieldtype.FieldNullInt64:
		return m.OldNullInt64(ctx)
	case fieldtype.FieldSchemaInt:
		return m.OldSchemaInt(ctx)
	case fieldtype.FieldSchemaInt8:
		return m.OldSchemaInt8(ctx)
	case fieldtype.FieldSchemaInt64:
		return m.OldSchemaInt64(ctx)
	case fieldtype.FieldSchemaFloat:
		return m.OldSchemaFloat(ctx)
	case fieldtype.FieldSchemaFloat32:
		return m.OldSchemaFloat32(ctx)
	case fieldtype.FieldNullFloat:
		return m.OldNullFloat(ctx)
	case fieldtype.FieldRole:
		return m.OldRole(ctx)
	case fieldtype.FieldMAC:
		return m.OldMAC(ctx)
	case fieldtype.FieldUUID:
		return m.OldUUID(ctx)
	}
	return nil, fmt.Errorf("unknown FieldType field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *FieldTypeMutation) SetField(name string, value ent.Value) error {
	switch name {
	case fieldtype.FieldInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInt(v)
		return nil
	case fieldtype.FieldInt8:
		v, ok := value.(int8)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInt8(v)
		return nil
	case fieldtype.FieldInt16:
		v, ok := value.(int16)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInt16(v)
		return nil
	case fieldtype.FieldInt32:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInt32(v)
		return nil
	case fieldtype.FieldInt64:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInt64(v)
		return nil
	case fieldtype.FieldOptionalInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalInt(v)
		return nil
	case fieldtype.FieldOptionalInt8:
		v, ok := value.(int8)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalInt8(v)
		return nil
	case fieldtype.FieldOptionalInt16:
		v, ok := value.(int16)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalInt16(v)
		return nil
	case fieldtype.FieldOptionalInt32:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalInt32(v)
		return nil
	case fieldtype.FieldOptionalInt64:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalInt64(v)
		return nil
	case fieldtype.FieldNillableInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNillableInt(v)
		return nil
	case fieldtype.FieldNillableInt8:
		v, ok := value.(int8)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNillableInt8(v)
		return nil
	case fieldtype.FieldNillableInt16:
		v, ok := value.(int16)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNillableInt16(v)
		return nil
	case fieldtype.FieldNillableInt32:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNillableInt32(v)
		return nil
	case fieldtype.FieldNillableInt64:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNillableInt64(v)
		return nil
	case fieldtype.FieldValidateOptionalInt32:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetValidateOptionalInt32(v)
		return nil
	case fieldtype.FieldOptionalUint:
		v, ok := value.(uint)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalUint(v)
		return nil
	case fieldtype.FieldOptionalUint8:
		v, ok := value.(uint8)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalUint8(v)
		return nil
	case fieldtype.FieldOptionalUint16:
		v, ok := value.(uint16)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalUint16(v)
		return nil
	case fieldtype.FieldOptionalUint32:
		v, ok := value.(uint32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalUint32(v)
		return nil
	case fieldtype.FieldOptionalUint64:
		v, ok := value.(uint64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalUint64(v)
		return nil
	case fieldtype.FieldState:
		v, ok := value.(fieldtype.State)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetState(v)
		return nil
	case fieldtype.FieldOptionalFloat:
		v, ok := value.(float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalFloat(v)
		return nil
	case fieldtype.FieldOptionalFloat32:
		v, ok := value.(float32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalFloat32(v)
		return nil
	case fieldtype.FieldDatetime:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDatetime(v)
		return nil
	case fieldtype.FieldDecimal:
		v, ok := value.(float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDecimal(v)
		return nil
	case fieldtype.FieldDir:
		v, ok := value.(http.Dir)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDir(v)
		return nil
	case fieldtype.FieldNdir:
		v, ok := value.(http.Dir)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNdir(v)
		return nil
	case fieldtype.FieldStr:
		v, ok := value.(sql.NullString)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStr(v)
		return nil
	case fieldtype.FieldNullStr:
		v, ok := value.(sql.NullString)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNullStr(v)
		return nil
	case fieldtype.FieldLink:
		v, ok := value.(schema.Link)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLink(v)
		return nil
	case fieldtype.FieldNullLink:
		v, ok := value.(schema.Link)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNullLink(v)
		return nil
	case fieldtype.FieldActive:
		v, ok := value.(schema.Status)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetActive(v)
		return nil
	case fieldtype.FieldNullActive:
		v, ok := value.(schema.Status)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNullActive(v)
		return nil
	case fieldtype.FieldDeleted:
		v, ok := value.(sql.NullBool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeleted(v)
		return nil
	case fieldtype.FieldDeletedAt:
		v, ok := value.(sql.NullTime)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeletedAt(v)
		return nil
	case fieldtype.FieldIP:
		v, ok := value.(net.IP)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetIP(v)
		return nil
	case fieldtype.FieldNullInt64:
		v, ok := value.(sql.NullInt64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNullInt64(v)
		return nil
	case fieldtype.FieldSchemaInt:
		v, ok := value.(schema.Int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSchemaInt(v)
		return nil
	case fieldtype.FieldSchemaInt8:
		v, ok := value.(schema.Int8)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSchemaInt8(v)
		return nil
	case fieldtype.FieldSchemaInt64:
		v, ok := value.(schema.Int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSchemaInt64(v)
		return nil
	case fieldtype.FieldSchemaFloat:
		v, ok := value.(schema.Float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSchemaFloat(v)
		return nil
	case fieldtype.FieldSchemaFloat32:
		v, ok := value.(schema.Float32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSchemaFloat32(v)
		return nil
	case fieldtype.FieldNullFloat:
		v, ok := value.(sql.NullFloat64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNullFloat(v)
		return nil
	case fieldtype.FieldRole:
		v, ok := value.(role.Role)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRole(v)
		return nil
	case fieldtype.FieldMAC:
		v, ok := value.(schema.MAC)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMAC(v)
		return nil
	case fieldtype.FieldUUID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUUID(v)
		return nil
	}
	return fmt.Errorf("unknown FieldType field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *FieldTypeMutation) AddedFields() []string {
	var fields []string
	if m.addint != nil {
		fields = append(fields, fieldtype.FieldInt)
	}
	if m.addint8 != nil {
		fields = append(fields, fieldtype.FieldInt8)
	}
	if m.addint16 != nil {
		fields = append(fields, fieldtype.FieldInt16)
	}
	if m.addint32 != nil {
		fields = append(fields, fieldtype.FieldInt32)
	}
	if m.addint64 != nil {
		fields = append(fields, fieldtype.FieldInt64)
	}
	if m.addoptional_int != nil {
		fields = append(fields, fieldtype.FieldOptionalInt)
	}
	if m.addoptional_int8 != nil {
		fields = append(fields, fieldtype.FieldOptionalInt8)
	}
	if m.addoptional_int16 != nil {
		fields = append(fields, fieldtype.FieldOptionalInt16)
	}
	if m.addoptional_int32 != nil {
		fields = append(fields, fieldtype.FieldOptionalInt32)
	}
	if m.addoptional_int64 != nil {
		fields = append(fields, fieldtype.FieldOptionalInt64)
	}
	if m.addnillable_int != nil {
		fields = append(fields, fieldtype.FieldNillableInt)
	}
	if m.addnillable_int8 != nil {
		fields = append(fields, fieldtype.FieldNillableInt8)
	}
	if m.addnillable_int16 != nil {
		fields = append(fields, fieldtype.FieldNillableInt16)
	}
	if m.addnillable_int32 != nil {
		fields = append(fields, fieldtype.FieldNillableInt32)
	}
	if m.addnillable_int64 != nil {
		fields = append(fields, fieldtype.FieldNillableInt64)
	}
	if m.addvalidate_optional_int32 != nil {
		fields = append(fields, fieldtype.FieldValidateOptionalInt32)
	}
	if m.addoptional_uint != nil {
		fields = append(fields, fieldtype.FieldOptionalUint)
	}
	if m.addoptional_uint8 != nil {
		fields = append(fields, fieldtype.FieldOptionalUint8)
	}
	if m.addoptional_uint16 != nil {
		fields = append(fields, fieldtype.FieldOptionalUint16)
	}
	if m.addoptional_uint32 != nil {
		fields = append(fields, fieldtype.FieldOptionalUint32)
	}
	if m.addoptional_uint64 != nil {
		fields = append(fields, fieldtype.FieldOptionalUint64)
	}
	if m.addoptional_float != nil {
		fields = append(fields, fieldtype.FieldOptionalFloat)
	}
	if m.addoptional_float32 != nil {
		fields = append(fields, fieldtype.FieldOptionalFloat32)
	}
	if m.adddecimal != nil {
		fields = append(fields, fieldtype.FieldDecimal)
	}
	if m.addschema_int != nil {
		fields = append(fields, fieldtype.FieldSchemaInt)
	}
	if m.addschema_int8 != nil {
		fields = append(fields, fieldtype.FieldSchemaInt8)
	}
	if m.addschema_int64 != nil {
		fields = append(fields, fieldtype.FieldSchemaInt64)
	}
	if m.addschema_float != nil {
		fields = append(fields, fieldtype.FieldSchemaFloat)
	}
	if m.addschema_float32 != nil {
		fields = append(fields, fieldtype.FieldSchemaFloat32)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *FieldTypeMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case fieldtype.FieldInt:
		return m.AddedInt()
	case fieldtype.FieldInt8:
		return m.AddedInt8()
	case fieldtype.FieldInt16:
		return m.AddedInt16()
	case fieldtype.FieldInt32:
		return m.AddedInt32()
	case fieldtype.FieldInt64:
		return m.AddedInt64()
	case fieldtype.FieldOptionalInt:
		return m.AddedOptionalInt()
	case fieldtype.FieldOptionalInt8:
		return m.AddedOptionalInt8()
	case fieldtype.FieldOptionalInt16:
		return m.AddedOptionalInt16()
	case fieldtype.FieldOptionalInt32:
		return m.AddedOptionalInt32()
	case fieldtype.FieldOptionalInt64:
		return m.AddedOptionalInt64()
	case fieldtype.FieldNillableInt:
		return m.AddedNillableInt()
	case fieldtype.FieldNillableInt8:
		return m.AddedNillableInt8()
	case fieldtype.FieldNillableInt16:
		return m.AddedNillableInt16()
	case fieldtype.FieldNillableInt32:
		return m.AddedNillableInt32()
	case fieldtype.FieldNillableInt64:
		return m.AddedNillableInt64()
	case fieldtype.FieldValidateOptionalInt32:
		return m.AddedValidateOptionalInt32()
	case fieldtype.FieldOptionalUint:
		return m.AddedOptionalUint()
	case fieldtype.FieldOptionalUint8:
		return m.AddedOptionalUint8()
	case fieldtype.FieldOptionalUint16:
		return m.AddedOptionalUint16()
	case fieldtype.FieldOptionalUint32:
		return m.AddedOptionalUint32()
	case fieldtype.FieldOptionalUint64:
		return m.AddedOptionalUint64()
	case fieldtype.FieldOptionalFloat:
		return m.AddedOptionalFloat()
	case fieldtype.FieldOptionalFloat32:
		return m.AddedOptionalFloat32()
	case fieldtype.FieldDecimal:
		return m.AddedDecimal()
	case fieldtype.FieldSchemaInt:
		return m.AddedSchemaInt()
	case fieldtype.FieldSchemaInt8:
		return m.AddedSchemaInt8()
	case fieldtype.FieldSchemaInt64:
		return m.AddedSchemaInt64()
	case fieldtype.FieldSchemaFloat:
		return m.AddedSchemaFloat()
	case fieldtype.FieldSchemaFloat32:
		return m.AddedSchemaFloat32()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *FieldTypeMutation) AddField(name string, value ent.Value) error {
	switch name {
	case fieldtype.FieldInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddInt(v)
		return nil
	case fieldtype.FieldInt8:
		v, ok := value.(int8)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddInt8(v)
		return nil
	case fieldtype.FieldInt16:
		v, ok := value.(int16)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddInt16(v)
		return nil
	case fieldtype.FieldInt32:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddInt32(v)
		return nil
	case fieldtype.FieldInt64:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddInt64(v)
		return nil
	case fieldtype.FieldOptionalInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalInt(v)
		return nil
	case fieldtype.FieldOptionalInt8:
		v, ok := value.(int8)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalInt8(v)
		return nil
	case fieldtype.FieldOptionalInt16:
		v, ok := value.(int16)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalInt16(v)
		return nil
	case fieldtype.FieldOptionalInt32:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalInt32(v)
		return nil
	case fieldtype.FieldOptionalInt64:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalInt64(v)
		return nil
	case fieldtype.FieldNillableInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddNillableInt(v)
		return nil
	case fieldtype.FieldNillableInt8:
		v, ok := value.(int8)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddNillableInt8(v)
		return nil
	case fieldtype.FieldNillableInt16:
		v, ok := value.(int16)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddNillableInt16(v)
		return nil
	case fieldtype.FieldNillableInt32:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddNillableInt32(v)
		return nil
	case fieldtype.FieldNillableInt64:
		v, ok := value.(int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddNillableInt64(v)
		return nil
	case fieldtype.FieldValidateOptionalInt32:
		v, ok := value.(int32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddValidateOptionalInt32(v)
		return nil
	case fieldtype.FieldOptionalUint:
		v, ok := value.(uint)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalUint(v)
		return nil
	case fieldtype.FieldOptionalUint8:
		v, ok := value.(uint8)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalUint8(v)
		return nil
	case fieldtype.FieldOptionalUint16:
		v, ok := value.(uint16)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalUint16(v)
		return nil
	case fieldtype.FieldOptionalUint32:
		v, ok := value.(uint32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalUint32(v)
		return nil
	case fieldtype.FieldOptionalUint64:
		v, ok := value.(uint64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalUint64(v)
		return nil
	case fieldtype.FieldOptionalFloat:
		v, ok := value.(float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalFloat(v)
		return nil
	case fieldtype.FieldOptionalFloat32:
		v, ok := value.(float32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalFloat32(v)
		return nil
	case fieldtype.FieldDecimal:
		v, ok := value.(float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddDecimal(v)
		return nil
	case fieldtype.FieldSchemaInt:
		v, ok := value.(schema.Int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddSchemaInt(v)
		return nil
	case fieldtype.FieldSchemaInt8:
		v, ok := value.(schema.Int8)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddSchemaInt8(v)
		return nil
	case fieldtype.FieldSchemaInt64:
		v, ok := value.(schema.Int64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddSchemaInt64(v)
		return nil
	case fieldtype.FieldSchemaFloat:
		v, ok := value.(schema.Float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddSchemaFloat(v)
		return nil
	case fieldtype.FieldSchemaFloat32:
		v, ok := value.(schema.Float32)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddSchemaFloat32(v)
		return nil
	}
	return fmt.Errorf("unknown FieldType numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *FieldTypeMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(fieldtype.FieldOptionalInt) {
		fields = append(fields, fieldtype.FieldOptionalInt)
	}
	if m.FieldCleared(fieldtype.FieldOptionalInt8) {
		fields = append(fields, fieldtype.FieldOptionalInt8)
	}
	if m.FieldCleared(fieldtype.FieldOptionalInt16) {
		fields = append(fields, fieldtype.FieldOptionalInt16)
	}
	if m.FieldCleared(fieldtype.FieldOptionalInt32) {
		fields = append(fields, fieldtype.FieldOptionalInt32)
	}
	if m.FieldCleared(fieldtype.FieldOptionalInt64) {
		fields = append(fields, fieldtype.FieldOptionalInt64)
	}
	if m.FieldCleared(fieldtype.FieldNillableInt) {
		fields = append(fields, fieldtype.FieldNillableInt)
	}
	if m.FieldCleared(fieldtype.FieldNillableInt8) {
		fields = append(fields, fieldtype.FieldNillableInt8)
	}
	if m.FieldCleared(fieldtype.FieldNillableInt16) {
		fields = append(fields, fieldtype.FieldNillableInt16)
	}
	if m.FieldCleared(fieldtype.FieldNillableInt32) {
		fields = append(fields, fieldtype.FieldNillableInt32)
	}
	if m.FieldCleared(fieldtype.FieldNillableInt64) {
		fields = append(fields, fieldtype.FieldNillableInt64)
	}
	if m.FieldCleared(fieldtype.FieldValidateOptionalInt32) {
		fields = append(fields, fieldtype.FieldValidateOptionalInt32)
	}
	if m.FieldCleared(fieldtype.FieldOptionalUint) {
		fields = append(fields, fieldtype.FieldOptionalUint)
	}
	if m.FieldCleared(fieldtype.FieldOptionalUint8) {
		fields = append(fields, fieldtype.FieldOptionalUint8)
	}
	if m.FieldCleared(fieldtype.FieldOptionalUint16) {
		fields = append(fields, fieldtype.FieldOptionalUint16)
	}
	if m.FieldCleared(fieldtype.FieldOptionalUint32) {
		fields = append(fields, fieldtype.FieldOptionalUint32)
	}
	if m.FieldCleared(fieldtype.FieldOptionalUint64) {
		fields = append(fields, fieldtype.FieldOptionalUint64)
	}
	if m.FieldCleared(fieldtype.FieldState) {
		fields = append(fields, fieldtype.FieldState)
	}
	if m.FieldCleared(fieldtype.FieldOptionalFloat) {
		fields = append(fields, fieldtype.FieldOptionalFloat)
	}
	if m.FieldCleared(fieldtype.FieldOptionalFloat32) {
		fields = append(fields, fieldtype.FieldOptionalFloat32)
	}
	if m.FieldCleared(fieldtype.FieldDatetime) {
		fields = append(fields, fieldtype.FieldDatetime)
	}
	if m.FieldCleared(fieldtype.FieldDecimal) {
		fields = append(fields, fieldtype.FieldDecimal)
	}
	if m.FieldCleared(fieldtype.FieldDir) {
		fields = append(fields, fieldtype.FieldDir)
	}
	if m.FieldCleared(fieldtype.FieldNdir) {
		fields = append(fields, fieldtype.FieldNdir)
	}
	if m.FieldCleared(fieldtype.FieldStr) {
		fields = append(fields, fieldtype.FieldStr)
	}
	if m.FieldCleared(fieldtype.FieldNullStr) {
		fields = append(fields, fieldtype.FieldNullStr)
	}
	if m.FieldCleared(fieldtype.FieldLink) {
		fields = append(fields, fieldtype.FieldLink)
	}
	if m.FieldCleared(fieldtype.FieldNullLink) {
		fields = append(fields, fieldtype.FieldNullLink)
	}
	if m.FieldCleared(fieldtype.FieldActive) {
		fields = append(fields, fieldtype.FieldActive)
	}
	if m.FieldCleared(fieldtype.FieldNullActive) {
		fields = append(fields, fieldtype.FieldNullActive)
	}
	if m.FieldCleared(fieldtype.FieldDeleted) {
		fields = append(fields, fieldtype.FieldDeleted)
	}
	if m.FieldCleared(fieldtype.FieldDeletedAt) {
		fields = append(fields, fieldtype.FieldDeletedAt)
	}
	if m.FieldCleared(fieldtype.FieldIP) {
		fields = append(fields, fieldtype.FieldIP)
	}
	if m.FieldCleared(fieldtype.FieldNullInt64) {
		fields = append(fields, fieldtype.FieldNullInt64)
	}
	if m.FieldCleared(fieldtype.FieldSchemaInt) {
		fields = append(fields, fieldtype.FieldSchemaInt)
	}
	if m.FieldCleared(fieldtype.FieldSchemaInt8) {
		fields = append(fields, fieldtype.FieldSchemaInt8)
	}
	if m.FieldCleared(fieldtype.FieldSchemaInt64) {
		fields = append(fields, fieldtype.FieldSchemaInt64)
	}
	if m.FieldCleared(fieldtype.FieldSchemaFloat) {
		fields = append(fields, fieldtype.FieldSchemaFloat)
	}
	if m.FieldCleared(fieldtype.FieldSchemaFloat32) {
		fields = append(fields, fieldtype.FieldSchemaFloat32)
	}
	if m.FieldCleared(fieldtype.FieldNullFloat) {
		fields = append(fields, fieldtype.FieldNullFloat)
	}
	if m.FieldCleared(fieldtype.FieldMAC) {
		fields = append(fields, fieldtype.FieldMAC)
	}
	if m.FieldCleared(fieldtype.FieldUUID) {
		fields = append(fields, fieldtype.FieldUUID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *FieldTypeMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *FieldTypeMutation) ClearField(name string) error {
	switch name {
	case fieldtype.FieldOptionalInt:
		m.ClearOptionalInt()
		return nil
	case fieldtype.FieldOptionalInt8:
		m.ClearOptionalInt8()
		return nil
	case fieldtype.FieldOptionalInt16:
		m.ClearOptionalInt16()
		return nil
	case fieldtype.FieldOptionalInt32:
		m.ClearOptionalInt32()
		return nil
	case fieldtype.FieldOptionalInt64:
		m.ClearOptionalInt64()
		return nil
	case fieldtype.FieldNillableInt:
		m.ClearNillableInt()
		return nil
	case fieldtype.FieldNillableInt8:
		m.ClearNillableInt8()
		return nil
	case fieldtype.FieldNillableInt16:
		m.ClearNillableInt16()
		return nil
	case fieldtype.FieldNillableInt32:
		m.ClearNillableInt32()
		return nil
	case fieldtype.FieldNillableInt64:
		m.ClearNillableInt64()
		return nil
	case fieldtype.FieldValidateOptionalInt32:
		m.ClearValidateOptionalInt32()
		return nil
	case fieldtype.FieldOptionalUint:
		m.ClearOptionalUint()
		return nil
	case fieldtype.FieldOptionalUint8:
		m.ClearOptionalUint8()
		return nil
	case fieldtype.FieldOptionalUint16:
		m.ClearOptionalUint16()
		return nil
	case fieldtype.FieldOptionalUint32:
		m.ClearOptionalUint32()
		return nil
	case fieldtype.FieldOptionalUint64:
		m.ClearOptionalUint64()
		return nil
	case fieldtype.FieldState:
		m.ClearState()
		return nil
	case fieldtype.FieldOptionalFloat:
		m.ClearOptionalFloat()
		return nil
	case fieldtype.FieldOptionalFloat32:
		m.ClearOptionalFloat32()
		return nil
	case fieldtype.FieldDatetime:
		m.ClearDatetime()
		return nil
	case fieldtype.FieldDecimal:
		m.ClearDecimal()
		return nil
	case fieldtype.FieldDir:
		m.ClearDir()
		return nil
	case fieldtype.FieldNdir:
		m.ClearNdir()
		return nil
	case fieldtype.FieldStr:
		m.ClearStr()
		return nil
	case fieldtype.FieldNullStr:
		m.ClearNullStr()
		return nil
	case fieldtype.FieldLink:
		m.ClearLink()
		return nil
	case fieldtype.FieldNullLink:
		m.ClearNullLink()
		return nil
	case fieldtype.FieldActive:
		m.ClearActive()
		return nil
	case fieldtype.FieldNullActive:
		m.ClearNullActive()
		return nil
	case fieldtype.FieldDeleted:
		m.ClearDeleted()
		return nil
	case fieldtype.FieldDeletedAt:
		m.ClearDeletedAt()
		return nil
	case fieldtype.FieldIP:
		m.ClearIP()
		return nil
	case fieldtype.FieldNullInt64:
		m.ClearNullInt64()
		return nil
	case fieldtype.FieldSchemaInt:
		m.ClearSchemaInt()
		return nil
	case fieldtype.FieldSchemaInt8:
		m.ClearSchemaInt8()
		return nil
	case fieldtype.FieldSchemaInt64:
		m.ClearSchemaInt64()
		return nil
	case fieldtype.FieldSchemaFloat:
		m.ClearSchemaFloat()
		return nil
	case fieldtype.FieldSchemaFloat32:
		m.ClearSchemaFloat32()
		return nil
	case fieldtype.FieldNullFloat:
		m.ClearNullFloat()
		return nil
	case fieldtype.FieldMAC:
		m.ClearMAC()
		return nil
	case fieldtype.FieldUUID:
		m.ClearUUID()
		return nil
	}
	return fmt.Errorf("unknown FieldType nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *FieldTypeMutation) ResetField(name string) error {
	switch name {
	case fieldtype.FieldInt:
		m.ResetInt()
		return nil
	case fieldtype.FieldInt8:
		m.ResetInt8()
		return nil
	case fieldtype.FieldInt16:
		m.ResetInt16()
		return nil
	case fieldtype.FieldInt32:
		m.ResetInt32()
		return nil
	case fieldtype.FieldInt64:
		m.ResetInt64()
		return nil
	case fieldtype.FieldOptionalInt:
		m.ResetOptionalInt()
		return nil
	case fieldtype.FieldOptionalInt8:
		m.ResetOptionalInt8()
		return nil
	case fieldtype.FieldOptionalInt16:
		m.ResetOptionalInt16()
		return nil
	case fieldtype.FieldOptionalInt32:
		m.ResetOptionalInt32()
		return nil
	case fieldtype.FieldOptionalInt64:
		m.ResetOptionalInt64()
		return nil
	case fieldtype.FieldNillableInt:
		m.ResetNillableInt()
		return nil
	case fieldtype.FieldNillableInt8:
		m.ResetNillableInt8()
		return nil
	case fieldtype.FieldNillableInt16:
		m.ResetNillableInt16()
		return nil
	case fieldtype.FieldNillableInt32:
		m.ResetNillableInt32()
		return nil
	case fieldtype.FieldNillableInt64:
		m.ResetNillableInt64()
		return nil
	case fieldtype.FieldValidateOptionalInt32:
		m.ResetValidateOptionalInt32()
		return nil
	case fieldtype.FieldOptionalUint:
		m.ResetOptionalUint()
		return nil
	case fieldtype.FieldOptionalUint8:
		m.ResetOptionalUint8()
		return nil
	case fieldtype.FieldOptionalUint16:
		m.ResetOptionalUint16()
		return nil
	case fieldtype.FieldOptionalUint32:
		m.ResetOptionalUint32()
		return nil
	case fieldtype.FieldOptionalUint64:
		m.ResetOptionalUint64()
		return nil
	case fieldtype.FieldState:
		m.ResetState()
		return nil
	case fieldtype.FieldOptionalFloat:
		m.ResetOptionalFloat()
		return nil
	case fieldtype.FieldOptionalFloat32:
		m.ResetOptionalFloat32()
		return nil
	case fieldtype.FieldDatetime:
		m.ResetDatetime()
		return nil
	case fieldtype.FieldDecimal:
		m.ResetDecimal()
		return nil
	case fieldtype.FieldDir:
		m.ResetDir()
		return nil
	case fieldtype.FieldNdir:
		m.ResetNdir()
		return nil
	case fieldtype.FieldStr:
		m.ResetStr()
		return nil
	case fieldtype.FieldNullStr:
		m.ResetNullStr()
		return nil
	case fieldtype.FieldLink:
		m.ResetLink()
		return nil
	case fieldtype.FieldNullLink:
		m.ResetNullLink()
		return nil
	case fieldtype.FieldActive:
		m.ResetActive()
		return nil
	case fieldtype.FieldNullActive:
		m.ResetNullActive()
		return nil
	case fieldtype.FieldDeleted:
		m.ResetDeleted()
		return nil
	case fieldtype.FieldDeletedAt:
		m.ResetDeletedAt()
		return nil
	case fieldtype.FieldIP:
		m.ResetIP()
		return nil
	case fieldtype.FieldNullInt64:
		m.ResetNullInt64()
		return nil
	case fieldtype.FieldSchemaInt:
		m.ResetSchemaInt()
		return nil
	case fieldtype.FieldSchemaInt8:
		m.ResetSchemaInt8()
		return nil
	case fieldtype.FieldSchemaInt64:
		m.ResetSchemaInt64()
		return nil
	case fieldtype.FieldSchemaFloat:
		m.ResetSchemaFloat()
		return nil
	case fieldtype.FieldSchemaFloat32:
		m.ResetSchemaFloat32()
		return nil
	case fieldtype.FieldNullFloat:
		m.ResetNullFloat()
		return nil
	case fieldtype.FieldRole:
		m.ResetRole()
		return nil
	case fieldtype.FieldMAC:
		m.ResetMAC()
		return nil
	case fieldtype.FieldUUID:
		m.ResetUUID()
		return nil
	}
	return fmt.Errorf("unknown FieldType field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *FieldTypeMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *FieldTypeMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *FieldTypeMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *FieldTypeMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *FieldTypeMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *FieldTypeMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *FieldTypeMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown FieldType unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *FieldTypeMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown FieldType edge %s", name)
}

// FileMutation represents an operation that mutates the File nodes in the graph.
type FileMutation struct {
	config
	op            Op
	typ           string
	id            *string
	size          *int
	addsize       *int
	name          *string
	user          *string
	group         *string
	_op           *bool
	clearedFields map[string]struct{}
	owner         *string
	clearedowner  bool
	_type         *string
	cleared_type  bool
	field         map[string]struct{}
	removedfield  map[string]struct{}
	clearedfield  bool
	done          bool
	oldValue      func(context.Context) (*File, error)
	predicates    []predicate.File
}

var _ ent.Mutation = (*FileMutation)(nil)

// fileOption allows management of the mutation configuration using functional options.
type fileOption func(*FileMutation)

// newFileMutation creates new mutation for the File entity.
func newFileMutation(c config, op Op, opts ...fileOption) *FileMutation {
	m := &FileMutation{
		config:        c,
		op:            op,
		typ:           TypeFile,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withFileID sets the ID field of the mutation.
func withFileID(id string) fileOption {
	return func(m *FileMutation) {
		var (
			err   error
			once  sync.Once
			value *File
		)
		m.oldValue = func(ctx context.Context) (*File, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().File.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withFile sets the old File of the mutation.
func withFile(node *File) fileOption {
	return func(m *FileMutation) {
		m.oldValue = func(context.Context) (*File, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m FileMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m FileMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *FileMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetSize sets the "size" field.
func (m *FileMutation) SetSize(i int) {
	m.size = &i
	m.addsize = nil
}

// Size returns the value of the "size" field in the mutation.
func (m *FileMutation) Size() (r int, exists bool) {
	v := m.size
	if v == nil {
		return
	}
	return *v, true
}

// OldSize returns the old "size" field's value of the File entity.
// If the File object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FileMutation) OldSize(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSize is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSize requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSize: %w", err)
	}
	return oldValue.Size, nil
}

// AddSize adds i to the "size" field.
func (m *FileMutation) AddSize(i int) {
	if m.addsize != nil {
		*m.addsize += i
	} else {
		m.addsize = &i
	}
}

// AddedSize returns the value that was added to the "size" field in this mutation.
func (m *FileMutation) AddedSize() (r int, exists bool) {
	v := m.addsize
	if v == nil {
		return
	}
	return *v, true
}

// ResetSize resets all changes to the "size" field.
func (m *FileMutation) ResetSize() {
	m.size = nil
	m.addsize = nil
}

// SetName sets the "name" field.
func (m *FileMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *FileMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the File entity.
// If the File object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FileMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *FileMutation) ResetName() {
	m.name = nil
}

// SetUser sets the "user" field.
func (m *FileMutation) SetUser(s string) {
	m.user = &s
}

// User returns the value of the "user" field in the mutation.
func (m *FileMutation) User() (r string, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUser returns the old "user" field's value of the File entity.
// If the File object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FileMutation) OldUser(ctx context.Context) (v *string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUser is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUser requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUser: %w", err)
	}
	return oldValue.User, nil
}

// ClearUser clears the value of the "user" field.
func (m *FileMutation) ClearUser() {
	m.user = nil
	m.clearedFields[file.FieldUser] = struct{}{}
}

// UserCleared returns if the "user" field was cleared in this mutation.
func (m *FileMutation) UserCleared() bool {
	_, ok := m.clearedFields[file.FieldUser]
	return ok
}

// ResetUser resets all changes to the "user" field.
func (m *FileMutation) ResetUser() {
	m.user = nil
	delete(m.clearedFields, file.FieldUser)
}

// SetGroup sets the "group" field.
func (m *FileMutation) SetGroup(s string) {
	m.group = &s
}

// Group returns the value of the "group" field in the mutation.
func (m *FileMutation) Group() (r string, exists bool) {
	v := m.group
	if v == nil {
		return
	}
	return *v, true
}

// OldGroup returns the old "group" field's value of the File entity.
// If the File object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FileMutation) OldGroup(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldGroup is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldGroup requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldGroup: %w", err)
	}
	return oldValue.Group, nil
}

// ClearGroup clears the value of the "group" field.
func (m *FileMutation) ClearGroup() {
	m.group = nil
	m.clearedFields[file.FieldGroup] = struct{}{}
}

// GroupCleared returns if the "group" field was cleared in this mutation.
func (m *FileMutation) GroupCleared() bool {
	_, ok := m.clearedFields[file.FieldGroup]
	return ok
}

// ResetGroup resets all changes to the "group" field.
func (m *FileMutation) ResetGroup() {
	m.group = nil
	delete(m.clearedFields, file.FieldGroup)
}

// SetOp sets the "op" field.
func (m *FileMutation) SetOp(b bool) {
	m._op = &b
}

// GetOp returns the value of the "op" field in the mutation.
func (m *FileMutation) GetOp() (r bool, exists bool) {
	v := m._op
	if v == nil {
		return
	}
	return *v, true
}

// OldOp returns the old "op" field's value of the File entity.
// If the File object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FileMutation) OldOp(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOp is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOp requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOp: %w", err)
	}
	return oldValue.Op, nil
}

// ClearOp clears the value of the "op" field.
func (m *FileMutation) ClearOp() {
	m._op = nil
	m.clearedFields[file.FieldOp] = struct{}{}
}

// OpCleared returns if the "op" field was cleared in this mutation.
func (m *FileMutation) OpCleared() bool {
	_, ok := m.clearedFields[file.FieldOp]
	return ok
}

// ResetOp resets all changes to the "op" field.
func (m *FileMutation) ResetOp() {
	m._op = nil
	delete(m.clearedFields, file.FieldOp)
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *FileMutation) SetOwnerID(id string) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *FileMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared returns if the "owner" edge to the User entity was cleared.
func (m *FileMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *FileMutation) OwnerID() (id string, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *FileMutation) OwnerIDs() (ids []string) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *FileMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// SetTypeID sets the "type" edge to the FileType entity by id.
func (m *FileMutation) SetTypeID(id string) {
	m._type = &id
}

// ClearType clears the "type" edge to the FileType entity.
func (m *FileMutation) ClearType() {
	m.cleared_type = true
}

// TypeCleared returns if the "type" edge to the FileType entity was cleared.
func (m *FileMutation) TypeCleared() bool {
	return m.cleared_type
}

// TypeID returns the "type" edge ID in the mutation.
func (m *FileMutation) TypeID() (id string, exists bool) {
	if m._type != nil {
		return *m._type, true
	}
	return
}

// TypeIDs returns the "type" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// TypeID instead. It exists only for internal usage by the builders.
func (m *FileMutation) TypeIDs() (ids []string) {
	if id := m._type; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetType resets all changes to the "type" edge.
func (m *FileMutation) ResetType() {
	m._type = nil
	m.cleared_type = false
}

// AddFieldIDs adds the "field" edge to the FieldType entity by ids.
func (m *FileMutation) AddFieldIDs(ids ...string) {
	if m.field == nil {
		m.field = make(map[string]struct{})
	}
	for i := range ids {
		m.field[ids[i]] = struct{}{}
	}
}

// ClearFieldEdge clears the "field" edge to the FieldType entity.
func (m *FileMutation) ClearFieldEdge() {
	m.clearedfield = true
}

// FieldEdgeCleared returns if the "field" edge to the FieldType entity was cleared.
func (m *FileMutation) FieldEdgeCleared() bool {
	return m.clearedfield
}

// RemoveFieldIDs removes the "field" edge to the FieldType entity by IDs.
func (m *FileMutation) RemoveFieldIDs(ids ...string) {
	if m.removedfield == nil {
		m.removedfield = make(map[string]struct{})
	}
	for i := range ids {
		m.removedfield[ids[i]] = struct{}{}
	}
}

// RemovedField returns the removed IDs of the "field" edge to the FieldType entity.
func (m *FileMutation) RemovedFieldIDs() (ids []string) {
	for id := range m.removedfield {
		ids = append(ids, id)
	}
	return
}

// FieldIDs returns the "field" edge IDs in the mutation.
func (m *FileMutation) FieldIDs() (ids []string) {
	for id := range m.field {
		ids = append(ids, id)
	}
	return
}

// ResetFieldEdge resets all changes to the "field" edge.
func (m *FileMutation) ResetFieldEdge() {
	m.field = nil
	m.clearedfield = false
	m.removedfield = nil
}

// Op returns the operation name.
func (m *FileMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (File).
func (m *FileMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *FileMutation) Fields() []string {
	fields := make([]string, 0, 5)
	if m.size != nil {
		fields = append(fields, file.FieldSize)
	}
	if m.name != nil {
		fields = append(fields, file.FieldName)
	}
	if m.user != nil {
		fields = append(fields, file.FieldUser)
	}
	if m.group != nil {
		fields = append(fields, file.FieldGroup)
	}
	if m._op != nil {
		fields = append(fields, file.FieldOp)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *FileMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case file.FieldSize:
		return m.Size()
	case file.FieldName:
		return m.Name()
	case file.FieldUser:
		return m.User()
	case file.FieldGroup:
		return m.Group()
	case file.FieldOp:
		return m.GetOp()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *FileMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case file.FieldSize:
		return m.OldSize(ctx)
	case file.FieldName:
		return m.OldName(ctx)
	case file.FieldUser:
		return m.OldUser(ctx)
	case file.FieldGroup:
		return m.OldGroup(ctx)
	case file.FieldOp:
		return m.OldOp(ctx)
	}
	return nil, fmt.Errorf("unknown File field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *FileMutation) SetField(name string, value ent.Value) error {
	switch name {
	case file.FieldSize:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSize(v)
		return nil
	case file.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case file.FieldUser:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUser(v)
		return nil
	case file.FieldGroup:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetGroup(v)
		return nil
	case file.FieldOp:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOp(v)
		return nil
	}
	return fmt.Errorf("unknown File field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *FileMutation) AddedFields() []string {
	var fields []string
	if m.addsize != nil {
		fields = append(fields, file.FieldSize)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *FileMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case file.FieldSize:
		return m.AddedSize()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *FileMutation) AddField(name string, value ent.Value) error {
	switch name {
	case file.FieldSize:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddSize(v)
		return nil
	}
	return fmt.Errorf("unknown File numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *FileMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(file.FieldUser) {
		fields = append(fields, file.FieldUser)
	}
	if m.FieldCleared(file.FieldGroup) {
		fields = append(fields, file.FieldGroup)
	}
	if m.FieldCleared(file.FieldOp) {
		fields = append(fields, file.FieldOp)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *FileMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *FileMutation) ClearField(name string) error {
	switch name {
	case file.FieldUser:
		m.ClearUser()
		return nil
	case file.FieldGroup:
		m.ClearGroup()
		return nil
	case file.FieldOp:
		m.ClearOp()
		return nil
	}
	return fmt.Errorf("unknown File nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *FileMutation) ResetField(name string) error {
	switch name {
	case file.FieldSize:
		m.ResetSize()
		return nil
	case file.FieldName:
		m.ResetName()
		return nil
	case file.FieldUser:
		m.ResetUser()
		return nil
	case file.FieldGroup:
		m.ResetGroup()
		return nil
	case file.FieldOp:
		m.ResetOp()
		return nil
	}
	return fmt.Errorf("unknown File field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *FileMutation) AddedEdges() []string {
	edges := make([]string, 0, 3)
	if m.owner != nil {
		edges = append(edges, file.EdgeOwner)
	}
	if m._type != nil {
		edges = append(edges, file.EdgeType)
	}
	if m.field != nil {
		edges = append(edges, file.EdgeField)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *FileMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case file.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	case file.EdgeType:
		if id := m._type; id != nil {
			return []ent.Value{*id}
		}
	case file.EdgeField:
		ids := make([]ent.Value, 0, len(m.field))
		for id := range m.field {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *FileMutation) RemovedEdges() []string {
	edges := make([]string, 0, 3)
	if m.removedfield != nil {
		edges = append(edges, file.EdgeField)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *FileMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case file.EdgeField:
		ids := make([]ent.Value, 0, len(m.removedfield))
		for id := range m.removedfield {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *FileMutation) ClearedEdges() []string {
	edges := make([]string, 0, 3)
	if m.clearedowner {
		edges = append(edges, file.EdgeOwner)
	}
	if m.cleared_type {
		edges = append(edges, file.EdgeType)
	}
	if m.clearedfield {
		edges = append(edges, file.EdgeField)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *FileMutation) EdgeCleared(name string) bool {
	switch name {
	case file.EdgeOwner:
		return m.clearedowner
	case file.EdgeType:
		return m.cleared_type
	case file.EdgeField:
		return m.clearedfield
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *FileMutation) ClearEdge(name string) error {
	switch name {
	case file.EdgeOwner:
		m.ClearOwner()
		return nil
	case file.EdgeType:
		m.ClearType()
		return nil
	}
	return fmt.Errorf("unknown File unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *FileMutation) ResetEdge(name string) error {
	switch name {
	case file.EdgeOwner:
		m.ResetOwner()
		return nil
	case file.EdgeType:
		m.ResetType()
		return nil
	case file.EdgeField:
		m.ResetFieldEdge()
		return nil
	}
	return fmt.Errorf("unknown File edge %s", name)
}

// FileTypeMutation represents an operation that mutates the FileType nodes in the graph.
type FileTypeMutation struct {
	config
	op            Op
	typ           string
	id            *string
	name          *string
	_type         *filetype.Type
	state         *filetype.State
	clearedFields map[string]struct{}
	files         map[string]struct{}
	removedfiles  map[string]struct{}
	clearedfiles  bool
	done          bool
	oldValue      func(context.Context) (*FileType, error)
	predicates    []predicate.FileType
}

var _ ent.Mutation = (*FileTypeMutation)(nil)

// filetypeOption allows management of the mutation configuration using functional options.
type filetypeOption func(*FileTypeMutation)

// newFileTypeMutation creates new mutation for the FileType entity.
func newFileTypeMutation(c config, op Op, opts ...filetypeOption) *FileTypeMutation {
	m := &FileTypeMutation{
		config:        c,
		op:            op,
		typ:           TypeFileType,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withFileTypeID sets the ID field of the mutation.
func withFileTypeID(id string) filetypeOption {
	return func(m *FileTypeMutation) {
		var (
			err   error
			once  sync.Once
			value *FileType
		)
		m.oldValue = func(ctx context.Context) (*FileType, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().FileType.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withFileType sets the old FileType of the mutation.
func withFileType(node *FileType) filetypeOption {
	return func(m *FileTypeMutation) {
		m.oldValue = func(context.Context) (*FileType, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m FileTypeMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m FileTypeMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *FileTypeMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetName sets the "name" field.
func (m *FileTypeMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *FileTypeMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the FileType entity.
// If the FileType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FileTypeMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *FileTypeMutation) ResetName() {
	m.name = nil
}

// SetType sets the "type" field.
func (m *FileTypeMutation) SetType(f filetype.Type) {
	m._type = &f
}

// GetType returns the value of the "type" field in the mutation.
func (m *FileTypeMutation) GetType() (r filetype.Type, exists bool) {
	v := m._type
	if v == nil {
		return
	}
	return *v, true
}

// OldType returns the old "type" field's value of the FileType entity.
// If the FileType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FileTypeMutation) OldType(ctx context.Context) (v filetype.Type, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldType: %w", err)
	}
	return oldValue.Type, nil
}

// ResetType resets all changes to the "type" field.
func (m *FileTypeMutation) ResetType() {
	m._type = nil
}

// SetState sets the "state" field.
func (m *FileTypeMutation) SetState(f filetype.State) {
	m.state = &f
}

// State returns the value of the "state" field in the mutation.
func (m *FileTypeMutation) State() (r filetype.State, exists bool) {
	v := m.state
	if v == nil {
		return
	}
	return *v, true
}

// OldState returns the old "state" field's value of the FileType entity.
// If the FileType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FileTypeMutation) OldState(ctx context.Context) (v filetype.State, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldState is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldState requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldState: %w", err)
	}
	return oldValue.State, nil
}

// ResetState resets all changes to the "state" field.
func (m *FileTypeMutation) ResetState() {
	m.state = nil
}

// AddFileIDs adds the "files" edge to the File entity by ids.
func (m *FileTypeMutation) AddFileIDs(ids ...string) {
	if m.files == nil {
		m.files = make(map[string]struct{})
	}
	for i := range ids {
		m.files[ids[i]] = struct{}{}
	}
}

// ClearFiles clears the "files" edge to the File entity.
func (m *FileTypeMutation) ClearFiles() {
	m.clearedfiles = true
}

// FilesCleared returns if the "files" edge to the File entity was cleared.
func (m *FileTypeMutation) FilesCleared() bool {
	return m.clearedfiles
}

// RemoveFileIDs removes the "files" edge to the File entity by IDs.
func (m *FileTypeMutation) RemoveFileIDs(ids ...string) {
	if m.removedfiles == nil {
		m.removedfiles = make(map[string]struct{})
	}
	for i := range ids {
		m.removedfiles[ids[i]] = struct{}{}
	}
}

// RemovedFiles returns the removed IDs of the "files" edge to the File entity.
func (m *FileTypeMutation) RemovedFilesIDs() (ids []string) {
	for id := range m.removedfiles {
		ids = append(ids, id)
	}
	return
}

// FilesIDs returns the "files" edge IDs in the mutation.
func (m *FileTypeMutation) FilesIDs() (ids []string) {
	for id := range m.files {
		ids = append(ids, id)
	}
	return
}

// ResetFiles resets all changes to the "files" edge.
func (m *FileTypeMutation) ResetFiles() {
	m.files = nil
	m.clearedfiles = false
	m.removedfiles = nil
}

// Op returns the operation name.
func (m *FileTypeMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (FileType).
func (m *FileTypeMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *FileTypeMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m.name != nil {
		fields = append(fields, filetype.FieldName)
	}
	if m._type != nil {
		fields = append(fields, filetype.FieldType)
	}
	if m.state != nil {
		fields = append(fields, filetype.FieldState)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *FileTypeMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case filetype.FieldName:
		return m.Name()
	case filetype.FieldType:
		return m.GetType()
	case filetype.FieldState:
		return m.State()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *FileTypeMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case filetype.FieldName:
		return m.OldName(ctx)
	case filetype.FieldType:
		return m.OldType(ctx)
	case filetype.FieldState:
		return m.OldState(ctx)
	}
	return nil, fmt.Errorf("unknown FileType field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *FileTypeMutation) SetField(name string, value ent.Value) error {
	switch name {
	case filetype.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case filetype.FieldType:
		v, ok := value.(filetype.Type)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetType(v)
		return nil
	case filetype.FieldState:
		v, ok := value.(filetype.State)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetState(v)
		return nil
	}
	return fmt.Errorf("unknown FileType field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *FileTypeMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *FileTypeMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *FileTypeMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown FileType numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *FileTypeMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *FileTypeMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *FileTypeMutation) ClearField(name string) error {
	return fmt.Errorf("unknown FileType nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *FileTypeMutation) ResetField(name string) error {
	switch name {
	case filetype.FieldName:
		m.ResetName()
		return nil
	case filetype.FieldType:
		m.ResetType()
		return nil
	case filetype.FieldState:
		m.ResetState()
		return nil
	}
	return fmt.Errorf("unknown FileType field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *FileTypeMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.files != nil {
		edges = append(edges, filetype.EdgeFiles)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *FileTypeMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case filetype.EdgeFiles:
		ids := make([]ent.Value, 0, len(m.files))
		for id := range m.files {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *FileTypeMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	if m.removedfiles != nil {
		edges = append(edges, filetype.EdgeFiles)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *FileTypeMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case filetype.EdgeFiles:
		ids := make([]ent.Value, 0, len(m.removedfiles))
		for id := range m.removedfiles {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *FileTypeMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedfiles {
		edges = append(edges, filetype.EdgeFiles)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *FileTypeMutation) EdgeCleared(name string) bool {
	switch name {
	case filetype.EdgeFiles:
		return m.clearedfiles
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *FileTypeMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown FileType unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *FileTypeMutation) ResetEdge(name string) error {
	switch name {
	case filetype.EdgeFiles:
		m.ResetFiles()
		return nil
	}
	return fmt.Errorf("unknown FileType edge %s", name)
}

// GoodsMutation represents an operation that mutates the Goods nodes in the graph.
type GoodsMutation struct {
	config
	op            Op
	typ           string
	id            *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Goods, error)
	predicates    []predicate.Goods
}

var _ ent.Mutation = (*GoodsMutation)(nil)

// goodsOption allows management of the mutation configuration using functional options.
type goodsOption func(*GoodsMutation)

// newGoodsMutation creates new mutation for the Goods entity.
func newGoodsMutation(c config, op Op, opts ...goodsOption) *GoodsMutation {
	m := &GoodsMutation{
		config:        c,
		op:            op,
		typ:           TypeGoods,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withGoodsID sets the ID field of the mutation.
func withGoodsID(id string) goodsOption {
	return func(m *GoodsMutation) {
		var (
			err   error
			once  sync.Once
			value *Goods
		)
		m.oldValue = func(ctx context.Context) (*Goods, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Goods.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withGoods sets the old Goods of the mutation.
func withGoods(node *Goods) goodsOption {
	return func(m *GoodsMutation) {
		m.oldValue = func(context.Context) (*Goods, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m GoodsMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m GoodsMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *GoodsMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// Op returns the operation name.
func (m *GoodsMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Goods).
func (m *GoodsMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *GoodsMutation) Fields() []string {
	fields := make([]string, 0, 0)
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *GoodsMutation) Field(name string) (ent.Value, bool) {
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *GoodsMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	return nil, fmt.Errorf("unknown Goods field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GoodsMutation) SetField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Goods field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *GoodsMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *GoodsMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GoodsMutation) AddField(name string, value ent.Value) error {
	return fmt.Errorf("unknown Goods numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *GoodsMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *GoodsMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *GoodsMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Goods nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *GoodsMutation) ResetField(name string) error {
	return fmt.Errorf("unknown Goods field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *GoodsMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *GoodsMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *GoodsMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *GoodsMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *GoodsMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *GoodsMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *GoodsMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Goods unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *GoodsMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Goods edge %s", name)
}

// GroupMutation represents an operation that mutates the Group nodes in the graph.
type GroupMutation struct {
	config
	op             Op
	typ            string
	id             *string
	active         *bool
	expire         *time.Time
	_type          *string
	max_users      *int
	addmax_users   *int
	name           *string
	clearedFields  map[string]struct{}
	files          map[string]struct{}
	removedfiles   map[string]struct{}
	clearedfiles   bool
	blocked        map[string]struct{}
	removedblocked map[string]struct{}
	clearedblocked bool
	users          map[string]struct{}
	removedusers   map[string]struct{}
	clearedusers   bool
	info           *string
	clearedinfo    bool
	done           bool
	oldValue       func(context.Context) (*Group, error)
	predicates     []predicate.Group
}

var _ ent.Mutation = (*GroupMutation)(nil)

// groupOption allows management of the mutation configuration using functional options.
type groupOption func(*GroupMutation)

// newGroupMutation creates new mutation for the Group entity.
func newGroupMutation(c config, op Op, opts ...groupOption) *GroupMutation {
	m := &GroupMutation{
		config:        c,
		op:            op,
		typ:           TypeGroup,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withGroupID sets the ID field of the mutation.
func withGroupID(id string) groupOption {
	return func(m *GroupMutation) {
		var (
			err   error
			once  sync.Once
			value *Group
		)
		m.oldValue = func(ctx context.Context) (*Group, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Group.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withGroup sets the old Group of the mutation.
func withGroup(node *Group) groupOption {
	return func(m *GroupMutation) {
		m.oldValue = func(context.Context) (*Group, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m GroupMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m GroupMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *GroupMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetActive sets the "active" field.
func (m *GroupMutation) SetActive(b bool) {
	m.active = &b
}

// Active returns the value of the "active" field in the mutation.
func (m *GroupMutation) Active() (r bool, exists bool) {
	v := m.active
	if v == nil {
		return
	}
	return *v, true
}

// OldActive returns the old "active" field's value of the Group entity.
// If the Group object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *GroupMutation) OldActive(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldActive is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldActive requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldActive: %w", err)
	}
	return oldValue.Active, nil
}

// ResetActive resets all changes to the "active" field.
func (m *GroupMutation) ResetActive() {
	m.active = nil
}

// SetExpire sets the "expire" field.
func (m *GroupMutation) SetExpire(t time.Time) {
	m.expire = &t
}

// Expire returns the value of the "expire" field in the mutation.
func (m *GroupMutation) Expire() (r time.Time, exists bool) {
	v := m.expire
	if v == nil {
		return
	}
	return *v, true
}

// OldExpire returns the old "expire" field's value of the Group entity.
// If the Group object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *GroupMutation) OldExpire(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldExpire is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldExpire requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldExpire: %w", err)
	}
	return oldValue.Expire, nil
}

// ResetExpire resets all changes to the "expire" field.
func (m *GroupMutation) ResetExpire() {
	m.expire = nil
}

// SetType sets the "type" field.
func (m *GroupMutation) SetType(s string) {
	m._type = &s
}

// GetType returns the value of the "type" field in the mutation.
func (m *GroupMutation) GetType() (r string, exists bool) {
	v := m._type
	if v == nil {
		return
	}
	return *v, true
}

// OldType returns the old "type" field's value of the Group entity.
// If the Group object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *GroupMutation) OldType(ctx context.Context) (v *string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldType: %w", err)
	}
	return oldValue.Type, nil
}

// ClearType clears the value of the "type" field.
func (m *GroupMutation) ClearType() {
	m._type = nil
	m.clearedFields[group.FieldType] = struct{}{}
}

// TypeCleared returns if the "type" field was cleared in this mutation.
func (m *GroupMutation) TypeCleared() bool {
	_, ok := m.clearedFields[group.FieldType]
	return ok
}

// ResetType resets all changes to the "type" field.
func (m *GroupMutation) ResetType() {
	m._type = nil
	delete(m.clearedFields, group.FieldType)
}

// SetMaxUsers sets the "max_users" field.
func (m *GroupMutation) SetMaxUsers(i int) {
	m.max_users = &i
	m.addmax_users = nil
}

// MaxUsers returns the value of the "max_users" field in the mutation.
func (m *GroupMutation) MaxUsers() (r int, exists bool) {
	v := m.max_users
	if v == nil {
		return
	}
	return *v, true
}

// OldMaxUsers returns the old "max_users" field's value of the Group entity.
// If the Group object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *GroupMutation) OldMaxUsers(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldMaxUsers is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldMaxUsers requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMaxUsers: %w", err)
	}
	return oldValue.MaxUsers, nil
}

// AddMaxUsers adds i to the "max_users" field.
func (m *GroupMutation) AddMaxUsers(i int) {
	if m.addmax_users != nil {
		*m.addmax_users += i
	} else {
		m.addmax_users = &i
	}
}

// AddedMaxUsers returns the value that was added to the "max_users" field in this mutation.
func (m *GroupMutation) AddedMaxUsers() (r int, exists bool) {
	v := m.addmax_users
	if v == nil {
		return
	}
	return *v, true
}

// ClearMaxUsers clears the value of the "max_users" field.
func (m *GroupMutation) ClearMaxUsers() {
	m.max_users = nil
	m.addmax_users = nil
	m.clearedFields[group.FieldMaxUsers] = struct{}{}
}

// MaxUsersCleared returns if the "max_users" field was cleared in this mutation.
func (m *GroupMutation) MaxUsersCleared() bool {
	_, ok := m.clearedFields[group.FieldMaxUsers]
	return ok
}

// ResetMaxUsers resets all changes to the "max_users" field.
func (m *GroupMutation) ResetMaxUsers() {
	m.max_users = nil
	m.addmax_users = nil
	delete(m.clearedFields, group.FieldMaxUsers)
}

// SetName sets the "name" field.
func (m *GroupMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *GroupMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Group entity.
// If the Group object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *GroupMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *GroupMutation) ResetName() {
	m.name = nil
}

// AddFileIDs adds the "files" edge to the File entity by ids.
func (m *GroupMutation) AddFileIDs(ids ...string) {
	if m.files == nil {
		m.files = make(map[string]struct{})
	}
	for i := range ids {
		m.files[ids[i]] = struct{}{}
	}
}

// ClearFiles clears the "files" edge to the File entity.
func (m *GroupMutation) ClearFiles() {
	m.clearedfiles = true
}

// FilesCleared returns if the "files" edge to the File entity was cleared.
func (m *GroupMutation) FilesCleared() bool {
	return m.clearedfiles
}

// RemoveFileIDs removes the "files" edge to the File entity by IDs.
func (m *GroupMutation) RemoveFileIDs(ids ...string) {
	if m.removedfiles == nil {
		m.removedfiles = make(map[string]struct{})
	}
	for i := range ids {
		m.removedfiles[ids[i]] = struct{}{}
	}
}

// RemovedFiles returns the removed IDs of the "files" edge to the File entity.
func (m *GroupMutation) RemovedFilesIDs() (ids []string) {
	for id := range m.removedfiles {
		ids = append(ids, id)
	}
	return
}

// FilesIDs returns the "files" edge IDs in the mutation.
func (m *GroupMutation) FilesIDs() (ids []string) {
	for id := range m.files {
		ids = append(ids, id)
	}
	return
}

// ResetFiles resets all changes to the "files" edge.
func (m *GroupMutation) ResetFiles() {
	m.files = nil
	m.clearedfiles = false
	m.removedfiles = nil
}

// AddBlockedIDs adds the "blocked" edge to the User entity by ids.
func (m *GroupMutation) AddBlockedIDs(ids ...string) {
	if m.blocked == nil {
		m.blocked = make(map[string]struct{})
	}
	for i := range ids {
		m.blocked[ids[i]] = struct{}{}
	}
}

// ClearBlocked clears the "blocked" edge to the User entity.
func (m *GroupMutation) ClearBlocked() {
	m.clearedblocked = true
}

// BlockedCleared returns if the "blocked" edge to the User entity was cleared.
func (m *GroupMutation) BlockedCleared() bool {
	return m.clearedblocked
}

// RemoveBlockedIDs removes the "blocked" edge to the User entity by IDs.
func (m *GroupMutation) RemoveBlockedIDs(ids ...string) {
	if m.removedblocked == nil {
		m.removedblocked = make(map[string]struct{})
	}
	for i := range ids {
		m.removedblocked[ids[i]] = struct{}{}
	}
}

// RemovedBlocked returns the removed IDs of the "blocked" edge to the User entity.
func (m *GroupMutation) RemovedBlockedIDs() (ids []string) {
	for id := range m.removedblocked {
		ids = append(ids, id)
	}
	return
}

// BlockedIDs returns the "blocked" edge IDs in the mutation.
func (m *GroupMutation) BlockedIDs() (ids []string) {
	for id := range m.blocked {
		ids = append(ids, id)
	}
	return
}

// ResetBlocked resets all changes to the "blocked" edge.
func (m *GroupMutation) ResetBlocked() {
	m.blocked = nil
	m.clearedblocked = false
	m.removedblocked = nil
}

// AddUserIDs adds the "users" edge to the User entity by ids.
func (m *GroupMutation) AddUserIDs(ids ...string) {
	if m.users == nil {
		m.users = make(map[string]struct{})
	}
	for i := range ids {
		m.users[ids[i]] = struct{}{}
	}
}

// ClearUsers clears the "users" edge to the User entity.
func (m *GroupMutation) ClearUsers() {
	m.clearedusers = true
}

// UsersCleared returns if the "users" edge to the User entity was cleared.
func (m *GroupMutation) UsersCleared() bool {
	return m.clearedusers
}

// RemoveUserIDs removes the "users" edge to the User entity by IDs.
func (m *GroupMutation) RemoveUserIDs(ids ...string) {
	if m.removedusers == nil {
		m.removedusers = make(map[string]struct{})
	}
	for i := range ids {
		m.removedusers[ids[i]] = struct{}{}
	}
}

// RemovedUsers returns the removed IDs of the "users" edge to the User entity.
func (m *GroupMutation) RemovedUsersIDs() (ids []string) {
	for id := range m.removedusers {
		ids = append(ids, id)
	}
	return
}

// UsersIDs returns the "users" edge IDs in the mutation.
func (m *GroupMutation) UsersIDs() (ids []string) {
	for id := range m.users {
		ids = append(ids, id)
	}
	return
}

// ResetUsers resets all changes to the "users" edge.
func (m *GroupMutation) ResetUsers() {
	m.users = nil
	m.clearedusers = false
	m.removedusers = nil
}

// SetInfoID sets the "info" edge to the GroupInfo entity by id.
func (m *GroupMutation) SetInfoID(id string) {
	m.info = &id
}

// ClearInfo clears the "info" edge to the GroupInfo entity.
func (m *GroupMutation) ClearInfo() {
	m.clearedinfo = true
}

// InfoCleared returns if the "info" edge to the GroupInfo entity was cleared.
func (m *GroupMutation) InfoCleared() bool {
	return m.clearedinfo
}

// InfoID returns the "info" edge ID in the mutation.
func (m *GroupMutation) InfoID() (id string, exists bool) {
	if m.info != nil {
		return *m.info, true
	}
	return
}

// InfoIDs returns the "info" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// InfoID instead. It exists only for internal usage by the builders.
func (m *GroupMutation) InfoIDs() (ids []string) {
	if id := m.info; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetInfo resets all changes to the "info" edge.
func (m *GroupMutation) ResetInfo() {
	m.info = nil
	m.clearedinfo = false
}

// Op returns the operation name.
func (m *GroupMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Group).
func (m *GroupMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *GroupMutation) Fields() []string {
	fields := make([]string, 0, 5)
	if m.active != nil {
		fields = append(fields, group.FieldActive)
	}
	if m.expire != nil {
		fields = append(fields, group.FieldExpire)
	}
	if m._type != nil {
		fields = append(fields, group.FieldType)
	}
	if m.max_users != nil {
		fields = append(fields, group.FieldMaxUsers)
	}
	if m.name != nil {
		fields = append(fields, group.FieldName)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *GroupMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case group.FieldActive:
		return m.Active()
	case group.FieldExpire:
		return m.Expire()
	case group.FieldType:
		return m.GetType()
	case group.FieldMaxUsers:
		return m.MaxUsers()
	case group.FieldName:
		return m.Name()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *GroupMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case group.FieldActive:
		return m.OldActive(ctx)
	case group.FieldExpire:
		return m.OldExpire(ctx)
	case group.FieldType:
		return m.OldType(ctx)
	case group.FieldMaxUsers:
		return m.OldMaxUsers(ctx)
	case group.FieldName:
		return m.OldName(ctx)
	}
	return nil, fmt.Errorf("unknown Group field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupMutation) SetField(name string, value ent.Value) error {
	switch name {
	case group.FieldActive:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetActive(v)
		return nil
	case group.FieldExpire:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetExpire(v)
		return nil
	case group.FieldType:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetType(v)
		return nil
	case group.FieldMaxUsers:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMaxUsers(v)
		return nil
	case group.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	}
	return fmt.Errorf("unknown Group field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *GroupMutation) AddedFields() []string {
	var fields []string
	if m.addmax_users != nil {
		fields = append(fields, group.FieldMaxUsers)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *GroupMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case group.FieldMaxUsers:
		return m.AddedMaxUsers()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupMutation) AddField(name string, value ent.Value) error {
	switch name {
	case group.FieldMaxUsers:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddMaxUsers(v)
		return nil
	}
	return fmt.Errorf("unknown Group numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *GroupMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(group.FieldType) {
		fields = append(fields, group.FieldType)
	}
	if m.FieldCleared(group.FieldMaxUsers) {
		fields = append(fields, group.FieldMaxUsers)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *GroupMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *GroupMutation) ClearField(name string) error {
	switch name {
	case group.FieldType:
		m.ClearType()
		return nil
	case group.FieldMaxUsers:
		m.ClearMaxUsers()
		return nil
	}
	return fmt.Errorf("unknown Group nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *GroupMutation) ResetField(name string) error {
	switch name {
	case group.FieldActive:
		m.ResetActive()
		return nil
	case group.FieldExpire:
		m.ResetExpire()
		return nil
	case group.FieldType:
		m.ResetType()
		return nil
	case group.FieldMaxUsers:
		m.ResetMaxUsers()
		return nil
	case group.FieldName:
		m.ResetName()
		return nil
	}
	return fmt.Errorf("unknown Group field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *GroupMutation) AddedEdges() []string {
	edges := make([]string, 0, 4)
	if m.files != nil {
		edges = append(edges, group.EdgeFiles)
	}
	if m.blocked != nil {
		edges = append(edges, group.EdgeBlocked)
	}
	if m.users != nil {
		edges = append(edges, group.EdgeUsers)
	}
	if m.info != nil {
		edges = append(edges, group.EdgeInfo)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *GroupMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case group.EdgeFiles:
		ids := make([]ent.Value, 0, len(m.files))
		for id := range m.files {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeBlocked:
		ids := make([]ent.Value, 0, len(m.blocked))
		for id := range m.blocked {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeUsers:
		ids := make([]ent.Value, 0, len(m.users))
		for id := range m.users {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeInfo:
		if id := m.info; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *GroupMutation) RemovedEdges() []string {
	edges := make([]string, 0, 4)
	if m.removedfiles != nil {
		edges = append(edges, group.EdgeFiles)
	}
	if m.removedblocked != nil {
		edges = append(edges, group.EdgeBlocked)
	}
	if m.removedusers != nil {
		edges = append(edges, group.EdgeUsers)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *GroupMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case group.EdgeFiles:
		ids := make([]ent.Value, 0, len(m.removedfiles))
		for id := range m.removedfiles {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeBlocked:
		ids := make([]ent.Value, 0, len(m.removedblocked))
		for id := range m.removedblocked {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeUsers:
		ids := make([]ent.Value, 0, len(m.removedusers))
		for id := range m.removedusers {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *GroupMutation) ClearedEdges() []string {
	edges := make([]string, 0, 4)
	if m.clearedfiles {
		edges = append(edges, group.EdgeFiles)
	}
	if m.clearedblocked {
		edges = append(edges, group.EdgeBlocked)
	}
	if m.clearedusers {
		edges = append(edges, group.EdgeUsers)
	}
	if m.clearedinfo {
		edges = append(edges, group.EdgeInfo)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *GroupMutation) EdgeCleared(name string) bool {
	switch name {
	case group.EdgeFiles:
		return m.clearedfiles
	case group.EdgeBlocked:
		return m.clearedblocked
	case group.EdgeUsers:
		return m.clearedusers
	case group.EdgeInfo:
		return m.clearedinfo
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *GroupMutation) ClearEdge(name string) error {
	switch name {
	case group.EdgeInfo:
		m.ClearInfo()
		return nil
	}
	return fmt.Errorf("unknown Group unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *GroupMutation) ResetEdge(name string) error {
	switch name {
	case group.EdgeFiles:
		m.ResetFiles()
		return nil
	case group.EdgeBlocked:
		m.ResetBlocked()
		return nil
	case group.EdgeUsers:
		m.ResetUsers()
		return nil
	case group.EdgeInfo:
		m.ResetInfo()
		return nil
	}
	return fmt.Errorf("unknown Group edge %s", name)
}

// GroupInfoMutation represents an operation that mutates the GroupInfo nodes in the graph.
type GroupInfoMutation struct {
	config
	op            Op
	typ           string
	id            *string
	desc          *string
	max_users     *int
	addmax_users  *int
	clearedFields map[string]struct{}
	groups        map[string]struct{}
	removedgroups map[string]struct{}
	clearedgroups bool
	done          bool
	oldValue      func(context.Context) (*GroupInfo, error)
	predicates    []predicate.GroupInfo
}

var _ ent.Mutation = (*GroupInfoMutation)(nil)

// groupinfoOption allows management of the mutation configuration using functional options.
type groupinfoOption func(*GroupInfoMutation)

// newGroupInfoMutation creates new mutation for the GroupInfo entity.
func newGroupInfoMutation(c config, op Op, opts ...groupinfoOption) *GroupInfoMutation {
	m := &GroupInfoMutation{
		config:        c,
		op:            op,
		typ:           TypeGroupInfo,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withGroupInfoID sets the ID field of the mutation.
func withGroupInfoID(id string) groupinfoOption {
	return func(m *GroupInfoMutation) {
		var (
			err   error
			once  sync.Once
			value *GroupInfo
		)
		m.oldValue = func(ctx context.Context) (*GroupInfo, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().GroupInfo.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withGroupInfo sets the old GroupInfo of the mutation.
func withGroupInfo(node *GroupInfo) groupinfoOption {
	return func(m *GroupInfoMutation) {
		m.oldValue = func(context.Context) (*GroupInfo, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m GroupInfoMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m GroupInfoMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *GroupInfoMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetDesc sets the "desc" field.
func (m *GroupInfoMutation) SetDesc(s string) {
	m.desc = &s
}

// Desc returns the value of the "desc" field in the mutation.
func (m *GroupInfoMutation) Desc() (r string, exists bool) {
	v := m.desc
	if v == nil {
		return
	}
	return *v, true
}

// OldDesc returns the old "desc" field's value of the GroupInfo entity.
// If the GroupInfo object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *GroupInfoMutation) OldDesc(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDesc is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDesc requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDesc: %w", err)
	}
	return oldValue.Desc, nil
}

// ResetDesc resets all changes to the "desc" field.
func (m *GroupInfoMutation) ResetDesc() {
	m.desc = nil
}

// SetMaxUsers sets the "max_users" field.
func (m *GroupInfoMutation) SetMaxUsers(i int) {
	m.max_users = &i
	m.addmax_users = nil
}

// MaxUsers returns the value of the "max_users" field in the mutation.
func (m *GroupInfoMutation) MaxUsers() (r int, exists bool) {
	v := m.max_users
	if v == nil {
		return
	}
	return *v, true
}

// OldMaxUsers returns the old "max_users" field's value of the GroupInfo entity.
// If the GroupInfo object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *GroupInfoMutation) OldMaxUsers(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldMaxUsers is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldMaxUsers requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMaxUsers: %w", err)
	}
	return oldValue.MaxUsers, nil
}

// AddMaxUsers adds i to the "max_users" field.
func (m *GroupInfoMutation) AddMaxUsers(i int) {
	if m.addmax_users != nil {
		*m.addmax_users += i
	} else {
		m.addmax_users = &i
	}
}

// AddedMaxUsers returns the value that was added to the "max_users" field in this mutation.
func (m *GroupInfoMutation) AddedMaxUsers() (r int, exists bool) {
	v := m.addmax_users
	if v == nil {
		return
	}
	return *v, true
}

// ResetMaxUsers resets all changes to the "max_users" field.
func (m *GroupInfoMutation) ResetMaxUsers() {
	m.max_users = nil
	m.addmax_users = nil
}

// AddGroupIDs adds the "groups" edge to the Group entity by ids.
func (m *GroupInfoMutation) AddGroupIDs(ids ...string) {
	if m.groups == nil {
		m.groups = make(map[string]struct{})
	}
	for i := range ids {
		m.groups[ids[i]] = struct{}{}
	}
}

// ClearGroups clears the "groups" edge to the Group entity.
func (m *GroupInfoMutation) ClearGroups() {
	m.clearedgroups = true
}

// GroupsCleared returns if the "groups" edge to the Group entity was cleared.
func (m *GroupInfoMutation) GroupsCleared() bool {
	return m.clearedgroups
}

// RemoveGroupIDs removes the "groups" edge to the Group entity by IDs.
func (m *GroupInfoMutation) RemoveGroupIDs(ids ...string) {
	if m.removedgroups == nil {
		m.removedgroups = make(map[string]struct{})
	}
	for i := range ids {
		m.removedgroups[ids[i]] = struct{}{}
	}
}

// RemovedGroups returns the removed IDs of the "groups" edge to the Group entity.
func (m *GroupInfoMutation) RemovedGroupsIDs() (ids []string) {
	for id := range m.removedgroups {
		ids = append(ids, id)
	}
	return
}

// GroupsIDs returns the "groups" edge IDs in the mutation.
func (m *GroupInfoMutation) GroupsIDs() (ids []string) {
	for id := range m.groups {
		ids = append(ids, id)
	}
	return
}

// ResetGroups resets all changes to the "groups" edge.
func (m *GroupInfoMutation) ResetGroups() {
	m.groups = nil
	m.clearedgroups = false
	m.removedgroups = nil
}

// Op returns the operation name.
func (m *GroupInfoMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (GroupInfo).
func (m *GroupInfoMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *GroupInfoMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.desc != nil {
		fields = append(fields, groupinfo.FieldDesc)
	}
	if m.max_users != nil {
		fields = append(fields, groupinfo.FieldMaxUsers)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *GroupInfoMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case groupinfo.FieldDesc:
		return m.Desc()
	case groupinfo.FieldMaxUsers:
		return m.MaxUsers()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *GroupInfoMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case groupinfo.FieldDesc:
		return m.OldDesc(ctx)
	case groupinfo.FieldMaxUsers:
		return m.OldMaxUsers(ctx)
	}
	return nil, fmt.Errorf("unknown GroupInfo field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupInfoMutation) SetField(name string, value ent.Value) error {
	switch name {
	case groupinfo.FieldDesc:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDesc(v)
		return nil
	case groupinfo.FieldMaxUsers:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMaxUsers(v)
		return nil
	}
	return fmt.Errorf("unknown GroupInfo field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *GroupInfoMutation) AddedFields() []string {
	var fields []string
	if m.addmax_users != nil {
		fields = append(fields, groupinfo.FieldMaxUsers)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *GroupInfoMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case groupinfo.FieldMaxUsers:
		return m.AddedMaxUsers()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupInfoMutation) AddField(name string, value ent.Value) error {
	switch name {
	case groupinfo.FieldMaxUsers:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddMaxUsers(v)
		return nil
	}
	return fmt.Errorf("unknown GroupInfo numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *GroupInfoMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *GroupInfoMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *GroupInfoMutation) ClearField(name string) error {
	return fmt.Errorf("unknown GroupInfo nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *GroupInfoMutation) ResetField(name string) error {
	switch name {
	case groupinfo.FieldDesc:
		m.ResetDesc()
		return nil
	case groupinfo.FieldMaxUsers:
		m.ResetMaxUsers()
		return nil
	}
	return fmt.Errorf("unknown GroupInfo field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *GroupInfoMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.groups != nil {
		edges = append(edges, groupinfo.EdgeGroups)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *GroupInfoMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case groupinfo.EdgeGroups:
		ids := make([]ent.Value, 0, len(m.groups))
		for id := range m.groups {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *GroupInfoMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	if m.removedgroups != nil {
		edges = append(edges, groupinfo.EdgeGroups)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *GroupInfoMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case groupinfo.EdgeGroups:
		ids := make([]ent.Value, 0, len(m.removedgroups))
		for id := range m.removedgroups {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *GroupInfoMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedgroups {
		edges = append(edges, groupinfo.EdgeGroups)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *GroupInfoMutation) EdgeCleared(name string) bool {
	switch name {
	case groupinfo.EdgeGroups:
		return m.clearedgroups
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *GroupInfoMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown GroupInfo unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *GroupInfoMutation) ResetEdge(name string) error {
	switch name {
	case groupinfo.EdgeGroups:
		m.ResetGroups()
		return nil
	}
	return fmt.Errorf("unknown GroupInfo edge %s", name)
}

// ItemMutation represents an operation that mutates the Item nodes in the graph.
type ItemMutation struct {
	config
	op            Op
	typ           string
	id            *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Item, error)
	predicates    []predicate.Item
}

var _ ent.Mutation = (*ItemMutation)(nil)

// itemOption allows management of the mutation configuration using functional options.
type itemOption func(*ItemMutation)

// newItemMutation creates new mutation for the Item entity.
func newItemMutation(c config, op Op, opts ...itemOption) *ItemMutation {
	m := &ItemMutation{
		config:        c,
		op:            op,
		typ:           TypeItem,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withItemID sets the ID field of the mutation.
func withItemID(id string) itemOption {
	return func(m *ItemMutation) {
		var (
			err   error
			once  sync.Once
			value *Item
		)
		m.oldValue = func(ctx context.Context) (*Item, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Item.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withItem sets the old Item of the mutation.
func withItem(node *Item) itemOption {
	return func(m *ItemMutation) {
		m.oldValue = func(context.Context) (*Item, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ItemMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ItemMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *ItemMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// Op returns the operation name.
func (m *ItemMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Item).
func (m *ItemMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ItemMutation) Fields() []string {
	fields := make([]string, 0, 0)
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ItemMutation) Field(name string) (ent.Value, bool) {
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ItemMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	return nil, fmt.Errorf("unknown Item field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ItemMutation) SetField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Item field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ItemMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ItemMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ItemMutation) AddField(name string, value ent.Value) error {
	return fmt.Errorf("unknown Item numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ItemMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ItemMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ItemMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Item nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ItemMutation) ResetField(name string) error {
	return fmt.Errorf("unknown Item field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ItemMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ItemMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ItemMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ItemMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ItemMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ItemMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ItemMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Item unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ItemMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Item edge %s", name)
}

// NodeMutation represents an operation that mutates the Node nodes in the graph.
type NodeMutation struct {
	config
	op            Op
	typ           string
	id            *string
	value         *int
	addvalue      *int
	clearedFields map[string]struct{}
	prev          *string
	clearedprev   bool
	next          *string
	clearednext   bool
	done          bool
	oldValue      func(context.Context) (*Node, error)
	predicates    []predicate.Node
}

var _ ent.Mutation = (*NodeMutation)(nil)

// nodeOption allows management of the mutation configuration using functional options.
type nodeOption func(*NodeMutation)

// newNodeMutation creates new mutation for the Node entity.
func newNodeMutation(c config, op Op, opts ...nodeOption) *NodeMutation {
	m := &NodeMutation{
		config:        c,
		op:            op,
		typ:           TypeNode,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withNodeID sets the ID field of the mutation.
func withNodeID(id string) nodeOption {
	return func(m *NodeMutation) {
		var (
			err   error
			once  sync.Once
			value *Node
		)
		m.oldValue = func(ctx context.Context) (*Node, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Node.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withNode sets the old Node of the mutation.
func withNode(node *Node) nodeOption {
	return func(m *NodeMutation) {
		m.oldValue = func(context.Context) (*Node, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m NodeMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m NodeMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *NodeMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetValue sets the "value" field.
func (m *NodeMutation) SetValue(i int) {
	m.value = &i
	m.addvalue = nil
}

// Value returns the value of the "value" field in the mutation.
func (m *NodeMutation) Value() (r int, exists bool) {
	v := m.value
	if v == nil {
		return
	}
	return *v, true
}

// OldValue returns the old "value" field's value of the Node entity.
// If the Node object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *NodeMutation) OldValue(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldValue is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldValue requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldValue: %w", err)
	}
	return oldValue.Value, nil
}

// AddValue adds i to the "value" field.
func (m *NodeMutation) AddValue(i int) {
	if m.addvalue != nil {
		*m.addvalue += i
	} else {
		m.addvalue = &i
	}
}

// AddedValue returns the value that was added to the "value" field in this mutation.
func (m *NodeMutation) AddedValue() (r int, exists bool) {
	v := m.addvalue
	if v == nil {
		return
	}
	return *v, true
}

// ClearValue clears the value of the "value" field.
func (m *NodeMutation) ClearValue() {
	m.value = nil
	m.addvalue = nil
	m.clearedFields[node.FieldValue] = struct{}{}
}

// ValueCleared returns if the "value" field was cleared in this mutation.
func (m *NodeMutation) ValueCleared() bool {
	_, ok := m.clearedFields[node.FieldValue]
	return ok
}

// ResetValue resets all changes to the "value" field.
func (m *NodeMutation) ResetValue() {
	m.value = nil
	m.addvalue = nil
	delete(m.clearedFields, node.FieldValue)
}

// SetPrevID sets the "prev" edge to the Node entity by id.
func (m *NodeMutation) SetPrevID(id string) {
	m.prev = &id
}

// ClearPrev clears the "prev" edge to the Node entity.
func (m *NodeMutation) ClearPrev() {
	m.clearedprev = true
}

// PrevCleared returns if the "prev" edge to the Node entity was cleared.
func (m *NodeMutation) PrevCleared() bool {
	return m.clearedprev
}

// PrevID returns the "prev" edge ID in the mutation.
func (m *NodeMutation) PrevID() (id string, exists bool) {
	if m.prev != nil {
		return *m.prev, true
	}
	return
}

// PrevIDs returns the "prev" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// PrevID instead. It exists only for internal usage by the builders.
func (m *NodeMutation) PrevIDs() (ids []string) {
	if id := m.prev; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetPrev resets all changes to the "prev" edge.
func (m *NodeMutation) ResetPrev() {
	m.prev = nil
	m.clearedprev = false
}

// SetNextID sets the "next" edge to the Node entity by id.
func (m *NodeMutation) SetNextID(id string) {
	m.next = &id
}

// ClearNext clears the "next" edge to the Node entity.
func (m *NodeMutation) ClearNext() {
	m.clearednext = true
}

// NextCleared returns if the "next" edge to the Node entity was cleared.
func (m *NodeMutation) NextCleared() bool {
	return m.clearednext
}

// NextID returns the "next" edge ID in the mutation.
func (m *NodeMutation) NextID() (id string, exists bool) {
	if m.next != nil {
		return *m.next, true
	}
	return
}

// NextIDs returns the "next" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// NextID instead. It exists only for internal usage by the builders.
func (m *NodeMutation) NextIDs() (ids []string) {
	if id := m.next; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetNext resets all changes to the "next" edge.
func (m *NodeMutation) ResetNext() {
	m.next = nil
	m.clearednext = false
}

// Op returns the operation name.
func (m *NodeMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Node).
func (m *NodeMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *NodeMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.value != nil {
		fields = append(fields, node.FieldValue)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *NodeMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case node.FieldValue:
		return m.Value()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *NodeMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case node.FieldValue:
		return m.OldValue(ctx)
	}
	return nil, fmt.Errorf("unknown Node field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *NodeMutation) SetField(name string, value ent.Value) error {
	switch name {
	case node.FieldValue:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetValue(v)
		return nil
	}
	return fmt.Errorf("unknown Node field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *NodeMutation) AddedFields() []string {
	var fields []string
	if m.addvalue != nil {
		fields = append(fields, node.FieldValue)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *NodeMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case node.FieldValue:
		return m.AddedValue()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *NodeMutation) AddField(name string, value ent.Value) error {
	switch name {
	case node.FieldValue:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddValue(v)
		return nil
	}
	return fmt.Errorf("unknown Node numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *NodeMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(node.FieldValue) {
		fields = append(fields, node.FieldValue)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *NodeMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *NodeMutation) ClearField(name string) error {
	switch name {
	case node.FieldValue:
		m.ClearValue()
		return nil
	}
	return fmt.Errorf("unknown Node nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *NodeMutation) ResetField(name string) error {
	switch name {
	case node.FieldValue:
		m.ResetValue()
		return nil
	}
	return fmt.Errorf("unknown Node field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *NodeMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.prev != nil {
		edges = append(edges, node.EdgePrev)
	}
	if m.next != nil {
		edges = append(edges, node.EdgeNext)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *NodeMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case node.EdgePrev:
		if id := m.prev; id != nil {
			return []ent.Value{*id}
		}
	case node.EdgeNext:
		if id := m.next; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *NodeMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *NodeMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *NodeMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedprev {
		edges = append(edges, node.EdgePrev)
	}
	if m.clearednext {
		edges = append(edges, node.EdgeNext)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *NodeMutation) EdgeCleared(name string) bool {
	switch name {
	case node.EdgePrev:
		return m.clearedprev
	case node.EdgeNext:
		return m.clearednext
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *NodeMutation) ClearEdge(name string) error {
	switch name {
	case node.EdgePrev:
		m.ClearPrev()
		return nil
	case node.EdgeNext:
		m.ClearNext()
		return nil
	}
	return fmt.Errorf("unknown Node unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *NodeMutation) ResetEdge(name string) error {
	switch name {
	case node.EdgePrev:
		m.ResetPrev()
		return nil
	case node.EdgeNext:
		m.ResetNext()
		return nil
	}
	return fmt.Errorf("unknown Node edge %s", name)
}

// PetMutation represents an operation that mutates the Pet nodes in the graph.
type PetMutation struct {
	config
	op            Op
	typ           string
	id            *string
	name          *string
	uuid          *uuid.UUID
	clearedFields map[string]struct{}
	team          *string
	clearedteam   bool
	owner         *string
	clearedowner  bool
	done          bool
	oldValue      func(context.Context) (*Pet, error)
	predicates    []predicate.Pet
}

var _ ent.Mutation = (*PetMutation)(nil)

// petOption allows management of the mutation configuration using functional options.
type petOption func(*PetMutation)

// newPetMutation creates new mutation for the Pet entity.
func newPetMutation(c config, op Op, opts ...petOption) *PetMutation {
	m := &PetMutation{
		config:        c,
		op:            op,
		typ:           TypePet,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withPetID sets the ID field of the mutation.
func withPetID(id string) petOption {
	return func(m *PetMutation) {
		var (
			err   error
			once  sync.Once
			value *Pet
		)
		m.oldValue = func(ctx context.Context) (*Pet, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Pet.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withPet sets the old Pet of the mutation.
func withPet(node *Pet) petOption {
	return func(m *PetMutation) {
		m.oldValue = func(context.Context) (*Pet, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m PetMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m PetMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *PetMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetName sets the "name" field.
func (m *PetMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *PetMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Pet entity.
// If the Pet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *PetMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *PetMutation) ResetName() {
	m.name = nil
}

// SetUUID sets the "uuid" field.
func (m *PetMutation) SetUUID(u uuid.UUID) {
	m.uuid = &u
}

// UUID returns the value of the "uuid" field in the mutation.
func (m *PetMutation) UUID() (r uuid.UUID, exists bool) {
	v := m.uuid
	if v == nil {
		return
	}
	return *v, true
}

// OldUUID returns the old "uuid" field's value of the Pet entity.
// If the Pet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *PetMutation) OldUUID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUUID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUUID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUUID: %w", err)
	}
	return oldValue.UUID, nil
}

// ClearUUID clears the value of the "uuid" field.
func (m *PetMutation) ClearUUID() {
	m.uuid = nil
	m.clearedFields[pet.FieldUUID] = struct{}{}
}

// UUIDCleared returns if the "uuid" field was cleared in this mutation.
func (m *PetMutation) UUIDCleared() bool {
	_, ok := m.clearedFields[pet.FieldUUID]
	return ok
}

// ResetUUID resets all changes to the "uuid" field.
func (m *PetMutation) ResetUUID() {
	m.uuid = nil
	delete(m.clearedFields, pet.FieldUUID)
}

// SetTeamID sets the "team" edge to the User entity by id.
func (m *PetMutation) SetTeamID(id string) {
	m.team = &id
}

// ClearTeam clears the "team" edge to the User entity.
func (m *PetMutation) ClearTeam() {
	m.clearedteam = true
}

// TeamCleared returns if the "team" edge to the User entity was cleared.
func (m *PetMutation) TeamCleared() bool {
	return m.clearedteam
}

// TeamID returns the "team" edge ID in the mutation.
func (m *PetMutation) TeamID() (id string, exists bool) {
	if m.team != nil {
		return *m.team, true
	}
	return
}

// TeamIDs returns the "team" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// TeamID instead. It exists only for internal usage by the builders.
func (m *PetMutation) TeamIDs() (ids []string) {
	if id := m.team; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetTeam resets all changes to the "team" edge.
func (m *PetMutation) ResetTeam() {
	m.team = nil
	m.clearedteam = false
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *PetMutation) SetOwnerID(id string) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *PetMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared returns if the "owner" edge to the User entity was cleared.
func (m *PetMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *PetMutation) OwnerID() (id string, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *PetMutation) OwnerIDs() (ids []string) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *PetMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Op returns the operation name.
func (m *PetMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Pet).
func (m *PetMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *PetMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.name != nil {
		fields = append(fields, pet.FieldName)
	}
	if m.uuid != nil {
		fields = append(fields, pet.FieldUUID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *PetMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case pet.FieldName:
		return m.Name()
	case pet.FieldUUID:
		return m.UUID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *PetMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case pet.FieldName:
		return m.OldName(ctx)
	case pet.FieldUUID:
		return m.OldUUID(ctx)
	}
	return nil, fmt.Errorf("unknown Pet field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PetMutation) SetField(name string, value ent.Value) error {
	switch name {
	case pet.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case pet.FieldUUID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUUID(v)
		return nil
	}
	return fmt.Errorf("unknown Pet field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *PetMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *PetMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PetMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Pet numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *PetMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(pet.FieldUUID) {
		fields = append(fields, pet.FieldUUID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *PetMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *PetMutation) ClearField(name string) error {
	switch name {
	case pet.FieldUUID:
		m.ClearUUID()
		return nil
	}
	return fmt.Errorf("unknown Pet nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *PetMutation) ResetField(name string) error {
	switch name {
	case pet.FieldName:
		m.ResetName()
		return nil
	case pet.FieldUUID:
		m.ResetUUID()
		return nil
	}
	return fmt.Errorf("unknown Pet field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *PetMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.team != nil {
		edges = append(edges, pet.EdgeTeam)
	}
	if m.owner != nil {
		edges = append(edges, pet.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *PetMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case pet.EdgeTeam:
		if id := m.team; id != nil {
			return []ent.Value{*id}
		}
	case pet.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *PetMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *PetMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *PetMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedteam {
		edges = append(edges, pet.EdgeTeam)
	}
	if m.clearedowner {
		edges = append(edges, pet.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *PetMutation) EdgeCleared(name string) bool {
	switch name {
	case pet.EdgeTeam:
		return m.clearedteam
	case pet.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *PetMutation) ClearEdge(name string) error {
	switch name {
	case pet.EdgeTeam:
		m.ClearTeam()
		return nil
	case pet.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Pet unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *PetMutation) ResetEdge(name string) error {
	switch name {
	case pet.EdgeTeam:
		m.ResetTeam()
		return nil
	case pet.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Pet edge %s", name)
}

// SpecMutation represents an operation that mutates the Spec nodes in the graph.
type SpecMutation struct {
	config
	op            Op
	typ           string
	id            *string
	clearedFields map[string]struct{}
	card          map[string]struct{}
	removedcard   map[string]struct{}
	clearedcard   bool
	done          bool
	oldValue      func(context.Context) (*Spec, error)
	predicates    []predicate.Spec
}

var _ ent.Mutation = (*SpecMutation)(nil)

// specOption allows management of the mutation configuration using functional options.
type specOption func(*SpecMutation)

// newSpecMutation creates new mutation for the Spec entity.
func newSpecMutation(c config, op Op, opts ...specOption) *SpecMutation {
	m := &SpecMutation{
		config:        c,
		op:            op,
		typ:           TypeSpec,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withSpecID sets the ID field of the mutation.
func withSpecID(id string) specOption {
	return func(m *SpecMutation) {
		var (
			err   error
			once  sync.Once
			value *Spec
		)
		m.oldValue = func(ctx context.Context) (*Spec, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Spec.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withSpec sets the old Spec of the mutation.
func withSpec(node *Spec) specOption {
	return func(m *SpecMutation) {
		m.oldValue = func(context.Context) (*Spec, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m SpecMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m SpecMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *SpecMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// AddCardIDs adds the "card" edge to the Card entity by ids.
func (m *SpecMutation) AddCardIDs(ids ...string) {
	if m.card == nil {
		m.card = make(map[string]struct{})
	}
	for i := range ids {
		m.card[ids[i]] = struct{}{}
	}
}

// ClearCard clears the "card" edge to the Card entity.
func (m *SpecMutation) ClearCard() {
	m.clearedcard = true
}

// CardCleared returns if the "card" edge to the Card entity was cleared.
func (m *SpecMutation) CardCleared() bool {
	return m.clearedcard
}

// RemoveCardIDs removes the "card" edge to the Card entity by IDs.
func (m *SpecMutation) RemoveCardIDs(ids ...string) {
	if m.removedcard == nil {
		m.removedcard = make(map[string]struct{})
	}
	for i := range ids {
		m.removedcard[ids[i]] = struct{}{}
	}
}

// RemovedCard returns the removed IDs of the "card" edge to the Card entity.
func (m *SpecMutation) RemovedCardIDs() (ids []string) {
	for id := range m.removedcard {
		ids = append(ids, id)
	}
	return
}

// CardIDs returns the "card" edge IDs in the mutation.
func (m *SpecMutation) CardIDs() (ids []string) {
	for id := range m.card {
		ids = append(ids, id)
	}
	return
}

// ResetCard resets all changes to the "card" edge.
func (m *SpecMutation) ResetCard() {
	m.card = nil
	m.clearedcard = false
	m.removedcard = nil
}

// Op returns the operation name.
func (m *SpecMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Spec).
func (m *SpecMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *SpecMutation) Fields() []string {
	fields := make([]string, 0, 0)
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *SpecMutation) Field(name string) (ent.Value, bool) {
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *SpecMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	return nil, fmt.Errorf("unknown Spec field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SpecMutation) SetField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Spec field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *SpecMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *SpecMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SpecMutation) AddField(name string, value ent.Value) error {
	return fmt.Errorf("unknown Spec numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *SpecMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *SpecMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *SpecMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Spec nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *SpecMutation) ResetField(name string) error {
	return fmt.Errorf("unknown Spec field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *SpecMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.card != nil {
		edges = append(edges, spec.EdgeCard)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *SpecMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case spec.EdgeCard:
		ids := make([]ent.Value, 0, len(m.card))
		for id := range m.card {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *SpecMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	if m.removedcard != nil {
		edges = append(edges, spec.EdgeCard)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *SpecMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case spec.EdgeCard:
		ids := make([]ent.Value, 0, len(m.removedcard))
		for id := range m.removedcard {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *SpecMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedcard {
		edges = append(edges, spec.EdgeCard)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *SpecMutation) EdgeCleared(name string) bool {
	switch name {
	case spec.EdgeCard:
		return m.clearedcard
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *SpecMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Spec unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *SpecMutation) ResetEdge(name string) error {
	switch name {
	case spec.EdgeCard:
		m.ResetCard()
		return nil
	}
	return fmt.Errorf("unknown Spec edge %s", name)
}

// TaskMutation represents an operation that mutates the Task nodes in the graph.
type TaskMutation struct {
	config
	op            Op
	typ           string
	id            *string
	priority      *schema.Priority
	addpriority   *schema.Priority
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Task, error)
	predicates    []predicate.Task
}

var _ ent.Mutation = (*TaskMutation)(nil)

// taskOption allows management of the mutation configuration using functional options.
type taskOption func(*TaskMutation)

// newTaskMutation creates new mutation for the Task entity.
func newTaskMutation(c config, op Op, opts ...taskOption) *TaskMutation {
	m := &TaskMutation{
		config:        c,
		op:            op,
		typ:           TypeTask,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withTaskID sets the ID field of the mutation.
func withTaskID(id string) taskOption {
	return func(m *TaskMutation) {
		var (
			err   error
			once  sync.Once
			value *Task
		)
		m.oldValue = func(ctx context.Context) (*Task, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Task.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withTask sets the old Task of the mutation.
func withTask(node *Task) taskOption {
	return func(m *TaskMutation) {
		m.oldValue = func(context.Context) (*Task, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m TaskMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m TaskMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *TaskMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetPriority sets the "priority" field.
func (m *TaskMutation) SetPriority(s schema.Priority) {
	m.priority = &s
	m.addpriority = nil
}

// Priority returns the value of the "priority" field in the mutation.
func (m *TaskMutation) Priority() (r schema.Priority, exists bool) {
	v := m.priority
	if v == nil {
		return
	}
	return *v, true
}

// OldPriority returns the old "priority" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldPriority(ctx context.Context) (v schema.Priority, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldPriority is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldPriority requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPriority: %w", err)
	}
	return oldValue.Priority, nil
}

// AddPriority adds s to the "priority" field.
func (m *TaskMutation) AddPriority(s schema.Priority) {
	if m.addpriority != nil {
		*m.addpriority += s
	} else {
		m.addpriority = &s
	}
}

// AddedPriority returns the value that was added to the "priority" field in this mutation.
func (m *TaskMutation) AddedPriority() (r schema.Priority, exists bool) {
	v := m.addpriority
	if v == nil {
		return
	}
	return *v, true
}

// ResetPriority resets all changes to the "priority" field.
func (m *TaskMutation) ResetPriority() {
	m.priority = nil
	m.addpriority = nil
}

// Op returns the operation name.
func (m *TaskMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Task).
func (m *TaskMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *TaskMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.priority != nil {
		fields = append(fields, task.FieldPriority)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *TaskMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case task.FieldPriority:
		return m.Priority()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *TaskMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case task.FieldPriority:
		return m.OldPriority(ctx)
	}
	return nil, fmt.Errorf("unknown Task field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TaskMutation) SetField(name string, value ent.Value) error {
	switch name {
	case task.FieldPriority:
		v, ok := value.(schema.Priority)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPriority(v)
		return nil
	}
	return fmt.Errorf("unknown Task field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *TaskMutation) AddedFields() []string {
	var fields []string
	if m.addpriority != nil {
		fields = append(fields, task.FieldPriority)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *TaskMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case task.FieldPriority:
		return m.AddedPriority()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TaskMutation) AddField(name string, value ent.Value) error {
	switch name {
	case task.FieldPriority:
		v, ok := value.(schema.Priority)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddPriority(v)
		return nil
	}
	return fmt.Errorf("unknown Task numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *TaskMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *TaskMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *TaskMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Task nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *TaskMutation) ResetField(name string) error {
	switch name {
	case task.FieldPriority:
		m.ResetPriority()
		return nil
	}
	return fmt.Errorf("unknown Task field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *TaskMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *TaskMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *TaskMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *TaskMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *TaskMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *TaskMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *TaskMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Task unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *TaskMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Task edge %s", name)
}

// UserMutation represents an operation that mutates the User nodes in the graph.
type UserMutation struct {
	config
	op               Op
	typ              string
	id               *string
	optional_int     *int
	addoptional_int  *int
	age              *int
	addage           *int
	name             *string
	last             *string
	nickname         *string
	address          *string
	phone            *string
	password         *string
	role             *user.Role
	_SSOCert         *string
	clearedFields    map[string]struct{}
	card             *string
	clearedcard      bool
	pets             map[string]struct{}
	removedpets      map[string]struct{}
	clearedpets      bool
	files            map[string]struct{}
	removedfiles     map[string]struct{}
	clearedfiles     bool
	groups           map[string]struct{}
	removedgroups    map[string]struct{}
	clearedgroups    bool
	friends          map[string]struct{}
	removedfriends   map[string]struct{}
	clearedfriends   bool
	followers        map[string]struct{}
	removedfollowers map[string]struct{}
	clearedfollowers bool
	following        map[string]struct{}
	removedfollowing map[string]struct{}
	clearedfollowing bool
	team             *string
	clearedteam      bool
	spouse           *string
	clearedspouse    bool
	children         map[string]struct{}
	removedchildren  map[string]struct{}
	clearedchildren  bool
	parent           *string
	clearedparent    bool
	done             bool
	oldValue         func(context.Context) (*User, error)
	predicates       []predicate.User
}

var _ ent.Mutation = (*UserMutation)(nil)

// userOption allows management of the mutation configuration using functional options.
type userOption func(*UserMutation)

// newUserMutation creates new mutation for the User entity.
func newUserMutation(c config, op Op, opts ...userOption) *UserMutation {
	m := &UserMutation{
		config:        c,
		op:            op,
		typ:           TypeUser,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserID sets the ID field of the mutation.
func withUserID(id string) userOption {
	return func(m *UserMutation) {
		var (
			err   error
			once  sync.Once
			value *User
		)
		m.oldValue = func(ctx context.Context) (*User, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().User.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUser sets the old User of the mutation.
func withUser(node *User) userOption {
	return func(m *UserMutation) {
		m.oldValue = func(context.Context) (*User, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *UserMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetOptionalInt sets the "optional_int" field.
func (m *UserMutation) SetOptionalInt(i int) {
	m.optional_int = &i
	m.addoptional_int = nil
}

// OptionalInt returns the value of the "optional_int" field in the mutation.
func (m *UserMutation) OptionalInt() (r int, exists bool) {
	v := m.optional_int
	if v == nil {
		return
	}
	return *v, true
}

// OldOptionalInt returns the old "optional_int" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldOptionalInt(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOptionalInt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOptionalInt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOptionalInt: %w", err)
	}
	return oldValue.OptionalInt, nil
}

// AddOptionalInt adds i to the "optional_int" field.
func (m *UserMutation) AddOptionalInt(i int) {
	if m.addoptional_int != nil {
		*m.addoptional_int += i
	} else {
		m.addoptional_int = &i
	}
}

// AddedOptionalInt returns the value that was added to the "optional_int" field in this mutation.
func (m *UserMutation) AddedOptionalInt() (r int, exists bool) {
	v := m.addoptional_int
	if v == nil {
		return
	}
	return *v, true
}

// ClearOptionalInt clears the value of the "optional_int" field.
func (m *UserMutation) ClearOptionalInt() {
	m.optional_int = nil
	m.addoptional_int = nil
	m.clearedFields[user.FieldOptionalInt] = struct{}{}
}

// OptionalIntCleared returns if the "optional_int" field was cleared in this mutation.
func (m *UserMutation) OptionalIntCleared() bool {
	_, ok := m.clearedFields[user.FieldOptionalInt]
	return ok
}

// ResetOptionalInt resets all changes to the "optional_int" field.
func (m *UserMutation) ResetOptionalInt() {
	m.optional_int = nil
	m.addoptional_int = nil
	delete(m.clearedFields, user.FieldOptionalInt)
}

// SetAge sets the "age" field.
func (m *UserMutation) SetAge(i int) {
	m.age = &i
	m.addage = nil
}

// Age returns the value of the "age" field in the mutation.
func (m *UserMutation) Age() (r int, exists bool) {
	v := m.age
	if v == nil {
		return
	}
	return *v, true
}

// OldAge returns the old "age" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldAge(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldAge is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldAge requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAge: %w", err)
	}
	return oldValue.Age, nil
}

// AddAge adds i to the "age" field.
func (m *UserMutation) AddAge(i int) {
	if m.addage != nil {
		*m.addage += i
	} else {
		m.addage = &i
	}
}

// AddedAge returns the value that was added to the "age" field in this mutation.
func (m *UserMutation) AddedAge() (r int, exists bool) {
	v := m.addage
	if v == nil {
		return
	}
	return *v, true
}

// ResetAge resets all changes to the "age" field.
func (m *UserMutation) ResetAge() {
	m.age = nil
	m.addage = nil
}

// SetName sets the "name" field.
func (m *UserMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *UserMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *UserMutation) ResetName() {
	m.name = nil
}

// SetLast sets the "last" field.
func (m *UserMutation) SetLast(s string) {
	m.last = &s
}

// Last returns the value of the "last" field in the mutation.
func (m *UserMutation) Last() (r string, exists bool) {
	v := m.last
	if v == nil {
		return
	}
	return *v, true
}

// OldLast returns the old "last" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldLast(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldLast is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldLast requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLast: %w", err)
	}
	return oldValue.Last, nil
}

// ResetLast resets all changes to the "last" field.
func (m *UserMutation) ResetLast() {
	m.last = nil
}

// SetNickname sets the "nickname" field.
func (m *UserMutation) SetNickname(s string) {
	m.nickname = &s
}

// Nickname returns the value of the "nickname" field in the mutation.
func (m *UserMutation) Nickname() (r string, exists bool) {
	v := m.nickname
	if v == nil {
		return
	}
	return *v, true
}

// OldNickname returns the old "nickname" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldNickname(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNickname is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNickname requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNickname: %w", err)
	}
	return oldValue.Nickname, nil
}

// ClearNickname clears the value of the "nickname" field.
func (m *UserMutation) ClearNickname() {
	m.nickname = nil
	m.clearedFields[user.FieldNickname] = struct{}{}
}

// NicknameCleared returns if the "nickname" field was cleared in this mutation.
func (m *UserMutation) NicknameCleared() bool {
	_, ok := m.clearedFields[user.FieldNickname]
	return ok
}

// ResetNickname resets all changes to the "nickname" field.
func (m *UserMutation) ResetNickname() {
	m.nickname = nil
	delete(m.clearedFields, user.FieldNickname)
}

// SetAddress sets the "address" field.
func (m *UserMutation) SetAddress(s string) {
	m.address = &s
}

// Address returns the value of the "address" field in the mutation.
func (m *UserMutation) Address() (r string, exists bool) {
	v := m.address
	if v == nil {
		return
	}
	return *v, true
}

// OldAddress returns the old "address" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldAddress(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldAddress is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldAddress requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAddress: %w", err)
	}
	return oldValue.Address, nil
}

// ClearAddress clears the value of the "address" field.
func (m *UserMutation) ClearAddress() {
	m.address = nil
	m.clearedFields[user.FieldAddress] = struct{}{}
}

// AddressCleared returns if the "address" field was cleared in this mutation.
func (m *UserMutation) AddressCleared() bool {
	_, ok := m.clearedFields[user.FieldAddress]
	return ok
}

// ResetAddress resets all changes to the "address" field.
func (m *UserMutation) ResetAddress() {
	m.address = nil
	delete(m.clearedFields, user.FieldAddress)
}

// SetPhone sets the "phone" field.
func (m *UserMutation) SetPhone(s string) {
	m.phone = &s
}

// Phone returns the value of the "phone" field in the mutation.
func (m *UserMutation) Phone() (r string, exists bool) {
	v := m.phone
	if v == nil {
		return
	}
	return *v, true
}

// OldPhone returns the old "phone" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldPhone(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldPhone is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldPhone requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPhone: %w", err)
	}
	return oldValue.Phone, nil
}

// ClearPhone clears the value of the "phone" field.
func (m *UserMutation) ClearPhone() {
	m.phone = nil
	m.clearedFields[user.FieldPhone] = struct{}{}
}

// PhoneCleared returns if the "phone" field was cleared in this mutation.
func (m *UserMutation) PhoneCleared() bool {
	_, ok := m.clearedFields[user.FieldPhone]
	return ok
}

// ResetPhone resets all changes to the "phone" field.
func (m *UserMutation) ResetPhone() {
	m.phone = nil
	delete(m.clearedFields, user.FieldPhone)
}

// SetPassword sets the "password" field.
func (m *UserMutation) SetPassword(s string) {
	m.password = &s
}

// Password returns the value of the "password" field in the mutation.
func (m *UserMutation) Password() (r string, exists bool) {
	v := m.password
	if v == nil {
		return
	}
	return *v, true
}

// OldPassword returns the old "password" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldPassword(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldPassword is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldPassword requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPassword: %w", err)
	}
	return oldValue.Password, nil
}

// ClearPassword clears the value of the "password" field.
func (m *UserMutation) ClearPassword() {
	m.password = nil
	m.clearedFields[user.FieldPassword] = struct{}{}
}

// PasswordCleared returns if the "password" field was cleared in this mutation.
func (m *UserMutation) PasswordCleared() bool {
	_, ok := m.clearedFields[user.FieldPassword]
	return ok
}

// ResetPassword resets all changes to the "password" field.
func (m *UserMutation) ResetPassword() {
	m.password = nil
	delete(m.clearedFields, user.FieldPassword)
}

// SetRole sets the "role" field.
func (m *UserMutation) SetRole(u user.Role) {
	m.role = &u
}

// Role returns the value of the "role" field in the mutation.
func (m *UserMutation) Role() (r user.Role, exists bool) {
	v := m.role
	if v == nil {
		return
	}
	return *v, true
}

// OldRole returns the old "role" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldRole(ctx context.Context) (v user.Role, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldRole is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldRole requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRole: %w", err)
	}
	return oldValue.Role, nil
}

// ResetRole resets all changes to the "role" field.
func (m *UserMutation) ResetRole() {
	m.role = nil
}

// SetSSOCert sets the "SSOCert" field.
func (m *UserMutation) SetSSOCert(s string) {
	m._SSOCert = &s
}

// SSOCert returns the value of the "SSOCert" field in the mutation.
func (m *UserMutation) SSOCert() (r string, exists bool) {
	v := m._SSOCert
	if v == nil {
		return
	}
	return *v, true
}

// OldSSOCert returns the old "SSOCert" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldSSOCert(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSSOCert is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSSOCert requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSSOCert: %w", err)
	}
	return oldValue.SSOCert, nil
}

// ClearSSOCert clears the value of the "SSOCert" field.
func (m *UserMutation) ClearSSOCert() {
	m._SSOCert = nil
	m.clearedFields[user.FieldSSOCert] = struct{}{}
}

// SSOCertCleared returns if the "SSOCert" field was cleared in this mutation.
func (m *UserMutation) SSOCertCleared() bool {
	_, ok := m.clearedFields[user.FieldSSOCert]
	return ok
}

// ResetSSOCert resets all changes to the "SSOCert" field.
func (m *UserMutation) ResetSSOCert() {
	m._SSOCert = nil
	delete(m.clearedFields, user.FieldSSOCert)
}

// SetCardID sets the "card" edge to the Card entity by id.
func (m *UserMutation) SetCardID(id string) {
	m.card = &id
}

// ClearCard clears the "card" edge to the Card entity.
func (m *UserMutation) ClearCard() {
	m.clearedcard = true
}

// CardCleared returns if the "card" edge to the Card entity was cleared.
func (m *UserMutation) CardCleared() bool {
	return m.clearedcard
}

// CardID returns the "card" edge ID in the mutation.
func (m *UserMutation) CardID() (id string, exists bool) {
	if m.card != nil {
		return *m.card, true
	}
	return
}

// CardIDs returns the "card" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// CardID instead. It exists only for internal usage by the builders.
func (m *UserMutation) CardIDs() (ids []string) {
	if id := m.card; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetCard resets all changes to the "card" edge.
func (m *UserMutation) ResetCard() {
	m.card = nil
	m.clearedcard = false
}

// AddPetIDs adds the "pets" edge to the Pet entity by ids.
func (m *UserMutation) AddPetIDs(ids ...string) {
	if m.pets == nil {
		m.pets = make(map[string]struct{})
	}
	for i := range ids {
		m.pets[ids[i]] = struct{}{}
	}
}

// ClearPets clears the "pets" edge to the Pet entity.
func (m *UserMutation) ClearPets() {
	m.clearedpets = true
}

// PetsCleared returns if the "pets" edge to the Pet entity was cleared.
func (m *UserMutation) PetsCleared() bool {
	return m.clearedpets
}

// RemovePetIDs removes the "pets" edge to the Pet entity by IDs.
func (m *UserMutation) RemovePetIDs(ids ...string) {
	if m.removedpets == nil {
		m.removedpets = make(map[string]struct{})
	}
	for i := range ids {
		m.removedpets[ids[i]] = struct{}{}
	}
}

// RemovedPets returns the removed IDs of the "pets" edge to the Pet entity.
func (m *UserMutation) RemovedPetsIDs() (ids []string) {
	for id := range m.removedpets {
		ids = append(ids, id)
	}
	return
}

// PetsIDs returns the "pets" edge IDs in the mutation.
func (m *UserMutation) PetsIDs() (ids []string) {
	for id := range m.pets {
		ids = append(ids, id)
	}
	return
}

// ResetPets resets all changes to the "pets" edge.
func (m *UserMutation) ResetPets() {
	m.pets = nil
	m.clearedpets = false
	m.removedpets = nil
}

// AddFileIDs adds the "files" edge to the File entity by ids.
func (m *UserMutation) AddFileIDs(ids ...string) {
	if m.files == nil {
		m.files = make(map[string]struct{})
	}
	for i := range ids {
		m.files[ids[i]] = struct{}{}
	}
}

// ClearFiles clears the "files" edge to the File entity.
func (m *UserMutation) ClearFiles() {
	m.clearedfiles = true
}

// FilesCleared returns if the "files" edge to the File entity was cleared.
func (m *UserMutation) FilesCleared() bool {
	return m.clearedfiles
}

// RemoveFileIDs removes the "files" edge to the File entity by IDs.
func (m *UserMutation) RemoveFileIDs(ids ...string) {
	if m.removedfiles == nil {
		m.removedfiles = make(map[string]struct{})
	}
	for i := range ids {
		m.removedfiles[ids[i]] = struct{}{}
	}
}

// RemovedFiles returns the removed IDs of the "files" edge to the File entity.
func (m *UserMutation) RemovedFilesIDs() (ids []string) {
	for id := range m.removedfiles {
		ids = append(ids, id)
	}
	return
}

// FilesIDs returns the "files" edge IDs in the mutation.
func (m *UserMutation) FilesIDs() (ids []string) {
	for id := range m.files {
		ids = append(ids, id)
	}
	return
}

// ResetFiles resets all changes to the "files" edge.
func (m *UserMutation) ResetFiles() {
	m.files = nil
	m.clearedfiles = false
	m.removedfiles = nil
}

// AddGroupIDs adds the "groups" edge to the Group entity by ids.
func (m *UserMutation) AddGroupIDs(ids ...string) {
	if m.groups == nil {
		m.groups = make(map[string]struct{})
	}
	for i := range ids {
		m.groups[ids[i]] = struct{}{}
	}
}

// ClearGroups clears the "groups" edge to the Group entity.
func (m *UserMutation) ClearGroups() {
	m.clearedgroups = true
}

// GroupsCleared returns if the "groups" edge to the Group entity was cleared.
func (m *UserMutation) GroupsCleared() bool {
	return m.clearedgroups
}

// RemoveGroupIDs removes the "groups" edge to the Group entity by IDs.
func (m *UserMutation) RemoveGroupIDs(ids ...string) {
	if m.removedgroups == nil {
		m.removedgroups = make(map[string]struct{})
	}
	for i := range ids {
		m.removedgroups[ids[i]] = struct{}{}
	}
}

// RemovedGroups returns the removed IDs of the "groups" edge to the Group entity.
func (m *UserMutation) RemovedGroupsIDs() (ids []string) {
	for id := range m.removedgroups {
		ids = append(ids, id)
	}
	return
}

// GroupsIDs returns the "groups" edge IDs in the mutation.
func (m *UserMutation) GroupsIDs() (ids []string) {
	for id := range m.groups {
		ids = append(ids, id)
	}
	return
}

// ResetGroups resets all changes to the "groups" edge.
func (m *UserMutation) ResetGroups() {
	m.groups = nil
	m.clearedgroups = false
	m.removedgroups = nil
}

// AddFriendIDs adds the "friends" edge to the User entity by ids.
func (m *UserMutation) AddFriendIDs(ids ...string) {
	if m.friends == nil {
		m.friends = make(map[string]struct{})
	}
	for i := range ids {
		m.friends[ids[i]] = struct{}{}
	}
}

// ClearFriends clears the "friends" edge to the User entity.
func (m *UserMutation) ClearFriends() {
	m.clearedfriends = true
}

// FriendsCleared returns if the "friends" edge to the User entity was cleared.
func (m *UserMutation) FriendsCleared() bool {
	return m.clearedfriends
}

// RemoveFriendIDs removes the "friends" edge to the User entity by IDs.
func (m *UserMutation) RemoveFriendIDs(ids ...string) {
	if m.removedfriends == nil {
		m.removedfriends = make(map[string]struct{})
	}
	for i := range ids {
		m.removedfriends[ids[i]] = struct{}{}
	}
}

// RemovedFriends returns the removed IDs of the "friends" edge to the User entity.
func (m *UserMutation) RemovedFriendsIDs() (ids []string) {
	for id := range m.removedfriends {
		ids = append(ids, id)
	}
	return
}

// FriendsIDs returns the "friends" edge IDs in the mutation.
func (m *UserMutation) FriendsIDs() (ids []string) {
	for id := range m.friends {
		ids = append(ids, id)
	}
	return
}

// ResetFriends resets all changes to the "friends" edge.
func (m *UserMutation) ResetFriends() {
	m.friends = nil
	m.clearedfriends = false
	m.removedfriends = nil
}

// AddFollowerIDs adds the "followers" edge to the User entity by ids.
func (m *UserMutation) AddFollowerIDs(ids ...string) {
	if m.followers == nil {
		m.followers = make(map[string]struct{})
	}
	for i := range ids {
		m.followers[ids[i]] = struct{}{}
	}
}

// ClearFollowers clears the "followers" edge to the User entity.
func (m *UserMutation) ClearFollowers() {
	m.clearedfollowers = true
}

// FollowersCleared returns if the "followers" edge to the User entity was cleared.
func (m *UserMutation) FollowersCleared() bool {
	return m.clearedfollowers
}

// RemoveFollowerIDs removes the "followers" edge to the User entity by IDs.
func (m *UserMutation) RemoveFollowerIDs(ids ...string) {
	if m.removedfollowers == nil {
		m.removedfollowers = make(map[string]struct{})
	}
	for i := range ids {
		m.removedfollowers[ids[i]] = struct{}{}
	}
}

// RemovedFollowers returns the removed IDs of the "followers" edge to the User entity.
func (m *UserMutation) RemovedFollowersIDs() (ids []string) {
	for id := range m.removedfollowers {
		ids = append(ids, id)
	}
	return
}

// FollowersIDs returns the "followers" edge IDs in the mutation.
func (m *UserMutation) FollowersIDs() (ids []string) {
	for id := range m.followers {
		ids = append(ids, id)
	}
	return
}

// ResetFollowers resets all changes to the "followers" edge.
func (m *UserMutation) ResetFollowers() {
	m.followers = nil
	m.clearedfollowers = false
	m.removedfollowers = nil
}

// AddFollowingIDs adds the "following" edge to the User entity by ids.
func (m *UserMutation) AddFollowingIDs(ids ...string) {
	if m.following == nil {
		m.following = make(map[string]struct{})
	}
	for i := range ids {
		m.following[ids[i]] = struct{}{}
	}
}

// ClearFollowing clears the "following" edge to the User entity.
func (m *UserMutation) ClearFollowing() {
	m.clearedfollowing = true
}

// FollowingCleared returns if the "following" edge to the User entity was cleared.
func (m *UserMutation) FollowingCleared() bool {
	return m.clearedfollowing
}

// RemoveFollowingIDs removes the "following" edge to the User entity by IDs.
func (m *UserMutation) RemoveFollowingIDs(ids ...string) {
	if m.removedfollowing == nil {
		m.removedfollowing = make(map[string]struct{})
	}
	for i := range ids {
		m.removedfollowing[ids[i]] = struct{}{}
	}
}

// RemovedFollowing returns the removed IDs of the "following" edge to the User entity.
func (m *UserMutation) RemovedFollowingIDs() (ids []string) {
	for id := range m.removedfollowing {
		ids = append(ids, id)
	}
	return
}

// FollowingIDs returns the "following" edge IDs in the mutation.
func (m *UserMutation) FollowingIDs() (ids []string) {
	for id := range m.following {
		ids = append(ids, id)
	}
	return
}

// ResetFollowing resets all changes to the "following" edge.
func (m *UserMutation) ResetFollowing() {
	m.following = nil
	m.clearedfollowing = false
	m.removedfollowing = nil
}

// SetTeamID sets the "team" edge to the Pet entity by id.
func (m *UserMutation) SetTeamID(id string) {
	m.team = &id
}

// ClearTeam clears the "team" edge to the Pet entity.
func (m *UserMutation) ClearTeam() {
	m.clearedteam = true
}

// TeamCleared returns if the "team" edge to the Pet entity was cleared.
func (m *UserMutation) TeamCleared() bool {
	return m.clearedteam
}

// TeamID returns the "team" edge ID in the mutation.
func (m *UserMutation) TeamID() (id string, exists bool) {
	if m.team != nil {
		return *m.team, true
	}
	return
}

// TeamIDs returns the "team" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// TeamID instead. It exists only for internal usage by the builders.
func (m *UserMutation) TeamIDs() (ids []string) {
	if id := m.team; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetTeam resets all changes to the "team" edge.
func (m *UserMutation) ResetTeam() {
	m.team = nil
	m.clearedteam = false
}

// SetSpouseID sets the "spouse" edge to the User entity by id.
func (m *UserMutation) SetSpouseID(id string) {
	m.spouse = &id
}

// ClearSpouse clears the "spouse" edge to the User entity.
func (m *UserMutation) ClearSpouse() {
	m.clearedspouse = true
}

// SpouseCleared returns if the "spouse" edge to the User entity was cleared.
func (m *UserMutation) SpouseCleared() bool {
	return m.clearedspouse
}

// SpouseID returns the "spouse" edge ID in the mutation.
func (m *UserMutation) SpouseID() (id string, exists bool) {
	if m.spouse != nil {
		return *m.spouse, true
	}
	return
}

// SpouseIDs returns the "spouse" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// SpouseID instead. It exists only for internal usage by the builders.
func (m *UserMutation) SpouseIDs() (ids []string) {
	if id := m.spouse; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetSpouse resets all changes to the "spouse" edge.
func (m *UserMutation) ResetSpouse() {
	m.spouse = nil
	m.clearedspouse = false
}

// AddChildIDs adds the "children" edge to the User entity by ids.
func (m *UserMutation) AddChildIDs(ids ...string) {
	if m.children == nil {
		m.children = make(map[string]struct{})
	}
	for i := range ids {
		m.children[ids[i]] = struct{}{}
	}
}

// ClearChildren clears the "children" edge to the User entity.
func (m *UserMutation) ClearChildren() {
	m.clearedchildren = true
}

// ChildrenCleared returns if the "children" edge to the User entity was cleared.
func (m *UserMutation) ChildrenCleared() bool {
	return m.clearedchildren
}

// RemoveChildIDs removes the "children" edge to the User entity by IDs.
func (m *UserMutation) RemoveChildIDs(ids ...string) {
	if m.removedchildren == nil {
		m.removedchildren = make(map[string]struct{})
	}
	for i := range ids {
		m.removedchildren[ids[i]] = struct{}{}
	}
}

// RemovedChildren returns the removed IDs of the "children" edge to the User entity.
func (m *UserMutation) RemovedChildrenIDs() (ids []string) {
	for id := range m.removedchildren {
		ids = append(ids, id)
	}
	return
}

// ChildrenIDs returns the "children" edge IDs in the mutation.
func (m *UserMutation) ChildrenIDs() (ids []string) {
	for id := range m.children {
		ids = append(ids, id)
	}
	return
}

// ResetChildren resets all changes to the "children" edge.
func (m *UserMutation) ResetChildren() {
	m.children = nil
	m.clearedchildren = false
	m.removedchildren = nil
}

// SetParentID sets the "parent" edge to the User entity by id.
func (m *UserMutation) SetParentID(id string) {
	m.parent = &id
}

// ClearParent clears the "parent" edge to the User entity.
func (m *UserMutation) ClearParent() {
	m.clearedparent = true
}

// ParentCleared returns if the "parent" edge to the User entity was cleared.
func (m *UserMutation) ParentCleared() bool {
	return m.clearedparent
}

// ParentID returns the "parent" edge ID in the mutation.
func (m *UserMutation) ParentID() (id string, exists bool) {
	if m.parent != nil {
		return *m.parent, true
	}
	return
}

// ParentIDs returns the "parent" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// ParentID instead. It exists only for internal usage by the builders.
func (m *UserMutation) ParentIDs() (ids []string) {
	if id := m.parent; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetParent resets all changes to the "parent" edge.
func (m *UserMutation) ResetParent() {
	m.parent = nil
	m.clearedparent = false
}

// Op returns the operation name.
func (m *UserMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (User).
func (m *UserMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserMutation) Fields() []string {
	fields := make([]string, 0, 10)
	if m.optional_int != nil {
		fields = append(fields, user.FieldOptionalInt)
	}
	if m.age != nil {
		fields = append(fields, user.FieldAge)
	}
	if m.name != nil {
		fields = append(fields, user.FieldName)
	}
	if m.last != nil {
		fields = append(fields, user.FieldLast)
	}
	if m.nickname != nil {
		fields = append(fields, user.FieldNickname)
	}
	if m.address != nil {
		fields = append(fields, user.FieldAddress)
	}
	if m.phone != nil {
		fields = append(fields, user.FieldPhone)
	}
	if m.password != nil {
		fields = append(fields, user.FieldPassword)
	}
	if m.role != nil {
		fields = append(fields, user.FieldRole)
	}
	if m._SSOCert != nil {
		fields = append(fields, user.FieldSSOCert)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case user.FieldOptionalInt:
		return m.OptionalInt()
	case user.FieldAge:
		return m.Age()
	case user.FieldName:
		return m.Name()
	case user.FieldLast:
		return m.Last()
	case user.FieldNickname:
		return m.Nickname()
	case user.FieldAddress:
		return m.Address()
	case user.FieldPhone:
		return m.Phone()
	case user.FieldPassword:
		return m.Password()
	case user.FieldRole:
		return m.Role()
	case user.FieldSSOCert:
		return m.SSOCert()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case user.FieldOptionalInt:
		return m.OldOptionalInt(ctx)
	case user.FieldAge:
		return m.OldAge(ctx)
	case user.FieldName:
		return m.OldName(ctx)
	case user.FieldLast:
		return m.OldLast(ctx)
	case user.FieldNickname:
		return m.OldNickname(ctx)
	case user.FieldAddress:
		return m.OldAddress(ctx)
	case user.FieldPhone:
		return m.OldPhone(ctx)
	case user.FieldPassword:
		return m.OldPassword(ctx)
	case user.FieldRole:
		return m.OldRole(ctx)
	case user.FieldSSOCert:
		return m.OldSSOCert(ctx)
	}
	return nil, fmt.Errorf("unknown User field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) SetField(name string, value ent.Value) error {
	switch name {
	case user.FieldOptionalInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOptionalInt(v)
		return nil
	case user.FieldAge:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAge(v)
		return nil
	case user.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case user.FieldLast:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLast(v)
		return nil
	case user.FieldNickname:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNickname(v)
		return nil
	case user.FieldAddress:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAddress(v)
		return nil
	case user.FieldPhone:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPhone(v)
		return nil
	case user.FieldPassword:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPassword(v)
		return nil
	case user.FieldRole:
		v, ok := value.(user.Role)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRole(v)
		return nil
	case user.FieldSSOCert:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSSOCert(v)
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserMutation) AddedFields() []string {
	var fields []string
	if m.addoptional_int != nil {
		fields = append(fields, user.FieldOptionalInt)
	}
	if m.addage != nil {
		fields = append(fields, user.FieldAge)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case user.FieldOptionalInt:
		return m.AddedOptionalInt()
	case user.FieldAge:
		return m.AddedAge()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) AddField(name string, value ent.Value) error {
	switch name {
	case user.FieldOptionalInt:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddOptionalInt(v)
		return nil
	case user.FieldAge:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddAge(v)
		return nil
	}
	return fmt.Errorf("unknown User numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(user.FieldOptionalInt) {
		fields = append(fields, user.FieldOptionalInt)
	}
	if m.FieldCleared(user.FieldNickname) {
		fields = append(fields, user.FieldNickname)
	}
	if m.FieldCleared(user.FieldAddress) {
		fields = append(fields, user.FieldAddress)
	}
	if m.FieldCleared(user.FieldPhone) {
		fields = append(fields, user.FieldPhone)
	}
	if m.FieldCleared(user.FieldPassword) {
		fields = append(fields, user.FieldPassword)
	}
	if m.FieldCleared(user.FieldSSOCert) {
		fields = append(fields, user.FieldSSOCert)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserMutation) ClearField(name string) error {
	switch name {
	case user.FieldOptionalInt:
		m.ClearOptionalInt()
		return nil
	case user.FieldNickname:
		m.ClearNickname()
		return nil
	case user.FieldAddress:
		m.ClearAddress()
		return nil
	case user.FieldPhone:
		m.ClearPhone()
		return nil
	case user.FieldPassword:
		m.ClearPassword()
		return nil
	case user.FieldSSOCert:
		m.ClearSSOCert()
		return nil
	}
	return fmt.Errorf("unknown User nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserMutation) ResetField(name string) error {
	switch name {
	case user.FieldOptionalInt:
		m.ResetOptionalInt()
		return nil
	case user.FieldAge:
		m.ResetAge()
		return nil
	case user.FieldName:
		m.ResetName()
		return nil
	case user.FieldLast:
		m.ResetLast()
		return nil
	case user.FieldNickname:
		m.ResetNickname()
		return nil
	case user.FieldAddress:
		m.ResetAddress()
		return nil
	case user.FieldPhone:
		m.ResetPhone()
		return nil
	case user.FieldPassword:
		m.ResetPassword()
		return nil
	case user.FieldRole:
		m.ResetRole()
		return nil
	case user.FieldSSOCert:
		m.ResetSSOCert()
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserMutation) AddedEdges() []string {
	edges := make([]string, 0, 11)
	if m.card != nil {
		edges = append(edges, user.EdgeCard)
	}
	if m.pets != nil {
		edges = append(edges, user.EdgePets)
	}
	if m.files != nil {
		edges = append(edges, user.EdgeFiles)
	}
	if m.groups != nil {
		edges = append(edges, user.EdgeGroups)
	}
	if m.friends != nil {
		edges = append(edges, user.EdgeFriends)
	}
	if m.followers != nil {
		edges = append(edges, user.EdgeFollowers)
	}
	if m.following != nil {
		edges = append(edges, user.EdgeFollowing)
	}
	if m.team != nil {
		edges = append(edges, user.EdgeTeam)
	}
	if m.spouse != nil {
		edges = append(edges, user.EdgeSpouse)
	}
	if m.children != nil {
		edges = append(edges, user.EdgeChildren)
	}
	if m.parent != nil {
		edges = append(edges, user.EdgeParent)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeCard:
		if id := m.card; id != nil {
			return []ent.Value{*id}
		}
	case user.EdgePets:
		ids := make([]ent.Value, 0, len(m.pets))
		for id := range m.pets {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeFiles:
		ids := make([]ent.Value, 0, len(m.files))
		for id := range m.files {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeGroups:
		ids := make([]ent.Value, 0, len(m.groups))
		for id := range m.groups {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeFriends:
		ids := make([]ent.Value, 0, len(m.friends))
		for id := range m.friends {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeFollowers:
		ids := make([]ent.Value, 0, len(m.followers))
		for id := range m.followers {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeFollowing:
		ids := make([]ent.Value, 0, len(m.following))
		for id := range m.following {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeTeam:
		if id := m.team; id != nil {
			return []ent.Value{*id}
		}
	case user.EdgeSpouse:
		if id := m.spouse; id != nil {
			return []ent.Value{*id}
		}
	case user.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.children))
		for id := range m.children {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeParent:
		if id := m.parent; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserMutation) RemovedEdges() []string {
	edges := make([]string, 0, 11)
	if m.removedpets != nil {
		edges = append(edges, user.EdgePets)
	}
	if m.removedfiles != nil {
		edges = append(edges, user.EdgeFiles)
	}
	if m.removedgroups != nil {
		edges = append(edges, user.EdgeGroups)
	}
	if m.removedfriends != nil {
		edges = append(edges, user.EdgeFriends)
	}
	if m.removedfollowers != nil {
		edges = append(edges, user.EdgeFollowers)
	}
	if m.removedfollowing != nil {
		edges = append(edges, user.EdgeFollowing)
	}
	if m.removedchildren != nil {
		edges = append(edges, user.EdgeChildren)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case user.EdgePets:
		ids := make([]ent.Value, 0, len(m.removedpets))
		for id := range m.removedpets {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeFiles:
		ids := make([]ent.Value, 0, len(m.removedfiles))
		for id := range m.removedfiles {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeGroups:
		ids := make([]ent.Value, 0, len(m.removedgroups))
		for id := range m.removedgroups {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeFriends:
		ids := make([]ent.Value, 0, len(m.removedfriends))
		for id := range m.removedfriends {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeFollowers:
		ids := make([]ent.Value, 0, len(m.removedfollowers))
		for id := range m.removedfollowers {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeFollowing:
		ids := make([]ent.Value, 0, len(m.removedfollowing))
		for id := range m.removedfollowing {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.removedchildren))
		for id := range m.removedchildren {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserMutation) ClearedEdges() []string {
	edges := make([]string, 0, 11)
	if m.clearedcard {
		edges = append(edges, user.EdgeCard)
	}
	if m.clearedpets {
		edges = append(edges, user.EdgePets)
	}
	if m.clearedfiles {
		edges = append(edges, user.EdgeFiles)
	}
	if m.clearedgroups {
		edges = append(edges, user.EdgeGroups)
	}
	if m.clearedfriends {
		edges = append(edges, user.EdgeFriends)
	}
	if m.clearedfollowers {
		edges = append(edges, user.EdgeFollowers)
	}
	if m.clearedfollowing {
		edges = append(edges, user.EdgeFollowing)
	}
	if m.clearedteam {
		edges = append(edges, user.EdgeTeam)
	}
	if m.clearedspouse {
		edges = append(edges, user.EdgeSpouse)
	}
	if m.clearedchildren {
		edges = append(edges, user.EdgeChildren)
	}
	if m.clearedparent {
		edges = append(edges, user.EdgeParent)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserMutation) EdgeCleared(name string) bool {
	switch name {
	case user.EdgeCard:
		return m.clearedcard
	case user.EdgePets:
		return m.clearedpets
	case user.EdgeFiles:
		return m.clearedfiles
	case user.EdgeGroups:
		return m.clearedgroups
	case user.EdgeFriends:
		return m.clearedfriends
	case user.EdgeFollowers:
		return m.clearedfollowers
	case user.EdgeFollowing:
		return m.clearedfollowing
	case user.EdgeTeam:
		return m.clearedteam
	case user.EdgeSpouse:
		return m.clearedspouse
	case user.EdgeChildren:
		return m.clearedchildren
	case user.EdgeParent:
		return m.clearedparent
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserMutation) ClearEdge(name string) error {
	switch name {
	case user.EdgeCard:
		m.ClearCard()
		return nil
	case user.EdgeTeam:
		m.ClearTeam()
		return nil
	case user.EdgeSpouse:
		m.ClearSpouse()
		return nil
	case user.EdgeParent:
		m.ClearParent()
		return nil
	}
	return fmt.Errorf("unknown User unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserMutation) ResetEdge(name string) error {
	switch name {
	case user.EdgeCard:
		m.ResetCard()
		return nil
	case user.EdgePets:
		m.ResetPets()
		return nil
	case user.EdgeFiles:
		m.ResetFiles()
		return nil
	case user.EdgeGroups:
		m.ResetGroups()
		return nil
	case user.EdgeFriends:
		m.ResetFriends()
		return nil
	case user.EdgeFollowers:
		m.ResetFollowers()
		return nil
	case user.EdgeFollowing:
		m.ResetFollowing()
		return nil
	case user.EdgeTeam:
		m.ResetTeam()
		return nil
	case user.EdgeSpouse:
		m.ResetSpouse()
		return nil
	case user.EdgeChildren:
		m.ResetChildren()
		return nil
	case user.EdgeParent:
		m.ResetParent()
		return nil
	}
	return fmt.Errorf("unknown User edge %s", name)
}
