/***************************************************************************
                          application.h  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 1999-2002 by Brian Ashe & Jacques Fortier
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef APPLICATION_H
#define APPLICATION_H
#include <gtk/gtk.h>
#include <vector>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "connectdialog.h"
#include "check_table_collision.h"
#include "move_balls.h"
#include "apply_friction.h"
#include "draw_ball.h"
#include "pointer_selects.h"
#include "check_pocket.h"
#include "vec2d.h"
#include "point2d.h"
#include "ball.h"
#include "indentify_ball.h"
#include "game.h"

/**
  *@author Brian Ashe & Jacques Fortier
  */

extern int udl, udr, udt, udb;

class Application {
public: 
	std::vector<Ball> balls;		// Balls on the table
	std::vector<int> sunk_balls1;	// Balls in the first rack
	std::vector<int> sunk_balls2;	// Balls in the second rack
	Ball *selected;				// Selected ball (shooting)
	Game *thegame;				// The Game
	int width, height, gap;		// Table dimensions
	bool running, placing_cue, hit_moving, superhuman, aimlineoff;
								// Is app running?, Are we placing the cue ball,
								// Can we hit moving balls, Are we super human,
								// Is there an aiming line
	bool sunk_tf, collide_tf, bounce_tf;
	bool sound;
	bool connected;
	int last_sunk;
	int table_choice;
	gchar s1 [10];
	gchar s2 [10];

	
	int sunk_balls;

	char coll_snd[12000];
	int coll_sndc;
	char bnc_snd[1025];
	int bnc_sndc;
	char pock_snd[194000];
	int pock_sndc;

	int game_name;

	double FRICTION;
	double BUMPER_DRAG;
	double COLLIDE_DRAG;

	GdkRectangle table;
	Point2D shoot;
	GdkVisual *visual;
	GdkColormap *colormap;
	GdkGC *gc;
	GdkPixmap *buf_pixmap;
	GdkPixmap **balls_pixmaps;
	GdkPixmap **balls_pixmap_masks;
	GdkPixmap **balls_big_pixmaps;
	GdkPixmap **balls_big_pixmap_masks;
	GdkPixmap *rack_pixmap;
	GdkPixmap *rack_mask;
	GdkPixmap **table_pixmaps;
	GdkColor *black;
	GdkColor *red;
	GdkColor *yellow;
	GdkColor *p1_color;
	GdkColor *p2_color;
	GdkColor *table_color;
	GdkColor *message_colours[15];
	GtkWidget *rack_area;
	GtkWidget *drawing_area;
	GtkWidget *opt_dlg;
	GtkWidget *chat_text;
	GtkObject *friction_adjustment;
	GtkObject *collide_drag_adjustment;
	GtkObject *bumper_drag_adjustment;

	ConnectDialog *connect_dialog;

	guint button_press_handler_id, qbp_hndlr;
	
	Application();
	~Application();
	void init();
	void destroy();
	void updateBalls ();
	void replaceBall ();
	void resetTable ();
	void paint (GdkDrawable *pixmap, GdkGC *gc);
	void mouse_down (double x, double y);
	void mouse_up (double x, double y);
	void mouse_drag (double x, double y);
	void update_rack();
	void update_table();
	void new_cue_ball();
	GdkPixmap *load_pixmap(GdkPixmap **mask, char *file);
	void add_pixmap_directory (const gchar *directory);
	gchar* check_file_exists (const gchar *directory, const gchar *filename);
	void load_ball_xpms();
	void load_sounds();
	void init_sound();
	static gint cue_ball_placed(GtkWidget *widget, GdkEventButton *event, Application *app);
	void print_message(const char *, int = 0);
	void ball_in_hand();
	int low_ball();
	float friction()
	{
		return GTK_ADJUSTMENT(friction_adjustment)->value;
	}
	float collide_drag()
	{
		return GTK_ADJUSTMENT(collide_drag_adjustment)->value;
	}
	float bumper_drag()
	{
		return GTK_ADJUSTMENT(bumper_drag_adjustment)->value;
	}
	void new_ball(double x, double y , int bn, int category = other, bool isc = false, bool ise = false, bool isn = false, bool isso = false, bool isst = false)
	{
		balls.push_back(Ball(x, y, BALL_SIZE, bn, balls_pixmaps[bn],
		                     balls_pixmap_masks[bn], balls_big_pixmaps[bn],
		                     balls_big_pixmap_masks[bn], category, isc, ise, isn, isso, isst));
	}

};

#endif
