/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.SimpleInputStream;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSPacket;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSReader {
    private static final Logger logger;
    private final boolean isLoggable = logger.isLoggable(Level.FINEST);
    private final TDSChannel tdsChannel;
    private final SQLServerConnection con;
    private TDSPacket currentPacket;
    private TDSPacket lastPacket = this.currentPacket = new TDSPacket(0);
    private int payloadOffset = 0;
    private int packetNum = 0;
    private boolean isStreaming = true;
    private final byte[] valueBytes = new byte[256];
    static final String guidTemplate = "NNNNNNNN-NNNN-NNNN-NNNN-NNNNNNNNNNNN";
    static final /* synthetic */ boolean $assertionsDisabled;

    final String toLogString() {
        return "TDSReader@" + Integer.toHexString(this.hashCode()) + " (" + this.con.toLogString() + ")";
    }

    final SQLServerConnection getConnection() {
        return this.con;
    }

    TDSReader(TDSChannel tDSChannel, SQLServerConnection sQLServerConnection) {
        this.tdsChannel = tDSChannel;
        this.con = sQLServerConnection;
        tDSChannel.setRecvBufferSize(sQLServerConnection.getTDSPacketSize());
    }

    final void throwInvalidTDS() throws SQLServerException {
        logger.severe(this.toLogString() + " got unexpected value in TDS response at offset:" + this.payloadOffset);
        this.con.throwInvalidTDS();
    }

    final boolean responseEOM() {
        return this.lastPacket.isEOM();
    }

    final synchronized void readResponse() throws SQLServerException {
        if (!$assertionsDisabled && this.tdsChannel.numMsgsRcvd > this.tdsChannel.numMsgsSent) {
            throw new AssertionError();
        }
        if (!this.responseEOM()) {
            if (this.isLoggable) {
                logger.finest(this.toLogString() + ": Buffering all remaining response bytes...");
            }
            while (this.readPacket()) {
            }
        }
        if (!$assertionsDisabled && this.tdsChannel.numMsgsRcvd > this.tdsChannel.numMsgsSent) {
            throw new AssertionError();
        }
    }

    private final boolean ensurePayload() throws SQLServerException {
        if (this.payloadOffset == this.currentPacket.payloadLength && !this.nextPacket()) {
            return false;
        }
        if (!$assertionsDisabled && this.payloadOffset >= this.currentPacket.payloadLength) {
            throw new AssertionError();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean nextPacket() throws SQLServerException {
        if (!$assertionsDisabled && null == this.currentPacket) {
            throw new AssertionError();
        }
        TDSPacket tDSPacket = this.currentPacket;
        if (!$assertionsDisabled && this.payloadOffset != tDSPacket.payloadLength) {
            throw new AssertionError();
        }
        Object object = this;
        synchronized (object) {
            if (null == tDSPacket.next) {
                if (!$assertionsDisabled && tDSPacket != this.lastPacket) {
                    throw new AssertionError();
                }
                if (tDSPacket.isEOM()) {
                    return false;
                }
                this.readPacket();
            }
        }
        if (!$assertionsDisabled && null == tDSPacket.next) {
            throw new AssertionError();
        }
        object = tDSPacket.next;
        if (this.isStreaming) {
            tDSPacket.next = null;
        }
        this.currentPacket = object;
        this.payloadOffset = 0;
        return true;
    }

    final boolean readPacket() throws SQLServerException {
        return this.readPacket(4);
    }

    final boolean readPacket(int n) throws SQLServerException {
        int n2;
        int n3;
        int n4;
        if (!$assertionsDisabled && this.tdsChannel.numMsgsRcvd >= this.tdsChannel.numMsgsSent) {
            throw new AssertionError((Object)("numMsgsRcvd:" + this.tdsChannel.numMsgsRcvd + " should be less than numMsgsSent:" + this.tdsChannel.numMsgsSent));
        }
        TDSPacket tDSPacket = new TDSPacket(this.con.getTDSPacketSize());
        for (n3 = 0; n3 < 8; n3 += n4) {
            n4 = this.tdsChannel.read(tDSPacket.header, n3, 8 - n3);
            if (n4 >= 0) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " Premature EOS in response. packetNum:" + this.packetNum + " headerBytesRead:" + n3);
            }
            this.con.terminate(3, 0 == this.packetNum && 0 == n3 ? SQLServerException.getErrString("R_noServerResponse") : SQLServerException.getErrString("R_truncatedServerResponse"));
        }
        if (tDSPacket.header[0] != n) {
            logger.warning(this.toLogString() + " Unexpected message type:" + tDSPacket.header[0] + " in TDS header; expected type:" + n);
            this.throwInvalidTDS();
        }
        if (tDSPacket.isEOM()) {
            ++this.tdsChannel.numMsgsRcvd;
        }
        if ((n3 = tDSPacket.header[3] & 0xFF | (tDSPacket.header[2] & 0xFF) << 8) < 8 || n3 > this.con.getTDSPacketSize()) {
            logger.warning(this.toLogString() + " TDS header contained invalid packet length:" + n3 + "; packet size:" + this.con.getTDSPacketSize());
            this.throwInvalidTDS();
        }
        tDSPacket.payloadLength = n3 - 8;
        n4 = tDSPacket.header[5] & 0xFF | (tDSPacket.header[4] & 0xFF) << 8;
        byte[] byArray = null;
        if (this.tdsChannel.isLoggingPackets()) {
            byArray = new byte[n3];
            System.arraycopy(tDSPacket.header, 0, byArray, 0, 8);
        }
        for (int i = 0; i < tDSPacket.payloadLength; i += n2) {
            n2 = this.tdsChannel.read(tDSPacket.payload, i, tDSPacket.payloadLength - i);
            if (n2 >= 0) continue;
            this.con.terminate(3, SQLServerException.getErrString("R_truncatedServerResponse"));
        }
        ++this.packetNum;
        this.lastPacket.next = tDSPacket;
        this.lastPacket = tDSPacket;
        if (this.tdsChannel.isLoggingPackets()) {
            System.arraycopy(tDSPacket.payload, 0, byArray, 8, tDSPacket.payloadLength);
            this.tdsChannel.logPacket(byArray, 0, n3, this.toLogString() + " received Packet:" + this.packetNum + " from SPID:" + n4 + " (" + tDSPacket.payloadLength + " bytes)");
        }
        return !tDSPacket.isEOM();
    }

    final TDSReaderMark mark() {
        TDSReaderMark tDSReaderMark = new TDSReaderMark(this.currentPacket, this.payloadOffset);
        this.isStreaming = false;
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": Buffering starting at mark MarkID:" + tDSReaderMark);
        }
        return tDSReaderMark;
    }

    final void reset(TDSReaderMark tDSReaderMark) {
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": Resetting to MarkID:" + tDSReaderMark);
        }
        this.currentPacket = tDSReaderMark.packet;
        this.payloadOffset = tDSReaderMark.payloadOffset;
    }

    final void stream() {
        this.isStreaming = true;
    }

    final int available() {
        int n = this.currentPacket.payloadLength - this.payloadOffset;
        TDSPacket tDSPacket = this.currentPacket.next;
        while (null != tDSPacket) {
            n += tDSPacket.payloadLength;
            tDSPacket = tDSPacket.next;
        }
        return n;
    }

    final int peekTokenType() throws SQLServerException {
        if (!this.ensurePayload()) {
            return -1;
        }
        return this.currentPacket.payload[this.payloadOffset] & 0xFF;
    }

    final int readUnsignedByte() throws SQLServerException {
        if (!this.ensurePayload()) {
            this.throwInvalidTDS();
        }
        return this.currentPacket.payload[this.payloadOffset++] & 0xFF;
    }

    final short readShort() throws SQLServerException {
        if (this.payloadOffset + 2 <= this.currentPacket.payloadLength) {
            short s = Util.readShort(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 2;
            return s;
        }
        return Util.readShort(this.readWrappedBytes(2), 0);
    }

    final int readUnsignedShort() throws SQLServerException {
        if (this.payloadOffset + 2 <= this.currentPacket.payloadLength) {
            int n = Util.readUnsignedShort(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 2;
            return n;
        }
        return Util.readUnsignedShort(this.readWrappedBytes(2), 0);
    }

    final String readUnicodeString(int n) throws SQLServerException {
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        this.readBytes(byArray, 0, n2);
        return Util.readUnicodeString(byArray, 0, n2);
    }

    final char readChar() throws SQLServerException {
        return (char)this.readShort();
    }

    final int readInt() throws SQLServerException {
        if (this.payloadOffset + 4 <= this.currentPacket.payloadLength) {
            int n = Util.readInt(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 4;
            return n;
        }
        return Util.readInt(this.readWrappedBytes(4), 0);
    }

    final int readIntBigEndian() throws SQLServerException {
        if (this.payloadOffset + 4 <= this.currentPacket.payloadLength) {
            int n = Util.readIntBigEndian(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 4;
            return n;
        }
        return Util.readIntBigEndian(this.readWrappedBytes(4), 0);
    }

    final long readUnsignedInt() throws SQLServerException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    final long readLong() throws SQLServerException {
        if (this.payloadOffset + 8 <= this.currentPacket.payloadLength) {
            long l = Util.readLong(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 8;
            return l;
        }
        return Util.readLong(this.readWrappedBytes(8), 0);
    }

    final void readBytes(byte[] byArray, int n, int n2) throws SQLServerException {
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if (!this.ensurePayload()) {
                this.throwInvalidTDS();
            }
            if ((n4 = n2 - n3) > this.currentPacket.payloadLength - this.payloadOffset) {
                n4 = this.currentPacket.payloadLength - this.payloadOffset;
            }
            System.arraycopy(this.currentPacket.payload, this.payloadOffset, byArray, n + n3, n4);
            n3 += n4;
            this.payloadOffset += n4;
        }
    }

    final byte[] readWrappedBytes(int n) throws SQLServerException {
        this.readBytes(this.valueBytes, 0, n);
        return this.valueBytes;
    }

    final Object readUnicodeString(int n, int n2, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        SimpleInputStream simpleInputStream = new SimpleInputStream(this, n, inputStreamGetterArgs, serverDTVImpl);
        if (2 == inputStreamGetterArgs.streamType && inputStreamGetterArgs.isAdaptive) {
            return simpleInputStream;
        }
        byte[] byArray = simpleInputStream.getBytes();
        return DDC.convertStringToObject(Util.readUnicodeString(byArray, 0, n), "UTF-16LE", n2, inputStreamGetterArgs.streamType);
    }

    final Object readDecimal(int n, TypeInfo typeInfo, int n2, int n3) throws SQLServerException {
        if (n > this.valueBytes.length) {
            logger.warning(this.toLogString() + " Invalid value length:" + n);
            this.throwInvalidTDS();
        }
        this.readBytes(this.valueBytes, 0, n);
        int n4 = 0 == this.valueBytes[0] ? -1 : 1;
        byte[] byArray = new byte[n - 1];
        for (int i = 1; i <= byArray.length; ++i) {
            byArray[byArray.length - i] = this.valueBytes[i];
        }
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(n4, byArray), typeInfo.getScale());
        return DDC.convertBigDecimalToObject(bigDecimal, n2, n3);
    }

    final Object readMoney(int n, int n2, int n3) throws SQLServerException {
        BigInteger bigInteger;
        switch (n) {
            case 8: {
                int n4 = this.readInt();
                int n5 = this.readInt();
                if (-2 == n2) {
                    byte[] byArray = new byte[8];
                    Util.writeIntBigEndian(n4, byArray, 0);
                    Util.writeIntBigEndian(n5, byArray, 4);
                    return byArray;
                }
                bigInteger = BigInteger.valueOf((long)n4 << 32 | (long)n5 & 0xFFFFFFFFL);
                break;
            }
            case 4: {
                if (-2 == n2) {
                    byte[] byArray = new byte[4];
                    Util.writeIntBigEndian(this.readInt(), byArray, 0);
                    return byArray;
                }
                bigInteger = BigInteger.valueOf(this.readInt());
                break;
            }
            default: {
                this.throwInvalidTDS();
                return null;
            }
        }
        return DDC.convertBigDecimalToObject(new BigDecimal(bigInteger, 4), n2, n3);
    }

    final Object readReal(int n, int n2, int n3) throws SQLServerException {
        if (4 != n) {
            this.throwInvalidTDS();
        }
        return DDC.convertFloatToObject(Float.intBitsToFloat(this.readInt()), n2, n3);
    }

    final Object readFloat(int n, int n2, int n3) throws SQLServerException {
        if (8 != n) {
            this.throwInvalidTDS();
        }
        return DDC.convertDoubleToObject(Double.longBitsToDouble(this.readLong()), n2, n3);
    }

    final Object readDateTime(int n, Calendar calendar, int n2, int n3) throws SQLServerException {
        int n4;
        int n5;
        switch (n) {
            case 8: {
                n5 = this.readInt();
                int n6 = this.readInt();
                if (-2 == n2) {
                    byte[] byArray = new byte[8];
                    Util.writeIntBigEndian(n5, byArray, 0);
                    Util.writeIntBigEndian(n6, byArray, 4);
                    return byArray;
                }
                n4 = (n6 * 10 + 1) / 3;
                break;
            }
            case 4: {
                n5 = this.readUnsignedShort();
                int n7 = this.readUnsignedShort();
                if (-2 == n2) {
                    byte[] byArray = new byte[4];
                    Util.writeShortBigEndian((short)n5, byArray, 0);
                    Util.writeShortBigEndian((short)n7, byArray, 2);
                    return byArray;
                }
                n4 = n7 * 60 * 1000;
                break;
            }
            default: {
                this.throwInvalidTDS();
                return null;
            }
        }
        Calendar calendar2 = calendar;
        if (null == calendar2) {
            calendar2 = Calendar.getInstance(Locale.US);
        }
        calendar2.setLenient(true);
        calendar2.clear();
        if (91 == n2) {
            calendar2.set(1, 1900);
            calendar2.set(6, 1 + n5);
            return new Date(calendar2.getTimeInMillis());
        }
        if (92 == n2) {
            calendar2.set(14, n4);
            return new Time(calendar2.getTimeInMillis());
        }
        calendar2.set(1, 1900);
        calendar2.set(6, 1 + n5);
        calendar2.set(14, n4);
        Timestamp timestamp = new Timestamp(calendar2.getTimeInMillis());
        if (93 == n2) {
            return timestamp;
        }
        if (2 == n3) {
            return new StringReader(timestamp.toString());
        }
        return timestamp.toString();
    }

    final Object readBinary(int n, int n2, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        SimpleInputStream simpleInputStream = new SimpleInputStream(this, n, inputStreamGetterArgs, serverDTVImpl);
        if (1 == inputStreamGetterArgs.streamType || 3 == inputStreamGetterArgs.streamType) {
            return simpleInputStream;
        }
        byte[] byArray = simpleInputStream.getBytes();
        switch (n2) {
            case 2004: {
                return new SQLServerBlob(null, byArray);
            }
            case -1: 
            case 1: 
            case 12: {
                return DDC.convertStringToObject(Util.bytesToHexString(byArray, n), "UTF-16LE", n2, inputStreamGetterArgs.streamType);
            }
        }
        return byArray;
    }

    final Object readGUID(int n, int n2, int n3) throws SQLServerException {
        if (16 != n) {
            this.throwInvalidTDS();
        }
        byte[] byArray = new byte[16];
        this.readBytes(byArray, 0, 16);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                int n4;
                StringBuffer stringBuffer = new StringBuffer(guidTemplate.length());
                for (n4 = 0; n4 < 4; ++n4) {
                    stringBuffer.append(Util.hexChars[(byArray[3 - n4] & 0xF0) >> 4]);
                    stringBuffer.append(Util.hexChars[byArray[3 - n4] & 0xF]);
                }
                stringBuffer.append('-');
                for (n4 = 0; n4 < 2; ++n4) {
                    stringBuffer.append(Util.hexChars[(byArray[5 - n4] & 0xF0) >> 4]);
                    stringBuffer.append(Util.hexChars[byArray[5 - n4] & 0xF]);
                }
                stringBuffer.append('-');
                for (n4 = 0; n4 < 2; ++n4) {
                    stringBuffer.append(Util.hexChars[(byArray[7 - n4] & 0xF0) >> 4]);
                    stringBuffer.append(Util.hexChars[byArray[7 - n4] & 0xF]);
                }
                stringBuffer.append('-');
                for (n4 = 0; n4 < 2; ++n4) {
                    stringBuffer.append(Util.hexChars[(byArray[8 + n4] & 0xF0) >> 4]);
                    stringBuffer.append(Util.hexChars[byArray[8 + n4] & 0xF]);
                }
                stringBuffer.append('-');
                for (n4 = 0; n4 < 6; ++n4) {
                    stringBuffer.append(Util.hexChars[(byArray[10 + n4] & 0xF0) >> 4]);
                    stringBuffer.append(Util.hexChars[byArray[10 + n4] & 0xF]);
                }
                return DDC.convertStringToObject(stringBuffer.toString(), "UTF-16LE", n2, n3);
            }
        }
        if (1 == n3 || 3 == n3) {
            return new ByteArrayInputStream(byArray);
        }
        return byArray;
    }

    final void skip(int n) throws SQLServerException {
        while (n > 0) {
            int n2;
            if (!this.ensurePayload()) {
                this.throwInvalidTDS();
            }
            if ((n2 = n) > this.currentPacket.payloadLength - this.payloadOffset) {
                n2 = this.currentPacket.payloadLength - this.payloadOffset;
            }
            n -= n2;
            this.payloadOffset += n2;
        }
    }

    static {
        $assertionsDisabled = !TDSReader.class.desiredAssertionStatus();
        logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDSReader");
    }
}

