/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include <gdk/gdkkeysyms.h>
#include "include/support.h"
#include "include/command.h"
#include "include/message.h"

extern gboolean set_direction_by_key (LWWizard *wizard, guint key);

class LWCommandControlGo: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) args;
	
	g_return_val_if_fail (argc == 0, NULL);

	while (FALSE == g_queue_is_empty (context->queue_keys)) {
		guint key = GPOINTER_TO_UINT(g_queue_pop_head (context->queue_keys));
		if (TRUE == set_direction_by_key (context->wizard, key)) {
			context->wizard->stepForward();;
			return NULL;
		}
	}
	
	context->resume = TRUE;
	context->wait_for = LW_RESUME_KEYPRESS;
	return NULL;
}

const gchar *getName () 
{
	return "controlgo";
}	

gchar *getHint ()
{
	return _("Wait for pressing key and go in direction requested by the user");
}

void checkArgc (guint n)
{
	if (n != 0) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

};

LWSymbol *new_LWCommandControlGo()
{
	return new LWCommandControlGo();
}
