/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.util;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.List;

public class InvalidCommandException
extends Exception {
    private ImmutableList<String> usage;

    public InvalidCommandException(String message, Object ... args) {
        super(String.format(message, args));
    }

    public void setUsage(List<String> usage) {
        this.usage = ImmutableList.copyOf(usage);
    }

    public void display(PrintWriter writer) {
        writer.println(this.getMessage());
        if (this.usage != null) {
            writer.println();
            this.displayUsage(writer);
        }
    }

    protected final void displayUsage(PrintWriter writer) {
        for (String line : this.usage) {
            writer.println(line);
        }
    }

    public int exitCode() {
        return 1;
    }
}

