
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file GraphShadeAttributes.h
    \\brief Definition of GraphShade Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "GraphShadeWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


GraphShadeWrapper::GraphShadeWrapper(): graphshade_(new GraphShade())

{

	
	
	
} 
GraphShadeWrapper::GraphShadeWrapper(GraphShade* graphshade): graphshade_(graphshade)
{
	
	
} 

GraphShadeWrapper::~GraphShadeWrapper()
{
	
}

void GraphShadeWrapper::set(const MagRequest& request)
{
	
	

	
	
		string style_value = request.countValues("GRAPH_SHADE_STYLE") ?  (string) request("GRAPH_SHADE_STYLE") : "area_fill";
	MagLog::debug() << " GRAPH_SHADE_STYLE set to " << style_value << endl;
	GraphShadeStyleWrapper* style_wrapper = 0;
	try
	{
		style_wrapper = SimpleFactory<GraphShadeStyleWrapper>::create(style_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << style_value << "] is not a valid value for style: reset to default -> [area_fill]" << endl;
		style_wrapper = SimpleFactory<GraphShadeStyleWrapper>::create("area_fill");
	}
	style_wrapper->set(request);
	graphshade_->style_ =  unique_ptr<GraphShadeStyle>(style_wrapper->object());
	delete style_wrapper;
	
}

void GraphShadeWrapper::print(ostream& out)  const
{
	out << "GraphShadeWrapper[]";
}


    



#include "GraphShadeStyleWrapper.h"

static SimpleObjectMaker<GraphShadeStyleWrapper> GraphShade_graph_shade_style_solid_Wrapper("solid");


#include "GraphShadeStyleWrapper.h"

static SimpleObjectMaker<GraphShadeStyleWrapper> GraphShade_graph_shade_style_area_fill_Wrapper("area_fill");


#include "HatchGraphShadeStyleWrapper.h"
static SimpleObjectMaker<HatchGraphShadeStyle, GraphShadeStyle> GraphShade_graph_shade_style_hatch ("hatch");
static SimpleObjectMaker<HatchGraphShadeStyleWrapper, GraphShadeStyleWrapper> GraphShade_graph_shade_style_hatch_wrapper ("hatch");


#include "DotGraphShadeStyleWrapper.h"
static SimpleObjectMaker<DotGraphShadeStyle, GraphShadeStyle> GraphShade_graph_shade_style_dot ("dot");
static SimpleObjectMaker<DotGraphShadeStyleWrapper, GraphShadeStyleWrapper> GraphShade_graph_shade_style_dot_wrapper ("dot");



