/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/CleavageAgent.hpp>
#include <MsXpS/libXpertMassCore/CleavageRule.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ui_CleavageAgentDefDlg.h"
#include "AbstractPolChemDefDependentDlg.hpp"


namespace MsXpS
{
namespace MassXpert
{


class PolChemDef;
class PolChemDefWnd;


class CleavageAgentDefDlg : public AbstractPolChemDefDependentDlg
{
  Q_OBJECT

  public:
  CleavageAgentDefDlg(libXpertMassCore::PolChemDefSPtr pol_chem_def_csp,
                      PolChemDefWnd *pol_chem_def_wnd,
                      const QString &config_settings_file_path,
                      const QString &application_name,
                      const QString &description);

  ~CleavageAgentDefDlg();

  bool initialize();

  void updateCleavageAgentIdentityDetails(
    libXpertMassCore::CleavageAgentSPtr cleavage_agent_sp);
  void
  updateCleavageRuleDetails(libXpertMassCore::CleavageRuleSPtr cleavage_rule_sp);

  void clearAllDetails();

  public slots:

  // ACTIONS
  void addCleavageAgentPushButtonClicked();
  void removeCleavageAgentPushButtonClicked();
  void moveUpCleavageAgentPushButtonClicked();
  void moveDownCleavageAgentPushButtonClicked();

  void addCleavageRulePushButtonClicked();
  void removeCleavageRulePushButtonClicked();
  void moveUpCleavageRulePushButtonClicked();
  void moveDownCleavageRulePushButtonClicked();

  void applyCleavageAgentPushButtonClicked();
  void applyCleavageRulePushButtonClicked();

  bool validatePushButtonClicked();

  // VALIDATION
  bool validate();

  // WIDGETRY
  void cleavageAgentListWidgetItemSelectionChanged();
  void cleavageRuleListWidgetItemSelectionChanged();

  private:
  Ui::CleavageAgentDefDlg m_ui;

  std::vector<libXpertMassCore::CleavageAgentSPtr> &mref_cleavageAgents;

  void closeEvent(QCloseEvent *event);

  void writeSettings();
  void readSettings();
};


} // namespace MassXpert
} // namespace MsXpS
