/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QSortFilterProxyModel>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ui_CompositionsDlg.h"
#include "AbstractSeqEdWndDependentDlg.hpp"
#include "SequenceEditorWnd.hpp"
#include "CompositionTreeViewModel.hpp"
#include "CompositionTreeViewSortProxyModel.hpp"


namespace MsXpS
{
namespace MassXpert
{


enum class CompositionsTarget
{
  ELEMENTAL = 0,
  MONOMERIC = 1
};


class CompositionTreeViewModel;
class CompositionTreeViewSortProxyModel;

class CompositionsDlg : public AbstractSeqEdWndDependentDlg
{
  Q_OBJECT

  public:
  CompositionsDlg(SequenceEditorWnd *editor_wnd_p,
                  libXpertMassCore::PolymerQSPtr polymer_sp,
                  /* no libXpertMassCore::PolChemDef **/
                  const QString &config_settings_file_path,
                  const QString &application_name,
                  const QString &description,
                  const libXpertMassCore::CalcOptions &calc_options,
                  const libXpertMassCore::Ionizer &ionizer);

  ~CompositionsDlg();

  bool initialize();

  void setupTreeView();

  void updateIonizationData();

  void freeMonomerList();

  // The results-exporting functions. ////////////////////////////////
  void prepareResultsTxtString(CompositionsTarget target);
  bool exportResultsClipboard();
  bool exportResultsFile();
  bool selectResultsFile();
  //////////////////////////////////// The results-exporting functions.

  public slots:
  void updateSelectionData();
  void monomericComposition();
  void elementalComposition();
  void exportResults(int);

  protected:
  Ui::CompositionsDlg m_ui;

  // The results-exporting strings. ////////////////////////////////
  QString *mpa_resultsString;
  QString m_resultsFilePath;
  //////////////////////////////////// The results-exporting strings.

  const libXpertMassCore::CalcOptions &mref_calcOptions;
  libXpertMassCore::Ionizer m_ionizer;

  libXpertMassCore::IndexRangeCollection m_indexRangeCollection;

  QList<libXpertMassCore::Monomer *> m_monomerList;

  CompositionTreeViewModel *mpa_compositionTreeViewModel;
  CompositionTreeViewSortProxyModel *mpa_compositionProxyModel;
  CompositionTreeViewSortProxyModel *mpa_avgProxyModel;

  bool fetchValidateInputData();

  void writeSettings();
  void readSettings();
};


} // namespace MassXpert
} // namespace MsXpS
