/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QLineEdit>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/Polymer.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "SequenceEditorWnd.hpp"


namespace MsXpS
{
namespace MassXpert
{


class Polymer;
class SequenceEditorWnd;


class MonomerCodeEvaluator : public QObject
{
  Q_OBJECT

  public:
  MonomerCodeEvaluator(libXpertMassCore::PolymerQSPtr polymer_sp = nullptr,
                       SequenceEditorWnd *seq_editor_wnd_p   = nullptr,
                       QLineEdit *elab                       = nullptr,
                       QLineEdit *error                      = nullptr);

  ~MonomerCodeEvaluator();

  void setSequenceEditorWnd(SequenceEditorWnd *wnd);
  void setEdits(QLineEdit *elab, QLineEdit *error);

  bool evaluateCode(const QString &code);

  void escapeKey();
  bool newKey(QString &key);

  bool upperCaseChar(QChar qchar);
  bool lowerCaseChar(QChar qchar);

  int autoComplete(QString &code);
  void emptyCompletionsList();
  bool reportCompletions();

  void reportError(QString &msg);

  void debugCompletionsPutStdErr();

  private:
  libXpertMassCore::PolymerQSPtr msp_polymer;
  SequenceEditorWnd *mp_editorWnd;

  QLineEdit *m_elabCodeLineEdit;
  QLineEdit *m_errorCodeLineEdit;

  std::vector<int> m_completionsList;


  QString m_evalCode;
  QString m_elabCode;
};


} // namespace MassXpert
} // namespace MsXpS
