#ifndef DNOTIFY_WATCHERMAILDIR_H
#define DNOTIFY_WATCHERMAILDIR_H

#include <fcntl.h>

#include <string>

#include "compat.h"
#include "watcher.h"
#include "state.h"

// Watches a Maildir for changes
class watcher_maildir : public watcher
{
  public:
	watcher_maildir(struct dnotify_state* state, const std::string& maildir);
	virtual ~watcher_maildir();

	virtual void process_event(int fd);

  private:
	// Watch the maildir structure itself for cur/ and new/ removal
	// No need to watch for self because cur/ and new/ must go first
	static const long m_notify = DN_DELETE | DN_RENAME | DN_MULTISHOT;

	// A Maildir's cur/ and new/ can be modified only by moving files into
	// or out of or by deleting a file from these directories.
	// New messages are hardlinked or moved into into cur/ or new/.
	static const long cn_notify = DN_CREATE | DN_DELETE | DN_RENAME | DN_MULTISHOT;

	const std::string maildir;
	const std::string imap_name;

	struct dnotify_state* state;
	int fd_maildir, fd_cur, fd_new;

	int start_watch(const char* dir, long notify);
	void stop_watch(int fd);
};

#endif // DNOTIFY_WATCHERMAILDIR_H
