#ifndef RGB_HISTOGRAM_H
#define RGB_HISTOGRAM_H

#include <math.h>
#include <QPixmap>
#include <QWidget>
#include <QColor>

#include "vu_common.h"

class QObject;
class QPaintEvent;
class QResizeEvent;

class RGBHistogram : public QWidget
{
	Q_OBJECT

public:
	RGBHistogram(QWidget *parent);
	void set_histograms(std::vector<double> red, std::vector<double> green, std::vector<double> blue);

private:
	void paintEvent(QPaintEvent *event) override;
	void draw(const std::vector<double> &v, double max, Qt::GlobalColor color, QPainter *painter);

	std::vector<double> red, green, blue;
};

#endif
