/**
 * @file
 *
 * @author jeffrey.daily@gmail.com
 *
 * Copyright (c) 2015 Battelle Memorial Institute.
 */
#include "config.h"

#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "parasail.h"



parasail_result_t* parasail_nw_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_stats_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_stats_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_stats_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_stats_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_stats_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_stats_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_stats_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_stats_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_stats_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_stats_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_stats_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_stats_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_stats_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_stats_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_stats_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_stats_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_stats_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_stats_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_stats_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_stats_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_stats_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_stats_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_stats_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_stats_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_stats_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_stats_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_stats_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_stats_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_stats_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_stats_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_stats_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_stats_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_stats_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_stats_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_stats_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_stats_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_stats_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_stats_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_stats_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_stats_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_stats_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_stats_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_stats_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_stats_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_stats_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_stats_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_stats_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_stats_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_stats_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_stats_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_stats_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_stats_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_stats_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_stats_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_stats_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_stats_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_trace_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_trace_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_trace_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_trace_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_trace_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_trace_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_trace_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_trace_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_trace_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_trace_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_trace_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_trace_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_nw_trace_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_nw_trace_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_nw_trace_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_nw_trace_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_nw_trace_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_nw_trace_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_nw_trace_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_nw_trace_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_stats_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_stats_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_stats_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_stats_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_stats_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_stats_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_stats_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_stats_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_stats_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_stats_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_stats_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_stats_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_stats_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_stats_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_stats_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_stats_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_stats_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_stats_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_stats_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_stats_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_stats_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_stats_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_stats_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_stats_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_stats_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_stats_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_stats_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_stats_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_stats_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_stats_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_stats_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_stats_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_stats_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_stats_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_stats_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_stats_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_stats_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_stats_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_stats_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_stats_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_stats_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_stats_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_stats_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_stats_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_stats_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_stats_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_stats_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_stats_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_stats_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_stats_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_stats_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_stats_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_stats_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_stats_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_stats_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_stats_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_trace_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_trace_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_trace_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_trace_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_trace_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_trace_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_trace_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_trace_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_trace_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_trace_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_trace_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_trace_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_trace_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_trace_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_trace_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_trace_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_trace_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_trace_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_trace_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_trace_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_stats_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_stats_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_stats_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_stats_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_stats_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_stats_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_stats_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_stats_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_stats_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_stats_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_stats_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_stats_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_stats_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_stats_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_stats_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_stats_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_stats_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_stats_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_stats_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_stats_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_stats_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_stats_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_stats_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_stats_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_stats_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_stats_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_stats_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_stats_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_stats_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_stats_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_stats_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_stats_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_stats_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_stats_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_stats_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_stats_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_stats_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_stats_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_stats_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_stats_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_stats_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_stats_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_stats_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_stats_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_stats_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_stats_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_stats_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_stats_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_stats_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_stats_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_stats_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_stats_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_stats_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_stats_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_stats_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_stats_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_trace_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_trace_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_trace_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_trace_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_trace_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_trace_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_trace_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_trace_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_trace_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_trace_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_trace_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_trace_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sw_trace_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sw_trace_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sw_trace_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sw_trace_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sw_trace_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sw_trace_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sw_trace_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sw_trace_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_stats_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_stats_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_stats_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_stats_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_stats_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_stats_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_stats_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_stats_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_stats_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_stats_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_stats_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_stats_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_stats_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_stats_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_stats_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_stats_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_stats_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_stats_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_stats_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_stats_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_stats_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_stats_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_stats_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_stats_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_stats_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_stats_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_stats_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_stats_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_stats_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_stats_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_stats_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_stats_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_stats_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_stats_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_stats_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_stats_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_stats_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_stats_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_stats_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_stats_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_stats_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_stats_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_stats_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_stats_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_stats_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_stats_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_stats_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_stats_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_stats_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_stats_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_stats_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_stats_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_stats_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_stats_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_stats_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_stats_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_trace_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_trace_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_trace_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_trace_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_trace_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_trace_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_trace_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_trace_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_trace_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_trace_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_trace_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_trace_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_trace_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_trace_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_trace_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_trace_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_trace_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_trace_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_trace_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_trace_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_stats_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_stats_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_stats_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_stats_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_stats_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_stats_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_stats_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_stats_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_stats_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_stats_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_stats_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_stats_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_stats_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_stats_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_stats_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_stats_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_stats_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_stats_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_stats_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_stats_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_stats_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_stats_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_stats_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_stats_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_stats_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_stats_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_stats_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_stats_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_stats_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_stats_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_stats_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_stats_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_stats_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_stats_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_stats_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_stats_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_stats_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_stats_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_stats_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_stats_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_stats_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_stats_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_stats_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_stats_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_stats_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_stats_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_stats_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_stats_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_stats_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_stats_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_stats_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_stats_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_stats_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_stats_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_stats_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_stats_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_trace_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_trace_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_trace_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_trace_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_trace_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_trace_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_trace_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_trace_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_trace_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_trace_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_trace_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_trace_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qe_trace_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qe_trace_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qe_trace_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qe_trace_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qe_trace_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qe_trace_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qe_trace_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qe_trace_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_stats_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_stats_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_stats_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_stats_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_stats_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_stats_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_stats_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_stats_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_stats_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_stats_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_stats_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_stats_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_stats_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_stats_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_stats_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_stats_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_stats_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_stats_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_stats_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_stats_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_stats_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_stats_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_stats_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_stats_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_stats_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_stats_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_stats_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_stats_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_stats_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_stats_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_stats_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_stats_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_stats_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_stats_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_stats_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_stats_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_stats_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_stats_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_stats_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_stats_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_stats_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_stats_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_stats_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_stats_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_stats_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_stats_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_stats_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_stats_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_stats_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_stats_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_stats_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_stats_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_stats_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_stats_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_stats_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_stats_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_trace_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_trace_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_trace_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_trace_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_trace_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_trace_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_trace_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_trace_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_trace_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_trace_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_trace_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_trace_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qx_trace_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qx_trace_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qx_trace_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qx_trace_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qx_trace_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qx_trace_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qx_trace_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qx_trace_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_stats_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_stats_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_stats_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_stats_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_stats_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_stats_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_stats_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_stats_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_stats_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_stats_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_stats_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_stats_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_stats_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_stats_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_stats_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_stats_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_stats_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_stats_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_stats_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_stats_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_stats_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_stats_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_stats_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_stats_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_stats_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_stats_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_stats_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_stats_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_stats_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_stats_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_stats_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_stats_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_stats_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_stats_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_stats_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_stats_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_stats_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_stats_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_stats_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_stats_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_stats_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_stats_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_stats_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_stats_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_stats_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_stats_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_stats_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_stats_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_stats_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_stats_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_stats_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_stats_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_stats_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_stats_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_stats_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_stats_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_trace_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_trace_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_trace_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_trace_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_trace_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_trace_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_trace_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_trace_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_trace_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_trace_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_trace_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_trace_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_db_trace_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_db_trace_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_db_trace_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_db_trace_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_db_trace_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_db_trace_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_db_trace_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_db_trace_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_stats_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_stats_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_stats_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_stats_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_stats_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_stats_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_stats_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_stats_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_stats_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_stats_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_stats_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_stats_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_stats_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_stats_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_stats_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_stats_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_stats_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_stats_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_stats_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_stats_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_stats_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_stats_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_stats_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_stats_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_stats_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_stats_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_stats_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_stats_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_stats_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_stats_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_stats_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_stats_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_stats_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_stats_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_stats_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_stats_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_stats_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_stats_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_stats_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_stats_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_stats_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_stats_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_stats_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_stats_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_stats_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_stats_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_stats_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_stats_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_stats_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_stats_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_stats_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_stats_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_stats_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_stats_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_stats_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_stats_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_trace_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_trace_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_trace_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_trace_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_trace_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_trace_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_trace_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_trace_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_trace_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_trace_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_trace_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_trace_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_de_trace_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_de_trace_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_de_trace_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_de_trace_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_de_trace_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_de_trace_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_de_trace_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_de_trace_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_stats_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_stats_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_stats_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_stats_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_stats_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_stats_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_stats_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_stats_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_stats_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_stats_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_stats_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_stats_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_stats_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_stats_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_stats_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_stats_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_stats_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_stats_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_stats_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_stats_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_stats_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_stats_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_stats_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_stats_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_stats_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_stats_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_stats_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_stats_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_stats_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_stats_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_stats_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_stats_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_stats_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_stats_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_stats_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_stats_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_stats_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_stats_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_stats_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_stats_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_stats_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_stats_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_stats_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_stats_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_stats_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_stats_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_stats_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_stats_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_stats_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_stats_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_stats_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_stats_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_stats_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_stats_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_stats_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_stats_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_trace_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_trace_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_trace_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_trace_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_trace_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_trace_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_trace_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_trace_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_trace_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_trace_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_trace_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_trace_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_dx_trace_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_dx_trace_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_dx_trace_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_dx_trace_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_dx_trace_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_dx_trace_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_dx_trace_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_dx_trace_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_stats_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_stats_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_stats_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_stats_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_stats_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_stats_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_stats_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_stats_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_stats_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_stats_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_stats_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_stats_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_stats_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_stats_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_stats_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_stats_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_stats_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_stats_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_stats_table_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_stats_table_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_stats_table_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_stats_table_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_stats_table_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_stats_table_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_stats_table_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_stats_table_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_stats_table_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_stats_table_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_stats_table_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_stats_table_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_stats_table_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_stats_table_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_stats_table_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_stats_table_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_stats_table_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_stats_table_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_table_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_table_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_striped_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_rowcol_diag_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_diag_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_rowcol_diag_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_diag_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_rowcol_diag_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_diag_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_rowcol_diag_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_diag_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_rowcol_diag_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_diag_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_rowcol_diag_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_rowcol_diag_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_rowcol_diag_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_stats_rowcol_scan_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_scan_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_stats_rowcol_scan_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_scan_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_stats_rowcol_scan_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_scan_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_stats_rowcol_scan_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_scan_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_stats_rowcol_scan_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_scan_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_stats_rowcol_scan_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_scan_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_scan_neon_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif


parasail_result_t* parasail_sg_qb_de_stats_rowcol_striped_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_striped_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}


#if HAVE_SSE2
parasail_result_t* parasail_sg_qb_de_stats_rowcol_striped_sse2_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_striped_sse2_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_sse2_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_sse2_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_SSE41
parasail_result_t* parasail_sg_qb_de_stats_rowcol_striped_sse41_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_striped_sse41_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_sse41_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_sse41_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_AVX2
parasail_result_t* parasail_sg_qb_de_stats_rowcol_striped_avx2_256_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_striped_avx2_256_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_avx2_256_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_avx2_256_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_ALTIVEC
parasail_result_t* parasail_sg_qb_de_stats_rowcol_striped_altivec_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_striped_altivec_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_altivec_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_altivec_128_32(s1, s1Len, s2, s2Len, open, gap, matrix);
    }

    return result;
}
#endif

#if HAVE_NEON
parasail_result_t* parasail_sg_qb_de_stats_rowcol_striped_neon_128_sat(
        const char * const restrict s1, const int s1Len,
        const char * const restrict s2, const int s2Len,
        const int open, const int gap,
        const parasail_matrix_t *matrix)
{
    parasail_result_t * result = NULL;

    result = parasail_sg_qb_de_stats_rowcol_striped_neon_128_8(s1, s1Len, s2, s2Len, open, gap, matrix);
    if (parasail_result_is_saturated(result)) {
        parasail_result_free(result);
        result = parasail_sg_qb_de_stats_rowcol_striped_neon_128_16(s1, s1Len, s2, s2Len, open, gap, matrix);
    }
    if (parasail_result_is_saturated(result)) {
       