// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "ClipCases.h"

// This file is meant to be read and created by a program other than a
// compiler.  If you must modify it by hand, at least be nice to the 
// parser and don't add anything else to this file or rearrange it.

int numClipCasesPoly8 = 256;

int numClipShapesPoly8[256] = {
  3,  5,  5,  4,  5,  6,  4,  5, // cases 0 - 7
  5,  5,  6,  6,  4,  6,  5,  4, // cases 8 - 15
  5,  6,  5,  6,  6,  8,  6,  6, // cases 16 - 23
  4,  6,  6,  6,  5,  6,  4,  5, // cases 24 - 31
  5,  5,  6,  6,  5,  7,  6,  5, // cases 32 - 39
  6,  7,  8,  7,  6,  7,  6,  6, // cases 40 - 47
  4,  6,  6,  5,  6,  7,  6,  6, // cases 48 - 55
  5,  5,  6,  6,  4,  6,  5,  4, // cases 56 - 63
  5,  6,  5,  6,  6,  8,  6,  6, // cases 64 - 71
  5,  7,  7,  7,  6,  7,  5,  6, // cases 72 - 79
  6,  8,  7,  7,  8,  9,  7,  8, // cases 80 - 87
  6,  7,  7,  8,  6,  8,  6,  6, // cases 88 - 95
  4,  6,  6,  6,  6,  7,  5,  6, // cases 96 - 103
  6,  7,  7,  8,  6,  8,  6,  6, // cases 104 - 111
  5,  6,  5,  6,  6,  8,  6,  6, // cases 112 - 119
  4,  6,  6,  6,  5,  6,  4,  5, // cases 120 - 127
  5,  4,  6,  5,  5,  6,  6,  4, // cases 128 - 135
  6,  6,  8,  6,  6,  6,  6,  5, // cases 136 - 143
  5,  6,  7,  5,  7,  7,  7,  6, // cases 144 - 151
  6,  5,  7,  6,  5,  6,  6,  4, // cases 152 - 159
  6,  6,  8,  6,  7,  7,  7,  6, // cases 160 - 167
  8,  7,  9,  8,  7,  8,  8,  6, // cases 168 - 175
  6,  6,  7,  6,  7,  8,  8,  6, // cases 176 - 183
  6,  6,  8,  6,  6,  6,  6,  5, // cases 184 - 191
  4,  5,  6,  4,  6,  6,  6,  5, // cases 192 - 199
  6,  5,  7,  6,  5,  6,  6,  4, // cases 200 - 207
  6,  6,  7,  6,  7,  8,  8,  6, // cases 208 - 215
  6,  6,  8,  6,  6,  6,  6,  5, // cases 216 - 223
  5,  4,  6,  5,  5,  6,  6,  4, // cases 224 - 231
  6,  6,  8,  6,  6,  6,  6,  5, // cases 232 - 239
  4,  5,  6,  4,  6,  6,  6,  5, // cases 240 - 247
  5,  4,  6,  5,  4,  5,  5,  3  // cases 248 - 255
};

int startClipShapesPoly8[256] = {
  0, 18, 46, 74, 98, 126, 160, 184, // cases 0 - 7
  212, 240, 270, 304, 338, 362, 396, 424, // cases 8 - 15
  448, 476, 510, 540, 574, 608, 652, 686, // cases 16 - 23
  720, 744, 778, 812, 846, 874, 908, 932, // cases 24 - 31
  960, 988, 1018, 1052, 1086, 1116, 1156, 1190, // cases 32 - 39
  1220, 1254, 1294, 1338, 1378, 1412, 1452, 1486, // cases 40 - 47
  1520, 1544, 1578, 1612, 1642, 1676, 1716, 1750, // cases 48 - 55
  1784, 1812, 1842, 1876, 1910, 1934, 1968, 1996, // cases 56 - 63
  2020, 2048, 2082, 2112, 2146, 2180, 2224, 2258, // cases 64 - 71
  2292, 2322, 2362, 2402, 2442, 2476, 2516, 2546, // cases 72 - 79
  2580, 2614, 2658, 2698, 2738, 2782, 2832, 2872, // cases 80 - 87
  2916, 2950, 2990, 3030, 3074, 3108, 3152, 3186, // cases 88 - 95
  3220, 3244, 3278, 3312, 3346, 3380, 3420, 3450, // cases 96 - 103
  3484, 3518, 3558, 3598, 3642, 3676, 3720, 3754, // cases 104 - 111
  3788, 3816, 3850, 3880, 3914, 3948, 3992, 4026, // cases 112 - 119
  4060, 4084, 4118, 4152, 4186, 4214, 4248, 4272, // cases 120 - 127
  4300, 4328, 4352, 4386, 4414, 4444, 4478, 4512, // cases 128 - 135
  4536, 4570, 4604, 4648, 4682, 4716, 4750, 4784, // cases 136 - 143
  4812, 4842, 4876, 4916, 4946, 4986, 5026, 5066, // cases 144 - 151
  5100, 5134, 5164, 5204, 5238, 5268, 5302, 5336, // cases 152 - 159
  5360, 5394, 5428, 5472, 5506, 5546, 5586, 5626, // cases 160 - 167
  5660, 5704, 5744, 5794, 5838, 5878, 5922, 5966, // cases 168 - 175
  6000, 6034, 6068, 6108, 6142, 6182, 6226, 6270, // cases 176 - 183
  6304, 6338, 6372, 6416, 6450, 6484, 6518, 6552, // cases 184 - 191
  6580, 6604, 6632, 6666, 6690, 6724, 6758, 6792, // cases 192 - 199
  6820, 6854, 6884, 6924, 6958, 6988, 7022, 7056, // cases 200 - 207
  7080, 7114, 7148, 7188, 7222, 7262, 7306, 7350, // cases 208 - 215
  7384, 7418, 7452, 7496, 7530, 7564, 7598, 7632, // cases 216 - 223
  7660, 7688, 7712, 7746, 7774, 7804, 7838, 7872, // cases 224 - 231
  7896, 7930, 7964, 8008, 8042, 8076, 8110, 8144, // cases 232 - 239
  8172, 8196, 8224, 8258, 8282, 8316, 8350, 8384, // cases 240 - 247
  8412, 8440, 8464, 8498, 8526, 8550, 8578, 8606  // cases 248 - 255
};

unsigned char clipShapesPoly8[] = {
 // Case #0: Unique case #1
  ST_QUA, COLOR0, P0, P1, P2, P3, 
  ST_QUA, COLOR0, P0, P3, P4, P5, 
  ST_QUA, COLOR0, P0, P5, P6, P7, 
 // Case #1: Unique case #2
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_QUA, COLOR0, EA, P3, P4, P5, 
  ST_QUA, COLOR0, EA, P5, P6, P7, 
  ST_TRI, COLOR0, EA, P7, EH, 
  ST_TRI, COLOR1, P0, EA, EH, 
 // Case #2: (cloned #1)
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_QUA, COLOR0, EB, P4, P5, P6, 
  ST_QUA, COLOR0, EB, P6, P7, P0, 
  ST_TRI, COLOR0, EB, P0, EA, 
  ST_TRI, COLOR1, P1, EB, EA, 
 // Case #3: Unique case #3
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_QUA, COLOR0, EB, P4, P5, P6, 
  ST_QUA, COLOR0, EB, P6, P7, EH, 
  ST_QUA, COLOR1, P0, P1, EB, EH, 
 // Case #4: (cloned #1)
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_QUA, COLOR0, EC, P5, P6, P7, 
  ST_QUA, COLOR0, EC, P7, P0, P1, 
  ST_TRI, COLOR0, EC, P1, EB, 
  ST_TRI, COLOR1, P2, EC, EB, 
 // Case #5: Unique case #4
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_QUA, COLOR0, EC, P5, P6, P7, 
  ST_TRI, COLOR0, EC, P7, EH, 
  ST_QUA, COLOR1, P0, EA, EB, P2, 
  ST_QUA, COLOR1, P0, P2, EC, EH, 
 // Case #6: (cloned #3)
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_QUA, COLOR0, EC, P5, P6, P7, 
  ST_QUA, COLOR0, EC, P7, P0, EA, 
  ST_QUA, COLOR1, P1, P2, EC, EA, 
 // Case #7: Unique case #5
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_QUA, COLOR0, EC, P5, P6, P7, 
  ST_TRI, COLOR0, EC, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, EC, 
  ST_TRI, COLOR1, P0, EC, EH, 
 // Case #8: (cloned #1)
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_QUA, COLOR0, ED, P6, P7, P0, 
  ST_QUA, COLOR0, ED, P0, P1, P2, 
  ST_TRI, COLOR0, ED, P2, EC, 
  ST_TRI, COLOR1, P3, ED, EC, 
 // Case #9: Unique case #6
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_QUA, COLOR0, ED, P6, P7, EH, 
  ST_QUA, COLOR1, P0, EA, EC, P3, 
  ST_QUA, COLOR1, P0, P3, ED, EH, 
 // Case #10: (cloned #5)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_QUA, COLOR0, ED, P6, P7, P0, 
  ST_TRI, COLOR0, ED, P0, EA, 
  ST_QUA, COLOR1, P1, EB, EC, P3, 
  ST_QUA, COLOR1, P1, P3, ED, EA, 
 // Case #11: Unique case #7
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_QUA, COLOR0, ED, P6, P7, EH, 
  ST_QUA, COLOR1, P0, P1, EB, EC, 
  ST_QUA, COLOR1, P0, EC, P3, ED, 
  ST_TRI, COLOR1, P0, ED, EH, 
 // Case #12: (cloned #3)
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_QUA, COLOR0, ED, P6, P7, P0, 
  ST_QUA, COLOR0, ED, P0, P1, EB, 
  ST_QUA, COLOR1, P2, P3, ED, EB, 
 // Case #13: (cloned #11)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, P5, P6, P7, EH, 
  ST_QUA, COLOR0, ED, P4, P5, EH, 
  ST_QUA, COLOR1, EA, EB, P2, P3, 
  ST_QUA, COLOR1, EH, P0, EA, P3, 
  ST_TRI, COLOR1, ED, EH, P3, 
 // Case #14: (cloned #7)
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_QUA, COLOR0, ED, P6, P7, P0, 
  ST_TRI, COLOR0, ED, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, ED, 
  ST_TRI, COLOR1, P1, ED, EA, 
 // Case #15: Unique case #8
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_QUA, COLOR0, ED, P6, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, P3, 
  ST_QUA, COLOR1, P0, P3, ED, EH, 
 // Case #16: (cloned #1)
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_QUA, COLOR0, EE, P7, P0, P1, 
  ST_QUA, COLOR0, EE, P1, P2, P3, 
  ST_TRI, COLOR0, EE, P3, ED, 
  ST_TRI, COLOR1, P4, EE, ED, 
 // Case #17: Unique case #9
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_TRI, COLOR0, EA, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_TRI, COLOR0, EE, P7, EH, 
  ST_QUA, COLOR1, P0, EA, ED, P4, 
  ST_QUA, COLOR1, P0, P4, EE, EH, 
 // Case #18: (cloned #9)
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_QUA, COLOR0, EE, P7, P0, EA, 
  ST_QUA, COLOR1, P1, EB, ED, P4, 
  ST_QUA, COLOR1, P1, P4, EE, EA, 
 // Case #19: Unique case #10
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_TRI, COLOR0, EE, P7, EH, 
  ST_QUA, COLOR1, P0, P1, EB, ED, 
  ST_QUA, COLOR1, P0, ED, P4, EE, 
  ST_TRI, COLOR1, P0, EE, EH, 
 // Case #20: (cloned #5)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_QUA, COLOR0, EE, P7, P0, P1, 
  ST_TRI, COLOR0, EE, P1, EB, 
  ST_QUA, COLOR1, P2, EC, ED, P4, 
  ST_QUA, COLOR1, P2, P4, EE, EB, 
 // Case #21: Unique case #11
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_TRI, COLOR0, EE, P7, EH, 
  ST_QUA, COLOR1, P0, EA, EB, P2, 
  ST_QUA, COLOR1, P0, P2, EC, ED, 
  ST_QUA, COLOR1, P0, ED, P4, EE, 
  ST_TRI, COLOR1, P0, EE, EH, 
 // Case #22: (cloned #11)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_QUA, COLOR0, EE, P7, P0, EA, 
  ST_QUA, COLOR1, P1, P2, EC, ED, 
  ST_QUA, COLOR1, P1, ED, P4, EE, 
  ST_TRI, COLOR1, P1, EE, EA, 
 // Case #23: Unique case #12
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_TRI, COLOR0, EE, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, EC, 
  ST_QUA, COLOR1, P0, EC, ED, P4, 
  ST_QUA, COLOR1, P0, P4, EE, EH, 
 // Case #24: (cloned #3)
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_QUA, COLOR0, EE, P7, P0, P1, 
  ST_QUA, COLOR0, EE, P1, P2, EC, 
  ST_QUA, COLOR1, P3, P4, EE, EC, 
 // Case #25: (cloned #19)
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR0, P5, P6, P7, EH, 
  ST_TRI, COLOR0, EE, P5, EH, 
  ST_QUA, COLOR1, EA, EC, P3, P4, 
  ST_QUA, COLOR1, EH, P0, EA, P4, 
  ST_TRI, COLOR1, EE, EH, P4, 
 // Case #26: (cloned #11)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, P6, P7, P0, EA, 
  ST_QUA, COLOR0, EE, P5, P6, EA, 
  ST_QUA, COLOR1, EB, EC, P3, P4, 
  ST_QUA, COLOR1, EA, P1, EB, P4, 
  ST_TRI, COLOR1, EE, EA, P4, 
 // Case #27: Unique case #13
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_TRI, COLOR0, EE, P7, EH, 
  ST_QUA, COLOR1, P0, P1, EB, EC, 
  ST_QUA, COLOR1, P0, EC, P3, P4, 
  ST_QUA, COLOR1, P0, P4, EE, EH, 
 // Case #28: (cloned #7)
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_QUA, COLOR0, EE, P7, P0, P1, 
  ST_TRI, COLOR0, EE, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, EE, 
  ST_TRI, COLOR1, P2, EE, EB, 
 // Case #29: (cloned #23)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, P5, P6, P7, EH, 
  ST_TRI, COLOR0, EE, P5, EH, 
  ST_QUA, COLOR1, EB, P2, P3, P4, 
  ST_QUA, COLOR1, P0, EA, EB, P4, 
  ST_QUA, COLOR1, EE, EH, P0, P4, 
 // Case #30: (cloned #15)
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_QUA, COLOR0, EE, P7, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, P4, 
  ST_QUA, COLOR1, P1, P4, EE, EA, 
 // Case #31: Unique case #14
  ST_QUA, COLOR0, EE, P5, P6, P7, 
  ST_TRI, COLOR0, EE, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, P3, 
  ST_QUA, COLOR1, P0, P3, P4, EE, 
  ST_TRI, COLOR1, P0, EE, EH, 
 // Case #32: (cloned #1)
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_QUA, COLOR0, EF, P0, P1, P2, 
  ST_QUA, COLOR0, EF, P2, P3, P4, 
  ST_TRI, COLOR0, EF, P4, EE, 
  ST_TRI, COLOR1, P5, EF, EE, 
 // Case #33: (cloned #9)
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_QUA, COLOR0, EA, P3, P4, EE, 
  ST_QUA, COLOR1, P5, EF, EH, P0, 
  ST_QUA, COLOR1, P5, P0, EA, EE, 
 // Case #34: (cloned #17)
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_TRI, COLOR0, EB, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_TRI, COLOR0, EF, P0, EA, 
  ST_QUA, COLOR1, P1, EB, EE, P5, 
  ST_QUA, COLOR1, P1, P5, EF, EA, 
 // Case #35: (cloned #19)
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR0, P2, P3, P4, EE, 
  ST_TRI, COLOR0, EB, P2, EE, 
  ST_QUA, COLOR1, EF, EH, P0, P1, 
  ST_QUA, COLOR1, EE, P5, EF, P1, 
  ST_TRI, COLOR1, EB, EE, P1, 
 // Case #36: (cloned #9)
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_QUA, COLOR0, EF, P0, P1, EB, 
  ST_QUA, COLOR1, P2, EC, EE, P5, 
  ST_QUA, COLOR1, P2, P5, EF, EB, 
 // Case #37: Unique case #15
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, P0, EA, EB, P2, 
  ST_QUA, COLOR1, P0, P2, EC, EE, 
  ST_QUA, COLOR1, P0, EE, P5, EF, 
  ST_TRI, COLOR1, P0, EF, EH, 
 // Case #38: (cloned #19)
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_TRI, COLOR0, EF, P0, EA, 
  ST_QUA, COLOR1, P1, P2, EC, EE, 
  ST_QUA, COLOR1, P1, EE, P5, EF, 
  ST_TRI, COLOR1, P1, EF, EA, 
 // Case #39: Unique case #16
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, EC, 
  ST_QUA, COLOR1, P0, EC, EE, P5, 
  ST_QUA, COLOR1, P0, P5, EF, EH, 
 // Case #40: (cloned #5)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_QUA, COLOR0, EF, P0, P1, P2, 
  ST_TRI, COLOR0, EF, P2, EC, 
  ST_QUA, COLOR1, P3, ED, EE, P5, 
  ST_QUA, COLOR1, P3, P5, EF, EC, 
 // Case #41: (cloned #37)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, P3, ED, EE, P5, 
  ST_QUA, COLOR1, P3, P5, EF, EH, 
  ST_QUA, COLOR1, P3, EH, P0, EA, 
  ST_TRI, COLOR1, P3, EA, EC, 
 // Case #42: (cloned #21)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_TRI, COLOR0, EF, P0, EA, 
  ST_QUA, COLOR1, P1, EB, EC, P3, 
  ST_QUA, COLOR1, P1, P3, ED, EE, 
  ST_QUA, COLOR1, P1, EE, P5, EF, 
  ST_TRI, COLOR1, P1, EF, EA, 
 // Case #43: Unique case #17
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, P0, P1, EB, EC, 
  ST_QUA, COLOR1, P0, EC, P3, ED, 
  ST_QUA, COLOR1, P0, ED, EE, P5, 
  ST_QUA, COLOR1, P0, P5, EF, EH, 
 // Case #44: (cloned #11)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_QUA, COLOR0, EF, P0, P1, EB, 
  ST_QUA, COLOR1, P2, P3, ED, EE, 
  ST_QUA, COLOR1, P2, EE, P5, EF, 
  ST_TRI, COLOR1, P2, EF, EB, 
 // Case #45: Unique case #18
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, P0, EA, EB, P2, 
  ST_QUA, COLOR1, P0, P2, P3, ED, 
  ST_QUA, COLOR1, P0, ED, EE, P5, 
  ST_QUA, COLOR1, P0, P5, EF, EH, 
 // Case #46: (cloned #23)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_TRI, COLOR0, EF, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, ED, 
  ST_QUA, COLOR1, P1, ED, EE, P5, 
  ST_QUA, COLOR1, P1, P5, EF, EA, 
 // Case #47: Unique case #19
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, P3, 
  ST_QUA, COLOR1, P0, P3, ED, EE, 
  ST_QUA, COLOR1, P0, EE, P5, EF, 
  ST_TRI, COLOR1, P0, EF, EH, 
 // Case #48: (cloned #3)
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_QUA, COLOR0, EF, P0, P1, P2, 
  ST_QUA, COLOR0, EF, P2, P3, ED, 
  ST_QUA, COLOR1, P4, P5, EF, ED, 
 // Case #49: (cloned #19)
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_TRI, COLOR0, EA, P3, ED, 
  ST_QUA, COLOR1, P4, P5, EF, EH, 
  ST_QUA, COLOR1, P4, EH, P0, EA, 
  ST_TRI, COLOR1, P4, EA, ED, 
 // Case #50: (cloned #19)
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR0, P6, P7, P0, EA, 
  ST_TRI, COLOR0, EF, P6, EA, 
  ST_QUA, COLOR1, EB, ED, P4, P5, 
  ST_QUA, COLOR1, EA, P1, EB, P5, 
  ST_TRI, COLOR1, EF, EA, P5, 
 // Case #51: Unique case #20
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, P0, P1, EB, ED, 
  ST_QUA, COLOR1, P0, ED, P4, P5, 
  ST_QUA, COLOR1, P0, P5, EF, EH, 
 // Case #52: (cloned #11)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, P7, P0, P1, EB, 
  ST_QUA, COLOR0, EF, P6, P7, EB, 
  ST_QUA, COLOR1, EC, ED, P4, P5, 
  ST_QUA, COLOR1, EB, P2, EC, P5, 
  ST_TRI, COLOR1, EF, EB, P5, 
 // Case #53: (cloned #43)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, EC, ED, P4, P5, 
  ST_QUA, COLOR1, EB, P2, EC, P5, 
  ST_QUA, COLOR1, P0, EA, EB, P5, 
  ST_QUA, COLOR1, EF, EH, P0, P5, 
 // Case #54: (cloned #27)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_TRI, COLOR0, EF, P0, EA, 
  ST_QUA, COLOR1, P1, P2, EC, ED, 
  ST_QUA, COLOR1, P1, ED, P4, P5, 
  ST_QUA, COLOR1, P1, P5, EF, EA, 
 // Case #55: Unique case #21
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, EC, 
  ST_QUA, COLOR1, P0, EC, ED, P4, 
  ST_QUA, COLOR1, P0, P4, P5, EF, 
  ST_TRI, COLOR1, P0, EF, EH, 
 // Case #56: (cloned #7)
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_QUA, COLOR0, EF, P0, P1, P2, 
  ST_TRI, COLOR0, EF, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, EF, 
  ST_TRI, COLOR1, P3, EF, EC, 
 // Case #57: (cloned #39)
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, EF, 
  ST_QUA, COLOR1, P3, EF, EH, P0, 
  ST_QUA, COLOR1, P3, P0, EA, EC, 
 // Case #58: (cloned #23)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, P6, P7, P0, EA, 
  ST_TRI, COLOR0, EF, P6, EA, 
  ST_QUA, COLOR1, EC, P3, P4, P5, 
  ST_QUA, COLOR1, P1, EB, EC, P5, 
  ST_QUA, COLOR1, EF, EA, P1, P5, 
 // Case #59: (cloned #55)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, EC, P3, P4, P5, 
  ST_QUA, COLOR1, P1, EB, EC, P5, 
  ST_QUA, COLOR1, EH, P0, P1, P5, 
  ST_TRI, COLOR1, EF, EH, P5, 
 // Case #60: (cloned #15)
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_QUA, COLOR0, EF, P0, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, P5, 
  ST_QUA, COLOR1, P2, P5, EF, EB, 
 // Case #61: (cloned #47)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, P2, P3, P4, P5, 
  ST_QUA, COLOR1, EA, EB, P2, P5, 
  ST_QUA, COLOR1, EH, P0, EA, P5, 
  ST_TRI, COLOR1, EF, EH, P5, 
 // Case #62: (cloned #31)
  ST_QUA, COLOR0, EF, P6, P7, P0, 
  ST_TRI, COLOR0, EF, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, P4, 
  ST_QUA, COLOR1, P1, P4, P5, EF, 
  ST_TRI, COLOR1, P1, EF, EA, 
 // Case #63: Unique case #22
  ST_QUA, COLOR0, EF, P6, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, P3, 
  ST_QUA, COLOR1, P0, P3, P4, P5, 
  ST_QUA, COLOR1, P0, P5, EF, EH, 
 // Case #64: (cloned #1)
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_QUA, COLOR0, EG, P1, P2, P3, 
  ST_QUA, COLOR0, EG, P3, P4, P5, 
  ST_TRI, COLOR0, EG, P5, EF, 
  ST_TRI, COLOR1, P6, EG, EF, 
 // Case #65: (cloned #5)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_QUA, COLOR0, EA, P3, P4, P5, 
  ST_TRI, COLOR0, EA, P5, EF, 
  ST_QUA, COLOR1, P6, EG, EH, P0, 
  ST_QUA, COLOR1, P6, P0, EA, EF, 
 // Case #66: (cloned #9)
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_QUA, COLOR0, EB, P4, P5, EF, 
  ST_QUA, COLOR1, P6, EG, EA, P1, 
  ST_QUA, COLOR1, P6, P1, EB, EF, 
 // Case #67: (cloned #11)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, P3, P4, P5, EF, 
  ST_QUA, COLOR0, EB, P2, P3, EF, 
  ST_QUA, COLOR1, EG, EH, P0, P1, 
  ST_QUA, COLOR1, EF, P6, EG, P1, 
  ST_TRI, COLOR1, EB, EF, P1, 
 // Case #68: (cloned #17)
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_TRI, COLOR0, EC, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_TRI, COLOR0, EG, P1, EB, 
  ST_QUA, COLOR1, P2, EC, EF, P6, 
  ST_QUA, COLOR1, P2, P6, EG, EB, 
 // Case #69: (cloned #21)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_TRI, COLOR0, EC, P5, EF, 
  ST_QUA, COLOR1, P6, EG, EH, P0, 
  ST_QUA, COLOR1, P6, P0, EA, EB, 
  ST_QUA, COLOR1, P6, EB, P2, EC, 
  ST_TRI, COLOR1, P6, EC, EF, 
 // Case #70: (cloned #19)
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR0, P3, P4, P5, EF, 
  ST_TRI, COLOR0, EC, P3, EF, 
  ST_QUA, COLOR1, EG, EA, P1, P2, 
  ST_QUA, COLOR1, EF, P6, EG, P2, 
  ST_TRI, COLOR1, EC, EF, P2, 
 // Case #71: (cloned #23)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, P3, P4, P5, EF, 
  ST_TRI, COLOR0, EC, P3, EF, 
  ST_QUA, COLOR1, EH, P0, P1, P2, 
  ST_QUA, COLOR1, P6, EG, EH, P2, 
  ST_QUA, COLOR1, EC, EF, P6, P2, 
 // Case #72: (cloned #9)
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_QUA, COLOR0, EG, P1, P2, EC, 
  ST_QUA, COLOR1, P3, ED, EF, P6, 
  ST_QUA, COLOR1, P3, P6, EG, EC, 
 // Case #73: (cloned #37)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR1, P6, EG, EH, P0, 
  ST_QUA, COLOR1, P6, P0, EA, EC, 
  ST_QUA, COLOR1, P6, EC, P3, ED, 
  ST_TRI, COLOR1, P6, ED, EF, 
 // Case #74: (cloned #37)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, P1, EB, EC, P3, 
  ST_QUA, COLOR1, P1, P3, ED, EF, 
  ST_QUA, COLOR1, P1, EF, P6, EG, 
  ST_TRI, COLOR1, P1, EG, EA, 
 // Case #75: (cloned #45)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR1, P6, EG, EH, P0, 
  ST_QUA, COLOR1, P6, P0, P1, EB, 
  ST_QUA, COLOR1, P6, EB, EC, P3, 
  ST_QUA, COLOR1, P6, P3, ED, EF, 
 // Case #76: (cloned #19)
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_TRI, COLOR0, EG, P1, EB, 
  ST_QUA, COLOR1, P2, P3, ED, EF, 
  ST_QUA, COLOR1, P2, EF, P6, EG, 
  ST_TRI, COLOR1, P2, EG, EB, 
 // Case #77: (cloned #43)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR1, EA, EB, P2, P3, 
  ST_QUA, COLOR1, EH, P0, EA, P3, 
  ST_QUA, COLOR1, P6, EG, EH, P3, 
  ST_QUA, COLOR1, ED, EF, P6, P3, 
 // Case #78: (cloned #39)
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, ED, 
  ST_QUA, COLOR1, P1, ED, EF, P6, 
  ST_QUA, COLOR1, P1, P6, EG, EA, 
 // Case #79: (cloned #47)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR1, P0, P1, P2, P3, 
  ST_QUA, COLOR1, EG, EH, P0, P3, 
  ST_QUA, COLOR1, EF, P6, EG, P3, 
  ST_TRI, COLOR1, ED, EF, P3, 
 // Case #80: (cloned #5)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_QUA, COLOR0, EG, P1, P2, P3, 
  ST_TRI, COLOR0, EG, P3, ED, 
  ST_QUA, COLOR1, P4, EE, EF, P6, 
  ST_QUA, COLOR1, P4, P6, EG, ED, 
 // Case #81: (cloned #21)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_TRI, COLOR0, EA, P3, ED, 
  ST_QUA, COLOR1, P4, EE, EF, P6, 
  ST_QUA, COLOR1, P4, P6, EG, EH, 
  ST_QUA, COLOR1, P4, EH, P0, EA, 
  ST_TRI, COLOR1, P4, EA, ED, 
 // Case #82: (cloned #37)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR1, P4, EE, EF, P6, 
  ST_QUA, COLOR1, P4, P6, EG, EA, 
  ST_QUA, COLOR1, P4, EA, P1, EB, 
  ST_TRI, COLOR1, P4, EB, ED, 
 // Case #83: (cloned #43)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR1, EG, EH, P0, P1, 
  ST_QUA, COLOR1, EF, P6, EG, P1, 
  ST_QUA, COLOR1, P4, EE, EF, P1, 
  ST_QUA, COLOR1, EB, ED, P4, P1, 
 // Case #84: (cloned #21)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_TRI, COLOR0, EG, P1, EB, 
  ST_QUA, COLOR1, P2, EC, ED, P4, 
  ST_QUA, COLOR1, P2, P4, EE, EF, 
  ST_QUA, COLOR1, P2, EF, P6, EG, 
  ST_TRI, COLOR1, P2, EG, EB, 
 // Case #85: Unique case #23
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR1, P0, EA, EB, P2, 
  ST_QUA, COLOR1, P0, P2, EC, ED, 
  ST_QUA, COLOR1, P0, ED, P4, EE, 
  ST_QUA, COLOR1, P0, EE, EF, P6, 
  ST_QUA, COLOR1, P0, P6, EG, EH, 
 // Case #86: (cloned #43)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, P1, P2, EC, ED, 
  ST_QUA, COLOR1, P1, ED, P4, EE, 
  ST_QUA, COLOR1, P1, EE, EF, P6, 
  ST_QUA, COLOR1, P1, P6, EG, EA, 
 // Case #87: Unique case #24
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, EC, 
  ST_QUA, COLOR1, P0, EC, ED, P4, 
  ST_QUA, COLOR1, P0, P4, EE, EF, 
  ST_QUA, COLOR1, P0, EF, P6, EG, 
  ST_TRI, COLOR1, P0, EG, EH, 
 // Case #88: (cloned #11)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_QUA, COLOR0, EG, P1, P2, EC, 
  ST_QUA, COLOR1, P3, P4, EE, EF, 
  ST_QUA, COLOR1, P3, EF, P6, EG, 
  ST_TRI, COLOR1, P3, EG, EC, 
 // Case #89: (cloned #43)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, P3, P4, EE, EF, 
  ST_QUA, COLOR1, P3, EF, P6, EG, 
  ST_QUA, COLOR1, P3, EG, EH, P0, 
  ST_QUA, COLOR1, P3, P0, EA, EC, 
 // Case #90: (cloned #45)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, P1, EB, EC, P3, 
  ST_QUA, COLOR1, P1, P3, P4, EE, 
  ST_QUA, COLOR1, P1, EE, EF, P6, 
  ST_QUA, COLOR1, P1, P6, EG, EA, 
 // Case #91: Unique case #25
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR1, P0, P1, EB, EC, 
  ST_QUA, COLOR1, P0, EC, P3, P4, 
  ST_QUA, COLOR1, P0, P4, EE, EF, 
  ST_QUA, COLOR1, P0, EF, P6, EG, 
  ST_TRI, COLOR1, P0, EG, EH, 
 // Case #92: (cloned #23)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_TRI, COLOR0, EG, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, EE, 
  ST_QUA, COLOR1, P2, EE, EF, P6, 
  ST_QUA, COLOR1, P2, P6, EG, EB, 
 // Case #93: (cloned #87)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, EE, 
  ST_QUA, COLOR1, P2, EE, EF, P6, 
  ST_QUA, COLOR1, P2, P6, EG, EH, 
  ST_QUA, COLOR1, P2, EH, P0, EA, 
  ST_TRI, COLOR1, P2, EA, EB, 
 // Case #94: (cloned #47)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, P4, 
  ST_QUA, COLOR1, P1, P4, EE, EF, 
  ST_QUA, COLOR1, P1, EF, P6, EG, 
  ST_TRI, COLOR1, P1, EG, EA, 
 // Case #95: Unique case #26
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, P3, 
  ST_QUA, COLOR1, P0, P3, P4, EE, 
  ST_QUA, COLOR1, P0, EE, EF, P6, 
  ST_QUA, COLOR1, P0, P6, EG, EH, 
 // Case #96: (cloned #3)
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_QUA, COLOR0, EG, P1, P2, P3, 
  ST_QUA, COLOR0, EG, P3, P4, EE, 
  ST_QUA, COLOR1, P5, P6, EG, EE, 
 // Case #97: (cloned #11)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_QUA, COLOR0, EA, P3, P4, EE, 
  ST_QUA, COLOR1, P5, P6, EG, EH, 
  ST_QUA, COLOR1, P5, EH, P0, EA, 
  ST_TRI, COLOR1, P5, EA, EE, 
 // Case #98: (cloned #19)
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_TRI, COLOR0, EB, P4, EE, 
  ST_QUA, COLOR1, P5, P6, EG, EA, 
  ST_QUA, COLOR1, P5, EA, P1, EB, 
  ST_TRI, COLOR1, P5, EB, EE, 
 // Case #99: (cloned #27)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_TRI, COLOR0, EB, P4, EE, 
  ST_QUA, COLOR1, P5, P6, EG, EH, 
  ST_QUA, COLOR1, P5, EH, P0, P1, 
  ST_QUA, COLOR1, P5, P1, EB, EE, 
 // Case #100: (cloned #19)
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR0, P7, P0, P1, EB, 
  ST_TRI, COLOR0, EG, P7, EB, 
  ST_QUA, COLOR1, EC, EE, P5, P6, 
  ST_QUA, COLOR1, EB, P2, EC, P6, 
  ST_TRI, COLOR1, EG, EB, P6, 
 // Case #101: (cloned #43)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR1, P5, P6, EG, EH, 
  ST_QUA, COLOR1, P5, EH, P0, EA, 
  ST_QUA, COLOR1, P5, EA, EB, P2, 
  ST_QUA, COLOR1, P5, P2, EC, EE, 
 // Case #102: (cloned #51)
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, P1, P2, EC, EE, 
  ST_QUA, COLOR1, P1, EE, P5, P6, 
  ST_QUA, COLOR1, P1, P6, EG, EA, 
 // Case #103: (cloned #55)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR1, EH, P0, P1, P2, 
  ST_QUA, COLOR1, P6, EG, EH, P2, 
  ST_QUA, COLOR1, EE, P5, P6, P2, 
  ST_TRI, COLOR1, EC, EE, P2, 
 // Case #104: (cloned #11)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, P0, P1, P2, EC, 
  ST_QUA, COLOR0, EG, P7, P0, EC, 
  ST_QUA, COLOR1, ED, EE, P5, P6, 
  ST_QUA, COLOR1, EC, P3, ED, P6, 
  ST_TRI, COLOR1, EG, EC, P6, 
 // Case #105: (cloned #45)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, P3, ED, EE, P5, 
  ST_QUA, COLOR1, P3, P5, P6, EG, 
  ST_QUA, COLOR1, P3, EG, EH, P0, 
  ST_QUA, COLOR1, P3, P0, EA, EC, 
 // Case #106: (cloned #43)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, ED, EE, P5, P6, 
  ST_QUA, COLOR1, EC, P3, ED, P6, 
  ST_QUA, COLOR1, P1, EB, EC, P6, 
  ST_QUA, COLOR1, EG, EA, P1, P6, 
 // Case #107: (cloned #91)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR1, P5, P6, EG, EH, 
  ST_QUA, COLOR1, P5, EH, P0, P1, 
  ST_QUA, COLOR1, P5, P1, EB, EC, 
  ST_QUA, COLOR1, P5, EC, P3, ED, 
  ST_TRI, COLOR1, P5, ED, EE, 
 // Case #108: (cloned #27)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_TRI, COLOR0, EG, P1, EB, 
  ST_QUA, COLOR1, P2, P3, ED, EE, 
  ST_QUA, COLOR1, P2, EE, P5, P6, 
  ST_QUA, COLOR1, P2, P6, EG, EB, 
 // Case #109: (cloned #91)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR1, P2, P3, ED, EE, 
  ST_QUA, COLOR1, P2, EE, P5, P6, 
  ST_QUA, COLOR1, P2, P6, EG, EH, 
  ST_QUA, COLOR1, P2, EH, P0, EA, 
  ST_TRI, COLOR1, P2, EA, EB, 
 // Case #110: (cloned #55)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, ED, 
  ST_QUA, COLOR1, P1, ED, EE, P5, 
  ST_QUA, COLOR1, P1, P5, P6, EG, 
  ST_TRI, COLOR1, P1, EG, EA, 
 // Case #111: Unique case #27
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, P3, 
  ST_QUA, COLOR1, P0, P3, ED, EE, 
  ST_QUA, COLOR1, P0, EE, P5, P6, 
  ST_QUA, COLOR1, P0, P6, EG, EH, 
 // Case #112: (cloned #7)
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_QUA, COLOR0, EG, P1, P2, P3, 
  ST_TRI, COLOR0, EG, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, EG, 
  ST_TRI, COLOR1, P4, EG, ED, 
 // Case #113: (cloned #23)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_TRI, COLOR0, EA, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, EG, 
  ST_QUA, COLOR1, P4, EG, EH, P0, 
  ST_QUA, COLOR1, P4, P0, EA, ED, 
 // Case #114: (cloned #39)
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, EG, 
  ST_QUA, COLOR1, P4, EG, EA, P1, 
  ST_QUA, COLOR1, P4, P1, EB, ED, 
 // Case #115: (cloned #55)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, EG, 
  ST_QUA, COLOR1, P4, EG, EH, P0, 
  ST_QUA, COLOR1, P4, P0, P1, EB, 
  ST_TRI, COLOR1, P4, EB, ED, 
 // Case #116: (cloned #23)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, P7, P0, P1, EB, 
  ST_TRI, COLOR0, EG, P7, EB, 
  ST_QUA, COLOR1, ED, P4, P5, P6, 
  ST_QUA, COLOR1, P2, EC, ED, P6, 
  ST_QUA, COLOR1, EG, EB, P2, P6, 
 // Case #117: (cloned #87)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, EG, 
  ST_QUA, COLOR1, P4, EG, EH, P0, 
  ST_QUA, COLOR1, P4, P0, EA, EB, 
  ST_QUA, COLOR1, P4, EB, P2, EC, 
  ST_TRI, COLOR1, P4, EC, ED, 
 // Case #118: (cloned #55)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, ED, P4, P5, P6, 
  ST_QUA, COLOR1, P2, EC, ED, P6, 
  ST_QUA, COLOR1, EA, P1, P2, P6, 
  ST_TRI, COLOR1, EG, EA, P6, 
 // Case #119: Unique case #28
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, EC, 
  ST_QUA, COLOR1, P0, EC, ED, P4, 
  ST_QUA, COLOR1, P0, P4, P5, P6, 
  ST_QUA, COLOR1, P0, P6, EG, EH, 
 // Case #120: (cloned #15)
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_QUA, COLOR0, EG, P1, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, P6, 
  ST_QUA, COLOR1, P3, P6, EG, EC, 
 // Case #121: (cloned #47)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, P6, 
  ST_QUA, COLOR1, P3, P6, EG, EH, 
  ST_QUA, COLOR1, P3, EH, P0, EA, 
  ST_TRI, COLOR1, P3, EA, EC, 
 // Case #122: (cloned #47)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, P3, P4, P5, P6, 
  ST_QUA, COLOR1, EB, EC, P3, P6, 
  ST_QUA, COLOR1, EA, P1, EB, P6, 
  ST_TRI, COLOR1, EG, EA, P6, 
 // Case #123: (cloned #111)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, P6, 
  ST_QUA, COLOR1, P3, P6, EG, EH, 
  ST_QUA, COLOR1, P3, EH, P0, P1, 
  ST_QUA, COLOR1, P3, P1, EB, EC, 
 // Case #124: (cloned #31)
  ST_QUA, COLOR0, EG, P7, P0, P1, 
  ST_TRI, COLOR0, EG, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, P5, 
  ST_QUA, COLOR1, P2, P5, P6, EG, 
  ST_TRI, COLOR1, P2, EG, EB, 
 // Case #125: (cloned #95)
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, P5, 
  ST_QUA, COLOR1, P2, P5, P6, EG, 
  ST_QUA, COLOR1, P2, EG, EH, P0, 
  ST_QUA, COLOR1, P2, P0, EA, EB, 
 // Case #126: (cloned #63)
  ST_QUA, COLOR0, EG, P7, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, P4, 
  ST_QUA, COLOR1, P1, P4, P5, P6, 
  ST_QUA, COLOR1, P1, P6, EG, EA, 
 // Case #127: Unique case #29
  ST_TRI, COLOR0, EG, P7, EH, 
  ST_QUA, COLOR1, P0, P1, P2, P3, 
  ST_QUA, COLOR1, P0, P3, P4, P5, 
  ST_QUA, COLOR1, P0, P5, P6, EG, 
  ST_TRI, COLOR1, P0, EG, EH, 
 // Case #128: (cloned #1)
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_QUA, COLOR0, EH, P2, P3, P4, 
  ST_QUA, COLOR0, EH, P4, P5, P6, 
  ST_TRI, COLOR0, EH, P6, EG, 
  ST_TRI, COLOR1, P7, EH, EG, 
 // Case #129: (cloned #3)
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_QUA, COLOR0, EA, P3, P4, P5, 
  ST_QUA, COLOR0, EA, P5, P6, EG, 
  ST_QUA, COLOR1, P7, P0, EA, EG, 
 // Case #130: (cloned #5)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_QUA, COLOR0, EB, P4, P5, P6, 
  ST_TRI, COLOR0, EB, P6, EG, 
  ST_QUA, COLOR1, P7, EH, EA, P1, 
  ST_QUA, COLOR1, P7, P1, EB, EG, 
 // Case #131: (cloned #7)
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_QUA, COLOR0, EB, P4, P5, P6, 
  ST_TRI, COLOR0, EB, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, EB, 
  ST_TRI, COLOR1, P7, EB, EG, 
 // Case #132: (cloned #9)
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_QUA, COLOR0, EC, P5, P6, EG, 
  ST_QUA, COLOR1, P7, EH, EB, P2, 
  ST_QUA, COLOR1, P7, P2, EC, EG, 
 // Case #133: (cloned #11)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_QUA, COLOR0, EC, P5, P6, EG, 
  ST_QUA, COLOR1, P7, P0, EA, EB, 
  ST_QUA, COLOR1, P7, EB, P2, EC, 
  ST_TRI, COLOR1, P7, EC, EG, 
 // Case #134: (cloned #11)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, P4, P5, P6, EG, 
  ST_QUA, COLOR0, EC, P3, P4, EG, 
  ST_QUA, COLOR1, EH, EA, P1, P2, 
  ST_QUA, COLOR1, EG, P7, EH, P2, 
  ST_TRI, COLOR1, EC, EG, P2, 
 // Case #135: (cloned #15)
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_QUA, COLOR0, EC, P5, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, P2, 
  ST_QUA, COLOR1, P7, P2, EC, EG, 
 // Case #136: (cloned #17)
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_TRI, COLOR0, ED, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_TRI, COLOR0, EH, P2, EC, 
  ST_QUA, COLOR1, P3, ED, EG, P7, 
  ST_QUA, COLOR1, P3, P7, EH, EC, 
 // Case #137: (cloned #19)
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_TRI, COLOR0, ED, P6, EG, 
  ST_QUA, COLOR1, P7, P0, EA, EC, 
  ST_QUA, COLOR1, P7, EC, P3, ED, 
  ST_TRI, COLOR1, P7, ED, EG, 
 // Case #138: (cloned #21)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_TRI, COLOR0, ED, P6, EG, 
  ST_QUA, COLOR1, P7, EH, EA, P1, 
  ST_QUA, COLOR1, P7, P1, EB, EC, 
  ST_QUA, COLOR1, P7, EC, P3, ED, 
  ST_TRI, COLOR1, P7, ED, EG, 
 // Case #139: (cloned #23)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_TRI, COLOR0, ED, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, EB, 
  ST_QUA, COLOR1, P7, EB, EC, P3, 
  ST_QUA, COLOR1, P7, P3, ED, EG, 
 // Case #140: (cloned #19)
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR0, P4, P5, P6, EG, 
  ST_TRI, COLOR0, ED, P4, EG, 
  ST_QUA, COLOR1, EH, EB, P2, P3, 
  ST_QUA, COLOR1, EG, P7, EH, P3, 
  ST_TRI, COLOR1, ED, EG, P3, 
 // Case #141: (cloned #27)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_TRI, COLOR0, ED, P6, EG, 
  ST_QUA, COLOR1, P7, P0, EA, EB, 
  ST_QUA, COLOR1, P7, EB, P2, P3, 
  ST_QUA, COLOR1, P7, P3, ED, EG, 
 // Case #142: (cloned #23)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, P4, P5, P6, EG, 
  ST_TRI, COLOR0, ED, P4, EG, 
  ST_QUA, COLOR1, EA, P1, P2, P3, 
  ST_QUA, COLOR1, P7, EH, EA, P3, 
  ST_QUA, COLOR1, ED, EG, P7, P3, 
 // Case #143: (cloned #31)
  ST_QUA, COLOR0, ED, P4, P5, P6, 
  ST_TRI, COLOR0, ED, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, P2, 
  ST_QUA, COLOR1, P7, P2, P3, ED, 
  ST_TRI, COLOR1, P7, ED, EG, 
 // Case #144: (cloned #9)
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_QUA, COLOR0, EH, P2, P3, ED, 
  ST_QUA, COLOR1, P4, EE, EG, P7, 
  ST_QUA, COLOR1, P4, P7, EH, ED, 
 // Case #145: (cloned #19)
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR0, P1, P2, P3, ED, 
  ST_TRI, COLOR0, EA, P1, ED, 
  ST_QUA, COLOR1, EE, EG, P7, P0, 
  ST_QUA, COLOR1, ED, P4, EE, P0, 
  ST_TRI, COLOR1, EA, ED, P0, 
 // Case #146: (cloned #37)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR1, P7, EH, EA, P1, 
  ST_QUA, COLOR1, P7, P1, EB, ED, 
  ST_QUA, COLOR1, P7, ED, P4, EE, 
  ST_TRI, COLOR1, P7, EE, EG, 
 // Case #147: (cloned #39)
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, EB, 
  ST_QUA, COLOR1, P7, EB, ED, P4, 
  ST_QUA, COLOR1, P7, P4, EE, EG, 
 // Case #148: (cloned #37)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, P2, EC, ED, P4, 
  ST_QUA, COLOR1, P2, P4, EE, EG, 
  ST_QUA, COLOR1, P2, EG, P7, EH, 
  ST_TRI, COLOR1, P2, EH, EB, 
 // Case #149: (cloned #43)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR1, P7, P0, EA, EB, 
  ST_QUA, COLOR1, P7, EB, P2, EC, 
  ST_QUA, COLOR1, P7, EC, ED, P4, 
  ST_QUA, COLOR1, P7, P4, EE, EG, 
 // Case #150: (cloned #45)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR1, P7, EH, EA, P1, 
  ST_QUA, COLOR1, P7, P1, P2, EC, 
  ST_QUA, COLOR1, P7, EC, ED, P4, 
  ST_QUA, COLOR1, P7, P4, EE, EG, 
 // Case #151: (cloned #47)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, P2, 
  ST_QUA, COLOR1, P7, P2, EC, ED, 
  ST_QUA, COLOR1, P7, ED, P4, EE, 
  ST_TRI, COLOR1, P7, EE, EG, 
 // Case #152: (cloned #19)
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_TRI, COLOR0, EH, P2, EC, 
  ST_QUA, COLOR1, P3, P4, EE, EG, 
  ST_QUA, COLOR1, P3, EG, P7, EH, 
  ST_TRI, COLOR1, P3, EH, EC, 
 // Case #153: (cloned #51)
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, P3, P4, EE, EG, 
  ST_QUA, COLOR1, P3, EG, P7, P0, 
  ST_QUA, COLOR1, P3, P0, EA, EC, 
 // Case #154: (cloned #43)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR1, EB, EC, P3, P4, 
  ST_QUA, COLOR1, EA, P1, EB, P4, 
  ST_QUA, COLOR1, P7, EH, EA, P4, 
  ST_QUA, COLOR1, EE, EG, P7, P4, 
 // Case #155: (cloned #55)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, EB, 
  ST_QUA, COLOR1, P7, EB, EC, P3, 
  ST_QUA, COLOR1, P7, P3, P4, EE, 
  ST_TRI, COLOR1, P7, EE, EG, 
 // Case #156: (cloned #39)
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, EE, 
  ST_QUA, COLOR1, P2, EE, EG, P7, 
  ST_QUA, COLOR1, P2, P7, EH, EB, 
 // Case #157: (cloned #55)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR1, EB, P2, P3, P4, 
  ST_QUA, COLOR1, P0, EA, EB, P4, 
  ST_QUA, COLOR1, EG, P7, P0, P4, 
  ST_TRI, COLOR1, EE, EG, P4, 
 // Case #158: (cloned #47)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR1, P1, P2, P3, P4, 
  ST_QUA, COLOR1, EH, EA, P1, P4, 
  ST_QUA, COLOR1, EG, P7, EH, P4, 
  ST_TRI, COLOR1, EE, EG, P4, 
 // Case #159: (cloned #63)
  ST_QUA, COLOR0, EE, P5, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, P2, 
  ST_QUA, COLOR1, P7, P2, P3, P4, 
  ST_QUA, COLOR1, P7, P4, EE, EG, 
 // Case #160: (cloned #5)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_QUA, COLOR0, EH, P2, P3, P4, 
  ST_TRI, COLOR0, EH, P4, EE, 
  ST_QUA, COLOR1, P5, EF, EG, P7, 
  ST_QUA, COLOR1, P5, P7, EH, EE, 
 // Case #161: (cloned #11)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, P2, P3, P4, EE, 
  ST_QUA, COLOR0, EA, P1, P2, EE, 
  ST_QUA, COLOR1, EF, EG, P7, P0, 
  ST_QUA, COLOR1, EE, P5, EF, P0, 
  ST_TRI, COLOR1, EA, EE, P0, 
 // Case #162: (cloned #21)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_TRI, COLOR0, EB, P4, EE, 
  ST_QUA, COLOR1, P5, EF, EG, P7, 
  ST_QUA, COLOR1, P5, P7, EH, EA, 
  ST_QUA, COLOR1, P5, EA, P1, EB, 
  ST_TRI, COLOR1, P5, EB, EE, 
 // Case #163: (cloned #23)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, P2, P3, P4, EE, 
  ST_TRI, COLOR0, EB, P2, EE, 
  ST_QUA, COLOR1, EG, P7, P0, P1, 
  ST_QUA, COLOR1, P5, EF, EG, P1, 
  ST_QUA, COLOR1, EB, EE, P5, P1, 
 // Case #164: (cloned #37)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR1, P5, EF, EG, P7, 
  ST_QUA, COLOR1, P5, P7, EH, EB, 
  ST_QUA, COLOR1, P5, EB, P2, EC, 
  ST_TRI, COLOR1, P5, EC, EE, 
 // Case #165: (cloned #45)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR1, P5, EF, EG, P7, 
  ST_QUA, COLOR1, P5, P7, P0, EA, 
  ST_QUA, COLOR1, P5, EA, EB, P2, 
  ST_QUA, COLOR1, P5, P2, EC, EE, 
 // Case #166: (cloned #43)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR1, EH, EA, P1, P2, 
  ST_QUA, COLOR1, EG, P7, EH, P2, 
  ST_QUA, COLOR1, P5, EF, EG, P2, 
  ST_QUA, COLOR1, EC, EE, P5, P2, 
 // Case #167: (cloned #47)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR1, P7, P0, P1, P2, 
  ST_QUA, COLOR1, EF, EG, P7, P2, 
  ST_QUA, COLOR1, EE, P5, EF, P2, 
  ST_TRI, COLOR1, EC, EE, P2, 
 // Case #168: (cloned #21)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_TRI, COLOR0, EH, P2, EC, 
  ST_QUA, COLOR1, P3, ED, EE, P5, 
  ST_QUA, COLOR1, P3, P5, EF, EG, 
  ST_QUA, COLOR1, P3, EG, P7, EH, 
  ST_TRI, COLOR1, P3, EH, EC, 
 // Case #169: (cloned #43)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, EF, EG, P7, P0, 
  ST_QUA, COLOR1, EE, P5, EF, P0, 
  ST_QUA, COLOR1, P3, ED, EE, P0, 
  ST_QUA, COLOR1, EA, EC, P3, P0, 
 // Case #170: (cloned #85)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR1, P1, EB, EC, P3, 
  ST_QUA, COLOR1, P1, P3, ED, EE, 
  ST_QUA, COLOR1, P1, EE, P5, EF, 
  ST_QUA, COLOR1, P1, EF, EG, P7, 
  ST_QUA, COLOR1, P1, P7, EH, EA, 
 // Case #171: (cloned #87)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, EB, 
  ST_QUA, COLOR1, P7, EB, EC, P3, 
  ST_QUA, COLOR1, P7, P3, ED, EE, 
  ST_QUA, COLOR1, P7, EE, P5, EF, 
  ST_TRI, COLOR1, P7, EF, EG, 
 // Case #172: (cloned #43)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, P2, P3, ED, EE, 
  ST_QUA, COLOR1, P2, EE, P5, EF, 
  ST_QUA, COLOR1, P2, EF, EG, P7, 
  ST_QUA, COLOR1, P2, P7, EH, EB, 
 // Case #173: (cloned #91)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR1, P7, P0, EA, EB, 
  ST_QUA, COLOR1, P7, EB, P2, P3, 
  ST_QUA, COLOR1, P7, P3, ED, EE, 
  ST_QUA, COLOR1, P7, EE, P5, EF, 
  ST_TRI, COLOR1, P7, EF, EG, 
 // Case #174: (cloned #87)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, ED, 
  ST_QUA, COLOR1, P1, ED, EE, P5, 
  ST_QUA, COLOR1, P1, P5, EF, EG, 
  ST_QUA, COLOR1, P1, EG, P7, EH, 
  ST_TRI, COLOR1, P1, EH, EA, 
 // Case #175: (cloned #95)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, P2, 
  ST_QUA, COLOR1, P7, P2, P3, ED, 
  ST_QUA, COLOR1, P7, ED, EE, P5, 
  ST_QUA, COLOR1, P7, P5, EF, EG, 
 // Case #176: (cloned #11)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_QUA, COLOR0, EH, P2, P3, ED, 
  ST_QUA, COLOR1, P4, P5, EF, EG, 
  ST_QUA, COLOR1, P4, EG, P7, EH, 
  ST_TRI, COLOR1, P4, EH, ED, 
 // Case #177: (cloned #27)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_TRI, COLOR0, EA, P3, ED, 
  ST_QUA, COLOR1, P4, P5, EF, EG, 
  ST_QUA, COLOR1, P4, EG, P7, P0, 
  ST_QUA, COLOR1, P4, P0, EA, ED, 
 // Case #178: (cloned #43)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR1, P4, P5, EF, EG, 
  ST_QUA, COLOR1, P4, EG, P7, EH, 
  ST_QUA, COLOR1, P4, EH, EA, P1, 
  ST_QUA, COLOR1, P4, P1, EB, ED, 
 // Case #179: (cloned #55)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR1, EG, P7, P0, P1, 
  ST_QUA, COLOR1, P5, EF, EG, P1, 
  ST_QUA, COLOR1, ED, P4, P5, P1, 
  ST_TRI, COLOR1, EB, ED, P1, 
 // Case #180: (cloned #45)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, P2, EC, ED, P4, 
  ST_QUA, COLOR1, P2, P4, P5, EF, 
  ST_QUA, COLOR1, P2, EF, EG, P7, 
  ST_QUA, COLOR1, P2, P7, EH, EB, 
 // Case #181: (cloned #91)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR1, P4, P5, EF, EG, 
  ST_QUA, COLOR1, P4, EG, P7, P0, 
  ST_QUA, COLOR1, P4, P0, EA, EB, 
  ST_QUA, COLOR1, P4, EB, P2, EC, 
  ST_TRI, COLOR1, P4, EC, ED, 
 // Case #182: (cloned #91)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR1, P1, P2, EC, ED, 
  ST_QUA, COLOR1, P1, ED, P4, P5, 
  ST_QUA, COLOR1, P1, P5, EF, EG, 
  ST_QUA, COLOR1, P1, EG, P7, EH, 
  ST_TRI, COLOR1, P1, EH, EA, 
 // Case #183: (cloned #111)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, P2, 
  ST_QUA, COLOR1, P7, P2, EC, ED, 
  ST_QUA, COLOR1, P7, ED, P4, P5, 
  ST_QUA, COLOR1, P7, P5, EF, EG, 
 // Case #184: (cloned #23)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_TRI, COLOR0, EH, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, EF, 
  ST_QUA, COLOR1, P3, EF, EG, P7, 
  ST_QUA, COLOR1, P3, P7, EH, EC, 
 // Case #185: (cloned #55)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, EF, 
  ST_QUA, COLOR1, P3, EF, EG, P7, 
  ST_QUA, COLOR1, P3, P7, P0, EA, 
  ST_TRI, COLOR1, P3, EA, EC, 
 // Case #186: (cloned #87)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, EF, 
  ST_QUA, COLOR1, P3, EF, EG, P7, 
  ST_QUA, COLOR1, P3, P7, EH, EA, 
  ST_QUA, COLOR1, P3, EA, P1, EB, 
  ST_TRI, COLOR1, P3, EB, EC, 
 // Case #187: (cloned #119)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, EF, 
  ST_QUA, COLOR1, P3, EF, EG, P7, 
  ST_QUA, COLOR1, P3, P7, P0, P1, 
  ST_QUA, COLOR1, P3, P1, EB, EC, 
 // Case #188: (cloned #47)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, P5, 
  ST_QUA, COLOR1, P2, P5, EF, EG, 
  ST_QUA, COLOR1, P2, EG, P7, EH, 
  ST_TRI, COLOR1, P2, EH, EB, 
 // Case #189: (cloned #111)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, P5, 
  ST_QUA, COLOR1, P2, P5, EF, EG, 
  ST_QUA, COLOR1, P2, EG, P7, P0, 
  ST_QUA, COLOR1, P2, P0, EA, EB, 
 // Case #190: (cloned #95)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, P4, 
  ST_QUA, COLOR1, P1, P4, P5, EF, 
  ST_QUA, COLOR1, P1, EF, EG, P7, 
  ST_QUA, COLOR1, P1, P7, EH, EA, 
 // Case #191: (cloned #127)
  ST_TRI, COLOR0, EF, P6, EG, 
  ST_QUA, COLOR1, P7, P0, P1, P2, 
  ST_QUA, COLOR1, P7, P2, P3, P4, 
  ST_QUA, COLOR1, P7, P4, P5, EF, 
  ST_TRI, COLOR1, P7, EF, EG, 
 // Case #192: (cloned #3)
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_QUA, COLOR0, EH, P2, P3, P4, 
  ST_QUA, COLOR0, EH, P4, P5, EF, 
  ST_QUA, COLOR1, P6, P7, EH, EF, 
 // Case #193: (cloned #7)
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_QUA, COLOR0, EA, P3, P4, P5, 
  ST_TRI, COLOR0, EA, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, EA, 
  ST_TRI, COLOR1, P6, EA, EF, 
 // Case #194: (cloned #11)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_QUA, COLOR0, EB, P4, P5, EF, 
  ST_QUA, COLOR1, P6, P7, EH, EA, 
  ST_QUA, COLOR1, P6, EA, P1, EB, 
  ST_TRI, COLOR1, P6, EB, EF, 
 // Case #195: (cloned #15)
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_QUA, COLOR0, EB, P4, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, P1, 
  ST_QUA, COLOR1, P6, P1, EB, EF, 
 // Case #196: (cloned #19)
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_TRI, COLOR0, EC, P5, EF, 
  ST_QUA, COLOR1, P6, P7, EH, EB, 
  ST_QUA, COLOR1, P6, EB, P2, EC, 
  ST_TRI, COLOR1, P6, EC, EF, 
 // Case #197: (cloned #23)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_TRI, COLOR0, EC, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, EA, 
  ST_QUA, COLOR1, P6, EA, EB, P2, 
  ST_QUA, COLOR1, P6, P2, EC, EF, 
 // Case #198: (cloned #27)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_TRI, COLOR0, EC, P5, EF, 
  ST_QUA, COLOR1, P6, P7, EH, EA, 
  ST_QUA, COLOR1, P6, EA, P1, P2, 
  ST_QUA, COLOR1, P6, P2, EC, EF, 
 // Case #199: (cloned #31)
  ST_QUA, COLOR0, EC, P3, P4, P5, 
  ST_TRI, COLOR0, EC, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, P1, 
  ST_QUA, COLOR1, P6, P1, P2, EC, 
  ST_TRI, COLOR1, P6, EC, EF, 
 // Case #200: (cloned #19)
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR0, P0, P1, P2, EC, 
  ST_TRI, COLOR0, EH, P0, EC, 
  ST_QUA, COLOR1, ED, EF, P6, P7, 
  ST_QUA, COLOR1, EC, P3, ED, P7, 
  ST_TRI, COLOR1, EH, EC, P7, 
 // Case #201: (cloned #39)
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, EA, 
  ST_QUA, COLOR1, P6, EA, EC, P3, 
  ST_QUA, COLOR1, P6, P3, ED, EF, 
 // Case #202: (cloned #43)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR1, P6, P7, EH, EA, 
  ST_QUA, COLOR1, P6, EA, P1, EB, 
  ST_QUA, COLOR1, P6, EB, EC, P3, 
  ST_QUA, COLOR1, P6, P3, ED, EF, 
 // Case #203: (cloned #47)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, P1, 
  ST_QUA, COLOR1, P6, P1, EB, EC, 
  ST_QUA, COLOR1, P6, EC, P3, ED, 
  ST_TRI, COLOR1, P6, ED, EF, 
 // Case #204: (cloned #51)
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, P2, P3, ED, EF, 
  ST_QUA, COLOR1, P2, EF, P6, P7, 
  ST_QUA, COLOR1, P2, P7, EH, EB, 
 // Case #205: (cloned #55)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, EA, 
  ST_QUA, COLOR1, P6, EA, EB, P2, 
  ST_QUA, COLOR1, P6, P2, P3, ED, 
  ST_TRI, COLOR1, P6, ED, EF, 
 // Case #206: (cloned #55)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR1, EA, P1, P2, P3, 
  ST_QUA, COLOR1, P7, EH, EA, P3, 
  ST_QUA, COLOR1, EF, P6, P7, P3, 
  ST_TRI, COLOR1, ED, EF, P3, 
 // Case #207: (cloned #63)
  ST_QUA, COLOR0, ED, P4, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, P1, 
  ST_QUA, COLOR1, P6, P1, P2, P3, 
  ST_QUA, COLOR1, P6, P3, ED, EF, 
 // Case #208: (cloned #11)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, P1, P2, P3, ED, 
  ST_QUA, COLOR0, EH, P0, P1, ED, 
  ST_QUA, COLOR1, EE, EF, P6, P7, 
  ST_QUA, COLOR1, ED, P4, EE, P7, 
  ST_TRI, COLOR1, EH, ED, P7, 
 // Case #209: (cloned #23)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, P1, P2, P3, ED, 
  ST_TRI, COLOR0, EA, P1, ED, 
  ST_QUA, COLOR1, EF, P6, P7, P0, 
  ST_QUA, COLOR1, P4, EE, EF, P0, 
  ST_QUA, COLOR1, EA, ED, P4, P0, 
 // Case #210: (cloned #45)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR1, P4, EE, EF, P6, 
  ST_QUA, COLOR1, P4, P6, P7, EH, 
  ST_QUA, COLOR1, P4, EH, EA, P1, 
  ST_QUA, COLOR1, P4, P1, EB, ED, 
 // Case #211: (cloned #47)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR1, P6, P7, P0, P1, 
  ST_QUA, COLOR1, EE, EF, P6, P1, 
  ST_QUA, COLOR1, ED, P4, EE, P1, 
  ST_TRI, COLOR1, EB, ED, P1, 
 // Case #212: (cloned #43)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, EE, EF, P6, P7, 
  ST_QUA, COLOR1, ED, P4, EE, P7, 
  ST_QUA, COLOR1, P2, EC, ED, P7, 
  ST_QUA, COLOR1, EH, EB, P2, P7, 
 // Case #213: (cloned #87)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, EA, 
  ST_QUA, COLOR1, P6, EA, EB, P2, 
  ST_QUA, COLOR1, P6, P2, EC, ED, 
  ST_QUA, COLOR1, P6, ED, P4, EE, 
  ST_TRI, COLOR1, P6, EE, EF, 
 // Case #214: (cloned #91)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR1, P6, P7, EH, EA, 
  ST_QUA, COLOR1, P6, EA, P1, P2, 
  ST_QUA, COLOR1, P6, P2, EC, ED, 
  ST_QUA, COLOR1, P6, ED, P4, EE, 
  ST_TRI, COLOR1, P6, EE, EF, 
 // Case #215: (cloned #95)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, P1, 
  ST_QUA, COLOR1, P6, P1, P2, EC, 
  ST_QUA, COLOR1, P6, EC, ED, P4, 
  ST_QUA, COLOR1, P6, P4, EE, EF, 
 // Case #216: (cloned #27)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_TRI, COLOR0, EH, P2, EC, 
  ST_QUA, COLOR1, P3, P4, EE, EF, 
  ST_QUA, COLOR1, P3, EF, P6, P7, 
  ST_QUA, COLOR1, P3, P7, EH, EC, 
 // Case #217: (cloned #55)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, EF, P6, P7, P0, 
  ST_QUA, COLOR1, P4, EE, EF, P0, 
  ST_QUA, COLOR1, EC, P3, P4, P0, 
  ST_TRI, COLOR1, EA, EC, P0, 
 // Case #218: (cloned #91)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR1, P3, P4, EE, EF, 
  ST_QUA, COLOR1, P3, EF, P6, P7, 
  ST_QUA, COLOR1, P3, P7, EH, EA, 
  ST_QUA, COLOR1, P3, EA, P1, EB, 
  ST_TRI, COLOR1, P3, EB, EC, 
 // Case #219: (cloned #111)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, P1, 
  ST_QUA, COLOR1, P6, P1, EB, EC, 
  ST_QUA, COLOR1, P6, EC, P3, P4, 
  ST_QUA, COLOR1, P6, P4, EE, EF, 
 // Case #220: (cloned #55)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, EE, 
  ST_QUA, COLOR1, P2, EE, EF, P6, 
  ST_QUA, COLOR1, P2, P6, P7, EH, 
  ST_TRI, COLOR1, P2, EH, EB, 
 // Case #221: (cloned #119)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, EE, 
  ST_QUA, COLOR1, P2, EE, EF, P6, 
  ST_QUA, COLOR1, P2, P6, P7, P0, 
  ST_QUA, COLOR1, P2, P0, EA, EB, 
 // Case #222: (cloned #111)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, P4, 
  ST_QUA, COLOR1, P1, P4, EE, EF, 
  ST_QUA, COLOR1, P1, EF, P6, P7, 
  ST_QUA, COLOR1, P1, P7, EH, EA, 
 // Case #223: (cloned #127)
  ST_TRI, COLOR0, EE, P5, EF, 
  ST_QUA, COLOR1, P6, P7, P0, P1, 
  ST_QUA, COLOR1, P6, P1, P2, P3, 
  ST_QUA, COLOR1, P6, P3, P4, EE, 
  ST_TRI, COLOR1, P6, EE, EF, 
 // Case #224: (cloned #7)
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_QUA, COLOR0, EH, P2, P3, P4, 
  ST_TRI, COLOR0, EH, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, EH, 
  ST_TRI, COLOR1, P5, EH, EE, 
 // Case #225: (cloned #15)
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_QUA, COLOR0, EA, P3, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, P0, 
  ST_QUA, COLOR1, P5, P0, EA, EE, 
 // Case #226: (cloned #23)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_TRI, COLOR0, EB, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, EH, 
  ST_QUA, COLOR1, P5, EH, EA, P1, 
  ST_QUA, COLOR1, P5, P1, EB, EE, 
 // Case #227: (cloned #31)
  ST_QUA, COLOR0, EB, P2, P3, P4, 
  ST_TRI, COLOR0, EB, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, P0, 
  ST_QUA, COLOR1, P5, P0, P1, EB, 
  ST_TRI, COLOR1, P5, EB, EE, 
 // Case #228: (cloned #39)
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, EH, 
  ST_QUA, COLOR1, P5, EH, EB, P2, 
  ST_QUA, COLOR1, P5, P2, EC, EE, 
 // Case #229: (cloned #47)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, P0, 
  ST_QUA, COLOR1, P5, P0, EA, EB, 
  ST_QUA, COLOR1, P5, EB, P2, EC, 
  ST_TRI, COLOR1, P5, EC, EE, 
 // Case #230: (cloned #55)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, EH, 
  ST_QUA, COLOR1, P5, EH, EA, P1, 
  ST_QUA, COLOR1, P5, P1, P2, EC, 
  ST_TRI, COLOR1, P5, EC, EE, 
 // Case #231: (cloned #63)
  ST_QUA, COLOR0, EC, P3, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, P0, 
  ST_QUA, COLOR1, P5, P0, P1, P2, 
  ST_QUA, COLOR1, P5, P2, EC, EE, 
 // Case #232: (cloned #23)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, P0, P1, P2, EC, 
  ST_TRI, COLOR0, EH, P0, EC, 
  ST_QUA, COLOR1, EE, P5, P6, P7, 
  ST_QUA, COLOR1, P3, ED, EE, P7, 
  ST_QUA, COLOR1, EH, EC, P3, P7, 
 // Case #233: (cloned #47)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, P5, P6, P7, P0, 
  ST_QUA, COLOR1, ED, EE, P5, P0, 
  ST_QUA, COLOR1, EC, P3, ED, P0, 
  ST_TRI, COLOR1, EA, EC, P0, 
 // Case #234: (cloned #87)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, EH, 
  ST_QUA, COLOR1, P5, EH, EA, P1, 
  ST_QUA, COLOR1, P5, P1, EB, EC, 
  ST_QUA, COLOR1, P5, EC, P3, ED, 
  ST_TRI, COLOR1, P5, ED, EE, 
 // Case #235: (cloned #95)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, P0, 
  ST_QUA, COLOR1, P5, P0, P1, EB, 
  ST_QUA, COLOR1, P5, EB, EC, P3, 
  ST_QUA, COLOR1, P5, P3, ED, EE, 
 // Case #236: (cloned #55)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, EE, P5, P6, P7, 
  ST_QUA, COLOR1, P3, ED, EE, P7, 
  ST_QUA, COLOR1, EB, P2, P3, P7, 
  ST_TRI, COLOR1, EH, EB, P7, 
 // Case #237: (cloned #111)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, P0, 
  ST_QUA, COLOR1, P5, P0, EA, EB, 
  ST_QUA, COLOR1, P5, EB, P2, P3, 
  ST_QUA, COLOR1, P5, P3, ED, EE, 
 // Case #238: (cloned #119)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, ED, 
  ST_QUA, COLOR1, P1, ED, EE, P5, 
  ST_QUA, COLOR1, P1, P5, P6, P7, 
  ST_QUA, COLOR1, P1, P7, EH, EA, 
 // Case #239: (cloned #127)
  ST_TRI, COLOR0, ED, P4, EE, 
  ST_QUA, COLOR1, P5, P6, P7, P0, 
  ST_QUA, COLOR1, P5, P0, P1, P2, 
  ST_QUA, COLOR1, P5, P2, P3, ED, 
  ST_TRI, COLOR1, P5, ED, EE, 
 // Case #240: (cloned #15)
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_QUA, COLOR0, EH, P2, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, P7, 
  ST_QUA, COLOR1, P4, P7, EH, ED, 
 // Case #241: (cloned #31)
  ST_QUA, COLOR0, EA, P1, P2, P3, 
  ST_TRI, COLOR0, EA, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, P7, 
  ST_QUA, COLOR1, P4, P7, P0, EA, 
  ST_TRI, COLOR1, P4, EA, ED, 
 // Case #242: (cloned #47)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, P7, 
  ST_QUA, COLOR1, P4, P7, EH, EA, 
  ST_QUA, COLOR1, P4, EA, P1, EB, 
  ST_TRI, COLOR1, P4, EB, ED, 
 // Case #243: (cloned #63)
  ST_QUA, COLOR0, EB, P2, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, P7, 
  ST_QUA, COLOR1, P4, P7, P0, P1, 
  ST_QUA, COLOR1, P4, P1, EB, ED, 
 // Case #244: (cloned #47)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, P4, P5, P6, P7, 
  ST_QUA, COLOR1, EC, ED, P4, P7, 
  ST_QUA, COLOR1, EB, P2, EC, P7, 
  ST_TRI, COLOR1, EH, EB, P7, 
 // Case #245: (cloned #95)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, P7, 
  ST_QUA, COLOR1, P4, P7, P0, EA, 
  ST_QUA, COLOR1, P4, EA, EB, P2, 
  ST_QUA, COLOR1, P4, P2, EC, ED, 
 // Case #246: (cloned #111)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, P7, 
  ST_QUA, COLOR1, P4, P7, EH, EA, 
  ST_QUA, COLOR1, P4, EA, P1, P2, 
  ST_QUA, COLOR1, P4, P2, EC, ED, 
 // Case #247: (cloned #127)
  ST_TRI, COLOR0, EC, P3, ED, 
  ST_QUA, COLOR1, P4, P5, P6, P7, 
  ST_QUA, COLOR1, P4, P7, P0, P1, 
  ST_QUA, COLOR1, P4, P1, P2, EC, 
  ST_TRI, COLOR1, P4, EC, ED, 
 // Case #248: (cloned #31)
  ST_QUA, COLOR0, EH, P0, P1, P2, 
  ST_TRI, COLOR0, EH, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, P6, 
  ST_QUA, COLOR1, P3, P6, P7, EH, 
  ST_TRI, COLOR1, P3, EH, EC, 
 // Case #249: (cloned #63)
  ST_QUA, COLOR0, EA, P1, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, P6, 
  ST_QUA, COLOR1, P3, P6, P7, P0, 
  ST_QUA, COLOR1, P3, P0, EA, EC, 
 // Case #250: (cloned #95)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, P6, 
  ST_QUA, COLOR1, P3, P6, P7, EH, 
  ST_QUA, COLOR1, P3, EH, EA, P1, 
  ST_QUA, COLOR1, P3, P1, EB, EC, 
 // Case #251: (cloned #127)
  ST_TRI, COLOR0, EB, P2, EC, 
  ST_QUA, COLOR1, P3, P4, P5, P6, 
  ST_QUA, COLOR1, P3, P6, P7, P0, 
  ST_QUA, COLOR1, P3, P0, P1, EB, 
  ST_TRI, COLOR1, P3, EB, EC, 
 // Case #252: (cloned #63)
  ST_QUA, COLOR0, EH, P0, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, P5, 
  ST_QUA, COLOR1, P2, P5, P6, P7, 
  ST_QUA, COLOR1, P2, P7, EH, EB, 
 // Case #253: (cloned #127)
  ST_TRI, COLOR0, EA, P1, EB, 
  ST_QUA, COLOR1, P2, P3, P4, P5, 
  ST_QUA, COLOR1, P2, P5, P6, P7, 
  ST_QUA, COLOR1, P2, P7, P0, EA, 
  ST_TRI, COLOR1, P2, EA, EB, 
 // Case #254: (cloned #127)
  ST_TRI, COLOR0, EH, P0, EA, 
  ST_QUA, COLOR1, P1, P2, P3, P4, 
  ST_QUA, COLOR1, P1, P4, P5, P6, 
  ST_QUA, COLOR1, P1, P6, P7, EH, 
  ST_TRI, COLOR1, P1, EH, EA, 
 // Case #255: Unique case #30
  ST_QUA, COLOR1, P0, P1, P2, P3, 
  ST_QUA, COLOR1, P0, P3, P4, P5, 
  ST_QUA, COLOR1, P0, P5, P6, P7, 
 // Dummy
  0
};

