//=============================================================================
//
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//  Copyright 2012 Sandia Corporation.
//  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
//  the U.S. Government retains certain rights in this software.
//
//=============================================================================

#include <vtkmContour.h>
#include <vtkmFilterOverrides.h>

#include <vtkNew.h>

#include <string>

namespace
{

template <typename BaseClass>
bool TestOverride(const std::string& baseClassName, const std::string& overrideClassName)
{
  std::cout << "Using object factory to instantiate " << baseClassName << "\n";
  vtkNew<BaseClass> instance;
  std::cout << "instantiated: " << instance->GetClassName() << "\n";

  return instance->GetClassName() ==
    (vtkmFilterOverrides::GetEnabled() ? overrideClassName : baseClassName);
}

#define TEST_OVERRIDE(BASE, OVERRIDE)                                                              \
  if (!TestOverride<BASE>(#BASE, #OVERRIDE))                                                       \
  {                                                                                                \
    return false;                                                                                  \
  }

bool TestOverrides()
{
  std::cout << "Testing with vtkmFilterOverrides::GetEnabled() = "
            << vtkmFilterOverrides::GetEnabled() << "\n";

  TEST_OVERRIDE(vtkContourFilter, vtkmContour)

  return true;
}

} // namespace

int TestVTKMOverride(int, char*[])
{
  // When VTK_ENABLE_VTKM_OVERRIDES is off, vtkmFilterOverrides::EnabledOn() should not have any
  // effects
  std::cout << "Build option VTK_ENABLE_VTKM_OVERRIDES: " << VTK_ENABLE_VTKM_OVERRIDES << "\n";

  vtkmFilterOverrides::EnabledOn();
  if (!VTK_ENABLE_VTKM_OVERRIDES && vtkmFilterOverrides::GetEnabled())
  {
    std::cerr << "vtkmFilterOverrides::GetEnabled() should always be false when "
              << "VTK_ENABLE_VTKM_OVERRIDES is off";
    return 1;
  }
  if (!TestOverrides())
  {
    return 1;
  }

#if VTK_ENABLE_VTKM_OVERRIDES
  // Only makes sense when VTK_ENABLE_VTKM_OVERRIDES is On.
  vtkmFilterOverrides::EnabledOff();
  if (!TestOverrides())
  {
    return 1;
  }
#endif

  return 0;
}
