<?php
/* MySQL change password backend
 * Author: Thijs Kinkhorst <kink@squirrelmail.org>
 */

/**
 * Config vars
 */

global $mysql_server, $mysql_database, $mysql_table, $mysql_userid_field,
       $mysql_password_field, $mysql_manager_id, $mysql_manager_pw;

// The MySQL Server
$mysql_server = 'localhost';
$mysql_database = 'postfix';
$mysql_table = 'mailbox';

// The names of the user ID and password columns
$mysql_userid_field = 'username';
$mysql_password_field ='password';

// The user to log into MySQL with (must have rights)
$mysql_manager_id = 'postfix';
$mysql_manager_pw = 'YOURPASSWORD';


// NO NEED TO CHANGE ANYTHING BELOW THIS LINE

$MAGIC = "$1$";
$ITOA64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

global $squirrelmail_plugin_hooks;
$squirrelmail_plugin_hooks['change_password_dochange']['mysql'] = 	'cpw_mysql_dochange';

/**
 * This is the function that is specific to your backend. It takes
 * the current password (as supplied by the user) and the desired
 * new password. It will return an array of messages. If everything
 * was successful, the array will be empty. Else, it will contain
 * the errormessage(s).
 * Constants to be used for these messages:
 * CPW_CURRENT_NOMATCH -> "Your current password is not correct."
 * CPW_INVALID_PW -> "Your new password contains invalid characters."
 *
 * @param array data The username/currentpw/newpw data. 
 * @return array Array of error messages.
 */
function cpw_mysql_dochange($data)
{
    // unfortunately, we can only pass one parameter to a hook function,
    // so we have to pass it as an array.
    $username = $data['username'];
    $curpw = $data['curpw'];
    $newpw = $data['newpw'];

    $msgs = array();

    global $mysql_server, $mysql_database, $mysql_table, $mysql_userid_field,
           $mysql_password_field, $mysql_manager_id, $mysql_manager_pw;

    $ds = mysql_pconnect($mysql_server, $mysql_manager_id, $mysql_manager_pw);
    if (! $ds) {
        array_push($msgs, _("Cannot connect to Database Server, please try later!"));
	return $msgs;
    }
    if (!mysql_select_db($mysql_database, $ds)) {
        array_push($msgs, _("Database not found on server"));
	return $msgs;
    }

  $qq = 'SELECT ' . $mysql_userid_field . ',' . $mysql_password_field
                  . ' FROM '  . $mysql_table
                  . ' WHERE ' . $mysql_userid_field . '="' . mysql_escape_string($username) .'"';
  $ss = mysql_query($qq, $ds);
  $dd = mysql_fetch_assoc ( $ss );

    $pw_db = $dd[$mysql_password_field];

  #echo "DEBUGINFO: Received Response  : " . $dd[$mysql_password_field] ." " .$curpw    ."<br />";
  #echo "DEBUGINFO: PACRYPT Password: " . mysql_escape_string(pacrypt($curpw, $pw_db)) . "<br />";
  #echo "DEBUGINFO: Newstored Password: (".$newpw.") " . mysql_escape_string(pacrypt($newpw, $pw_db)) . "<br />";

    $query_string = 'SELECT ' . $mysql_userid_field . ',' . $mysql_password_field
                  . ' FROM '  . $mysql_table
                  . ' WHERE ' . $mysql_userid_field . '="' . mysql_escape_string($username) .'"'
		  . ' AND ' . $mysql_password_field . '="' . mysql_escape_string(pacrypt($curpw,$pw_db)) . '"';

    $select_result = mysql_query($query_string, $ds);
    if (!$select_result) {
        array_push($msgs, _("SQL call failed, try again later."));
	return $msgs;
    }
    if (mysql_num_rows($select_result) == 0) {
        array_push($msgs, CPW_CURRENT_NOMATCH);
        return $msgs;
    }
    if (mysql_num_rows($select_result) > 1) {
        //make sure we only have 1 uid
        array_push($msgs, _("Duplicate login entries detected, cannot change password!"));
        return $msgs;
    }
    $update_string = 'UPDATE '. $mysql_table . ' SET ' . $mysql_password_field
                 . ' = "' . mysql_escape_string(pacrypt($newpw,$pw_db)) . '"'
		   . ' WHERE ' . $mysql_userid_field . ' = "' . mysql_escape_string($username) . '"';
    if (!mysql_query($update_string, $ds)) {
        array_push($msgs, _("Password change was not successful!"));
    }

    return $msgs;
}


function pacrypt ($pw, $pw_db="")
{
   global $CONF;
   $password = "";


   $CONF['encrypt']="md5crypt";

   if ($CONF['encrypt'] == 'md5crypt')
   {
      $split_salt = preg_split ('/\$/', $pw_db);
      $salt = $split_salt[2];
      $password = md5crypt ($pw, $salt);

   }

   if ($CONF['encrypt'] == 'system')
   {

      if (ereg ("\$1\$", $pw_db))
      {
         $split_salt = preg_split ('/\$/', $pw_db);
         $salt = $split_salt[2];
      }
      else
      {
         $salt = substr ($pw_db, 0, 2);
      }
      $password = crypt ($pw, $salt);
   }

   if ($CONF['encrypt'] == 'cleartext')
   {
      $password = $pw;
   }

   return $password;
}

function md5crypt ($pw, $salt="", $magic="")
{
   global $MAGIC;
   if ($magic == "") $magic = $MAGIC;
   if ($salt == "") $salt = create_salt();
   $slist = explode ("$", $salt);
   if ($slist[0] == "1") $salt = $slist[1];
   $salt = substr ($salt, 0, 8);
   $ctx = $pw . $magic . $salt;
   $final = hex2bin (md5 ($pw . $salt . $pw));
   for ($i=strlen ($pw); $i>0; $i-=16) {
      if ($i > 16)
         $ctx .= substr ($final,0,16);
      else
         $ctx .= substr ($final,0,$i);
   }
   $i = strlen ($pw);
   while ($i > 0) {
      if ($i & 1) $ctx .= chr (0);
      else $ctx .= $pw[0];
      $i = $i >> 1;
   }
   $final = hex2bin (md5 ($ctx));
   for ($i=0;$i<1000;$i++) {
      $ctx1 = "";
       if ($i & 1) $ctx1 .= $pw;
      else $ctx1 .= substr ($final,0,16);
      if ($i % 3) $ctx1 .= $salt;
        if ($i % 7) $ctx1 .= $pw;
      if ($i & 1) $ctx1 .= substr ($final,0,16);
      else $ctx1 .= $pw;
      $final = hex2bin (md5 ($ctx1));
   }

   $passwd = "";
   $passwd .= to64 ( ( (ord ($final[0]) << 16) | (ord ($final[6]) << 8) | (ord ($final[12])) ), 4);
   $passwd .= to64 ( ( (ord ($final[1]) << 16) | (ord ($final[7]) << 8) | (ord ($final[13])) ), 4);
   $passwd .= to64 ( ( (ord ($final[2]) << 16) | (ord ($final[8]) << 8) | (ord ($final[14])) ), 4);
   $passwd .= to64 ( ( (ord ($final[3]) << 16) | (ord ($final[9]) << 8) | (ord ($final[15])) ), 4);
   $passwd .= to64 ( ( (ord ($final[4]) << 16) | (ord ($final[10]) << 8) | (ord ($final[5])) ), 4);
   $passwd .= to64 ( ord ($final[11]), 2);
   return "$magic$salt\$$passwd";
}

function create_salt ()
{
   srand ((double)microtime ()*1000000);
   $salt = substr (md5 (rand (0,9999999)), 0, 8);
   return $salt;
}

function hex2bin ($str)
{
   $len = strlen ($str);
   $nstr = "";
   for ($i=0;$i<$len;$i+=2) {
      $num = sscanf (substr ($str,$i,2), "%x");
      $nstr.=chr ($num[0]);
   }
   return $nstr;
}

function to64 ($v, $n)
{
   global $ITOA64;
   $ret = "";
   while (($n - 1) >= 0) {
      $n--;
      $ret .= $ITOA64[$v & 0x3f];
      $v = $v >> 6;
   }
   return $ret;
}

