// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::{prelude::*, translate::*};
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkCoordType")]
pub enum CoordType {
    #[doc(alias = "ATK_XY_SCREEN")]
    Screen,
    #[doc(alias = "ATK_XY_WINDOW")]
    Window,
    #[doc(alias = "ATK_XY_PARENT")]
    Parent,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CoordType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CoordType::{}",
            match *self {
                Self::Screen => "Screen",
                Self::Window => "Window",
                Self::Parent => "Parent",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CoordType {
    type GlibType = ffi::AtkCoordType;

    #[inline]
    fn into_glib(self) -> ffi::AtkCoordType {
        match self {
            Self::Screen => ffi::ATK_XY_SCREEN,
            Self::Window => ffi::ATK_XY_WINDOW,
            Self::Parent => ffi::ATK_XY_PARENT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AtkCoordType> for CoordType {
    #[inline]
    unsafe fn from_glib(value: ffi::AtkCoordType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_XY_SCREEN => Self::Screen,
            ffi::ATK_XY_WINDOW => Self::Window,
            ffi::ATK_XY_PARENT => Self::Parent,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CoordType {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_coord_type_get_type()) }
    }
}

impl glib::HasParamSpec for CoordType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

impl glib::value::ValueType for CoordType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for CoordType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CoordType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<CoordType> for glib::Value {
    #[inline]
    fn from(v: CoordType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkLayer")]
pub enum Layer {
    #[doc(alias = "ATK_LAYER_INVALID")]
    Invalid,
    #[doc(alias = "ATK_LAYER_BACKGROUND")]
    Background,
    #[doc(alias = "ATK_LAYER_CANVAS")]
    Canvas,
    #[doc(alias = "ATK_LAYER_WIDGET")]
    Widget,
    #[doc(alias = "ATK_LAYER_MDI")]
    Mdi,
    #[doc(alias = "ATK_LAYER_POPUP")]
    Popup,
    #[doc(alias = "ATK_LAYER_OVERLAY")]
    Overlay,
    #[doc(alias = "ATK_LAYER_WINDOW")]
    Window,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Layer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Layer::{}",
            match *self {
                Self::Invalid => "Invalid",
                Self::Background => "Background",
                Self::Canvas => "Canvas",
                Self::Widget => "Widget",
                Self::Mdi => "Mdi",
                Self::Popup => "Popup",
                Self::Overlay => "Overlay",
                Self::Window => "Window",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Layer {
    type GlibType = ffi::AtkLayer;

    #[inline]
    fn into_glib(self) -> ffi::AtkLayer {
        match self {
            Self::Invalid => ffi::ATK_LAYER_INVALID,
            Self::Background => ffi::ATK_LAYER_BACKGROUND,
            Self::Canvas => ffi::ATK_LAYER_CANVAS,
            Self::Widget => ffi::ATK_LAYER_WIDGET,
            Self::Mdi => ffi::ATK_LAYER_MDI,
            Self::Popup => ffi::ATK_LAYER_POPUP,
            Self::Overlay => ffi::ATK_LAYER_OVERLAY,
            Self::Window => ffi::ATK_LAYER_WINDOW,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AtkLayer> for Layer {
    #[inline]
    unsafe fn from_glib(value: ffi::AtkLayer) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_LAYER_INVALID => Self::Invalid,
            ffi::ATK_LAYER_BACKGROUND => Self::Background,
            ffi::ATK_LAYER_CANVAS => Self::Canvas,
            ffi::ATK_LAYER_WIDGET => Self::Widget,
            ffi::ATK_LAYER_MDI => Self::Mdi,
            ffi::ATK_LAYER_POPUP => Self::Popup,
            ffi::ATK_LAYER_OVERLAY => Self::Overlay,
            ffi::ATK_LAYER_WINDOW => Self::Window,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Layer {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_layer_get_type()) }
    }
}

impl glib::HasParamSpec for Layer {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

impl glib::value::ValueType for Layer {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for Layer {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Layer {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<Layer> for glib::Value {
    #[inline]
    fn from(v: Layer) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v2_50")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_50")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkLive")]
pub enum Live {
    #[doc(alias = "ATK_LIVE_NONE")]
    None,
    #[doc(alias = "ATK_LIVE_POLITE")]
    Polite,
    #[doc(alias = "ATK_LIVE_ASSERTIVE")]
    Assertive,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v2_50")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_50")))]
impl fmt::Display for Live {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Live::{}",
            match *self {
                Self::None => "None",
                Self::Polite => "Polite",
                Self::Assertive => "Assertive",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(feature = "v2_50")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl IntoGlib for Live {
    type GlibType = ffi::AtkLive;

    #[inline]
    fn into_glib(self) -> ffi::AtkLive {
        match self {
            Self::None => ffi::ATK_LIVE_NONE,
            Self::Polite => ffi::ATK_LIVE_POLITE,
            Self::Assertive => ffi::ATK_LIVE_ASSERTIVE,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v2_50")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl FromGlib<ffi::AtkLive> for Live {
    #[inline]
    unsafe fn from_glib(value: ffi::AtkLive) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_LIVE_NONE => Self::None,
            ffi::ATK_LIVE_POLITE => Self::Polite,
            ffi::ATK_LIVE_ASSERTIVE => Self::Assertive,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v2_50")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_50")))]
impl StaticType for Live {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_live_get_type()) }
    }
}

#[cfg(feature = "v2_50")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_50")))]
impl glib::HasParamSpec for Live {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

#[cfg(feature = "v2_50")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_50")))]
impl glib::value::ValueType for Live {
    type Type = Self;
}

#[cfg(feature = "v2_50")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_50")))]
unsafe impl<'a> glib::value::FromValue<'a> for Live {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v2_50")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_50")))]
impl ToValue for Live {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v2_50")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_50")))]
impl From<Live> for glib::Value {
    #[inline]
    fn from(v: Live) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkRelationType")]
pub enum RelationType {
    #[doc(alias = "ATK_RELATION_NULL")]
    Null,
    #[doc(alias = "ATK_RELATION_CONTROLLED_BY")]
    ControlledBy,
    #[doc(alias = "ATK_RELATION_CONTROLLER_FOR")]
    ControllerFor,
    #[doc(alias = "ATK_RELATION_LABEL_FOR")]
    LabelFor,
    #[doc(alias = "ATK_RELATION_LABELLED_BY")]
    LabelledBy,
    #[doc(alias = "ATK_RELATION_MEMBER_OF")]
    MemberOf,
    #[doc(alias = "ATK_RELATION_NODE_CHILD_OF")]
    NodeChildOf,
    #[doc(alias = "ATK_RELATION_FLOWS_TO")]
    FlowsTo,
    #[doc(alias = "ATK_RELATION_FLOWS_FROM")]
    FlowsFrom,
    #[doc(alias = "ATK_RELATION_SUBWINDOW_OF")]
    SubwindowOf,
    #[doc(alias = "ATK_RELATION_EMBEDS")]
    Embeds,
    #[doc(alias = "ATK_RELATION_EMBEDDED_BY")]
    EmbeddedBy,
    #[doc(alias = "ATK_RELATION_POPUP_FOR")]
    PopupFor,
    #[doc(alias = "ATK_RELATION_PARENT_WINDOW_OF")]
    ParentWindowOf,
    #[doc(alias = "ATK_RELATION_DESCRIBED_BY")]
    DescribedBy,
    #[doc(alias = "ATK_RELATION_DESCRIPTION_FOR")]
    DescriptionFor,
    #[doc(alias = "ATK_RELATION_NODE_PARENT_OF")]
    NodeParentOf,
    #[doc(alias = "ATK_RELATION_DETAILS")]
    Details,
    #[doc(alias = "ATK_RELATION_DETAILS_FOR")]
    DetailsFor,
    #[doc(alias = "ATK_RELATION_ERROR_MESSAGE")]
    ErrorMessage,
    #[doc(alias = "ATK_RELATION_ERROR_FOR")]
    ErrorFor,
    #[doc(alias = "ATK_RELATION_LAST_DEFINED")]
    LastDefined,
    #[doc(hidden)]
    __Unknown(i32),
}

impl RelationType {
    #[doc(alias = "atk_relation_type_for_name")]
    pub fn for_name(name: &str) -> RelationType {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::atk_relation_type_for_name(name.to_glib_none().0)) }
    }

    #[doc(alias = "atk_relation_type_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::atk_relation_type_get_name(self.into_glib())) }
    }
}

impl fmt::Display for RelationType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RelationType::{}",
            match *self {
                Self::Null => "Null",
                Self::ControlledBy => "ControlledBy",
                Self::ControllerFor => "ControllerFor",
                Self::LabelFor => "LabelFor",
                Self::LabelledBy => "LabelledBy",
                Self::MemberOf => "MemberOf",
                Self::NodeChildOf => "NodeChildOf",
                Self::FlowsTo => "FlowsTo",
                Self::FlowsFrom => "FlowsFrom",
                Self::SubwindowOf => "SubwindowOf",
                Self::Embeds => "Embeds",
                Self::EmbeddedBy => "EmbeddedBy",
                Self::PopupFor => "PopupFor",
                Self::ParentWindowOf => "ParentWindowOf",
                Self::DescribedBy => "DescribedBy",
                Self::DescriptionFor => "DescriptionFor",
                Self::NodeParentOf => "NodeParentOf",
                Self::Details => "Details",
                Self::DetailsFor => "DetailsFor",
                Self::ErrorMessage => "ErrorMessage",
                Self::ErrorFor => "ErrorFor",
                Self::LastDefined => "LastDefined",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for RelationType {
    type GlibType = ffi::AtkRelationType;

    fn into_glib(self) -> ffi::AtkRelationType {
        match self {
            Self::Null => ffi::ATK_RELATION_NULL,
            Self::ControlledBy => ffi::ATK_RELATION_CONTROLLED_BY,
            Self::ControllerFor => ffi::ATK_RELATION_CONTROLLER_FOR,
            Self::LabelFor => ffi::ATK_RELATION_LABEL_FOR,
            Self::LabelledBy => ffi::ATK_RELATION_LABELLED_BY,
            Self::MemberOf => ffi::ATK_RELATION_MEMBER_OF,
            Self::NodeChildOf => ffi::ATK_RELATION_NODE_CHILD_OF,
            Self::FlowsTo => ffi::ATK_RELATION_FLOWS_TO,
            Self::FlowsFrom => ffi::ATK_RELATION_FLOWS_FROM,
            Self::SubwindowOf => ffi::ATK_RELATION_SUBWINDOW_OF,
            Self::Embeds => ffi::ATK_RELATION_EMBEDS,
            Self::EmbeddedBy => ffi::ATK_RELATION_EMBEDDED_BY,
            Self::PopupFor => ffi::ATK_RELATION_POPUP_FOR,
            Self::ParentWindowOf => ffi::ATK_RELATION_PARENT_WINDOW_OF,
            Self::DescribedBy => ffi::ATK_RELATION_DESCRIBED_BY,
            Self::DescriptionFor => ffi::ATK_RELATION_DESCRIPTION_FOR,
            Self::NodeParentOf => ffi::ATK_RELATION_NODE_PARENT_OF,
            Self::Details => ffi::ATK_RELATION_DETAILS,
            Self::DetailsFor => ffi::ATK_RELATION_DETAILS_FOR,
            Self::ErrorMessage => ffi::ATK_RELATION_ERROR_MESSAGE,
            Self::ErrorFor => ffi::ATK_RELATION_ERROR_FOR,
            Self::LastDefined => ffi::ATK_RELATION_LAST_DEFINED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AtkRelationType> for RelationType {
    unsafe fn from_glib(value: ffi::AtkRelationType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_RELATION_NULL => Self::Null,
            ffi::ATK_RELATION_CONTROLLED_BY => Self::ControlledBy,
            ffi::ATK_RELATION_CONTROLLER_FOR => Self::ControllerFor,
            ffi::ATK_RELATION_LABEL_FOR => Self::LabelFor,
            ffi::ATK_RELATION_LABELLED_BY => Self::LabelledBy,
            ffi::ATK_RELATION_MEMBER_OF => Self::MemberOf,
            ffi::ATK_RELATION_NODE_CHILD_OF => Self::NodeChildOf,
            ffi::ATK_RELATION_FLOWS_TO => Self::FlowsTo,
            ffi::ATK_RELATION_FLOWS_FROM => Self::FlowsFrom,
            ffi::ATK_RELATION_SUBWINDOW_OF => Self::SubwindowOf,
            ffi::ATK_RELATION_EMBEDS => Self::Embeds,
            ffi::ATK_RELATION_EMBEDDED_BY => Self::EmbeddedBy,
            ffi::ATK_RELATION_POPUP_FOR => Self::PopupFor,
            ffi::ATK_RELATION_PARENT_WINDOW_OF => Self::ParentWindowOf,
            ffi::ATK_RELATION_DESCRIBED_BY => Self::DescribedBy,
            ffi::ATK_RELATION_DESCRIPTION_FOR => Self::DescriptionFor,
            ffi::ATK_RELATION_NODE_PARENT_OF => Self::NodeParentOf,
            ffi::ATK_RELATION_DETAILS => Self::Details,
            ffi::ATK_RELATION_DETAILS_FOR => Self::DetailsFor,
            ffi::ATK_RELATION_ERROR_MESSAGE => Self::ErrorMessage,
            ffi::ATK_RELATION_ERROR_FOR => Self::ErrorFor,
            ffi::ATK_RELATION_LAST_DEFINED => Self::LastDefined,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for RelationType {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_relation_type_get_type()) }
    }
}

impl glib::HasParamSpec for RelationType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

impl glib::value::ValueType for RelationType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for RelationType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for RelationType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<RelationType> for glib::Value {
    #[inline]
    fn from(v: RelationType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkRole")]
pub enum Role {
    #[doc(alias = "ATK_ROLE_INVALID")]
    Invalid,
    #[doc(alias = "ATK_ROLE_ACCEL_LABEL")]
    AcceleratorLabel,
    #[doc(alias = "ATK_ROLE_ALERT")]
    Alert,
    #[doc(alias = "ATK_ROLE_ANIMATION")]
    Animation,
    #[doc(alias = "ATK_ROLE_ARROW")]
    Arrow,
    #[doc(alias = "ATK_ROLE_CALENDAR")]
    Calendar,
    #[doc(alias = "ATK_ROLE_CANVAS")]
    Canvas,
    #[doc(alias = "ATK_ROLE_CHECK_BOX")]
    CheckBox,
    #[doc(alias = "ATK_ROLE_CHECK_MENU_ITEM")]
    CheckMenuItem,
    #[doc(alias = "ATK_ROLE_COLOR_CHOOSER")]
    ColorChooser,
    #[doc(alias = "ATK_ROLE_COLUMN_HEADER")]
    ColumnHeader,
    #[doc(alias = "ATK_ROLE_COMBO_BOX")]
    ComboBox,
    #[doc(alias = "ATK_ROLE_DATE_EDITOR")]
    DateEditor,
    #[doc(alias = "ATK_ROLE_DESKTOP_ICON")]
    DesktopIcon,
    #[doc(alias = "ATK_ROLE_DESKTOP_FRAME")]
    DesktopFrame,
    #[doc(alias = "ATK_ROLE_DIAL")]
    Dial,
    #[doc(alias = "ATK_ROLE_DIALOG")]
    Dialog,
    #[doc(alias = "ATK_ROLE_DIRECTORY_PANE")]
    DirectoryPane,
    #[doc(alias = "ATK_ROLE_DRAWING_AREA")]
    DrawingArea,
    #[doc(alias = "ATK_ROLE_FILE_CHOOSER")]
    FileChooser,
    #[doc(alias = "ATK_ROLE_FILLER")]
    Filler,
    #[doc(alias = "ATK_ROLE_FONT_CHOOSER")]
    FontChooser,
    #[doc(alias = "ATK_ROLE_FRAME")]
    Frame,
    #[doc(alias = "ATK_ROLE_GLASS_PANE")]
    GlassPane,
    #[doc(alias = "ATK_ROLE_HTML_CONTAINER")]
    HtmlContainer,
    #[doc(alias = "ATK_ROLE_ICON")]
    Icon,
    #[doc(alias = "ATK_ROLE_IMAGE")]
    Image,
    #[doc(alias = "ATK_ROLE_INTERNAL_FRAME")]
    InternalFrame,
    #[doc(alias = "ATK_ROLE_LABEL")]
    Label,
    #[doc(alias = "ATK_ROLE_LAYERED_PANE")]
    LayeredPane,
    #[doc(alias = "ATK_ROLE_LIST")]
    List,
    #[doc(alias = "ATK_ROLE_LIST_ITEM")]
    ListItem,
    #[doc(alias = "ATK_ROLE_MENU")]
    Menu,
    #[doc(alias = "ATK_ROLE_MENU_BAR")]
    MenuBar,
    #[doc(alias = "ATK_ROLE_MENU_ITEM")]
    MenuItem,
    #[doc(alias = "ATK_ROLE_OPTION_PANE")]
    OptionPane,
    #[doc(alias = "ATK_ROLE_PAGE_TAB")]
    PageTab,
    #[doc(alias = "ATK_ROLE_PAGE_TAB_LIST")]
    PageTabList,
    #[doc(alias = "ATK_ROLE_PANEL")]
    Panel,
    #[doc(alias = "ATK_ROLE_PASSWORD_TEXT")]
    PasswordText,
    #[doc(alias = "ATK_ROLE_POPUP_MENU")]
    PopupMenu,
    #[doc(alias = "ATK_ROLE_PROGRESS_BAR")]
    ProgressBar,
    #[doc(alias = "ATK_ROLE_PUSH_BUTTON")]
    PushButton,
    #[doc(alias = "ATK_ROLE_RADIO_BUTTON")]
    RadioButton,
    #[doc(alias = "ATK_ROLE_RADIO_MENU_ITEM")]
    RadioMenuItem,
    #[doc(alias = "ATK_ROLE_ROOT_PANE")]
    RootPane,
    #[doc(alias = "ATK_ROLE_ROW_HEADER")]
    RowHeader,
    #[doc(alias = "ATK_ROLE_SCROLL_BAR")]
    ScrollBar,
    #[doc(alias = "ATK_ROLE_SCROLL_PANE")]
    ScrollPane,
    #[doc(alias = "ATK_ROLE_SEPARATOR")]
    Separator,
    #[doc(alias = "ATK_ROLE_SLIDER")]
    Slider,
    #[doc(alias = "ATK_ROLE_SPLIT_PANE")]
    SplitPane,
    #[doc(alias = "ATK_ROLE_SPIN_BUTTON")]
    SpinButton,
    #[doc(alias = "ATK_ROLE_STATUSBAR")]
    Statusbar,
    #[doc(alias = "ATK_ROLE_TABLE")]
    Table,
    #[doc(alias = "ATK_ROLE_TABLE_CELL")]
    TableCell,
    #[doc(alias = "ATK_ROLE_TABLE_COLUMN_HEADER")]
    TableColumnHeader,
    #[doc(alias = "ATK_ROLE_TABLE_ROW_HEADER")]
    TableRowHeader,
    #[doc(alias = "ATK_ROLE_TEAR_OFF_MENU_ITEM")]
    TearOffMenuItem,
    #[doc(alias = "ATK_ROLE_TERMINAL")]
    Terminal,
    #[doc(alias = "ATK_ROLE_TEXT")]
    Text,
    #[doc(alias = "ATK_ROLE_TOGGLE_BUTTON")]
    ToggleButton,
    #[doc(alias = "ATK_ROLE_TOOL_BAR")]
    ToolBar,
    #[doc(alias = "ATK_ROLE_TOOL_TIP")]
    ToolTip,
    #[doc(alias = "ATK_ROLE_TREE")]
    Tree,
    #[doc(alias = "ATK_ROLE_TREE_TABLE")]
    TreeTable,
    #[doc(alias = "ATK_ROLE_UNKNOWN")]
    Unknown,
    #[doc(alias = "ATK_ROLE_VIEWPORT")]
    Viewport,
    #[doc(alias = "ATK_ROLE_WINDOW")]
    Window,
    #[doc(alias = "ATK_ROLE_HEADER")]
    Header,
    #[doc(alias = "ATK_ROLE_FOOTER")]
    Footer,
    #[doc(alias = "ATK_ROLE_PARAGRAPH")]
    Paragraph,
    #[doc(alias = "ATK_ROLE_RULER")]
    Ruler,
    #[doc(alias = "ATK_ROLE_APPLICATION")]
    Application,
    #[doc(alias = "ATK_ROLE_AUTOCOMPLETE")]
    Autocomplete,
    #[doc(alias = "ATK_ROLE_EDITBAR")]
    EditBar,
    #[doc(alias = "ATK_ROLE_EMBEDDED")]
    Embedded,
    #[doc(alias = "ATK_ROLE_ENTRY")]
    Entry,
    #[doc(alias = "ATK_ROLE_CHART")]
    Chart,
    #[doc(alias = "ATK_ROLE_CAPTION")]
    Caption,
    #[doc(alias = "ATK_ROLE_DOCUMENT_FRAME")]
    DocumentFrame,
    #[doc(alias = "ATK_ROLE_HEADING")]
    Heading,
    #[doc(alias = "ATK_ROLE_PAGE")]
    Page,
    #[doc(alias = "ATK_ROLE_SECTION")]
    Section,
    #[doc(alias = "ATK_ROLE_REDUNDANT_OBJECT")]
    RedundantObject,
    #[doc(alias = "ATK_ROLE_FORM")]
    Form,
    #[doc(alias = "ATK_ROLE_LINK")]
    Link,
    #[doc(alias = "ATK_ROLE_INPUT_METHOD_WINDOW")]
    InputMethodWindow,
    #[doc(alias = "ATK_ROLE_TABLE_ROW")]
    TableRow,
    #[doc(alias = "ATK_ROLE_TREE_ITEM")]
    TreeItem,
    #[doc(alias = "ATK_ROLE_DOCUMENT_SPREADSHEET")]
    DocumentSpreadsheet,
    #[doc(alias = "ATK_ROLE_DOCUMENT_PRESENTATION")]
    DocumentPresentation,
    #[doc(alias = "ATK_ROLE_DOCUMENT_TEXT")]
    DocumentText,
    #[doc(alias = "ATK_ROLE_DOCUMENT_WEB")]
    DocumentWeb,
    #[doc(alias = "ATK_ROLE_DOCUMENT_EMAIL")]
    DocumentEmail,
    #[doc(alias = "ATK_ROLE_COMMENT")]
    Comment,
    #[doc(alias = "ATK_ROLE_LIST_BOX")]
    ListBox,
    #[doc(alias = "ATK_ROLE_GROUPING")]
    Grouping,
    #[doc(alias = "ATK_ROLE_IMAGE_MAP")]
    ImageMap,
    #[doc(alias = "ATK_ROLE_NOTIFICATION")]
    Notification,
    #[doc(alias = "ATK_ROLE_INFO_BAR")]
    InfoBar,
    #[doc(alias = "ATK_ROLE_LEVEL_BAR")]
    LevelBar,
    #[doc(alias = "ATK_ROLE_TITLE_BAR")]
    TitleBar,
    #[doc(alias = "ATK_ROLE_BLOCK_QUOTE")]
    BlockQuote,
    #[doc(alias = "ATK_ROLE_AUDIO")]
    Audio,
    #[doc(alias = "ATK_ROLE_VIDEO")]
    Video,
    #[doc(alias = "ATK_ROLE_DEFINITION")]
    Definition,
    #[doc(alias = "ATK_ROLE_ARTICLE")]
    Article,
    #[doc(alias = "ATK_ROLE_LANDMARK")]
    Landmark,
    #[doc(alias = "ATK_ROLE_LOG")]
    Log,
    #[doc(alias = "ATK_ROLE_MARQUEE")]
    Marquee,
    #[doc(alias = "ATK_ROLE_MATH")]
    Math,
    #[doc(alias = "ATK_ROLE_RATING")]
    Rating,
    #[doc(alias = "ATK_ROLE_TIMER")]
    Timer,
    #[doc(alias = "ATK_ROLE_DESCRIPTION_LIST")]
    DescriptionList,
    #[doc(alias = "ATK_ROLE_DESCRIPTION_TERM")]
    DescriptionTerm,
    #[doc(alias = "ATK_ROLE_DESCRIPTION_VALUE")]
    DescriptionValue,
    #[doc(alias = "ATK_ROLE_STATIC")]
    Static,
    #[doc(alias = "ATK_ROLE_MATH_FRACTION")]
    MathFraction,
    #[doc(alias = "ATK_ROLE_MATH_ROOT")]
    MathRoot,
    #[doc(alias = "ATK_ROLE_SUBSCRIPT")]
    Subscript,
    #[doc(alias = "ATK_ROLE_SUPERSCRIPT")]
    Superscript,
    #[doc(alias = "ATK_ROLE_FOOTNOTE")]
    Footnote,
    #[doc(alias = "ATK_ROLE_CONTENT_DELETION")]
    ContentDeletion,
    #[doc(alias = "ATK_ROLE_CONTENT_INSERTION")]
    ContentInsertion,
    #[doc(alias = "ATK_ROLE_MARK")]
    Mark,
    #[doc(alias = "ATK_ROLE_SUGGESTION")]
    Suggestion,
    #[doc(alias = "ATK_ROLE_PUSH_BUTTON_MENU")]
    PushButtonMenu,
    #[doc(alias = "ATK_ROLE_LAST_DEFINED")]
    LastDefined,
    #[doc(hidden)]
    __Unknown(i32),
}

impl Role {
    #[doc(alias = "atk_role_for_name")]
    pub fn for_name(name: &str) -> Role {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::atk_role_for_name(name.to_glib_none().0)) }
    }

    #[doc(alias = "atk_role_get_localized_name")]
    #[doc(alias = "get_localized_name")]
    pub fn localized_name(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::atk_role_get_localized_name(self.into_glib())) }
    }

    #[doc(alias = "atk_role_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::atk_role_get_name(self.into_glib())) }
    }
}

impl fmt::Display for Role {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Role::{}",
            match *self {
                Self::Invalid => "Invalid",
                Self::AcceleratorLabel => "AcceleratorLabel",
                Self::Alert => "Alert",
                Self::Animation => "Animation",
                Self::Arrow => "Arrow",
                Self::Calendar => "Calendar",
                Self::Canvas => "Canvas",
                Self::CheckBox => "CheckBox",
                Self::CheckMenuItem => "CheckMenuItem",
                Self::ColorChooser => "ColorChooser",
                Self::ColumnHeader => "ColumnHeader",
                Self::ComboBox => "ComboBox",
                Self::DateEditor => "DateEditor",
                Self::DesktopIcon => "DesktopIcon",
                Self::DesktopFrame => "DesktopFrame",
                Self::Dial => "Dial",
                Self::Dialog => "Dialog",
                Self::DirectoryPane => "DirectoryPane",
                Self::DrawingArea => "DrawingArea",
                Self::FileChooser => "FileChooser",
                Self::Filler => "Filler",
                Self::FontChooser => "FontChooser",
                Self::Frame => "Frame",
                Self::GlassPane => "GlassPane",
                Self::HtmlContainer => "HtmlContainer",
                Self::Icon => "Icon",
                Self::Image => "Image",
                Self::InternalFrame => "InternalFrame",
                Self::Label => "Label",
                Self::LayeredPane => "LayeredPane",
                Self::List => "List",
                Self::ListItem => "ListItem",
                Self::Menu => "Menu",
                Self::MenuBar => "MenuBar",
                Self::MenuItem => "MenuItem",
                Self::OptionPane => "OptionPane",
                Self::PageTab => "PageTab",
                Self::PageTabList => "PageTabList",
                Self::Panel => "Panel",
                Self::PasswordText => "PasswordText",
                Self::PopupMenu => "PopupMenu",
                Self::ProgressBar => "ProgressBar",
                Self::PushButton => "PushButton",
                Self::RadioButton => "RadioButton",
                Self::RadioMenuItem => "RadioMenuItem",
                Self::RootPane => "RootPane",
                Self::RowHeader => "RowHeader",
                Self::ScrollBar => "ScrollBar",
                Self::ScrollPane => "ScrollPane",
                Self::Separator => "Separator",
                Self::Slider => "Slider",
                Self::SplitPane => "SplitPane",
                Self::SpinButton => "SpinButton",
                Self::Statusbar => "Statusbar",
                Self::Table => "Table",
                Self::TableCell => "TableCell",
                Self::TableColumnHeader => "TableColumnHeader",
                Self::TableRowHeader => "TableRowHeader",
                Self::TearOffMenuItem => "TearOffMenuItem",
                Self::Terminal => "Terminal",
                Self::Text => "Text",
                Self::ToggleButton => "ToggleButton",
                Self::ToolBar => "ToolBar",
                Self::ToolTip => "ToolTip",
                Self::Tree => "Tree",
                Self::TreeTable => "TreeTable",
                Self::Unknown => "Unknown",
                Self::Viewport => "Viewport",
                Self::Window => "Window",
                Self::Header => "Header",
                Self::Footer => "Footer",
                Self::Paragraph => "Paragraph",
                Self::Ruler => "Ruler",
                Self::Application => "Application",
                Self::Autocomplete => "Autocomplete",
                Self::EditBar => "EditBar",
                Self::Embedded => "Embedded",
                Self::Entry => "Entry",
                Self::Chart => "Chart",
                Self::Caption => "Caption",
                Self::DocumentFrame => "DocumentFrame",
                Self::Heading => "Heading",
                Self::Page => "Page",
                Self::Section => "Section",
                Self::RedundantObject => "RedundantObject",
                Self::Form => "Form",
                Self::Link => "Link",
                Self::InputMethodWindow => "InputMethodWindow",
                Self::TableRow => "TableRow",
                Self::TreeItem => "TreeItem",
                Self::DocumentSpreadsheet => "DocumentSpreadsheet",
                Self::DocumentPresentation => "DocumentPresentation",
                Self::DocumentText => "DocumentText",
                Self::DocumentWeb => "DocumentWeb",
                Self::DocumentEmail => "DocumentEmail",
                Self::Comment => "Comment",
                Self::ListBox => "ListBox",
                Self::Grouping => "Grouping",
                Self::ImageMap => "ImageMap",
                Self::Notification => "Notification",
                Self::InfoBar => "InfoBar",
                Self::LevelBar => "LevelBar",
                Self::TitleBar => "TitleBar",
                Self::BlockQuote => "BlockQuote",
                Self::Audio => "Audio",
                Self::Video => "Video",
                Self::Definition => "Definition",
                Self::Article => "Article",
                Self::Landmark => "Landmark",
                Self::Log => "Log",
                Self::Marquee => "Marquee",
                Self::Math => "Math",
                Self::Rating => "Rating",
                Self::Timer => "Timer",
                Self::DescriptionList => "DescriptionList",
                Self::DescriptionTerm => "DescriptionTerm",
                Self::DescriptionValue => "DescriptionValue",
                Self::Static => "Static",
                Self::MathFraction => "MathFraction",
                Self::MathRoot => "MathRoot",
                Self::Subscript => "Subscript",
                Self::Superscript => "Superscript",
                Self::Footnote => "Footnote",
                Self::ContentDeletion => "ContentDeletion",
                Self::ContentInsertion => "ContentInsertion",
                Self::Mark => "Mark",
                Self::Suggestion => "Suggestion",
                Self::PushButtonMenu => "PushButtonMenu",
                Self::LastDefined => "LastDefined",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Role {
    type GlibType = ffi::AtkRole;

    fn into_glib(self) -> ffi::AtkRole {
        match self {
            Self::Invalid => ffi::ATK_ROLE_INVALID,
            Self::AcceleratorLabel => ffi::ATK_ROLE_ACCEL_LABEL,
            Self::Alert => ffi::ATK_ROLE_ALERT,
            Self::Animation => ffi::ATK_ROLE_ANIMATION,
            Self::Arrow => ffi::ATK_ROLE_ARROW,
            Self::Calendar => ffi::ATK_ROLE_CALENDAR,
            Self::Canvas => ffi::ATK_ROLE_CANVAS,
            Self::CheckBox => ffi::ATK_ROLE_CHECK_BOX,
            Self::CheckMenuItem => ffi::ATK_ROLE_CHECK_MENU_ITEM,
            Self::ColorChooser => ffi::ATK_ROLE_COLOR_CHOOSER,
            Self::ColumnHeader => ffi::ATK_ROLE_COLUMN_HEADER,
            Self::ComboBox => ffi::ATK_ROLE_COMBO_BOX,
            Self::DateEditor => ffi::ATK_ROLE_DATE_EDITOR,
            Self::DesktopIcon => ffi::ATK_ROLE_DESKTOP_ICON,
            Self::DesktopFrame => ffi::ATK_ROLE_DESKTOP_FRAME,
            Self::Dial => ffi::ATK_ROLE_DIAL,
            Self::Dialog => ffi::ATK_ROLE_DIALOG,
            Self::DirectoryPane => ffi::ATK_ROLE_DIRECTORY_PANE,
            Self::DrawingArea => ffi::ATK_ROLE_DRAWING_AREA,
            Self::FileChooser => ffi::ATK_ROLE_FILE_CHOOSER,
            Self::Filler => ffi::ATK_ROLE_FILLER,
            Self::FontChooser => ffi::ATK_ROLE_FONT_CHOOSER,
            Self::Frame => ffi::ATK_ROLE_FRAME,
            Self::GlassPane => ffi::ATK_ROLE_GLASS_PANE,
            Self::HtmlContainer => ffi::ATK_ROLE_HTML_CONTAINER,
            Self::Icon => ffi::ATK_ROLE_ICON,
            Self::Image => ffi::ATK_ROLE_IMAGE,
            Self::InternalFrame => ffi::ATK_ROLE_INTERNAL_FRAME,
            Self::Label => ffi::ATK_ROLE_LABEL,
            Self::LayeredPane => ffi::ATK_ROLE_LAYERED_PANE,
            Self::List => ffi::ATK_ROLE_LIST,
            Self::ListItem => ffi::ATK_ROLE_LIST_ITEM,
            Self::Menu => ffi::ATK_ROLE_MENU,
            Self::MenuBar => ffi::ATK_ROLE_MENU_BAR,
            Self::MenuItem => ffi::ATK_ROLE_MENU_ITEM,
            Self::OptionPane => ffi::ATK_ROLE_OPTION_PANE,
            Self::PageTab => ffi::ATK_ROLE_PAGE_TAB,
            Self::PageTabList => ffi::ATK_ROLE_PAGE_TAB_LIST,
            Self::Panel => ffi::ATK_ROLE_PANEL,
            Self::PasswordText => ffi::ATK_ROLE_PASSWORD_TEXT,
            Self::PopupMenu => ffi::ATK_ROLE_POPUP_MENU,
            Self::ProgressBar => ffi::ATK_ROLE_PROGRESS_BAR,
            Self::PushButton => ffi::ATK_ROLE_PUSH_BUTTON,
            Self::RadioButton => ffi::ATK_ROLE_RADIO_BUTTON,
            Self::RadioMenuItem => ffi::ATK_ROLE_RADIO_MENU_ITEM,
            Self::RootPane => ffi::ATK_ROLE_ROOT_PANE,
            Self::RowHeader => ffi::ATK_ROLE_ROW_HEADER,
            Self::ScrollBar => ffi::ATK_ROLE_SCROLL_BAR,
            Self::ScrollPane => ffi::ATK_ROLE_SCROLL_PANE,
            Self::Separator => ffi::ATK_ROLE_SEPARATOR,
            Self::Slider => ffi::ATK_ROLE_SLIDER,
            Self::SplitPane => ffi::ATK_ROLE_SPLIT_PANE,
            Self::SpinButton => ffi::ATK_ROLE_SPIN_BUTTON,
            Self::Statusbar => ffi::ATK_ROLE_STATUSBAR,
            Self::Table => ffi::ATK_ROLE_TABLE,
            Self::TableCell => ffi::ATK_ROLE_TABLE_CELL,
            Self::TableColumnHeader => ffi::ATK_ROLE_TABLE_COLUMN_HEADER,
            Self::TableRowHeader => ffi::ATK_ROLE_TABLE_ROW_HEADER,
            Self::TearOffMenuItem => ffi::ATK_ROLE_TEAR_OFF_MENU_ITEM,
            Self::Terminal => ffi::ATK_ROLE_TERMINAL,
            Self::Text => ffi::ATK_ROLE_TEXT,
            Self::ToggleButton => ffi::ATK_ROLE_TOGGLE_BUTTON,
            Self::ToolBar => ffi::ATK_ROLE_TOOL_BAR,
            Self::ToolTip => ffi::ATK_ROLE_TOOL_TIP,
            Self::Tree => ffi::ATK_ROLE_TREE,
            Self::TreeTable => ffi::ATK_ROLE_TREE_TABLE,
            Self::Unknown => ffi::ATK_ROLE_UNKNOWN,
            Self::Viewport => ffi::ATK_ROLE_VIEWPORT,
            Self::Window => ffi::ATK_ROLE_WINDOW,
            Self::Header => ffi::ATK_ROLE_HEADER,
            Self::Footer => ffi::ATK_ROLE_FOOTER,
            Self::Paragraph => ffi::ATK_ROLE_PARAGRAPH,
            Self::Ruler => ffi::ATK_ROLE_RULER,
            Self::Application => ffi::ATK_ROLE_APPLICATION,
            Self::Autocomplete => ffi::ATK_ROLE_AUTOCOMPLETE,
            Self::EditBar => ffi::ATK_ROLE_EDITBAR,
            Self::Embedded => ffi::ATK_ROLE_EMBEDDED,
            Self::Entry => ffi::ATK_ROLE_ENTRY,
            Self::Chart => ffi::ATK_ROLE_CHART,
            Self::Caption => ffi::ATK_ROLE_CAPTION,
            Self::DocumentFrame => ffi::ATK_ROLE_DOCUMENT_FRAME,
            Self::Heading => ffi::ATK_ROLE_HEADING,
            Self::Page => ffi::ATK_ROLE_PAGE,
            Self::Section => ffi::ATK_ROLE_SECTION,
            Self::RedundantObject => ffi::ATK_ROLE_REDUNDANT_OBJECT,
            Self::Form => ffi::ATK_ROLE_FORM,
            Self::Link => ffi::ATK_ROLE_LINK,
            Self::InputMethodWindow => ffi::ATK_ROLE_INPUT_METHOD_WINDOW,
            Self::TableRow => ffi::ATK_ROLE_TABLE_ROW,
            Self::TreeItem => ffi::ATK_ROLE_TREE_ITEM,
            Self::DocumentSpreadsheet => ffi::ATK_ROLE_DOCUMENT_SPREADSHEET,
            Self::DocumentPresentation => ffi::ATK_ROLE_DOCUMENT_PRESENTATION,
            Self::DocumentText => ffi::ATK_ROLE_DOCUMENT_TEXT,
            Self::DocumentWeb => ffi::ATK_ROLE_DOCUMENT_WEB,
            Self::DocumentEmail => ffi::ATK_ROLE_DOCUMENT_EMAIL,
            Self::Comment => ffi::ATK_ROLE_COMMENT,
            Self::ListBox => ffi::ATK_ROLE_LIST_BOX,
            Self::Grouping => ffi::ATK_ROLE_GROUPING,
            Self::ImageMap => ffi::ATK_ROLE_IMAGE_MAP,
            Self::Notification => ffi::ATK_ROLE_NOTIFICATION,
            Self::InfoBar => ffi::ATK_ROLE_INFO_BAR,
            Self::LevelBar => ffi::ATK_ROLE_LEVEL_BAR,
            Self::TitleBar => ffi::ATK_ROLE_TITLE_BAR,
            Self::BlockQuote => ffi::ATK_ROLE_BLOCK_QUOTE,
            Self::Audio => ffi::ATK_ROLE_AUDIO,
            Self::Video => ffi::ATK_ROLE_VIDEO,
            Self::Definition => ffi::ATK_ROLE_DEFINITION,
            Self::Article => ffi::ATK_ROLE_ARTICLE,
            Self::Landmark => ffi::ATK_ROLE_LANDMARK,
            Self::Log => ffi::ATK_ROLE_LOG,
            Self::Marquee => ffi::ATK_ROLE_MARQUEE,
            Self::Math => ffi::ATK_ROLE_MATH,
            Self::Rating => ffi::ATK_ROLE_RATING,
            Self::Timer => ffi::ATK_ROLE_TIMER,
            Self::DescriptionList => ffi::ATK_ROLE_DESCRIPTION_LIST,
            Self::DescriptionTerm => ffi::ATK_ROLE_DESCRIPTION_TERM,
            Self::DescriptionValue => ffi::ATK_ROLE_DESCRIPTION_VALUE,
            Self::Static => ffi::ATK_ROLE_STATIC,
            Self::MathFraction => ffi::ATK_ROLE_MATH_FRACTION,
            Self::MathRoot => ffi::ATK_ROLE_MATH_ROOT,
            Self::Subscript => ffi::ATK_ROLE_SUBSCRIPT,
            Self::Superscript => ffi::ATK_ROLE_SUPERSCRIPT,
            Self::Footnote => ffi::ATK_ROLE_FOOTNOTE,
            Self::ContentDeletion => ffi::ATK_ROLE_CONTENT_DELETION,
            Self::ContentInsertion => ffi::ATK_ROLE_CONTENT_INSERTION,
            Self::Mark => ffi::ATK_ROLE_MARK,
            Self::Suggestion => ffi::ATK_ROLE_SUGGESTION,
            Self::PushButtonMenu => ffi::ATK_ROLE_PUSH_BUTTON_MENU,
            Self::LastDefined => ffi::ATK_ROLE_LAST_DEFINED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AtkRole> for Role {
    unsafe fn from_glib(value: ffi::AtkRole) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_ROLE_INVALID => Self::Invalid,
            ffi::ATK_ROLE_ACCEL_LABEL => Self::AcceleratorLabel,
            ffi::ATK_ROLE_ALERT => Self::Alert,
            ffi::ATK_ROLE_ANIMATION => Self::Animation,
            ffi::ATK_ROLE_ARROW => Self::Arrow,
            ffi::ATK_ROLE_CALENDAR => Self::Calendar,
            ffi::ATK_ROLE_CANVAS => Self::Canvas,
            ffi::ATK_ROLE_CHECK_BOX => Self::CheckBox,
            ffi::ATK_ROLE_CHECK_MENU_ITEM => Self::CheckMenuItem,
            ffi::ATK_ROLE_COLOR_CHOOSER => Self::ColorChooser,
            ffi::ATK_ROLE_COLUMN_HEADER => Self::ColumnHeader,
            ffi::ATK_ROLE_COMBO_BOX => Self::ComboBox,
            ffi::ATK_ROLE_DATE_EDITOR => Self::DateEditor,
            ffi::ATK_ROLE_DESKTOP_ICON => Self::DesktopIcon,
            ffi::ATK_ROLE_DESKTOP_FRAME => Self::DesktopFrame,
            ffi::ATK_ROLE_DIAL => Self::Dial,
            ffi::ATK_ROLE_DIALOG => Self::Dialog,
            ffi::ATK_ROLE_DIRECTORY_PANE => Self::DirectoryPane,
            ffi::ATK_ROLE_DRAWING_AREA => Self::DrawingArea,
            ffi::ATK_ROLE_FILE_CHOOSER => Self::FileChooser,
            ffi::ATK_ROLE_FILLER => Self::Filler,
            ffi::ATK_ROLE_FONT_CHOOSER => Self::FontChooser,
            ffi::ATK_ROLE_FRAME => Self::Frame,
            ffi::ATK_ROLE_GLASS_PANE => Self::GlassPane,
            ffi::ATK_ROLE_HTML_CONTAINER => Self::HtmlContainer,
            ffi::ATK_ROLE_ICON => Self::Icon,
            ffi::ATK_ROLE_IMAGE => Self::Image,
            ffi::ATK_ROLE_INTERNAL_FRAME => Self::InternalFrame,
            ffi::ATK_ROLE_LABEL => Self::Label,
            ffi::ATK_ROLE_LAYERED_PANE => Self::LayeredPane,
            ffi::ATK_ROLE_LIST => Self::List,
            ffi::ATK_ROLE_LIST_ITEM => Self::ListItem,
            ffi::ATK_ROLE_MENU => Self::Menu,
            ffi::ATK_ROLE_MENU_BAR => Self::MenuBar,
            ffi::ATK_ROLE_MENU_ITEM => Self::MenuItem,
            ffi::ATK_ROLE_OPTION_PANE => Self::OptionPane,
            ffi::ATK_ROLE_PAGE_TAB => Self::PageTab,
            ffi::ATK_ROLE_PAGE_TAB_LIST => Self::PageTabList,
            ffi::ATK_ROLE_PANEL => Self::Panel,
            ffi::ATK_ROLE_PASSWORD_TEXT => Self::PasswordText,
            ffi::ATK_ROLE_POPUP_MENU => Self::PopupMenu,
            ffi::ATK_ROLE_PROGRESS_BAR => Self::ProgressBar,
            ffi::ATK_ROLE_PUSH_BUTTON => Self::PushButton,
            ffi::ATK_ROLE_RADIO_BUTTON => Self::RadioButton,
            ffi::ATK_ROLE_RADIO_MENU_ITEM => Self::RadioMenuItem,
            ffi::ATK_ROLE_ROOT_PANE => Self::RootPane,
            ffi::ATK_ROLE_ROW_HEADER => Self::RowHeader,
            ffi::ATK_ROLE_SCROLL_BAR => Self::ScrollBar,
            ffi::ATK_ROLE_SCROLL_PANE => Self::ScrollPane,
            ffi::ATK_ROLE_SEPARATOR => Self::Separator,
            ffi::ATK_ROLE_SLIDER => Self::Slider,
            ffi::ATK_ROLE_SPLIT_PANE => Self::SplitPane,
            ffi::ATK_ROLE_SPIN_BUTTON => Self::SpinButton,
            ffi::ATK_ROLE_STATUSBAR => Self::Statusbar,
            ffi::ATK_ROLE_TABLE => Self::Table,
            ffi::ATK_ROLE_TABLE_CELL => Self::TableCell,
            ffi::ATK_ROLE_TABLE_COLUMN_HEADER => Self::TableColumnHeader,
            ffi::ATK_ROLE_TABLE_ROW_HEADER => Self::TableRowHeader,
            ffi::ATK_ROLE_TEAR_OFF_MENU_ITEM => Self::TearOffMenuItem,
            ffi::ATK_ROLE_TERMINAL => Self::Terminal,
            ffi::ATK_ROLE_TEXT => Self::Text,
            ffi::ATK_ROLE_TOGGLE_BUTTON => Self::ToggleButton,
            ffi::ATK_ROLE_TOOL_BAR => Self::ToolBar,
            ffi::ATK_ROLE_TOOL_TIP => Self::ToolTip,
            ffi::ATK_ROLE_TREE => Self::Tree,
            ffi::ATK_ROLE_TREE_TABLE => Self::TreeTable,
            ffi::ATK_ROLE_UNKNOWN => Self::Unknown,
            ffi::ATK_ROLE_VIEWPORT => Self::Viewport,
            ffi::ATK_ROLE_WINDOW => Self::Window,
            ffi::ATK_ROLE_HEADER => Self::Header,
            ffi::ATK_ROLE_FOOTER => Self::Footer,
            ffi::ATK_ROLE_PARAGRAPH => Self::Paragraph,
            ffi::ATK_ROLE_RULER => Self::Ruler,
            ffi::ATK_ROLE_APPLICATION => Self::Application,
            ffi::ATK_ROLE_AUTOCOMPLETE => Self::Autocomplete,
            ffi::ATK_ROLE_EDITBAR => Self::EditBar,
            ffi::ATK_ROLE_EMBEDDED => Self::Embedded,
            ffi::ATK_ROLE_ENTRY => Self::Entry,
            ffi::ATK_ROLE_CHART => Self::Chart,
            ffi::ATK_ROLE_CAPTION => Self::Caption,
            ffi::ATK_ROLE_DOCUMENT_FRAME => Self::DocumentFrame,
            ffi::ATK_ROLE_HEADING => Self::Heading,
            ffi::ATK_ROLE_PAGE => Self::Page,
            ffi::ATK_ROLE_SECTION => Self::Section,
            ffi::ATK_ROLE_REDUNDANT_OBJECT => Self::RedundantObject,
            ffi::ATK_ROLE_FORM => Self::Form,
            ffi::ATK_ROLE_LINK => Self::Link,
            ffi::ATK_ROLE_INPUT_METHOD_WINDOW => Self::InputMethodWindow,
            ffi::ATK_ROLE_TABLE_ROW => Self::TableRow,
            ffi::ATK_ROLE_TREE_ITEM => Self::TreeItem,
            ffi::ATK_ROLE_DOCUMENT_SPREADSHEET => Self::DocumentSpreadsheet,
            ffi::ATK_ROLE_DOCUMENT_PRESENTATION => Self::DocumentPresentation,
            ffi::ATK_ROLE_DOCUMENT_TEXT => Self::DocumentText,
            ffi::ATK_ROLE_DOCUMENT_WEB => Self::DocumentWeb,
            ffi::ATK_ROLE_DOCUMENT_EMAIL => Self::DocumentEmail,
            ffi::ATK_ROLE_COMMENT => Self::Comment,
            ffi::ATK_ROLE_LIST_BOX => Self::ListBox,
            ffi::ATK_ROLE_GROUPING => Self::Grouping,
            ffi::ATK_ROLE_IMAGE_MAP => Self::ImageMap,
            ffi::ATK_ROLE_NOTIFICATION => Self::Notification,
            ffi::ATK_ROLE_INFO_BAR => Self::InfoBar,
            ffi::ATK_ROLE_LEVEL_BAR => Self::LevelBar,
            ffi::ATK_ROLE_TITLE_BAR => Self::TitleBar,
            ffi::ATK_ROLE_BLOCK_QUOTE => Self::BlockQuote,
            ffi::ATK_ROLE_AUDIO => Self::Audio,
            ffi::ATK_ROLE_VIDEO => Self::Video,
            ffi::ATK_ROLE_DEFINITION => Self::Definition,
            ffi::ATK_ROLE_ARTICLE => Self::Article,
            ffi::ATK_ROLE_LANDMARK => Self::Landmark,
            ffi::ATK_ROLE_LOG => Self::Log,
            ffi::ATK_ROLE_MARQUEE => Self::Marquee,
            ffi::ATK_ROLE_MATH => Self::Math,
            ffi::ATK_ROLE_RATING => Self::Rating,
            ffi::ATK_ROLE_TIMER => Self::Timer,
            ffi::ATK_ROLE_DESCRIPTION_LIST => Self::DescriptionList,
            ffi::ATK_ROLE_DESCRIPTION_TERM => Self::DescriptionTerm,
            ffi::ATK_ROLE_DESCRIPTION_VALUE => Self::DescriptionValue,
            ffi::ATK_ROLE_STATIC => Self::Static,
            ffi::ATK_ROLE_MATH_FRACTION => Self::MathFraction,
            ffi::ATK_ROLE_MATH_ROOT => Self::MathRoot,
            ffi::ATK_ROLE_SUBSCRIPT => Self::Subscript,
            ffi::ATK_ROLE_SUPERSCRIPT => Self::Superscript,
            ffi::ATK_ROLE_FOOTNOTE => Self::Footnote,
            ffi::ATK_ROLE_CONTENT_DELETION => Self::ContentDeletion,
            ffi::ATK_ROLE_CONTENT_INSERTION => Self::ContentInsertion,
            ffi::ATK_ROLE_MARK => Self::Mark,
            ffi::ATK_ROLE_SUGGESTION => Self::Suggestion,
            ffi::ATK_ROLE_PUSH_BUTTON_MENU => Self::PushButtonMenu,
            ffi::ATK_ROLE_LAST_DEFINED => Self::LastDefined,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Role {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_role_get_type()) }
    }
}

impl glib::HasParamSpec for Role {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

impl glib::value::ValueType for Role {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for Role {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Role {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<Role> for glib::Value {
    #[inline]
    fn from(v: Role) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v2_30")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkScrollType")]
pub enum ScrollType {
    #[doc(alias = "ATK_SCROLL_TOP_LEFT")]
    TopLeft,
    #[doc(alias = "ATK_SCROLL_BOTTOM_RIGHT")]
    BottomRight,
    #[doc(alias = "ATK_SCROLL_TOP_EDGE")]
    TopEdge,
    #[doc(alias = "ATK_SCROLL_BOTTOM_EDGE")]
    BottomEdge,
    #[doc(alias = "ATK_SCROLL_LEFT_EDGE")]
    LeftEdge,
    #[doc(alias = "ATK_SCROLL_RIGHT_EDGE")]
    RightEdge,
    #[doc(alias = "ATK_SCROLL_ANYWHERE")]
    Anywhere,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v2_30")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
impl fmt::Display for ScrollType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ScrollType::{}",
            match *self {
                Self::TopLeft => "TopLeft",
                Self::BottomRight => "BottomRight",
                Self::TopEdge => "TopEdge",
                Self::BottomEdge => "BottomEdge",
                Self::LeftEdge => "LeftEdge",
                Self::RightEdge => "RightEdge",
                Self::Anywhere => "Anywhere",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(feature = "v2_30")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
#[doc(hidden)]
impl IntoGlib for ScrollType {
    type GlibType = ffi::AtkScrollType;

    #[inline]
    fn into_glib(self) -> ffi::AtkScrollType {
        match self {
            Self::TopLeft => ffi::ATK_SCROLL_TOP_LEFT,
            Self::BottomRight => ffi::ATK_SCROLL_BOTTOM_RIGHT,
            Self::TopEdge => ffi::ATK_SCROLL_TOP_EDGE,
            Self::BottomEdge => ffi::ATK_SCROLL_BOTTOM_EDGE,
            Self::LeftEdge => ffi::ATK_SCROLL_LEFT_EDGE,
            Self::RightEdge => ffi::ATK_SCROLL_RIGHT_EDGE,
            Self::Anywhere => ffi::ATK_SCROLL_ANYWHERE,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v2_30")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
#[doc(hidden)]
impl FromGlib<ffi::AtkScrollType> for ScrollType {
    #[inline]
    unsafe fn from_glib(value: ffi::AtkScrollType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_SCROLL_TOP_LEFT => Self::TopLeft,
            ffi::ATK_SCROLL_BOTTOM_RIGHT => Self::BottomRight,
            ffi::ATK_SCROLL_TOP_EDGE => Self::TopEdge,
            ffi::ATK_SCROLL_BOTTOM_EDGE => Self::BottomEdge,
            ffi::ATK_SCROLL_LEFT_EDGE => Self::LeftEdge,
            ffi::ATK_SCROLL_RIGHT_EDGE => Self::RightEdge,
            ffi::ATK_SCROLL_ANYWHERE => Self::Anywhere,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v2_30")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
impl StaticType for ScrollType {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_scroll_type_get_type()) }
    }
}

#[cfg(feature = "v2_30")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
impl glib::HasParamSpec for ScrollType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

#[cfg(feature = "v2_30")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
impl glib::value::ValueType for ScrollType {
    type Type = Self;
}

#[cfg(feature = "v2_30")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
unsafe impl<'a> glib::value::FromValue<'a> for ScrollType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v2_30")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
impl ToValue for ScrollType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v2_30")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
impl From<ScrollType> for glib::Value {
    #[inline]
    fn from(v: ScrollType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkStateType")]
pub enum StateType {
    #[doc(alias = "ATK_STATE_INVALID")]
    Invalid,
    #[doc(alias = "ATK_STATE_ACTIVE")]
    Active,
    #[doc(alias = "ATK_STATE_ARMED")]
    Armed,
    #[doc(alias = "ATK_STATE_BUSY")]
    Busy,
    #[doc(alias = "ATK_STATE_CHECKED")]
    Checked,
    #[doc(alias = "ATK_STATE_DEFUNCT")]
    Defunct,
    #[doc(alias = "ATK_STATE_EDITABLE")]
    Editable,
    #[doc(alias = "ATK_STATE_ENABLED")]
    Enabled,
    #[doc(alias = "ATK_STATE_EXPANDABLE")]
    Expandable,
    #[doc(alias = "ATK_STATE_EXPANDED")]
    Expanded,
    #[doc(alias = "ATK_STATE_FOCUSABLE")]
    Focusable,
    #[doc(alias = "ATK_STATE_FOCUSED")]
    Focused,
    #[doc(alias = "ATK_STATE_HORIZONTAL")]
    Horizontal,
    #[doc(alias = "ATK_STATE_ICONIFIED")]
    Iconified,
    #[doc(alias = "ATK_STATE_MODAL")]
    Modal,
    #[doc(alias = "ATK_STATE_MULTI_LINE")]
    MultiLine,
    #[doc(alias = "ATK_STATE_MULTISELECTABLE")]
    Multiselectable,
    #[doc(alias = "ATK_STATE_OPAQUE")]
    Opaque,
    #[doc(alias = "ATK_STATE_PRESSED")]
    Pressed,
    #[doc(alias = "ATK_STATE_RESIZABLE")]
    Resizable,
    #[doc(alias = "ATK_STATE_SELECTABLE")]
    Selectable,
    #[doc(alias = "ATK_STATE_SELECTED")]
    Selected,
    #[doc(alias = "ATK_STATE_SENSITIVE")]
    Sensitive,
    #[doc(alias = "ATK_STATE_SHOWING")]
    Showing,
    #[doc(alias = "ATK_STATE_SINGLE_LINE")]
    SingleLine,
    #[doc(alias = "ATK_STATE_STALE")]
    Stale,
    #[doc(alias = "ATK_STATE_TRANSIENT")]
    Transient,
    #[doc(alias = "ATK_STATE_VERTICAL")]
    Vertical,
    #[doc(alias = "ATK_STATE_VISIBLE")]
    Visible,
    #[doc(alias = "ATK_STATE_MANAGES_DESCENDANTS")]
    ManagesDescendants,
    #[doc(alias = "ATK_STATE_INDETERMINATE")]
    Indeterminate,
    #[doc(alias = "ATK_STATE_TRUNCATED")]
    Truncated,
    #[doc(alias = "ATK_STATE_REQUIRED")]
    Required,
    #[doc(alias = "ATK_STATE_INVALID_ENTRY")]
    InvalidEntry,
    #[doc(alias = "ATK_STATE_SUPPORTS_AUTOCOMPLETION")]
    SupportsAutocompletion,
    #[doc(alias = "ATK_STATE_SELECTABLE_TEXT")]
    SelectableText,
    #[doc(alias = "ATK_STATE_DEFAULT")]
    Default,
    #[doc(alias = "ATK_STATE_ANIMATED")]
    Animated,
    #[doc(alias = "ATK_STATE_VISITED")]
    Visited,
    #[doc(alias = "ATK_STATE_CHECKABLE")]
    Checkable,
    #[doc(alias = "ATK_STATE_HAS_POPUP")]
    HasPopup,
    #[doc(alias = "ATK_STATE_HAS_TOOLTIP")]
    HasTooltip,
    #[doc(alias = "ATK_STATE_READ_ONLY")]
    ReadOnly,
    #[cfg(feature = "v2_38")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_38")))]
    #[doc(alias = "ATK_STATE_COLLAPSED")]
    Collapsed,
    #[doc(hidden)]
    __Unknown(i32),
}

impl StateType {
    #[doc(alias = "atk_state_type_for_name")]
    pub fn for_name(name: &str) -> StateType {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::atk_state_type_for_name(name.to_glib_none().0)) }
    }

    #[doc(alias = "atk_state_type_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::atk_state_type_get_name(self.into_glib())) }
    }
}

impl fmt::Display for StateType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StateType::{}",
            match *self {
                Self::Invalid => "Invalid",
                Self::Active => "Active",
                Self::Armed => "Armed",
                Self::Busy => "Busy",
                Self::Checked => "Checked",
                Self::Defunct => "Defunct",
                Self::Editable => "Editable",
                Self::Enabled => "Enabled",
                Self::Expandable => "Expandable",
                Self::Expanded => "Expanded",
                Self::Focusable => "Focusable",
                Self::Focused => "Focused",
                Self::Horizontal => "Horizontal",
                Self::Iconified => "Iconified",
                Self::Modal => "Modal",
                Self::MultiLine => "MultiLine",
                Self::Multiselectable => "Multiselectable",
                Self::Opaque => "Opaque",
                Self::Pressed => "Pressed",
                Self::Resizable => "Resizable",
                Self::Selectable => "Selectable",
                Self::Selected => "Selected",
                Self::Sensitive => "Sensitive",
                Self::Showing => "Showing",
                Self::SingleLine => "SingleLine",
                Self::Stale => "Stale",
                Self::Transient => "Transient",
                Self::Vertical => "Vertical",
                Self::Visible => "Visible",
                Self::ManagesDescendants => "ManagesDescendants",
                Self::Indeterminate => "Indeterminate",
                Self::Truncated => "Truncated",
                Self::Required => "Required",
                Self::InvalidEntry => "InvalidEntry",
                Self::SupportsAutocompletion => "SupportsAutocompletion",
                Self::SelectableText => "SelectableText",
                Self::Default => "Default",
                Self::Animated => "Animated",
                Self::Visited => "Visited",
                Self::Checkable => "Checkable",
                Self::HasPopup => "HasPopup",
                Self::HasTooltip => "HasTooltip",
                Self::ReadOnly => "ReadOnly",
                #[cfg(feature = "v2_38")]
                Self::Collapsed => "Collapsed",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StateType {
    type GlibType = ffi::AtkStateType;

    fn into_glib(self) -> ffi::AtkStateType {
        match self {
            Self::Invalid => ffi::ATK_STATE_INVALID,
            Self::Active => ffi::ATK_STATE_ACTIVE,
            Self::Armed => ffi::ATK_STATE_ARMED,
            Self::Busy => ffi::ATK_STATE_BUSY,
            Self::Checked => ffi::ATK_STATE_CHECKED,
            Self::Defunct => ffi::ATK_STATE_DEFUNCT,
            Self::Editable => ffi::ATK_STATE_EDITABLE,
            Self::Enabled => ffi::ATK_STATE_ENABLED,
            Self::Expandable => ffi::ATK_STATE_EXPANDABLE,
            Self::Expanded => ffi::ATK_STATE_EXPANDED,
            Self::Focusable => ffi::ATK_STATE_FOCUSABLE,
            Self::Focused => ffi::ATK_STATE_FOCUSED,
            Self::Horizontal => ffi::ATK_STATE_HORIZONTAL,
            Self::Iconified => ffi::ATK_STATE_ICONIFIED,
            Self::Modal => ffi::ATK_STATE_MODAL,
            Self::MultiLine => ffi::ATK_STATE_MULTI_LINE,
            Self::Multiselectable => ffi::ATK_STATE_MULTISELECTABLE,
            Self::Opaque => ffi::ATK_STATE_OPAQUE,
            Self::Pressed => ffi::ATK_STATE_PRESSED,
            Self::Resizable => ffi::ATK_STATE_RESIZABLE,
            Self::Selectable => ffi::ATK_STATE_SELECTABLE,
            Self::Selected => ffi::ATK_STATE_SELECTED,
            Self::Sensitive => ffi::ATK_STATE_SENSITIVE,
            Self::Showing => ffi::ATK_STATE_SHOWING,
            Self::SingleLine => ffi::ATK_STATE_SINGLE_LINE,
            Self::Stale => ffi::ATK_STATE_STALE,
            Self::Transient => ffi::ATK_STATE_TRANSIENT,
            Self::Vertical => ffi::ATK_STATE_VERTICAL,
            Self::Visible => ffi::ATK_STATE_VISIBLE,
            Self::ManagesDescendants => ffi::ATK_STATE_MANAGES_DESCENDANTS,
            Self::Indeterminate => ffi::ATK_STATE_INDETERMINATE,
            Self::Truncated => ffi::ATK_STATE_TRUNCATED,
            Self::Required => ffi::ATK_STATE_REQUIRED,
            Self::InvalidEntry => ffi::ATK_STATE_INVALID_ENTRY,
            Self::SupportsAutocompletion => ffi::ATK_STATE_SUPPORTS_AUTOCOMPLETION,
            Self::SelectableText => ffi::ATK_STATE_SELECTABLE_TEXT,
            Self::Default => ffi::ATK_STATE_DEFAULT,
            Self::Animated => ffi::ATK_STATE_ANIMATED,
            Self::Visited => ffi::ATK_STATE_VISITED,
            Self::Checkable => ffi::ATK_STATE_CHECKABLE,
            Self::HasPopup => ffi::ATK_STATE_HAS_POPUP,
            Self::HasTooltip => ffi::ATK_STATE_HAS_TOOLTIP,
            Self::ReadOnly => ffi::ATK_STATE_READ_ONLY,
            #[cfg(feature = "v2_38")]
            Self::Collapsed => ffi::ATK_STATE_COLLAPSED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AtkStateType> for StateType {
    unsafe fn from_glib(value: ffi::AtkStateType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_STATE_INVALID => Self::Invalid,
            ffi::ATK_STATE_ACTIVE => Self::Active,
            ffi::ATK_STATE_ARMED => Self::Armed,
            ffi::ATK_STATE_BUSY => Self::Busy,
            ffi::ATK_STATE_CHECKED => Self::Checked,
            ffi::ATK_STATE_DEFUNCT => Self::Defunct,
            ffi::ATK_STATE_EDITABLE => Self::Editable,
            ffi::ATK_STATE_ENABLED => Self::Enabled,
            ffi::ATK_STATE_EXPANDABLE => Self::Expandable,
            ffi::ATK_STATE_EXPANDED => Self::Expanded,
            ffi::ATK_STATE_FOCUSABLE => Self::Focusable,
            ffi::ATK_STATE_FOCUSED => Self::Focused,
            ffi::ATK_STATE_HORIZONTAL => Self::Horizontal,
            ffi::ATK_STATE_ICONIFIED => Self::Iconified,
            ffi::ATK_STATE_MODAL => Self::Modal,
            ffi::ATK_STATE_MULTI_LINE => Self::MultiLine,
            ffi::ATK_STATE_MULTISELECTABLE => Self::Multiselectable,
            ffi::ATK_STATE_OPAQUE => Self::Opaque,
            ffi::ATK_STATE_PRESSED => Self::Pressed,
            ffi::ATK_STATE_RESIZABLE => Self::Resizable,
            ffi::ATK_STATE_SELECTABLE => Self::Selectable,
            ffi::ATK_STATE_SELECTED => Self::Selected,
            ffi::ATK_STATE_SENSITIVE => Self::Sensitive,
            ffi::ATK_STATE_SHOWING => Self::Showing,
            ffi::ATK_STATE_SINGLE_LINE => Self::SingleLine,
            ffi::ATK_STATE_STALE => Self::Stale,
            ffi::ATK_STATE_TRANSIENT => Self::Transient,
            ffi::ATK_STATE_VERTICAL => Self::Vertical,
            ffi::ATK_STATE_VISIBLE => Self::Visible,
            ffi::ATK_STATE_MANAGES_DESCENDANTS => Self::ManagesDescendants,
            ffi::ATK_STATE_INDETERMINATE => Self::Indeterminate,
            ffi::ATK_STATE_TRUNCATED => Self::Truncated,
            ffi::ATK_STATE_REQUIRED => Self::Required,
            ffi::ATK_STATE_INVALID_ENTRY => Self::InvalidEntry,
            ffi::ATK_STATE_SUPPORTS_AUTOCOMPLETION => Self::SupportsAutocompletion,
            ffi::ATK_STATE_SELECTABLE_TEXT => Self::SelectableText,
            ffi::ATK_STATE_DEFAULT => Self::Default,
            ffi::ATK_STATE_ANIMATED => Self::Animated,
            ffi::ATK_STATE_VISITED => Self::Visited,
            ffi::ATK_STATE_CHECKABLE => Self::Checkable,
            ffi::ATK_STATE_HAS_POPUP => Self::HasPopup,
            ffi::ATK_STATE_HAS_TOOLTIP => Self::HasTooltip,
            ffi::ATK_STATE_READ_ONLY => Self::ReadOnly,
            #[cfg(feature = "v2_38")]
            ffi::ATK_STATE_COLLAPSED => Self::Collapsed,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StateType {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_state_type_get_type()) }
    }
}

impl glib::HasParamSpec for StateType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

impl glib::value::ValueType for StateType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for StateType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StateType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<StateType> for glib::Value {
    #[inline]
    fn from(v: StateType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkTextAttribute")]
pub enum TextAttribute {
    #[doc(alias = "ATK_TEXT_ATTR_INVALID")]
    Invalid,
    #[doc(alias = "ATK_TEXT_ATTR_LEFT_MARGIN")]
    LeftMargin,
    #[doc(alias = "ATK_TEXT_ATTR_RIGHT_MARGIN")]
    RightMargin,
    #[doc(alias = "ATK_TEXT_ATTR_INDENT")]
    Indent,
    #[doc(alias = "ATK_TEXT_ATTR_INVISIBLE")]
    Invisible,
    #[doc(alias = "ATK_TEXT_ATTR_EDITABLE")]
    Editable,
    #[doc(alias = "ATK_TEXT_ATTR_PIXELS_ABOVE_LINES")]
    PixelsAboveLines,
    #[doc(alias = "ATK_TEXT_ATTR_PIXELS_BELOW_LINES")]
    PixelsBelowLines,
    #[doc(alias = "ATK_TEXT_ATTR_PIXELS_INSIDE_WRAP")]
    PixelsInsideWrap,
    #[doc(alias = "ATK_TEXT_ATTR_BG_FULL_HEIGHT")]
    BgFullHeight,
    #[doc(alias = "ATK_TEXT_ATTR_RISE")]
    Rise,
    #[doc(alias = "ATK_TEXT_ATTR_UNDERLINE")]
    Underline,
    #[doc(alias = "ATK_TEXT_ATTR_STRIKETHROUGH")]
    Strikethrough,
    #[doc(alias = "ATK_TEXT_ATTR_SIZE")]
    Size,
    #[doc(alias = "ATK_TEXT_ATTR_SCALE")]
    Scale,
    #[doc(alias = "ATK_TEXT_ATTR_WEIGHT")]
    Weight,
    #[doc(alias = "ATK_TEXT_ATTR_LANGUAGE")]
    Language,
    #[doc(alias = "ATK_TEXT_ATTR_FAMILY_NAME")]
    FamilyName,
    #[doc(alias = "ATK_TEXT_ATTR_BG_COLOR")]
    BgColor,
    #[doc(alias = "ATK_TEXT_ATTR_FG_COLOR")]
    FgColor,
    #[doc(alias = "ATK_TEXT_ATTR_BG_STIPPLE")]
    BgStipple,
    #[doc(alias = "ATK_TEXT_ATTR_FG_STIPPLE")]
    FgStipple,
    #[doc(alias = "ATK_TEXT_ATTR_WRAP_MODE")]
    WrapMode,
    #[doc(alias = "ATK_TEXT_ATTR_DIRECTION")]
    Direction,
    #[doc(alias = "ATK_TEXT_ATTR_JUSTIFICATION")]
    Justification,
    #[doc(alias = "ATK_TEXT_ATTR_STRETCH")]
    Stretch,
    #[doc(alias = "ATK_TEXT_ATTR_VARIANT")]
    Variant,
    #[doc(alias = "ATK_TEXT_ATTR_STYLE")]
    Style,
    #[doc(alias = "ATK_TEXT_ATTR_TEXT_POSITION")]
    TextPosition,
    #[doc(alias = "ATK_TEXT_ATTR_LAST_DEFINED")]
    LastDefined,
    #[doc(hidden)]
    __Unknown(i32),
}

impl TextAttribute {
    #[doc(alias = "atk_text_attribute_for_name")]
    pub fn for_name(name: &str) -> TextAttribute {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::atk_text_attribute_for_name(name.to_glib_none().0)) }
    }

    #[doc(alias = "atk_text_attribute_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::atk_text_attribute_get_name(self.into_glib())) }
    }

    #[doc(alias = "atk_text_attribute_get_value")]
    #[doc(alias = "get_value")]
    pub fn value(self, index_: i32) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::atk_text_attribute_get_value(self.into_glib(), index_)) }
    }
}

impl fmt::Display for TextAttribute {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextAttribute::{}",
            match *self {
                Self::Invalid => "Invalid",
                Self::LeftMargin => "LeftMargin",
                Self::RightMargin => "RightMargin",
                Self::Indent => "Indent",
                Self::Invisible => "Invisible",
                Self::Editable => "Editable",
                Self::PixelsAboveLines => "PixelsAboveLines",
                Self::PixelsBelowLines => "PixelsBelowLines",
                Self::PixelsInsideWrap => "PixelsInsideWrap",
                Self::BgFullHeight => "BgFullHeight",
                Self::Rise => "Rise",
                Self::Underline => "Underline",
                Self::Strikethrough => "Strikethrough",
                Self::Size => "Size",
                Self::Scale => "Scale",
                Self::Weight => "Weight",
                Self::Language => "Language",
                Self::FamilyName => "FamilyName",
                Self::BgColor => "BgColor",
                Self::FgColor => "FgColor",
                Self::BgStipple => "BgStipple",
                Self::FgStipple => "FgStipple",
                Self::WrapMode => "WrapMode",
                Self::Direction => "Direction",
                Self::Justification => "Justification",
                Self::Stretch => "Stretch",
                Self::Variant => "Variant",
                Self::Style => "Style",
                Self::TextPosition => "TextPosition",
                Self::LastDefined => "LastDefined",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TextAttribute {
    type GlibType = ffi::AtkTextAttribute;

    fn into_glib(self) -> ffi::AtkTextAttribute {
        match self {
            Self::Invalid => ffi::ATK_TEXT_ATTR_INVALID,
            Self::LeftMargin => ffi::ATK_TEXT_ATTR_LEFT_MARGIN,
            Self::RightMargin => ffi::ATK_TEXT_ATTR_RIGHT_MARGIN,
            Self::Indent => ffi::ATK_TEXT_ATTR_INDENT,
            Self::Invisible => ffi::ATK_TEXT_ATTR_INVISIBLE,
            Self::Editable => ffi::ATK_TEXT_ATTR_EDITABLE,
            Self::PixelsAboveLines => ffi::ATK_TEXT_ATTR_PIXELS_ABOVE_LINES,
            Self::PixelsBelowLines => ffi::ATK_TEXT_ATTR_PIXELS_BELOW_LINES,
            Self::PixelsInsideWrap => ffi::ATK_TEXT_ATTR_PIXELS_INSIDE_WRAP,
            Self::BgFullHeight => ffi::ATK_TEXT_ATTR_BG_FULL_HEIGHT,
            Self::Rise => ffi::ATK_TEXT_ATTR_RISE,
            Self::Underline => ffi::ATK_TEXT_ATTR_UNDERLINE,
            Self::Strikethrough => ffi::ATK_TEXT_ATTR_STRIKETHROUGH,
            Self::Size => ffi::ATK_TEXT_ATTR_SIZE,
            Self::Scale => ffi::ATK_TEXT_ATTR_SCALE,
            Self::Weight => ffi::ATK_TEXT_ATTR_WEIGHT,
            Self::Language => ffi::ATK_TEXT_ATTR_LANGUAGE,
            Self::FamilyName => ffi::ATK_TEXT_ATTR_FAMILY_NAME,
            Self::BgColor => ffi::ATK_TEXT_ATTR_BG_COLOR,
            Self::FgColor => ffi::ATK_TEXT_ATTR_FG_COLOR,
            Self::BgStipple => ffi::ATK_TEXT_ATTR_BG_STIPPLE,
            Self::FgStipple => ffi::ATK_TEXT_ATTR_FG_STIPPLE,
            Self::WrapMode => ffi::ATK_TEXT_ATTR_WRAP_MODE,
            Self::Direction => ffi::ATK_TEXT_ATTR_DIRECTION,
            Self::Justification => ffi::ATK_TEXT_ATTR_JUSTIFICATION,
            Self::Stretch => ffi::ATK_TEXT_ATTR_STRETCH,
            Self::Variant => ffi::ATK_TEXT_ATTR_VARIANT,
            Self::Style => ffi::ATK_TEXT_ATTR_STYLE,
            Self::TextPosition => ffi::ATK_TEXT_ATTR_TEXT_POSITION,
            Self::LastDefined => ffi::ATK_TEXT_ATTR_LAST_DEFINED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AtkTextAttribute> for TextAttribute {
    unsafe fn from_glib(value: ffi::AtkTextAttribute) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_TEXT_ATTR_INVALID => Self::Invalid,
            ffi::ATK_TEXT_ATTR_LEFT_MARGIN => Self::LeftMargin,
            ffi::ATK_TEXT_ATTR_RIGHT_MARGIN => Self::RightMargin,
            ffi::ATK_TEXT_ATTR_INDENT => Self::Indent,
            ffi::ATK_TEXT_ATTR_INVISIBLE => Self::Invisible,
            ffi::ATK_TEXT_ATTR_EDITABLE => Self::Editable,
            ffi::ATK_TEXT_ATTR_PIXELS_ABOVE_LINES => Self::PixelsAboveLines,
            ffi::ATK_TEXT_ATTR_PIXELS_BELOW_LINES => Self::PixelsBelowLines,
            ffi::ATK_TEXT_ATTR_PIXELS_INSIDE_WRAP => Self::PixelsInsideWrap,
            ffi::ATK_TEXT_ATTR_BG_FULL_HEIGHT => Self::BgFullHeight,
            ffi::ATK_TEXT_ATTR_RISE => Self::Rise,
            ffi::ATK_TEXT_ATTR_UNDERLINE => Self::Underline,
            ffi::ATK_TEXT_ATTR_STRIKETHROUGH => Self::Strikethrough,
            ffi::ATK_TEXT_ATTR_SIZE => Self::Size,
            ffi::ATK_TEXT_ATTR_SCALE => Self::Scale,
            ffi::ATK_TEXT_ATTR_WEIGHT => Self::Weight,
            ffi::ATK_TEXT_ATTR_LANGUAGE => Self::Language,
            ffi::ATK_TEXT_ATTR_FAMILY_NAME => Self::FamilyName,
            ffi::ATK_TEXT_ATTR_BG_COLOR => Self::BgColor,
            ffi::ATK_TEXT_ATTR_FG_COLOR => Self::FgColor,
            ffi::ATK_TEXT_ATTR_BG_STIPPLE => Self::BgStipple,
            ffi::ATK_TEXT_ATTR_FG_STIPPLE => Self::FgStipple,
            ffi::ATK_TEXT_ATTR_WRAP_MODE => Self::WrapMode,
            ffi::ATK_TEXT_ATTR_DIRECTION => Self::Direction,
            ffi::ATK_TEXT_ATTR_JUSTIFICATION => Self::Justification,
            ffi::ATK_TEXT_ATTR_STRETCH => Self::Stretch,
            ffi::ATK_TEXT_ATTR_VARIANT => Self::Variant,
            ffi::ATK_TEXT_ATTR_STYLE => Self::Style,
            ffi::ATK_TEXT_ATTR_TEXT_POSITION => Self::TextPosition,
            ffi::ATK_TEXT_ATTR_LAST_DEFINED => Self::LastDefined,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TextAttribute {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_text_attribute_get_type()) }
    }
}

impl glib::HasParamSpec for TextAttribute {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

impl glib::value::ValueType for TextAttribute {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TextAttribute {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TextAttribute {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TextAttribute> for glib::Value {
    #[inline]
    fn from(v: TextAttribute) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkTextBoundary")]
pub enum TextBoundary {
    #[doc(alias = "ATK_TEXT_BOUNDARY_CHAR")]
    Char,
    #[doc(alias = "ATK_TEXT_BOUNDARY_WORD_START")]
    WordStart,
    #[doc(alias = "ATK_TEXT_BOUNDARY_WORD_END")]
    WordEnd,
    #[doc(alias = "ATK_TEXT_BOUNDARY_SENTENCE_START")]
    SentenceStart,
    #[doc(alias = "ATK_TEXT_BOUNDARY_SENTENCE_END")]
    SentenceEnd,
    #[doc(alias = "ATK_TEXT_BOUNDARY_LINE_START")]
    LineStart,
    #[doc(alias = "ATK_TEXT_BOUNDARY_LINE_END")]
    LineEnd,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextBoundary {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextBoundary::{}",
            match *self {
                Self::Char => "Char",
                Self::WordStart => "WordStart",
                Self::WordEnd => "WordEnd",
                Self::SentenceStart => "SentenceStart",
                Self::SentenceEnd => "SentenceEnd",
                Self::LineStart => "LineStart",
                Self::LineEnd => "LineEnd",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TextBoundary {
    type GlibType = ffi::AtkTextBoundary;

    #[inline]
    fn into_glib(self) -> ffi::AtkTextBoundary {
        match self {
            Self::Char => ffi::ATK_TEXT_BOUNDARY_CHAR,
            Self::WordStart => ffi::ATK_TEXT_BOUNDARY_WORD_START,
            Self::WordEnd => ffi::ATK_TEXT_BOUNDARY_WORD_END,
            Self::SentenceStart => ffi::ATK_TEXT_BOUNDARY_SENTENCE_START,
            Self::SentenceEnd => ffi::ATK_TEXT_BOUNDARY_SENTENCE_END,
            Self::LineStart => ffi::ATK_TEXT_BOUNDARY_LINE_START,
            Self::LineEnd => ffi::ATK_TEXT_BOUNDARY_LINE_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AtkTextBoundary> for TextBoundary {
    #[inline]
    unsafe fn from_glib(value: ffi::AtkTextBoundary) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_TEXT_BOUNDARY_CHAR => Self::Char,
            ffi::ATK_TEXT_BOUNDARY_WORD_START => Self::WordStart,
            ffi::ATK_TEXT_BOUNDARY_WORD_END => Self::WordEnd,
            ffi::ATK_TEXT_BOUNDARY_SENTENCE_START => Self::SentenceStart,
            ffi::ATK_TEXT_BOUNDARY_SENTENCE_END => Self::SentenceEnd,
            ffi::ATK_TEXT_BOUNDARY_LINE_START => Self::LineStart,
            ffi::ATK_TEXT_BOUNDARY_LINE_END => Self::LineEnd,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TextBoundary {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_text_boundary_get_type()) }
    }
}

impl glib::HasParamSpec for TextBoundary {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

impl glib::value::ValueType for TextBoundary {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TextBoundary {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TextBoundary {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TextBoundary> for glib::Value {
    #[inline]
    fn from(v: TextBoundary) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkTextClipType")]
pub enum TextClipType {
    #[doc(alias = "ATK_TEXT_CLIP_NONE")]
    None,
    #[doc(alias = "ATK_TEXT_CLIP_MIN")]
    Min,
    #[doc(alias = "ATK_TEXT_CLIP_MAX")]
    Max,
    #[doc(alias = "ATK_TEXT_CLIP_BOTH")]
    Both,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextClipType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextClipType::{}",
            match *self {
                Self::None => "None",
                Self::Min => "Min",
                Self::Max => "Max",
                Self::Both => "Both",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TextClipType {
    type GlibType = ffi::AtkTextClipType;

    #[inline]
    fn into_glib(self) -> ffi::AtkTextClipType {
        match self {
            Self::None => ffi::ATK_TEXT_CLIP_NONE,
            Self::Min => ffi::ATK_TEXT_CLIP_MIN,
            Self::Max => ffi::ATK_TEXT_CLIP_MAX,
            Self::Both => ffi::ATK_TEXT_CLIP_BOTH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AtkTextClipType> for TextClipType {
    #[inline]
    unsafe fn from_glib(value: ffi::AtkTextClipType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_TEXT_CLIP_NONE => Self::None,
            ffi::ATK_TEXT_CLIP_MIN => Self::Min,
            ffi::ATK_TEXT_CLIP_MAX => Self::Max,
            ffi::ATK_TEXT_CLIP_BOTH => Self::Both,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TextClipType {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_text_clip_type_get_type()) }
    }
}

impl glib::HasParamSpec for TextClipType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

impl glib::value::ValueType for TextClipType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TextClipType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TextClipType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TextClipType> for glib::Value {
    #[inline]
    fn from(v: TextClipType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkTextGranularity")]
pub enum TextGranularity {
    #[doc(alias = "ATK_TEXT_GRANULARITY_CHAR")]
    Char,
    #[doc(alias = "ATK_TEXT_GRANULARITY_WORD")]
    Word,
    #[doc(alias = "ATK_TEXT_GRANULARITY_SENTENCE")]
    Sentence,
    #[doc(alias = "ATK_TEXT_GRANULARITY_LINE")]
    Line,
    #[doc(alias = "ATK_TEXT_GRANULARITY_PARAGRAPH")]
    Paragraph,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextGranularity {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextGranularity::{}",
            match *self {
                Self::Char => "Char",
                Self::Word => "Word",
                Self::Sentence => "Sentence",
                Self::Line => "Line",
                Self::Paragraph => "Paragraph",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TextGranularity {
    type GlibType = ffi::AtkTextGranularity;

    #[inline]
    fn into_glib(self) -> ffi::AtkTextGranularity {
        match self {
            Self::Char => ffi::ATK_TEXT_GRANULARITY_CHAR,
            Self::Word => ffi::ATK_TEXT_GRANULARITY_WORD,
            Self::Sentence => ffi::ATK_TEXT_GRANULARITY_SENTENCE,
            Self::Line => ffi::ATK_TEXT_GRANULARITY_LINE,
            Self::Paragraph => ffi::ATK_TEXT_GRANULARITY_PARAGRAPH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AtkTextGranularity> for TextGranularity {
    #[inline]
    unsafe fn from_glib(value: ffi::AtkTextGranularity) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_TEXT_GRANULARITY_CHAR => Self::Char,
            ffi::ATK_TEXT_GRANULARITY_WORD => Self::Word,
            ffi::ATK_TEXT_GRANULARITY_SENTENCE => Self::Sentence,
            ffi::ATK_TEXT_GRANULARITY_LINE => Self::Line,
            ffi::ATK_TEXT_GRANULARITY_PARAGRAPH => Self::Paragraph,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TextGranularity {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_text_granularity_get_type()) }
    }
}

impl glib::HasParamSpec for TextGranularity {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

impl glib::value::ValueType for TextGranularity {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TextGranularity {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TextGranularity {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TextGranularity> for glib::Value {
    #[inline]
    fn from(v: TextGranularity) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AtkValueType")]
pub enum ValueType {
    #[doc(alias = "ATK_VALUE_VERY_WEAK")]
    VeryWeak,
    #[doc(alias = "ATK_VALUE_WEAK")]
    Weak,
    #[doc(alias = "ATK_VALUE_ACCEPTABLE")]
    Acceptable,
    #[doc(alias = "ATK_VALUE_STRONG")]
    Strong,
    #[doc(alias = "ATK_VALUE_VERY_STRONG")]
    VeryStrong,
    #[doc(alias = "ATK_VALUE_VERY_LOW")]
    VeryLow,
    #[doc(alias = "ATK_VALUE_LOW")]
    Low,
    #[doc(alias = "ATK_VALUE_MEDIUM")]
    Medium,
    #[doc(alias = "ATK_VALUE_HIGH")]
    High,
    #[doc(alias = "ATK_VALUE_VERY_HIGH")]
    VeryHigh,
    #[doc(alias = "ATK_VALUE_VERY_BAD")]
    VeryBad,
    #[doc(alias = "ATK_VALUE_BAD")]
    Bad,
    #[doc(alias = "ATK_VALUE_GOOD")]
    Good,
    #[doc(alias = "ATK_VALUE_VERY_GOOD")]
    VeryGood,
    #[doc(alias = "ATK_VALUE_BEST")]
    Best,
    #[doc(alias = "ATK_VALUE_LAST_DEFINED")]
    LastDefined,
    #[doc(hidden)]
    __Unknown(i32),
}

impl ValueType {
    #[doc(alias = "atk_value_type_get_localized_name")]
    #[doc(alias = "get_localized_name")]
    pub fn localized_name(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::atk_value_type_get_localized_name(self.into_glib())) }
    }

    #[doc(alias = "atk_value_type_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::atk_value_type_get_name(self.into_glib())) }
    }
}

impl fmt::Display for ValueType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ValueType::{}",
            match *self {
                Self::VeryWeak => "VeryWeak",
                Self::Weak => "Weak",
                Self::Acceptable => "Acceptable",
                Self::Strong => "Strong",
                Self::VeryStrong => "VeryStrong",
                Self::VeryLow => "VeryLow",
                Self::Low => "Low",
                Self::Medium => "Medium",
                Self::High => "High",
                Self::VeryHigh => "VeryHigh",
                Self::VeryBad => "VeryBad",
                Self::Bad => "Bad",
                Self::Good => "Good",
                Self::VeryGood => "VeryGood",
                Self::Best => "Best",
                Self::LastDefined => "LastDefined",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ValueType {
    type GlibType = ffi::AtkValueType;

    fn into_glib(self) -> ffi::AtkValueType {
        match self {
            Self::VeryWeak => ffi::ATK_VALUE_VERY_WEAK,
            Self::Weak => ffi::ATK_VALUE_WEAK,
            Self::Acceptable => ffi::ATK_VALUE_ACCEPTABLE,
            Self::Strong => ffi::ATK_VALUE_STRONG,
            Self::VeryStrong => ffi::ATK_VALUE_VERY_STRONG,
            Self::VeryLow => ffi::ATK_VALUE_VERY_LOW,
            Self::Low => ffi::ATK_VALUE_LOW,
            Self::Medium => ffi::ATK_VALUE_MEDIUM,
            Self::High => ffi::ATK_VALUE_HIGH,
            Self::VeryHigh => ffi::ATK_VALUE_VERY_HIGH,
            Self::VeryBad => ffi::ATK_VALUE_VERY_BAD,
            Self::Bad => ffi::ATK_VALUE_BAD,
            Self::Good => ffi::ATK_VALUE_GOOD,
            Self::VeryGood => ffi::ATK_VALUE_VERY_GOOD,
            Self::Best => ffi::ATK_VALUE_BEST,
            Self::LastDefined => ffi::ATK_VALUE_LAST_DEFINED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AtkValueType> for ValueType {
    unsafe fn from_glib(value: ffi::AtkValueType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ATK_VALUE_VERY_WEAK => Self::VeryWeak,
            ffi::ATK_VALUE_WEAK => Self::Weak,
            ffi::ATK_VALUE_ACCEPTABLE => Self::Acceptable,
            ffi::ATK_VALUE_STRONG => Self::Strong,
            ffi::ATK_VALUE_VERY_STRONG => Self::VeryStrong,
            ffi::ATK_VALUE_VERY_LOW => Self::VeryLow,
            ffi::ATK_VALUE_LOW => Self::Low,
            ffi::ATK_VALUE_MEDIUM => Self::Medium,
            ffi::ATK_VALUE_HIGH => Self::High,
            ffi::ATK_VALUE_VERY_HIGH => Self::VeryHigh,
            ffi::ATK_VALUE_VERY_BAD => Self::VeryBad,
            ffi::ATK_VALUE_BAD => Self::Bad,
            ffi::ATK_VALUE_GOOD => Self::Good,
            ffi::ATK_VALUE_VERY_GOOD => Self::VeryGood,
            ffi::ATK_VALUE_BEST => Self::Best,
            ffi::ATK_VALUE_LAST_DEFINED => Self::LastDefined,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ValueType {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::atk_value_type_get_type()) }
    }
}

impl glib::HasParamSpec for ValueType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
    }
}

impl glib::value::ValueType for ValueType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ValueType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ValueType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ValueType> for glib::Value {
    #[inline]
    fn from(v: ValueType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}
