% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showUtils.R
\name{selectSome}
\alias{selectSome}
\title{Select and return only some entries from a vector}
\usage{
selectSome(
  obj,
  maxToShow = 5,
  ellipsis = "...",
  ellipsisPos = c("middle", "end", "start"),
  quote = FALSE
)
}
\arguments{
\item{obj}{character() A vector to be abbreviated for display purposes}

\item{maxToShow}{numeric(1) The maximum number of values to show in the
output (default: 5)}

\item{ellipsis}{character(1) The symbol used to abbreviate values in the
vector (default: "...")}

\item{ellipsisPos}{character(1) The location for the ellipsis in the output,
by default in the \code{"middle"} but can be moved to either the \code{"end"} or
the \code{"start"}.}

\item{quote}{logical(1) Whether or not to add a single quote around the \code{obj}
input. This only works for character type inputs.}
}
\value{
An abbreviated output of \code{obj}
}
\description{
\code{selectSome} works well in \code{show} methods. It abbreviates a vector input
depending on the \code{maxToShow} argument.
}
\examples{

letters

selectSome(letters)

}
\author{
M. Morgan, H. Pagès
}
