% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadRegistry.R
\name{loadRegistry}
\alias{loadRegistry}
\title{Load a Registry from the File System}
\usage{
loadRegistry(
  file.dir,
  work.dir = NULL,
  conf.file = findConfFile(),
  make.default = TRUE,
  writeable = FALSE
)
}
\arguments{
\item{file.dir}{[\code{character(1)}]\cr
  Path where all files of the registry are saved.
  Default is directory \dQuote{registry} in the current working directory.
  The provided path will get normalized unless it is given relative to the home directory
  (i.e., starting with \dQuote{~}). Note that some templates do not handle relative paths well.

  If you pass \code{NA}, a temporary directory will be used.
  This way, you can create disposable registries for \code{\link{btlapply}} or examples.
  By default, the temporary directory \code{\link[base]{tempdir}()} will be used.
  If you want to use another directory, e.g. a directory which is shared between nodes,
  you can set it in your configuration file by setting the variable \code{temp.dir}.}

\item{work.dir}{[\code{character(1)}]\cr
  Working directory for R process for running jobs.
  Defaults to the working directory currently set during Registry construction (see \code{\link[base]{getwd}}).
  \code{loadRegistry} uses the stored \code{work.dir}, but you may also explicitly overwrite it,
  e.g., after switching to another system.

  The provided path will get normalized unless it is given relative to the home directory
  (i.e., starting with \dQuote{~}). Note that some templates do not handle relative paths well.}

\item{conf.file}{[\code{character(1)}]\cr
  Path to a configuration file which is sourced while the registry is created.
  In the configuration file you can define how \pkg{batchtools} interacts with the system via \code{\link{ClusterFunctions}}.
  Separating the configuration of the underlying host system from the R code allows to easily move computation to another site.

  The file lookup is implemented in the internal (but exported) function \code{findConfFile} which returns the first file found of the following candidates:
  \enumerate{
   \item{File \dQuote{batchtools.conf.R} in the path specified by the environment variable \dQuote{R_BATCHTOOLS_SEARCH_PATH}.}
   \item{File \dQuote{batchtools.conf.R} in the current working directory.}
   \item{File \dQuote{config.R} in the user configuration directory as reported by \code{rappdirs::user_config_dir("batchtools", expand = FALSE)} (depending on OS, e.g., on linux this usually resolves to \dQuote{~/.config/batchtools/config.R}).}
   \item{\dQuote{.batchtools.conf.R} in the home directory (\dQuote{~}).}
   \item{\dQuote{config.R} in the site config directory as reported by \code{rappdirs::site_config_dir("batchtools")} (depending on OS). This file can be used for admins to set sane defaults for a computation site.}
  }
  Set to \code{NA} if you want to suppress reading any configuration file.
  If a configuration file is found, it gets sourced inside the environment of the registry after the defaults for all variables are set.
  Therefore you can set and overwrite slots, e.g. \code{default.resources = list(walltime = 3600)} to set default resources or \dQuote{max.concurrent.jobs} to
  limit the number of jobs allowed to run simultaneously on the system.}

\item{make.default}{[\code{logical(1)}]\cr
If set to \code{TRUE}, the created registry is saved inside the package
namespace and acts as default registry. You might want to switch this
off if you work with multiple registries simultaneously.
Default is \code{TRUE}.}

\item{writeable}{[\code{logical(1)}]\cr
Loads the registry in read-write mode. Default is \code{FALSE}.}
}
\value{
[\code{\link{Registry}}].
}
\description{
Loads a registry from its \code{file.dir}.

Multiple R sessions accessing the same registry simultaneously can lead to database inconsistencies.
This is especially dangerous if the same \code{file.dir} is accessed from multiple machines, e.g. via a mount.

If you just need to check on the status or peek into some preliminary results while another process is still submitting or waiting
for pending results, you can load the registry in a read-only mode.
All operations that need to change the registry will raise an exception in this mode.
Files communicated back by the computational nodes are parsed to update the registry in memory while the registry on the file system remains unchanged.

A heuristic tries to detect if the registry has been altered in the background by an other process and in this case automatically restricts the current registry to read-only mode.
However, you should rely on this heuristic to work flawlessly.
Thus, set to \code{writeable} to \code{TRUE} if and only if you are absolutely sure that other state-changing processes are terminated.

If you need write access, load the registry with \code{writeable} set to \code{TRUE}.
}
\seealso{
Other Registry: 
\code{\link{clearRegistry}()},
\code{\link{getDefaultRegistry}()},
\code{\link{makeRegistry}()},
\code{\link{removeRegistry}()},
\code{\link{saveRegistry}()},
\code{\link{sweepRegistry}()},
\code{\link{syncRegistry}()}
}
\concept{Registry}
