% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_flextable.R
\name{merge_h}
\alias{merge_h}
\title{Merge flextable cells horizontally}
\usage{
merge_h(x, i = NULL, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' is not allowed by the function.}
}
\description{
Merge flextable cells horizontally when consecutive cells have
identical values. Text of formatted values are used to compare
values.
}
\examples{
dummy_df <- data.frame(
  col1 = letters,
  col2 = letters, stringsAsFactors = FALSE
)
ft_merge <- flextable(dummy_df)
ft_merge <- merge_h(x = ft_merge)
ft_merge
}
\seealso{
Other flextable merging function: 
\code{\link{merge_at}()},
\code{\link{merge_h_range}()},
\code{\link{merge_none}()},
\code{\link{merge_v}()}
}
\concept{flextable merging function}
