% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openssl.R
\docType{package}
\name{openssl}
\alias{openssl}
\alias{openssl-package}
\title{Toolkit for Encryption, Signatures and Certificates based on OpenSSL}
\description{
Bindings to OpenSSL libssl and libcrypto, plus custom SSH \link[=read_key]{pubkey}
parsers. Supports RSA, DSA and NIST curves P-256, P-384 and P-521. Cryptographic
\link[=signatures]{signatures} can either be created and verified
manually or via x509 \link[=certificates]{certificates}. The
\link[=aes_cbc]{AES block cipher} is used in CBC mode for symmetric
encryption; RSA for \link[=rsa_encrypt]{asymmetric (public key)}
encryption. High-level \link[=encrypt_envelope]{envelope} methods
combine RSA and AES for encrypting arbitrary sized data. Other utilities include
\link[=keygen]{key generators}, hash functions (\code{\link[=hash]{md5()}},
\code{\link[=hash]{sha1()}}, \code{\link[=hash]{sha256()}}, etc),
\code{\link[=base64_encode]{base64()}} encoder, a secure \link[=rand_bytes]{random number generator},
and \code{\link[=bignum]{bignum()}} math methods for manually performing crypto
calculations on large multibyte integers.
}
\author{
Jeroen Ooms, Oliver Keyes
}
