% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visGetUtils.R
\name{visGetScale}
\alias{visGetScale}
\title{Function to get current scale of network, with shiny only.}
\usage{
visGetScale(graph, input = paste0(graph$id, "_scale"))
}
\arguments{
\item{graph}{: a \code{\link{visNetworkProxy}}  object}

\item{input}{: name of shiny input created. Default to paste0(graph$id, "_scale")}
}
\description{
Function to get current scale of network, with shiny only. Returns the current scale of the network. 1.0 is comparible to full, 0 is zoomed out infinitely.
}
\examples{
\dontrun{

# have a look to : 
shiny::runApp(system.file("shiny", package = "visNetwork"))

}

}
\references{
See online documentation \url{https://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}
