/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -cif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define	BSIZE	8192

enum ScanContition {
	EStateNormal,
	EStateComment,
	EStateSkiptoeol,
	EStateString,
};


typedef struct Scanner
{
	FILE			    *fp;
	unsigned char	    *cur, *tok, *lim, *eof;
	unsigned char 	    buffer[BSIZE];
	unsigned char       yych;
	enum ScanContition  cond;
	int                 state;
} Scanner;

size_t fill(Scanner *s, size_t len)
{
	size_t got = ~0, cnt;

	if (!s->eof && s->lim - s->tok < len)
	{
		if (s->tok > s->buffer)
		{
			cnt = s->tok - s->buffer;
			memcpy(s->buffer, s->tok, s->lim - s->tok);
			s->tok -= cnt;
			s->cur -= cnt;
			s->lim -= cnt;
			cnt = &s->buffer[BSIZE] - s->lim;
		}
		else
		{
			cnt = BSIZE;
		}
		if ((got = fread(s->lim, 1, cnt, s->fp)) != cnt)
		{
			s->eof = &s->lim[got];
		}
		s->lim += got;
	}
	if (s->eof && s->cur + len > s->eof)
	{
		return ~0; /* not enough input data */
	}
	return got;
}

size_t init(Scanner *s)
{
	s->cur = s->tok = s->lim = s->buffer;
	s->eof = 0;
	s->cond = EStateNormal;
	s->state = -1;

	return fill(s, 0);
}

void fputl(const char *s, size_t len, FILE *stream)
{
	while(len-- > 0)
	{
		fputc(*s++, stream);
	}
}

void scan(Scanner *s)
{
	s->tok = s->cur;

	switch (s->state) {
		default: goto yy0;
		case 0: goto yyFillLabel0;
		case 1: goto yyFillLabel1;
		case 2: goto yyFillLabel2;
		case 3: goto yyFillLabel3;
	}

	for(;;)
	{
		s->tok = s->cur;


yy0:
		switch (s->cond) {
			case EStateNormal: goto yyc_Normal;
			case EStateComment: goto yyc_Comment;
			case EStateSkiptoeol: goto yyc_Skiptoeol;
			case EStateString: goto yyc_String;
		}
/* *********************************** */
yyc_Normal:
		s->state = 0;(0);
		if ((s->lim - s->cur) < 4) if (fill(s, 4) == ~0) break;
yyFillLabel0:
		s->yych = *s->cur;
		switch (s->yych) {
			case '"': goto yy4;
			case '\'': goto yy5;
			case '/': goto yy6;
			case '?': goto yy7;
			default: goto yy2;
		}
yy2:
		++s->cur;
yy3:
		s->state = -1;(-1);
		fputc(s->cur[-1], stdout);
		continue;
yy4:
		++s->cur;
		s->state = -1;(-1);
		s->cond = EStateString;(EStateString);
		fputc(s->cur[-1], stdout);
		continue;
yy5:
		s->yych = *(s->tok = ++s->cur);
		switch (s->yych) {
			case '"': goto yy8;
			case '\\': goto yy10;
			default: goto yy3;
		}
yy6:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '*': goto yy11;
			case '/': goto yy12;
			default: goto yy3;
		}
yy7:
		s->yych = *(s->tok = ++s->cur);
		switch (s->yych) {
			case '?': goto yy13;
			default: goto yy3;
		}
yy8:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '\'': goto yy14;
			default: goto yy9;
		}
yy9:
		s->cur = s->tok;
		goto yy3;
yy10:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '"': goto yy8;
			default: goto yy9;
		}
yy11:
		++s->cur;
		s->state = -1;(-1);
		s->cond = EStateComment;(EStateComment);
		continue;
yy12:
		++s->cur;
		s->state = -1;(-1);
		s->cond = EStateSkiptoeol;(EStateSkiptoeol);
		continue;
yy13:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '!': goto yy15;
			case '\'': goto yy16;
			case '(': goto yy17;
			case ')': goto yy18;
			case '-': goto yy19;
			case '/': goto yy20;
			case '<': goto yy21;
			case '=': goto yy22;
			case '>': goto yy23;
			default: goto yy9;
		}
yy14:
		++s->cur;
		s->state = -1;(-1);
		fputl("'\"'", 3, stdout);
		continue;
yy15:
		++s->cur;
		s->state = -1;(-1);
		fputc('|', stdout);
		continue;
yy16:
		++s->cur;
		s->state = -1;(-1);
		fputc('^', stdout);
		continue;
yy17:
		++s->cur;
		s->state = -1;(-1);
		fputc('[', stdout);
		continue;
yy18:
		++s->cur;
		s->state = -1;(-1);
		fputc(']', stdout);
		continue;
yy19:
		++s->cur;
		s->state = -1;(-1);
		fputc('~', stdout);
		continue;
yy20:
		++s->cur;
		s->state = -1;(-1);
		fputc('\\', stdout);
		continue;
yy21:
		++s->cur;
		s->state = -1;(-1);
		fputc('{', stdout);
		continue;
yy22:
		++s->cur;
		s->state = -1;(-1);
		fputc('#', stdout);
		continue;
yy23:
		++s->cur;
		s->state = -1;(-1);
		fputc('}', stdout);
		continue;
/* *********************************** */
yyc_Comment:
		s->state = 1;(1);
		if ((s->lim - s->cur) < 2) if (fill(s, 2) == ~0) break;
yyFillLabel1:
		s->yych = *s->cur;
		switch (s->yych) {
			case '*': goto yy27;
			default: goto yy25;
		}
yy25:
		++s->cur;
yy26:
		s->state = -1;(-1);
		continue;
yy27:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '/': goto yy28;
			default: goto yy26;
		}
yy28:
		++s->cur;
		s->state = -1;(-1);
		s->cond = EStateNormal;(EStateNormal);
		continue;
/* *********************************** */
yyc_Skiptoeol:
		s->state = 2;(2);
		if ((s->lim - s->cur) < 5) if (fill(s, 5) == ~0) break;
yyFillLabel2:
		s->yych = *s->cur;
		switch (s->yych) {
			case '\n': goto yy32;
			case '\r': goto yy33;
			case '?': goto yy34;
			case '\\': goto yy35;
			default: goto yy30;
		}
yy30:
		++s->cur;
yy31:
		s->state = -1;(-1);
		continue;
yy32:
		++s->cur;
		s->state = -1;(-1);
		s->cond = EStateNormal;(EStateNormal);
		fputc('\n', stdout);
		continue;
yy33:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '\n': goto yy36;
			default: goto yy31;
		}
yy34:
		s->yych = *(s->tok = ++s->cur);
		switch (s->yych) {
			case '?': goto yy37;
			default: goto yy31;
		}
yy35:
		s->yych = *(s->tok = ++s->cur);
		switch (s->yych) {
			case '\n': goto yy39;
			case '\r': goto yy40;
			default: goto yy31;
		}
yy36:
		++s->cur;
		s->state = -1;(-1);
		s->cond = EStateNormal;(EStateNormal);
		fputc('\r', stdout);
		fputc('\n', stdout);
		continue;
yy37:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '/': goto yy41;
			default: goto yy38;
		}
yy38:
		s->cur = s->tok;
		goto yy31;
yy39:
		++s->cur;
		s->state = -1;(-1);
		continue;
yy40:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '\n': goto yy39;
			default: goto yy38;
		}
yy41:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '\n': goto yy42;
			case '\r': goto yy43;
			default: goto yy38;
		}
yy42:
		++s->cur;
		s->state = -1;(-1);
		continue;
yy43:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '\n': goto yy42;
			default: goto yy38;
		}
/* *********************************** */
yyc_String:
		s->state = 3;(3);
		if ((s->lim - s->cur) < 2) if (fill(s, 2) == ~0) break;
yyFillLabel3:
		s->yych = *s->cur;
		switch (s->yych) {
			case '"': goto yy47;
			case '\\': goto yy48;
			default: goto yy45;
		}
yy45:
		++s->cur;
yy46:
		s->state = -1;(-1);
		fputc(s->cur[-1], stdout);
		continue;
yy47:
		++s->cur;
		s->state = -1;(-1);
		s->cond = EStateNormal;(EStateNormal);
		fputc(s->cur[-1], stdout);
		continue;
yy48:
		s->yych = *++s->cur;
		switch (s->yych) {
			case '\n': goto yy46;
			default: goto yy49;
		}
yy49:
		++s->cur;
		s->state = -1;(-1);
		fputl((const char*)s->cur-2, 2, stdout);
		continue;

	}
}

int main(int argc, char **argv)
{
	Scanner in;

	if (argc != 2)
	{
		fprintf(stderr, "%s <file>\n", argv[0]);
		return 1;;
	}

	memset((char*) &in, 0, sizeof(in));

	if (!strcmp(argv[1], "-"))
	{
		in.fp = stdin;
	}
	else if ((in.fp = fopen(argv[1], "r")) == NULL)
	{
		fprintf(stderr, "Cannot open file '%s'\n", argv[1]);
		return 1;
	}

	if (init(&in) > 0)
	{
 		scan(&in);
 	}

	if (in.fp != stdin)
	{
		fclose(in.fp);
	}
	return 0;
}
