/* automatically generated by rust-bindgen 0.68.1 */

#[doc = " Information about a display device.\n\n This includes at least one EDID or DisplayID blob.\n\n Use di_info_parse_edid() to create a struct di_info from an EDID blob.\n DisplayID blobs are not yet supported."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_info {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Parse an EDID blob.\n\n Callers do not need to keep the provided data pointer valid after calling\n this function. Callers should destroy the returned pointer via\n di_info_destroy()."]
    pub fn di_info_parse_edid(data: *const ::std::os::raw::c_void, size: usize) -> *mut di_info;
}
extern "C" {
    #[doc = " Destroy a display device information structure."]
    pub fn di_info_destroy(info: *mut di_info);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Returns the EDID the display device information was constructed with.\n\n The returned struct di_edid can be used to query low-level EDID information,\n see <libdisplay-info/edid.h>. Users should prefer the high-level API if\n possible.\n\n NULL is returned if the struct di_info doesn't contain an EDID. The returned\n struct di_edid is valid until di_info_destroy()."]
    pub fn di_info_get_edid(info: *const di_info) -> *const di_edid;
}
extern "C" {
    #[doc = " Get the failure messages for this blob.\n\n NULL is returned if the blob conforms to the relevant specifications."]
    pub fn di_info_get_failure_msg(info: *const di_info) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the make of the display device.\n\n This is the manufacturer name, either company name or PNP ID.\n This string is informational and not meant to be used in programmatic\n decisions, configuration keys, etc.\n\n The string is in UTF-8 and may contain any characters except ASCII control\n codes.\n\n The caller is responsible for free'ing the returned string.\n NULL is returned if the information is not available."]
    pub fn di_info_get_make(info: *const di_info) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the model of the display device.\n\n This is the product name/model string or product number.\n This string is informational and not meant to be used in programmatic\n decisions, configuration keys, etc.\n\n The string is in UTF-8 and may contain any characters except ASCII control\n codes.\n\n The caller is responsible for free'ing the returned string.\n NULL is returned if the information is not available."]
    pub fn di_info_get_model(info: *const di_info) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the serial of the display device.\n\n This is the product serial string or the serial number.\n This string is informational and not meant to be used in programmatic\n decisions, configuration keys, etc.\n\n The string is in UTF-8 and may contain any characters except ASCII control\n codes.\n\n The caller is responsible for free'ing the returned string.\n NULL is returned if the information is not available."]
    pub fn di_info_get_serial(info: *const di_info) -> *mut ::std::os::raw::c_char;
}
#[doc = " Display HDR static metadata"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
#[cfg(feature = "v0_2")]
pub struct di_hdr_static_metadata {
    pub desired_content_max_luminance: f32,
    pub desired_content_max_frame_avg_luminance: f32,
    pub desired_content_min_luminance: f32,
    pub type1: bool,
    pub traditional_sdr: bool,
    pub traditional_hdr: bool,
    pub pq: bool,
    pub hlg: bool,
}
#[test]
#[cfg(feature = "v0_2")]
fn bindgen_test_layout_di_hdr_static_metadata() {
    const UNINIT: ::std::mem::MaybeUninit<di_hdr_static_metadata> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_hdr_static_metadata>(),
        20usize,
        concat!("Size of: ", stringify!(di_hdr_static_metadata))
    );
    assert_eq!(
        ::std::mem::align_of::<di_hdr_static_metadata>(),
        4usize,
        concat!("Alignment of ", stringify!(di_hdr_static_metadata))
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).desired_content_max_luminance) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_hdr_static_metadata),
            "::",
            stringify!(desired_content_max_luminance)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).desired_content_max_frame_avg_luminance) as usize
                - ptr as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_hdr_static_metadata),
            "::",
            stringify!(desired_content_max_frame_avg_luminance)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).desired_content_min_luminance) as usize - ptr as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_hdr_static_metadata),
            "::",
            stringify!(desired_content_min_luminance)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type1) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_hdr_static_metadata),
            "::",
            stringify!(type1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).traditional_sdr) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(di_hdr_static_metadata),
            "::",
            stringify!(traditional_sdr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).traditional_hdr) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(di_hdr_static_metadata),
            "::",
            stringify!(traditional_hdr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pq) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(di_hdr_static_metadata),
            "::",
            stringify!(pq)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hlg) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(di_hdr_static_metadata),
            "::",
            stringify!(hlg)
        )
    );
}
#[cfg(feature = "v0_2")]
extern "C" {
    #[doc = " Get HDR static metadata support information as defined in ANSI/CTA-861-H\n as HDR Static Metadata Data Block.\n\n The returned pointer is owned by the struct di_info passed in. It remains\n valid only as long as the di_info exists, and must not be freed by the\n caller.\n\n This function does not return NULL. When HDR static metadata does not exist,\n all luminance fields are zero and only traditional_sdr is flagged as\n supported."]
    pub fn di_info_get_hdr_static_metadata(info: *const di_info) -> *const di_hdr_static_metadata;
}
#[doc = " CIE 1931 2-degree observer chromaticity coordinates"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
#[cfg(feature = "v0_2")]
pub struct di_chromaticity_cie1931 {
    pub x: f32,
    pub y: f32,
}
#[test]
#[cfg(feature = "v0_2")]
fn bindgen_test_layout_di_chromaticity_cie1931() {
    const UNINIT: ::std::mem::MaybeUninit<di_chromaticity_cie1931> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_chromaticity_cie1931>(),
        8usize,
        concat!("Size of: ", stringify!(di_chromaticity_cie1931))
    );
    assert_eq!(
        ::std::mem::align_of::<di_chromaticity_cie1931>(),
        4usize,
        concat!("Alignment of ", stringify!(di_chromaticity_cie1931))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).x) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_chromaticity_cie1931),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).y) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_chromaticity_cie1931),
            "::",
            stringify!(y)
        )
    );
}
#[doc = " Display color primaries and default white point"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
#[cfg(feature = "v0_2")]
pub struct di_color_primaries {
    pub has_primaries: bool,
    pub has_default_white_point: bool,
    pub primary: [di_chromaticity_cie1931; 3usize],
    pub default_white: di_chromaticity_cie1931,
}
#[test]
#[cfg(feature = "v0_2")]
fn bindgen_test_layout_di_color_primaries() {
    const UNINIT: ::std::mem::MaybeUninit<di_color_primaries> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_color_primaries>(),
        36usize,
        concat!("Size of: ", stringify!(di_color_primaries))
    );
    assert_eq!(
        ::std::mem::align_of::<di_color_primaries>(),
        4usize,
        concat!("Alignment of ", stringify!(di_color_primaries))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_primaries) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_color_primaries),
            "::",
            stringify!(has_primaries)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_default_white_point) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(di_color_primaries),
            "::",
            stringify!(has_default_white_point)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).primary) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_color_primaries),
            "::",
            stringify!(primary)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).default_white) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(di_color_primaries),
            "::",
            stringify!(default_white)
        )
    );
}
#[cfg(feature = "v0_2")]
extern "C" {
    #[doc = " Get display color primaries and default white point\n\n Get the parameters of the default RGB colorimetry mode which is always\n supported. Primaries for monochrome displays might be all zeroes.\n\n These primaries might not be display's physical primaries, but only the\n primaries of the default RGB colorimetry signal when using IT Video Format\n (ANSI/CTA-861-H, Section 5).\n\n The returned pointer is owned by the struct di_info passed in. It remains\n valid only as long as the di_info exists, and must not be freed by the\n caller.\n\n This function does not return NULL."]
    pub fn di_info_get_default_color_primaries(info: *const di_info) -> *const di_color_primaries;
}
#[doc = " Additional signal colorimetry encodings supported by the display"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
#[cfg(feature = "v0_2")]
pub struct di_supported_signal_colorimetry {
    pub bt2020_cycc: bool,
    pub bt2020_ycc: bool,
    pub bt2020_rgb: bool,
    pub st2113_rgb: bool,
    pub ictcp: bool,
}
#[test]
#[cfg(feature = "v0_2")]
fn bindgen_test_layout_di_supported_signal_colorimetry() {
    const UNINIT: ::std::mem::MaybeUninit<di_supported_signal_colorimetry> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_supported_signal_colorimetry>(),
        5usize,
        concat!("Size of: ", stringify!(di_supported_signal_colorimetry))
    );
    assert_eq!(
        ::std::mem::align_of::<di_supported_signal_colorimetry>(),
        1usize,
        concat!("Alignment of ", stringify!(di_supported_signal_colorimetry))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bt2020_cycc) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_supported_signal_colorimetry),
            "::",
            stringify!(bt2020_cycc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bt2020_ycc) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(di_supported_signal_colorimetry),
            "::",
            stringify!(bt2020_ycc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bt2020_rgb) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(di_supported_signal_colorimetry),
            "::",
            stringify!(bt2020_rgb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).st2113_rgb) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(di_supported_signal_colorimetry),
            "::",
            stringify!(st2113_rgb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ictcp) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_supported_signal_colorimetry),
            "::",
            stringify!(ictcp)
        )
    );
}
#[cfg(feature = "v0_2")]
extern "C" {
    #[doc = " Get signal colorimetry encodings supported by the display\n\n These signal colorimetry encodings are supported in addition to the\n display's default RGB colorimetry. When you wish to use one of the additional\n encodings, they need to be explicitly enabled in the video signal. How to\n do that is specific to the signalling used, e.g. HDMI.\n\n Signal colorimetry encoding provides the color space that the signal is\n encoded for. This includes primary and white point chromaticities, and the\n YCbCr-RGB conversion if necessary. Also the transfer function is implied\n unless explicitly set otherwise, e.g. with HDR static metadata.\n See ANSI/CTA-861-H for details.\n\n The signal color volume can be considerably larger than the physically\n displayable color volume.\n\n The returned pointer is owned by the struct di_info passed in. It remains\n valid only as long as the di_info exists, and must not be freed by the\n caller.\n\n This function does not return NULL."]
    pub fn di_info_get_supported_signal_colorimetry(
        info: *const di_info,
    ) -> *const di_supported_signal_colorimetry;
}
#[cfg(feature = "v0_2")]
extern "C" {
    #[doc = " Get display default transfer characteristic exponent (gamma)\n\n This should be the display gamma value when the display has been reset to\n its factory defaults, and it is driven with the default RGB colorimetry.\n The value is zero when unknown."]
    pub fn di_info_get_default_gamma(info: *const di_info) -> f32;
}
