# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** system environment, resource control and configuration details

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/ao_images.rb;hb=HEAD]

=end
module SiSU_AO_Images
  class Images
    begin
      require 'rmagick'
      include Magick
    rescue LoadError
      #SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).mark('rmagic NOT FOUND')
    end
    def initialize(md,data)
      @md,@data=md,data
    end
    def images
      data=@data
      @rmgk=false
      imagemagick_=true      #imagemagick_=SiSU_Env::InfoSettings.new.program?('rmagick')
      if imagemagick_
        begin
          @rmgk=SiSU_Env::Load.new('rmagick').prog
        rescue
          @rmgk=false
        end
      else
        if (@md.opt.act[:verbose_plus][:set]==:on \
        || @md.opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(
            @md.opt.act[:color_state][:set],
            '*WARN* use of rmagick is not enabled in sisurc.yml'
          ).warn
        end
      end
      data.select do |dob|
        unless dob.is ==:table
          dob.obj=dob.obj.strip
          if dob.obj =~/#{Mx[:lnk_o]}\s*\S+\.(?:png|jpg|gif)(?:\s*|\s+.+)?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/
            if dob.obj !~/#{Mx[:lnk_o]}\s*\S+\.(?:png|jpg|gif)\s+\d+x\d+/
              m=/#{Mx[:lnk_o]}\s*(\S+\.(?:png|jpg|gif))/
              if imagemagick_
                imgs=dob.obj.scan(m).flatten
                img_col=img_row=nil
                images=imgs.each do |image|
                  dir=SiSU_Env::InfoEnv.new(@md.fns)
                  path_image=[
                    dir.path.image_source_include_local,
                    dir.path.image_source_include_remote,
                    dir.path.image_source_include
                  ]
                  image_path=nil
                  path_image.each do |img_pth|
                    image_path=img_pth
                    break if FileTest.exist?("#{img_pth}/#{image}")
                  end
                  if FileTest.exist?("#{image_path}/#{image}")
                    if @rmgk
                      img=Magick::ImageList.new("#{image_path}/#{image}")
                      img_col,img_row=img.columns,img.rows
                    else
                      if (@md.opt.act[:verbose_plus][:set]==:on \
                      || @md.opt.act[:maintenance][:set]==:on)
                        SiSU_Screen::Ansi.new(
                          @md.opt.act[:color_state][:set],
                          '*WARN* rmagick not present, will attempt to use imagemagick (identify) directly'
                        ).warn
                      end
                      imgk=SiSU_Env::SystemCall.new.imagemagick
                      gmgk=SiSU_Env::SystemCall.new.graphicsmagick
                      if imgk or gmgk
                        if imgk
                          imgsys=`identify #{image_path}/#{image}`.strip                           #system call
                        elsif gmgk
                          imgsys=`gm identify #{image_path}/#{image}`.strip                        #system call
                        end
                        img_col,img_row=/(\d+)x(\d+)/m.match(imgsys)[1,2]
                        img_col,img_row=img_col.to_i,img_row.to_i
                      else
                        errmsg='imagemagick or graphicsmagick are required to process images'
                        if @md.opt.act[:no_stop][:set]==:on
                          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
                            error("#{errmsg}, proceeding (as requested) without image processing")
                          break
                        else
                          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
                            error("#{errmsg}, STOPPING")
                          exit
                        end
                      end
                    end
                    row=((img && defined? img.rows) ? img.rows : img_row)
                    col=((img && defined? img.columns) ? img.columns : img_col)
                    if img_col > img_row                                                           #landscape
                      if img_col> 640
                        img_col=640
                        img_row=((1.00*img_col/col)*row).round
                      end
                    else                                                                           #portrait
                      if img_col> 640
                        img_col=640
                        img_row=((1.00*img_col/col)*row).round
                      end
                      if img_row > 640
                        img_row=640
                        img_col=((1.00*img_row/row)*col).round
                      end
                    end
                    dob.obj=dob.obj.gsub(/(#{image})/,"#{image} #{img_col}x#{img_row}")
                  else
                    dob.obj=dob.obj.
                      gsub(/#{Mx[:lnk_o]}\s*(\S+)\.(png|jpg|gif).+?#{Mx[:lnk_c]}(#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/,
                        '[ \1 (\2 missing) ]')
                  end
                end
              else
                images=dob.obj.scan(m) do |image|
                  SiSU_Screen::Ansi.new(
                    @md.opt.act[:color_state][:set],
                    '*WARN* where image dimensions have not been provided rmagick or imagemagick is required',image
                  ).warn unless @md.opt.act[:quiet][:set]==:on
                end
              end
            end
          end
          if dob.obj =~/#{Mx[:lnk_o]}\s*\S+\.(?:png|jpg|gif).+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/
            dob.obj=dob.obj.gsub(/(#{Mx[:lnk_o]})\s*(\S+\.(?:png|jpg|gif))\s+/i,'\1\2 ')
          end
        end
        dob unless dob.nil?
      end
    end
  end
end
__END__
imgsys=`identify #{image_path}/#{image}`.strip
