# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['streamdeck_ui']

package_data = \
{'': ['*'], 'streamdeck_ui': ['fonts/roboto/*', 'icons/*']}

install_requires = \
['pillow>=8.2,<9.0',
 'pynput>=1.7,<2.0',
 'pyside2>=5.13,<6.0',
 'python3-xlib>=0.15,<0.16',
 'streamdeck>=0.8.4,<0.9.0']

entry_points = \
{'console_scripts': ['streamdeck = streamdeck_ui.gui:start']}

setup_kwargs = {
    'name': 'streamdeck-ui',
    'version': '1.1.2',
    'description': 'A service, Web Interface, and UI for interacting with your computer using a Stream Deck',
    'long_description': '[![streamdeck_ui - Linux compatible UI for the Elgato Stream Deck](art/logo_large.png)](https://timothycrosley.github.io/streamdeck-ui/)\n_________________\n\n[![PyPI version](https://badge.fury.io/py/streamdeck-ui.svg)](http://badge.fury.io/py/streamdeck-ui)\n[![Test Status](https://github.com/timothycrosley/streamdeck-ui/workflows/Test/badge.svg?branch=master)](https://github.com/timothycrosley/streamdeck-ui/actions?query=workflow%3ATest)\n[![codecov](https://codecov.io/gh/timothycrosley/streamdeck-ui/branch/master/graph/badge.svg)](https://codecov.io/gh/timothycrosley/streamdeck-ui)\n[![Join the chat at https://gitter.im/timothycrosley/streamdeck-ui](https://badges.gitter.im/timothycrosley/streamdeck-ui.svg)](https://gitter.im/timothycrosley/streamdeck-ui?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)\n[![License](https://img.shields.io/github/license/mashape/apistatus.svg)](https://pypi.python.org/pypi/streamdeck-ui/)\n[![Downloads](https://pepy.tech/badge/streamdeck-ui)](https://pepy.tech/project/streamdeck-ui)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Imports: isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://timothycrosley.github.io/isort/)\n \n_________________\n\n[Read Latest Documentation](https://timothycrosley.github.io/streamdeck-ui/) - [Browse GitHub Code Repository](https://github.com/timothycrosley/streamdeck-ui/)\n_________________\n\n**streamdeck_ui** A Linux compatible UI for the Elgato Stream Deck.\n\n![Streamdeck UI Usage Example](art/example.gif)\n\n## Key Features\n\n* **Linux Compatible**: Enables usage of all Stream Deck devices on Linux without needing to code.\n* **Multi-device**: Enables connecting and configuring multiple Stream Deck devices on one computer.\n* **Brightness Control**: Supports controlling the brightness from both the configuration UI and buttons on the device itself.\n* **Configurable Button Display**: Icons + Text, Icon Only, and Text Only configurable per button on the Stream Deck.\n* **Multi-Action Support**: Run commands, write text and press hotkey combinations at the press of a single button on your Stream Deck.\n* **Button Pages**: streamdeck_ui supports multiple pages of buttons and dynamically setting up buttons to switch between those pages.\n* **Auto Reconnect**: Automatically and gracefully reconnects, in the case the device is unplugged and replugged in.\n* **Import/Export**: Supports saving and restoring Stream Deck configuration.\n\nCommunication with the Streamdeck is powered by the [Python Elgato Stream Deck Library](https://github.com/abcminiuser/python-elgato-streamdeck#python-elgato-stream-deck-library).\n\n## Linux Quick Start\n**Python 3.8** is required. You can check which version you have installed with `python3 --version`.\n### Precooked Scripts\nThere are scripts for setting up streamdeck_ui on [Debian/Ubuntu](scripts/ubuntu_install.sh) and [Fedora](scripts/fedora_install.sh).\n### Manual installation\nTo use streamdeck_ui on Linux, you will need first to install some prerequisite system libraries.\nThe name of those libraries will differ depending on your Operating System.  \nDebian / Ubuntu:\n``` console\nsudo apt install python3-pip libhidapi-libusb0 libxcb-xinerama0\n```\nFedora:\n``` console\nsudo dnf install python3-pip python3-devel hidapi\n```\nIf you\'re using GNOME shell, you might need to manually install an extension that adds [KStatusNotifierItem/AppIndicator Support](https://extensions.gnome.org/extension/615/appindicator-support/) to make the tray icon show up.\n\nTo use streamdeck_ui without root permissions, you have to give your user full access to the device.\n\nAdd the udev rules using your text editor:\n``` console\nsudoedit /etc/udev/rules.d/70-streamdeck.rules\n# If that doesn\'t work, try:\nsudo nano /etc/udev/rules.d/70-streamdeck.rules\n```\nPaste the following lines:\n``` console\nSUBSYSTEM=="usb", ATTRS{idVendor}=="0fd9", ATTRS{idProduct}=="0060", TAG+="uaccess"\nSUBSYSTEM=="usb", ATTRS{idVendor}=="0fd9", ATTRS{idProduct}=="0063", TAG+="uaccess"\nSUBSYSTEM=="usb", ATTRS{idVendor}=="0fd9", ATTRS{idProduct}=="006c", TAG+="uaccess"\nSUBSYSTEM=="usb", ATTRS{idVendor}=="0fd9", ATTRS{idProduct}=="006d", TAG+="uaccess"\n```\nReload the rules:\n``` console\nsudo udevadm control --reload-rules\n```\nMake sure you unplug and replug your device before continuing.\nOnce complete, you should be able to install streamdeck_ui.\nInstalling the application itself is done via pip:\n``` console\npip3 install streamdeck-ui --user\n```\nMake sure to include `$HOME/.local/bin` to your PATH.  \nIf you haven\'t already, add\n``` console\nPATH=$PATH:$HOME/.local/bin\n```\nto the bottom your shell config file (most likely .bashrc in your home directory)\n\nYou can then launch `streamdeck` to start configuring your device.\n\n``` console\nstreamdeck\n```\n\nIt\'s recommended that you include `streamdeck` in your windowing environment\'s list of applications to auto-start.\n\n## Generic Quick Start\n\nOn other Operating Systems, you\'ll need to install the required [dependencies](https://github.com/abcminiuser/python-elgato-streamdeck#package-dependencies) of the library.\nAfter that, use pip to install the app:\n\n``` console\npip3 install streamdeck-ui --user\nstreamdeck\n```\n\nSee the guide for\n* [CentOS 7](docs/centos.md)\n* [Ubuntu 18.04](docs/ubuntu1804.md)\n\n## Help\n### Command\nEnter a value in the command field to execute a command. For example, `gnome-terminal` will launch a new terminal on Ubuntu/Fedora or `obs` will launch OBS.\n\n#### Some examples (Ubuntu)\nYou can use a tool like `xdotool` to interact with other applications.\n\nFind the window with a title starting with `Meet - ` and bring it to focus. This helps if you have a Google Meet session on a tab somewhere but you lost it behind another window. \n``` console\nxdotool search --name \'^Meet - .+$\' windowactivate \n```\n> The meeting tab must be active one if you have multiple tabs open, since the window title is set by the currently active tab.\n\nFind the window with a title starting with `Meet - ` and then send `ctrl+d` to it. This has the effect of toggling the mute button in Google Meet.\n``` console\nxdotool search --name \'^Meet - .+$\' windowactivate --sync key ctrl+d\n```\n\nChange the system volume up (or down) by a certain percentage. Assumes you\'re using PulseAudio/Alsa Mixer.\n``` console\namixer -D pulse sset Master 20%+\n```\n### Press Keys\nSimulates key press combinations (hot keys). The basic format is a group of keys, separated by a `+` sign to press simultaneously. Separate key combination groups with a `,` if additional key combinations are needed. For example, `alt+F4,f` means press and hold `alt`, followed by `F4` and then release both. Next, press and release `f`. \n\n> Use `comma` or `plus` if you want to actually *output* `,` or `+` respectively.\n> \n> Use `delay <n>` to add a delay, where `<n>` is the number (float or integer) of seconds to delay. If `<n>` is not specified, 0.5 second default is used. If `<n>` fails to parse as a valid number, it will result in no delay.\n> \n\n#### Examples\n- `F11` - Press F11. If you have focus on a browser, this will toggle full screen.\n- `alt+F4` - Closes the current window.\n- `ctrl+w` - Closes the current browser tab.\n- `cmd+left` - View split on left. Note `cmd` is the **super** key (equivalent of the Windows key).\n- `alt+plus` - Presses the alt and the `+` key at the same time.\n- `alt+delay+F4` - Press alt, then wait 0.5 seconds, then press F4. Release both.\n- `1,delay,delay,2,delay,delay,3` - Type 123 with a 1-second delay between key presses (using default delay).\n- `1,delay 1,2,delay 1,3` - Type 123 with a 1-second delay between key presses (using custom delay).\n\n\nThe standard list of keys can be found [at the source](https://pynput.readthedocs.io/en/latest/_modules/pynput/keyboard/_base.html#Key).\n\n## Known issues\nConfirm you are running the latest release with `pip3 show streamdeck-ui`. Compare it to: [![PyPI version](https://badge.fury.io/py/streamdeck-ui.svg)](http://badge.fury.io/py/streamdeck-ui)\n\n- Streamdeck uses [pynput](https://github.com/moses-palmer/pynput) for simulating **Key Presses** but it lacks proper [support for Wayland](https://github.com/moses-palmer/pynput/issues/189). Generally your results will be good when using X (Ubuntu/Linux Mint). [This thread](https://github.com/timothycrosley/streamdeck-ui/issues/47) may be useful.\n- **Key Press** or **Write Text** does not work on Fedora (outside of the streamdeck itself), which is not particularly useful. However, still do a lot with the **Command** feature.\n- On Ubuntu, the **Key Press** `ctrl+alt+t` [doesn\'t work](https://github.com/moses-palmer/pynput/issues/333\n). However using the **Command** `gnome-terminal` achieves the same result.\n- Version [1.0.2](https://pypi.org/project/streamdeck-ui/) lacks error handling when executing **Command** and **Key Press** actions. As a result, you have to be careful - an invalid command or key press makes everything else also stop working.  Please upgrade to the latest version.\n- Some users have reported that the Stream Deck device does not work on all on specific USB ports, as it draws quite a bit of power and/or has [strict bandwidth requirements](https://github.com/timothycrosley/streamdeck-ui/issues/69#issuecomment-715887397). Try a different port.\n',
    'author': 'Timothy Crosley',
    'author_email': 'timothy.crosley@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.10',
}


setup(**setup_kwargs)
