---
title: Z/Changes from Version 0.12.3 to Version 0.13.0
permalink: /Z/Changes_from_Version_0.12.3_to_Version_0.13.0/
---

**Release Date: 13.07.2011**

We are using the change of the minor release number as an opportunity to
clean up some things. The network format, option names, and XML
element/attribute names were changed.

### Network Format

For the **network**, we try to rework it the way it happened the last
times, too:

Networks generated by SUMO 0.12.x can still be loaded and you may find a
script {{SUMO}}/tools/net/0123to0130.py which converts a network into the new
format. All things marked as deprecated in version 0.12.x are now not
functioning anymore. This means, you can not load networks generated by
versions before 0.12.0. Networks generated by the current version can
not be loaded into old SUMO versions.

- Tags
  - removed `<lanes>` and `<logic>` elements
  - replaced `<succ>` and `<succlane>` elements by `<connection>`. Dummy connections (*SUMO_NO_DESTINATION*) are no longer written.
  - replaced `<row-logic>` and `<logicitem>` elements by `<request>` (within `<junction>` elements)
  - renamed element `tl-logic` to `tlLogic`
  - renamed element `district` to `taz`
  - renamed element `dsource` to `tazSource`
  - renamed element `dsink` to `tazSink`
- Attributes
  - renamed attribute `min_dur` to `minDur`
  - renamed attribute `max_dur` to `maxDur`
  - renamed attribute `maxspeed` to `speed`
  - renamed attribute `linkno` to `linkIndex`
  - removed attribute `<depart>`
  - added attribute `<index>` to lanes
  - added optional attribute `<name>` to edges
  - added optional attribute `spreadType` to edges
  - added optional attribute `shape` to edges
- Values
  - junctions with traffic light now have type `traffic_light` (as in plain-xml)
  - renamed junction type `DEAD_END` to `dead_end`
  - edge attribute `function` will no longer be written in the default case (`=normal`)
  - edge attribute `type` will only be written if set
  - junction attribute `shape` will only be written if set

### Further Input Format Changes

- dfrouter
  - renamed element `detector_definition` to `detectorDefinition`
- ROUTES
  - attribute `length` in element
    `vType` was used to declare the length
    from one vehicles front bumper to the next vehicles front
    bumper. NOW it declares the actual physical length of the
    vehicle. Attribute `minGap` is used to
    declare the distance between front bumper of a vehicle and the
    back bumper of its leader in a traffic jam.
- netconvert
  - added optional attribute `name` to
    plain edge input. This is used for visualisation (Street name)
  - added optional attribute `endOffset`
    to plain edge input. This can be used to shorten the usable
    edge/lane length when stopping (i.e. in case of pedestrian
    crossings)
  - added optional attribute `width` to
    plain edge input. This will be used for visualisation in future
    patches
  - plain edge input now supports lane specific speeds
  - plain edge input now supports edge-specific vehicle class
    restrictions (`allow`,
    `disallow`)
  - replaced element `forceLength` by
    element `split` with altered
    functionality

### Option Names

Many options have been renamed to increase consistency and to hopefully
make them easier to understand and remember. All changes apply to
options given via the command line as well as options declared via
configuration files. The old options still work although some are now
marked as deprecated.

Call `<APPLICATION> --save-template <filename> --save-commented`
to get a list of supported options including synonyms.

### Application-Specific Changes

- Simulation
  - removed emitters, now only normal route files are allowed
  - renamed **--emissions-output** to **--summary**
  - renamed **--sloppy-emit** to **--sloppy-insert**
- netconvert
  - now fully supports import of SUMO networks
- TraCI
  - removed the possibility to set and retrieve traffic lights by
    phase/brake/yellow-tuples (both, state 0x21 and program 0x25)
  - completely removed old API
  - solved tickets [ticket\#273 (consolidate speed and acceleration manipulation methods)](http://sourceforge.net/apps/trac/sumo/ticket/273) and
    [ticket\#330 (Speed adaptation after receiving SLOWDOWN command not working.)](http://sourceforge.net/apps/trac/sumo/ticket/330)
  - introduced a way to decide whether safe velocity, maximum
    deceleration and maximum acceleration shall be considered when
    changing a vehicle's speed, see:
    [TraCI/Change_Vehicle_State](../TraCI/Change_Vehicle_State.md),
    speed mode (0xb3)
  - added default "error" return values for
    teleported/not-yet-inserted vehicles
  - All lengths are encoded as written in the specification. The
    correct code for reading length is:

```
int length = readByte()
if length==0:
length = readInt()
```

- added [Contributed/SUMO Traffic Modeler](../Contributed/SUMO_Traffic_Modeler.md)