## TFSA-2021-138: Incomplete validation in `QuantizeV2`

### CVE Number
CVE-2021-37663

### Impact
Due to incomplete validation in `tf.raw_ops.QuantizeV2`, an attacker can trigger
undefined behavior via binding a reference to a null pointer or can access data
outside the bounds of heap allocated arrays:

```python
import tensorflow as tf

tf.raw_ops.QuantizeV2(
  input=[1,2,3],
  min_range=[1,2],
  max_range=[],
  T=tf.qint32,
  mode='SCALED',
  round_mode='HALF_AWAY_FROM_ZERO',
  narrow_range=False,
  axis=1,
  ensure_minimum_range=3)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/84d053187cb80d975ef2b9684d4b61981bca0c41/tensorflow/core/kernels/quantize_op.cc#L59)
has some validation but does not check that `min_range` and `max_range` both
have the same non-zero number of elements. If `axis` is provided (i.e., not
`-1`), then validation should check that it is a value in range for the rank of
`input` tensor and then the lengths of `min_range` and `max_range` inputs match
the `axis` dimension of the `input` tensor.

### Patches
We have patched the issue in GitHub commit
[6da6620efad397c85493b8f8667b821403516708](https://github.com/tensorflow/tensorflow/commit/6da6620efad397c85493b8f8667b821403516708).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
