{-# LANGUAGE ForeignFunctionInterface #-}

#include <bindings.dsl.h>
#include <nettle/chacha.h>

module Bindings.Nettle.Cipher.ChaCha where
#strict_import

#num CHACHA_KEY_SIZE
#num CHACHA_BLOCK_SIZE
#num CHACHA_NONCE_SIZE
#num CHACHA_NONCE96_SIZE

#starttype struct chacha_ctx
#stoptype

#ccall chacha_set_key , Ptr <struct chacha_ctx> -> Ptr CUChar -> IO ()
#ccall chacha_set_nonce , Ptr <struct chacha_ctx> -> Ptr CUChar -> IO ()
#ccall chacha_set_nonce96 , Ptr <struct chacha_ctx> -> Ptr CUChar -> IO ()
#ccall chacha_crypt , Ptr <struct chacha_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()
